static python::object
qstate_addtransition(QState* self, QObject *sender, const pyqt_signal &signal, QAbstractState * target)
{
    QSignalTransition *st = 0;
    if (sender->metaObject()->indexOfSignal(signal.signature()) != -1) {
        st = self->addTransition(sender, signal.toQtStyleSignature(), target);
    } else {
        pyqt_signal py_sig("_onActive()");
        QObject *proxy = signal_manager::instance().register_dynamic_signal(self, sender, signal, py_sig);
        st = self->addTransition(proxy, py_sig.toQtStyleSignature(), target);
    }

    PySide::qptr<QState> ptr_parent(self);
    python::object ret(PySide::ptr(st));

    PySide::qptr<QSignalTransition> ptr_child(ret.ptr());
    ptr_parent.add_child(ptr_child);

    return ret;
}
