/**
 * Override QChar equal operator to support Python string and Unicode
 **/
static bool
qchar_wrapper_operator_eq(const QChar& c, const python::object& str)
{
    PyObject* pyObj = str.ptr();

    if (PyUnicode_Check(pyObj)) { // unicode strings
        if (PyUnicode_GET_SIZE(pyObj) > 1)
            return false;
        wchar_t wc;
        PyUnicode_AsWideChar((PyUnicodeObject*)pyObj, &wc, 1);
        return c.unicode() == (ushort)wc;
    }
#if PY_VERSION_HEX < 0x03000000
    else if (PyString_Check(pyObj)) { // normal strings
        if (PyString_GET_SIZE(pyObj) > 1)
            return false;
        return c.cell() == PyString_AS_STRING(pyObj)[0];
    }
#endif
    return false;
}
