#include <QtGui>
#include "qapplication_policy.hpp"

void qlayout_add_widget(QLayout *self, QWidget *widget)
{
    PySide::qptr<QLayout> ptr_self(self);
    PySide::qptr<QWidget> ptr_child(widget);

    QWidget *parent = self->parentWidget();
    if (parent) {
        PySide::qptr<QWidget> ptr_parent(parent);
        ptr_parent.add_child(ptr_child);
    } else {
        ptr_self.add_child(ptr_child);
    }
}

void qlayout_add_layout(QLayout *self, QLayout *layout)
{
    PySide::qptr<QLayout> ptr_self(self);
    PySide::qptr<QLayout> ptr_layout(layout);

    QWidget *parent = self->parentWidget();
    if (parent) {
        PySide::qptr<QWidget> ptr_parent(parent);

        for (int i=0; i < layout->count(); i++)
        {
            QLayoutItem *item = layout->itemAt(i);
            QWidget *w = item->widget();

            if (w)
            {
                PySide::qptr<QWidget> ptr_widget(w);
                ptr_parent.add_child(ptr_widget);
            }
            else
            {
                QLayout *l = item->layout();
                if (l)
                    qlayout_add_layout(self, l);
            }
        }
        ptr_parent.add_child(ptr_layout);

    } else {
        ptr_self.add_child(ptr_layout);
    }
}
