    python_cls
       /**[sphinx-begin]
        *
        *  .. method:: QBoxLayout.addWidget(widget, strech, Qt.Alignment)
        *      .. param: widget - QWidget
        *      .. param: strech - int
        *      .. param: alignment - enum Qt.Alignment
        *
        * Adds widget to the end of this box layout, with a stretch factor of stretch and alignment alignment.
        * The stretch factor applies only in the direction of the QBoxLayout, and is relative to the other boxes and widgets in this QBoxLayout. Widgets and boxes with higher stretch factors grow more.
        * If the stretch factor is 0 and nothing else in the QBoxLayout has a stretch factor greater than zero, the space is distributed according to the QWidget:sizePolicy() of each widget that's involved.
        * The alignment is specified by alignment. The default alignment is 0, which means that the widget fills the entire cell.
        *
        [sphinx-end]**/
        .def("addWidget", qboxlayout_addwidget, 
                (python::arg(0), python::arg(0) = 0, python::arg(0) = 0))
       /**[sphinx-begin]
        *
        *  .. method:: QBoxLayout.insertWidget(index, widget, strech, Qt.Alignment)
        *      .. param: index - int
        *      .. param: widget - QWidget
        *      .. param: strech - int
        *      .. param: alignment - enum Qt.Alignment
        *
        * Inserts widget at position index, with stretch factor stretch and alignment alignment. If index is negative, the widget is added at the end.
        * The stretch factor applies only in the direction of the QBoxLayout, and is relative to the other boxes and widgets in this QBoxLayout. Widgets and boxes with higher stretch factors grow more.
        * If the stretch factor is 0 and nothing else in the QBoxLayout has a stretch factor greater than zero, the space is distributed according to the QWidget:sizePolicy() of each widget that's involved.
        * The alignment is specified by alignment. The default alignment is 0, which means that the widget fills the entire cell.
        *
        [sphinx-end]**/
        .def("insertWidget", qboxlayout_insertwidget,
                (python::arg(0), python::arg(0), python::arg(0) = 0, python::arg(0) = 0))
       /**[sphinx-begin]
        *
        *  .. method:: QBoxLayout.addLayout(layout, strech)
        *      .. param: layout - QLayout
        *      .. param: strech - int
        *
        * Adds layout to the end of the box, with serial stretch factor stretch.
        *
        [sphinx-end]**/
        .def("addLayout", qboxlayout_addlayout,
                (python::arg(0), python::arg(0) = 0))
       /**[sphinx-begin]
        *
        *  .. method:: QBoxLayout.insertLayout(index, layout, strech)
        *      .. param: index - int
        *      .. param: layout - QLayout
        *      .. param: strech - int
        *
        * Inserts layout at position index, with stretch factor stretch. If index is negative, the layout is added at the end.
        * layout becomes a child of the box layout.
        *
        [sphinx-end]**/
        .def("insertLayout", qboxlayout_insertwidget,
                (python::arg(0), python::arg(0), python::arg(0) = 0));
