/**
 * Q_DECLARE_METATYPE(boost::python::object);
 * Use the expanded version of Q_DECLARE_METATYPE macro to define a typename
 * compatible with PyQt4
 **/

QT_BEGIN_NAMESPACE
template <>
struct QMetaTypeId< boost::python::object >
{
    enum { Defined = 1 };
    static int qt_metatype_id()
    {
        static QBasicAtomicInt metatype_id = Q_BASIC_ATOMIC_INITIALIZER(0);
        if (!metatype_id)
            metatype_id =
                qRegisterMetaType<boost::python::object>("PyQt_PyObject");
        return metatype_id;
    }
};
QT_END_NAMESPACE


/**
 * Override QVariant constructor to accept python::object and parse this
 * to extract the correct value
 **/
static PySide::qptr<QVariant>
qvariant_constructor(const python::object& obj)
{
    QVariant retval;
    PyObject* ptr = obj.ptr();

    // Use boost extractor to get rid of implicity conversions
    python::extract<int> intExtractor(obj);

    if (PyBool_Check(ptr)) { // bool MUST be the first, because it's a int subclass
        retval = bool(python::extract<long>(ptr));
    } else if (PyFloat_Check(ptr)) {
        retval = PyFloat_AS_DOUBLE(ptr);
    } else if (intExtractor.check()) {
        retval = intExtractor();
#if PY_VERSION_HEX < 0x03000000
        } else if (PyString_Check(ptr) || PyUnicode_Check(ptr)) {
#else
        } else if (PyUnicode_Check(ptr)) {
#endif
        QString value = python::extract<QString>(obj);
        return PySide::qptr<QVariant>(new QVariant(value));
    } else {
        // voodoo stuff to avoid linking qtcore bindings with qtgui
        python::object raw_name = obj.attr("__class__").attr("__name__");
        QString name = python::extract<QString>(raw_name);
        uint type = QMetaType::type(qPrintable(name));

        if (!type || type > QVariant::UserType) {
            retval = QVariant::fromValue<python::object>(obj);
        } else {
            void* ptr = type_manager::instance().to_cpp(name, obj).data();
            retval = QVariant(type, ptr);
        }
    }
    return PySide::qptr<QVariant>(new QVariant(retval));
}

/**
 * Extract python::object from a QVariant
 **/
static python::object
qvariant_toPyObj(QVariant& self)
{
    const char *type_name = self.typeName();
    uint type_id = QMetaType::type(type_name);
    if (!type_id || type_id > QVariant::UserType) {
        return self.value<python::object>();
    } else {
        return type_manager::instance().to_python(type_name, self.data());
    }
}
