/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_versit_python.h"

#include "qtmobility_qversitproperty_wrapper.h"

// Extra includes
#include <QStringList>
#include <qversitproperty.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QVersitProperty_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QVersitProperty >()))
        return -1;

    QtMobility::QVersitProperty* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QVersitProperty", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QVersitProperty()
    // 1: QVersitProperty(QtMobility::QVersitProperty)
    if (numArgs == 0) {
        overloadId = 0; // QVersitProperty()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QVersitProperty & >::isConvertible(arg)) {
        overloadId = 1; // QVersitProperty(QtMobility::QVersitProperty)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitProperty_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QVersitProperty()
            {

                if(!PyErr_Occurred()) {
                // QVersitProperty()
                cptr = new QtMobility::QVersitProperty();
                }
                break;
            }
            case 1: // QVersitProperty(QtMobility::QVersitProperty)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QVersitProperty* cpp_arg0 = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QVersitProperty(QtMobility::QVersitProperty)
                cptr = new QtMobility::QVersitProperty(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QVersitProperty >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QVersitProperty_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QVersitProperty_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Versit.QtMobility::QVersitProperty", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Versit.QVersitProperty", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QVersitPropertyFunc_clear(PyObject* self)
{
    QtMobility::QVersitProperty* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // clear()
            cppSelf->QtMobility::QVersitProperty::clear();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QVersitPropertyFunc_groups(PyObject* self)
{
    QtMobility::QVersitProperty* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // groups()const
            QStringList cppResult = cppSelf->QtMobility::QVersitProperty::groups();
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitPropertyFunc_insertParameter(PyObject* self, PyObject* args)
{
    QtMobility::QVersitProperty* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(self);

    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertParameter", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: insertParameter(QString,QString)
    if (numArgs == 2 && Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
        overloadId = 0; // insertParameter(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitPropertyFunc_insertParameter_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // insertParameter(QString,QString)
            cppSelf->QtMobility::QVersitProperty::insertParameter(cpp_arg0, cpp_arg1);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QVersitPropertyFunc_insertParameter_TypeError:
        const char* overloads[] = {"QString, QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Versit.QVersitProperty.insertParameter", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitPropertyFunc_isEmpty(PyObject* self)
{
    QtMobility::QVersitProperty* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = cppSelf->QtMobility::QVersitProperty::isEmpty();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitPropertyFunc_name(PyObject* self)
{
    QtMobility::QVersitProperty* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // name()const
            QString cppResult = cppSelf->QtMobility::QVersitProperty::name();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitPropertyFunc_removeParameter(PyObject* self, PyObject* args)
{
    QtMobility::QVersitProperty* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(self);

    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "removeParameter", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: removeParameter(QString,QString)
    if (numArgs == 2 && Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
        overloadId = 0; // removeParameter(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitPropertyFunc_removeParameter_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // removeParameter(QString,QString)
            cppSelf->QtMobility::QVersitProperty::removeParameter(cpp_arg0, cpp_arg1);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QVersitPropertyFunc_removeParameter_TypeError:
        const char* overloads[] = {"QString, QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Versit.QVersitProperty.removeParameter", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitPropertyFunc_removeParameters(PyObject* self, PyObject* arg)
{
    QtMobility::QVersitProperty* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: removeParameters(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // removeParameters(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitPropertyFunc_removeParameters_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // removeParameters(QString)
            cppSelf->QtMobility::QVersitProperty::removeParameters(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QVersitPropertyFunc_removeParameters_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Versit.QVersitProperty.removeParameters", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitPropertyFunc_setGroups(PyObject* self, PyObject* arg)
{
    QtMobility::QVersitProperty* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setGroups(QStringList)
    if (Shiboken::Converter< QStringList  >::isConvertible(arg)) {
        overloadId = 0; // setGroups(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitPropertyFunc_setGroups_TypeError;

    // Call function/method
    {
        {
            QStringList cpp_arg0 = Shiboken::Converter<QStringList >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setGroups(QStringList)
            cppSelf->QtMobility::QVersitProperty::setGroups(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QVersitPropertyFunc_setGroups_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Versit.QVersitProperty.setGroups", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitPropertyFunc_setName(PyObject* self, PyObject* arg)
{
    QtMobility::QVersitProperty* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setName(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitPropertyFunc_setName_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setName(QString)
            cppSelf->QtMobility::QVersitProperty::setName(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QVersitPropertyFunc_setName_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Versit.QVersitProperty.setName", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitPropertyFunc_setValue(PyObject* self, PyObject* arg)
{
    QtMobility::QVersitProperty* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setValue(QVariant)
    if (Shiboken::Converter<QVariant >::isConvertible(arg)) {
        overloadId = 0; // setValue(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitPropertyFunc_setValue_TypeError;

    // Call function/method
    {
        {
            QVariant cpp_arg0 = Shiboken::Converter<QVariant >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setValue(QVariant)
            cppSelf->QtMobility::QVersitProperty::setValue(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QVersitPropertyFunc_setValue_TypeError:
        const char* overloads[] = {"QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Versit.QVersitProperty.setValue", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitPropertyFunc_setValueType(PyObject* self, PyObject* arg)
{
    QtMobility::QVersitProperty* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setValueType(QtMobility::QVersitProperty::ValueType)
    if (Shiboken::Converter<QtMobility::QVersitProperty::ValueType >::isConvertible(arg)) {
        overloadId = 0; // setValueType(QtMobility::QVersitProperty::ValueType)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitPropertyFunc_setValueType_TypeError;

    // Call function/method
    {
        {
            QtMobility::QVersitProperty::ValueType cpp_arg0 = Shiboken::Converter<QtMobility::QVersitProperty::ValueType >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setValueType(QtMobility::QVersitProperty::ValueType)
            cppSelf->QtMobility::QVersitProperty::setValueType(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QVersitPropertyFunc_setValueType_TypeError:
        const char* overloads[] = {"QtMobility.Versit.QtMobility::QVersitProperty.ValueType", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Versit.QVersitProperty.setValueType", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitPropertyFunc_value(PyObject* self)
{
    QtMobility::QVersitProperty* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // value()const
            QString cppResult = cppSelf->QtMobility::QVersitProperty::value();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitPropertyFunc_valueType(PyObject* self)
{
    QtMobility::QVersitProperty* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // valueType()const
            QtMobility::QVersitProperty::ValueType cppResult = cppSelf->QtMobility::QVersitProperty::valueType();
            pyResult = Shiboken::Converter<QtMobility::QVersitProperty::ValueType >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitPropertyFunc_variantValue(PyObject* self)
{
    QtMobility::QVersitProperty* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // variantValue()const
            QVariant cppResult = cppSelf->QtMobility::QVersitProperty::variantValue();
            pyResult = Shiboken::Converter<QVariant >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QVersitProperty_methods[] = {
    {"clear", (PyCFunction)SbkQtMobility_QVersitPropertyFunc_clear, METH_NOARGS},
    {"groups", (PyCFunction)SbkQtMobility_QVersitPropertyFunc_groups, METH_NOARGS},
    {"insertParameter", (PyCFunction)SbkQtMobility_QVersitPropertyFunc_insertParameter, METH_VARARGS},
    {"isEmpty", (PyCFunction)SbkQtMobility_QVersitPropertyFunc_isEmpty, METH_NOARGS},
    {"name", (PyCFunction)SbkQtMobility_QVersitPropertyFunc_name, METH_NOARGS},
    {"removeParameter", (PyCFunction)SbkQtMobility_QVersitPropertyFunc_removeParameter, METH_VARARGS},
    {"removeParameters", (PyCFunction)SbkQtMobility_QVersitPropertyFunc_removeParameters, METH_O},
    {"setGroups", (PyCFunction)SbkQtMobility_QVersitPropertyFunc_setGroups, METH_O},
    {"setName", (PyCFunction)SbkQtMobility_QVersitPropertyFunc_setName, METH_O},
    {"setValue", (PyCFunction)SbkQtMobility_QVersitPropertyFunc_setValue, METH_O},
    {"setValueType", (PyCFunction)SbkQtMobility_QVersitPropertyFunc_setValueType, METH_O},
    {"value", (PyCFunction)SbkQtMobility_QVersitPropertyFunc_value, METH_NOARGS},
    {"valueType", (PyCFunction)SbkQtMobility_QVersitPropertyFunc_valueType, METH_NOARGS},
    {"variantValue", (PyCFunction)SbkQtMobility_QVersitPropertyFunc_variantValue, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQtMobility_QVersitProperty_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QVersitProperty& cpp_self = *Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QVersitProperty & >::isConvertible(other)) {
                // operator!=(const QtMobility::QVersitProperty & other) const
                QtMobility::QVersitProperty* cpp_other = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QVersitProperty  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QVersitProperty_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QVersitProperty & >::isConvertible(other)) {
                // operator==(const QtMobility::QVersitProperty & other) const
                QtMobility::QVersitProperty* cpp_other = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QVersitProperty  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QVersitProperty_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QVersitProperty_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

static long SbkQtMobility_QVersitProperty_HashFunc(PyObject* obj){
    return qHash(Shiboken::Converter<QtMobility::QVersitProperty >::toCpp(obj));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QVersitProperty_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Versit.QVersitProperty",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             &SbkQtMobility_QVersitProperty_HashFunc,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QVersitProperty_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QVersitProperty_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QVersitProperty_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QVersitProperty >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QVersitProperty",
    /*user_data*/           0
};
} //extern

static PyGetSetDef SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ValueType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QVersitProperty(PyObject* module)
{
    SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITPROPERTY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QVersitProperty_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QVersitProperty_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QVersitProperty_Type));
    PyModule_AddObject(module, "QVersitProperty",
        ((PyObject*)&SbkQtMobility_QVersitProperty_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ValueType
    SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITPROPERTY_VALUETYPE_IDX] = &SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_Type);
    PyDict_SetItemString(SbkQtMobility_QVersitProperty_Type.super.ht_type.tp_dict,
            "ValueType",((PyObject*)&SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_Type,
        (long) QtMobility::QVersitProperty::PlainType, "PlainType");
    PyDict_SetItemString(SbkQtMobility_QVersitProperty_Type.super.ht_type.tp_dict,
        "PlainType", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_Type.tp_dict,
        "PlainType", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_Type,
        (long) QtMobility::QVersitProperty::CompoundType, "CompoundType");
    PyDict_SetItemString(SbkQtMobility_QVersitProperty_Type.super.ht_type.tp_dict,
        "CompoundType", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_Type.tp_dict,
        "CompoundType", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_Type,
        (long) QtMobility::QVersitProperty::ListType, "ListType");
    PyDict_SetItemString(SbkQtMobility_QVersitProperty_Type.super.ht_type.tp_dict,
        "ListType", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_Type.tp_dict,
        "ListType", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_Type,
        (long) QtMobility::QVersitProperty::BinaryType, "BinaryType");
    PyDict_SetItemString(SbkQtMobility_QVersitProperty_Type.super.ht_type.tp_dict,
        "BinaryType", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_Type.tp_dict,
        "BinaryType", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_Type,
        (long) QtMobility::QVersitProperty::VersitDocumentType, "VersitDocumentType");
    PyDict_SetItemString(SbkQtMobility_QVersitProperty_Type.super.ht_type.tp_dict,
        "VersitDocumentType", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitProperty_ValueType_Type.tp_dict,
        "VersitDocumentType", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QVersitProperty::ValueType");


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QVersitProperty >("QtMobility::QVersitProperty");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QVersitProperty >("QtMobility::QVersitProperty*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QVersitProperty >(typeid(QtMobility::QVersitProperty).name());
    PySide::initQtMetaType<QtMobility::QVersitProperty >();
}

