/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_versit_python.h"

#include "qtmobility_qversitdefaultresourcehandler_wrapper.h"

// Extra includes
#include <qbytearray.h>
#include <qversitproperty.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QVersitDefaultResourceHandlerWrapper::QVersitDefaultResourceHandlerWrapper() : QtMobility::QVersitDefaultResourceHandler() {
    // ... middle
}

bool QVersitDefaultResourceHandlerWrapper::loadResource(const QString & location, QByteArray * contents, QString * mimeType)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "loadResource"));
    if (py_override.isNull()) {
        return this->QtMobility::QVersitDefaultResourceHandler::loadResource(location, contents, mimeType);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNN)",
        Shiboken::Converter<QString >::toPython(location),
        Shiboken::Converter<QByteArray * >::toPython(contents),
        Shiboken::Converter<QString * >::toPython(mimeType)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QVersitDefaultResourceHandler.loadResource", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

bool QVersitDefaultResourceHandlerWrapper::saveResource(const QByteArray & contents, const QtMobility::QVersitProperty & property, QString * location)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "saveResource"));
    if (py_override.isNull()) {
        return this->QtMobility::QVersitDefaultResourceHandler::saveResource(contents, property, location);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNN)",
        Shiboken::Converter<const QByteArray & >::toPython(contents),
        Shiboken::Converter<const QtMobility::QVersitProperty & >::toPython(property),
        Shiboken::Converter<QString * >::toPython(location)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QVersitDefaultResourceHandler.saveResource", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

QVersitDefaultResourceHandlerWrapper::~QVersitDefaultResourceHandlerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QVersitDefaultResourceHandler_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QVersitDefaultResourceHandler >()))
        return -1;

    QVersitDefaultResourceHandlerWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QVersitDefaultResourceHandler", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QVersitDefaultResourceHandler(QtMobility::QVersitDefaultResourceHandler)
    // 1: QVersitDefaultResourceHandler()
    if (numArgs == 0) {
        overloadId = 1; // QVersitDefaultResourceHandler()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QVersitDefaultResourceHandler & >::isConvertible(arg)) {
        overloadId = 0; // QVersitDefaultResourceHandler(QtMobility::QVersitDefaultResourceHandler)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitDefaultResourceHandler_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QVersitDefaultResourceHandler(QtMobility::QVersitDefaultResourceHandler)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QVersitDefaultResourceHandler* cpp_arg0 = Shiboken::Converter<QtMobility::QVersitDefaultResourceHandler* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QVersitDefaultResourceHandler(QtMobility::QVersitDefaultResourceHandler)
                cptr = new QVersitDefaultResourceHandlerWrapper(*reinterpret_cast<QVersitDefaultResourceHandlerWrapper*>(cpp_arg0));
                }
                break;
            }
            case 1: // QVersitDefaultResourceHandler()
            {

                if(!PyErr_Occurred()) {
                // QVersitDefaultResourceHandler()
                cptr = new QVersitDefaultResourceHandlerWrapper();
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QVersitDefaultResourceHandler >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QVersitDefaultResourceHandler_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QVersitDefaultResourceHandler_Init_TypeError:
        const char* overloads[] = {"QtMobility.Versit.QtMobility::QVersitDefaultResourceHandler", "", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Versit.QVersitDefaultResourceHandler", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QVersitDefaultResourceHandlerFunc_loadResource(PyObject* self, PyObject* args)
{
    QtMobility::QVersitDefaultResourceHandler* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitDefaultResourceHandler* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "loadResource", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: loadResource(QString,QByteArray*,QString*)
    if (numArgs == 3 && Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter<QByteArray * >::isConvertible(pyargs[1]) && Shiboken::Converter<QString * >::isConvertible(pyargs[2])) {
        overloadId = 0; // loadResource(QString,QByteArray*,QString*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitDefaultResourceHandlerFunc_loadResource_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
            QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QByteArray >::checkType(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
            QString * cpp_arg2 = Shiboken::Converter<QString * >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // loadResource(QString,QByteArray*,QString*)
            bool cppResult = cppSelf->QtMobility::QVersitDefaultResourceHandler::loadResource(cpp_arg0, cpp_arg1, cpp_arg2);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QVersitDefaultResourceHandlerFunc_loadResource_TypeError:
        const char* overloads[] = {"QString, PySide.QtCore.QByteArray, QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Versit.QVersitDefaultResourceHandler.loadResource", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitDefaultResourceHandlerFunc_saveResource(PyObject* self, PyObject* args)
{
    QtMobility::QVersitDefaultResourceHandler* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitDefaultResourceHandler* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "saveResource", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: saveResource(QByteArray,QtMobility::QVersitProperty,QString*)
    if (numArgs == 3 && Shiboken::Converter<const QByteArray & >::isConvertible(pyargs[0]) && Shiboken::Converter<const QtMobility::QVersitProperty & >::isConvertible(pyargs[1]) && Shiboken::Converter<QString * >::isConvertible(pyargs[2])) {
        overloadId = 0; // saveResource(QByteArray,QtMobility::QVersitProperty,QString*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitDefaultResourceHandlerFunc_saveResource_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
            QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
            if (!Shiboken::Converter<QByteArray >::checkType(pyargs[0]))
                cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QtMobility::QVersitProperty* cpp_arg1 = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(pyargs[1]);
            QString * cpp_arg2 = Shiboken::Converter<QString * >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // saveResource(QByteArray,QtMobility::QVersitProperty,QString*)
            bool cppResult = cppSelf->QtMobility::QVersitDefaultResourceHandler::saveResource(*cpp_arg0, *cpp_arg1, cpp_arg2);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QVersitDefaultResourceHandlerFunc_saveResource_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray, QtMobility.Versit.QtMobility::QVersitProperty, QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Versit.QVersitDefaultResourceHandler.saveResource", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QVersitDefaultResourceHandler_methods[] = {
    {"loadResource", (PyCFunction)SbkQtMobility_QVersitDefaultResourceHandlerFunc_loadResource, METH_VARARGS},
    {"saveResource", (PyCFunction)SbkQtMobility_QVersitDefaultResourceHandlerFunc_saveResource, METH_VARARGS},
    {0} // Sentinel
};

} // extern "C"

static void* SbkQtMobility_QVersitDefaultResourceHandler_ObjCopierFunc(const void* ptr){
    return new QVersitDefaultResourceHandlerWrapper(*reinterpret_cast<const QtMobility::QVersitDefaultResourceHandler*>(ptr));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QVersitDefaultResourceHandler_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Versit.QVersitDefaultResourceHandler",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QVersitDefaultResourceHandler_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QVersitDefaultResourceHandler_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQtMobility_QVersitDefaultResourceHandler_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QVersitDefaultResourceHandler >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QVersitDefaultResourceHandler",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QVersitDefaultResourceHandler_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QtMobility::QVersitResourceHandler >()) && dynamic_cast<QtMobility::QVersitDefaultResourceHandler*>(reinterpret_cast<QtMobility::QVersitResourceHandler*>(cptr)))
        return &SbkQtMobility_QVersitDefaultResourceHandler_Type;
    return 0;
}


void init_QtMobility_QVersitDefaultResourceHandler(PyObject* module)
{
    SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITDEFAULTRESOURCEHANDLER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QVersitDefaultResourceHandler_Type);

    SbkQtMobility_QVersitDefaultResourceHandler_Type.super.ht_type.tp_base = SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITRESOURCEHANDLER_IDX];
    // Fill type discovery information
    SbkQtMobility_QVersitDefaultResourceHandler_Type.type_discovery = &SbkQtMobility_QVersitDefaultResourceHandler_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITRESOURCEHANDLER_IDX]), &SbkQtMobility_QVersitDefaultResourceHandler_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QVersitDefaultResourceHandler_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QVersitDefaultResourceHandler_Type));
    PyModule_AddObject(module, "QVersitDefaultResourceHandler",
        ((PyObject*)&SbkQtMobility_QVersitDefaultResourceHandler_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QVersitDefaultResourceHandler >("QtMobility::QVersitDefaultResourceHandler");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QVersitDefaultResourceHandler >("QtMobility::QVersitDefaultResourceHandler*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QVersitDefaultResourceHandler >(typeid(QtMobility::QVersitDefaultResourceHandler).name());
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QVersitDefaultResourceHandler >(typeid(QVersitDefaultResourceHandlerWrapper).name());
    PySide::initQtMetaType<QtMobility::QVersitDefaultResourceHandler >();
}

