/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_versit_python.h"

#include "qtmobility_qversitcontactimporterpropertyhandler_wrapper.h"

// Extra includes
#include <qcontact.h>
#include <qversitdocument.h>
#include <qversitproperty.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QVersitContactImporterPropertyHandlerWrapper::QVersitContactImporterPropertyHandlerWrapper() : QtMobility::QVersitContactImporterPropertyHandler() {
    // ... middle
}

bool QVersitContactImporterPropertyHandlerWrapper::postProcessProperty(const QtMobility::QVersitDocument & document, const QtMobility::QVersitProperty & property, bool alreadyProcessed, int contactIndex, QtMobility::QContact * contact)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "postProcessProperty"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QVersitContactImporterPropertyHandler.postProcessProperty()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNNiN)",
        Shiboken::Converter<const QtMobility::QVersitDocument & >::toPython(document),
        Shiboken::Converter<const QtMobility::QVersitProperty & >::toPython(property),
        Shiboken::Converter<bool >::toPython(alreadyProcessed),
        contactIndex,
        Shiboken::Converter<QtMobility::QContact * >::toPython(contact)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QVersitContactImporterPropertyHandler.postProcessProperty", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

bool QVersitContactImporterPropertyHandlerWrapper::preProcessProperty(const QtMobility::QVersitDocument & document, const QtMobility::QVersitProperty & property, int contactIndex, QtMobility::QContact * contact)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "preProcessProperty"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QVersitContactImporterPropertyHandler.preProcessProperty()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNiN)",
        Shiboken::Converter<const QtMobility::QVersitDocument & >::toPython(document),
        Shiboken::Converter<const QtMobility::QVersitProperty & >::toPython(property),
        contactIndex,
        Shiboken::Converter<QtMobility::QContact * >::toPython(contact)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QVersitContactImporterPropertyHandler.preProcessProperty", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

QVersitContactImporterPropertyHandlerWrapper::~QVersitContactImporterPropertyHandlerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QVersitContactImporterPropertyHandler_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QVersitContactImporterPropertyHandler >()))
        return -1;

    QVersitContactImporterPropertyHandlerWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITCONTACTIMPORTERPROPERTYHANDLER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QtMobility::QVersitContactImporterPropertyHandler' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // QVersitContactImporterPropertyHandler()
            cptr = new QVersitContactImporterPropertyHandlerWrapper();
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QVersitContactImporterPropertyHandler >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject* SbkQtMobility_QVersitContactImporterPropertyHandlerFunc_postProcessProperty(PyObject* self, PyObject* args)
{
    QtMobility::QVersitContactImporterPropertyHandler* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitContactImporterPropertyHandler* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "postProcessProperty", 5, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;


    // Overloaded function decisor
    // 0: postProcessProperty(QtMobility::QVersitDocument,QtMobility::QVersitProperty,bool,int,QtMobility::QContact*)
    if (numArgs == 5 && Shiboken::Converter<const QtMobility::QVersitDocument & >::isConvertible(pyargs[0]) && Shiboken::Converter<const QtMobility::QVersitProperty & >::isConvertible(pyargs[1]) && SbkNumber_Check(pyargs[2]) && SbkNumber_Check(pyargs[3]) && Shiboken::Converter<QtMobility::QContact * >::isConvertible(pyargs[4])) {
        overloadId = 0; // postProcessProperty(QtMobility::QVersitDocument,QtMobility::QVersitProperty,bool,int,QtMobility::QContact*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitContactImporterPropertyHandlerFunc_postProcessProperty_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            std::auto_ptr<QtMobility::QVersitDocument > cpp_arg0_auto_ptr;
            QtMobility::QVersitDocument* cpp_arg0 = Shiboken::Converter<QtMobility::QVersitDocument* >::toCpp(pyargs[0]);
            if (!Shiboken::Converter<QtMobility::QVersitDocument >::checkType(pyargs[0]))
                cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QVersitDocument >(cpp_arg0);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QtMobility::QVersitProperty* cpp_arg1 = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(pyargs[1]);
            bool cpp_arg2 = Shiboken::Converter<bool >::toCpp(pyargs[2]);
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                return 0;
            QtMobility::QContact* cpp_arg4 = Shiboken::Converter<QtMobility::QContact* >::toCpp(pyargs[4]);

            if(!PyErr_Occurred()) {
            // postProcessProperty(QtMobility::QVersitDocument,QtMobility::QVersitProperty,bool,int,QtMobility::QContact*)
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QVersitContactImporterPropertyHandler.postProcessProperty()' not implemented.");
                return 0;
            }
            bool cppResult = cppSelf->postProcessProperty(*cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QVersitContactImporterPropertyHandlerFunc_postProcessProperty_TypeError:
        const char* overloads[] = {"QtMobility.Versit.QtMobility::QVersitDocument, QtMobility.Versit.QtMobility::QVersitProperty, bool, int, QtMobility.Contacts.QtMobility::QContact", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Versit.QVersitContactImporterPropertyHandler.postProcessProperty", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitContactImporterPropertyHandlerFunc_preProcessProperty(PyObject* self, PyObject* args)
{
    QtMobility::QVersitContactImporterPropertyHandler* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitContactImporterPropertyHandler* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "preProcessProperty", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;


    // Overloaded function decisor
    // 0: preProcessProperty(QtMobility::QVersitDocument,QtMobility::QVersitProperty,int,QtMobility::QContact*)
    if (numArgs == 4 && Shiboken::Converter<const QtMobility::QVersitDocument & >::isConvertible(pyargs[0]) && Shiboken::Converter<const QtMobility::QVersitProperty & >::isConvertible(pyargs[1]) && SbkNumber_Check(pyargs[2]) && Shiboken::Converter<QtMobility::QContact * >::isConvertible(pyargs[3])) {
        overloadId = 0; // preProcessProperty(QtMobility::QVersitDocument,QtMobility::QVersitProperty,int,QtMobility::QContact*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitContactImporterPropertyHandlerFunc_preProcessProperty_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            std::auto_ptr<QtMobility::QVersitDocument > cpp_arg0_auto_ptr;
            QtMobility::QVersitDocument* cpp_arg0 = Shiboken::Converter<QtMobility::QVersitDocument* >::toCpp(pyargs[0]);
            if (!Shiboken::Converter<QtMobility::QVersitDocument >::checkType(pyargs[0]))
                cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QVersitDocument >(cpp_arg0);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QtMobility::QVersitProperty* cpp_arg1 = Shiboken::Converter<QtMobility::QVersitProperty* >::toCpp(pyargs[1]);
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            QtMobility::QContact* cpp_arg3 = Shiboken::Converter<QtMobility::QContact* >::toCpp(pyargs[3]);

            if(!PyErr_Occurred()) {
            // preProcessProperty(QtMobility::QVersitDocument,QtMobility::QVersitProperty,int,QtMobility::QContact*)
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QVersitContactImporterPropertyHandler.preProcessProperty()' not implemented.");
                return 0;
            }
            bool cppResult = cppSelf->preProcessProperty(*cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QVersitContactImporterPropertyHandlerFunc_preProcessProperty_TypeError:
        const char* overloads[] = {"QtMobility.Versit.QtMobility::QVersitDocument, QtMobility.Versit.QtMobility::QVersitProperty, int, QtMobility.Contacts.QtMobility::QContact", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Versit.QVersitContactImporterPropertyHandler.preProcessProperty", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QVersitContactImporterPropertyHandler_methods[] = {
    {"postProcessProperty", (PyCFunction)SbkQtMobility_QVersitContactImporterPropertyHandlerFunc_postProcessProperty, METH_VARARGS},
    {"preProcessProperty", (PyCFunction)SbkQtMobility_QVersitContactImporterPropertyHandlerFunc_preProcessProperty, METH_VARARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QVersitContactImporterPropertyHandler_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Versit.QVersitContactImporterPropertyHandler",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QVersitContactImporterPropertyHandler_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QVersitContactImporterPropertyHandler_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QVersitContactImporterPropertyHandler >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QVersitContactImporterPropertyHandler*",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QVersitContactImporterPropertyHandler(PyObject* module)
{
    SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITCONTACTIMPORTERPROPERTYHANDLER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QVersitContactImporterPropertyHandler_Type);

    // Fill type discovery information

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QVersitContactImporterPropertyHandler_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QVersitContactImporterPropertyHandler_Type));
    PyModule_AddObject(module, "QVersitContactImporterPropertyHandler",
        ((PyObject*)&SbkQtMobility_QVersitContactImporterPropertyHandler_Type));


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QVersitContactImporterPropertyHandler >("QtMobility::QVersitContactImporterPropertyHandler*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QVersitContactImporterPropertyHandler >(typeid(QtMobility::QVersitContactImporterPropertyHandler).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QVersitContactImporterPropertyHandler >(typeid(QVersitContactImporterPropertyHandlerWrapper).name());
    PySide::initQtMetaType<QtMobility::QVersitContactImporterPropertyHandler* >();
}

