/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_versit_python.h"

#include "qtmobility_qversitcontactimporter_wrapper.h"

// Extra includes
#include <QList>
#include <QMap>
#include <qcontact.h>
#include <qversitcontactimporter.h>
#include <qversitdocument.h>
#include <qversitresourcehandler.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QVersitContactImporter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QVersitContactImporter >()))
        return -1;

    QtMobility::QVersitContactImporter* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QVersitContactImporter", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QVersitContactImporter(QtMobility::QVersitContactImporter)
    // 1: QVersitContactImporter()
    if (numArgs == 0) {
        overloadId = 1; // QVersitContactImporter()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QVersitContactImporter & >::isConvertible(arg)) {
        overloadId = 0; // QVersitContactImporter(QtMobility::QVersitContactImporter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitContactImporter_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QVersitContactImporter(QtMobility::QVersitContactImporter)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QVersitContactImporter* cpp_arg0 = Shiboken::Converter<QtMobility::QVersitContactImporter* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QVersitContactImporter(QtMobility::QVersitContactImporter)
                cptr = new QtMobility::QVersitContactImporter(*cpp_arg0);
                }
                break;
            }
            case 1: // QVersitContactImporter()
            {

                if(!PyErr_Occurred()) {
                // QVersitContactImporter()
                cptr = new QtMobility::QVersitContactImporter();
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QVersitContactImporter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QVersitContactImporter_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QVersitContactImporter_Init_TypeError:
        const char* overloads[] = {"QtMobility.Versit.QtMobility::QVersitContactImporter", "", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Versit.QVersitContactImporter", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QVersitContactImporterFunc_contacts(PyObject* self)
{
    QtMobility::QVersitContactImporter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitContactImporter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // contacts()const
            QList<QtMobility::QContact > cppResult = cppSelf->QtMobility::QVersitContactImporter::contacts();
            pyResult = Shiboken::Converter<QList<QtMobility::QContact > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitContactImporterFunc_errors(PyObject* self)
{
    QtMobility::QVersitContactImporter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitContactImporter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // errors()const
            QMap<int, QtMobility::QVersitContactImporter::Error > cppResult = cppSelf->QtMobility::QVersitContactImporter::errors();
            pyResult = Shiboken::Converter<QMap<int, QtMobility::QVersitContactImporter::Error > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitContactImporterFunc_importDocuments(PyObject* self, PyObject* arg)
{
    QtMobility::QVersitContactImporter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitContactImporter* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: importDocuments(QList<QtMobility::QVersitDocument>)
    if (Shiboken::Converter< QList<QtMobility::QVersitDocument >  >::isConvertible(arg)) {
        overloadId = 0; // importDocuments(QList<QtMobility::QVersitDocument>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitContactImporterFunc_importDocuments_TypeError;

    // Call function/method
    {
        {
            QList<QtMobility::QVersitDocument > cpp_arg0 = Shiboken::Converter<QList<QtMobility::QVersitDocument > >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // importDocuments(QList<QtMobility::QVersitDocument>)
            bool cppResult = cppSelf->QtMobility::QVersitContactImporter::importDocuments(cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QVersitContactImporterFunc_importDocuments_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Versit.QVersitContactImporter.importDocuments", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitContactImporterFunc_propertyHandler(PyObject* self)
{
    QtMobility::QVersitContactImporter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitContactImporter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // propertyHandler()const
            QtMobility::QVersitContactImporterPropertyHandler * cppResult = cppSelf->QtMobility::QVersitContactImporter::propertyHandler();
            pyResult = Shiboken::Converter<QtMobility::QVersitContactImporterPropertyHandler * >::toPython(cppResult);
            Shiboken::setParent(self, pyResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitContactImporterFunc_resourceHandler(PyObject* self)
{
    QtMobility::QVersitContactImporter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitContactImporter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // resourceHandler()const
            QtMobility::QVersitResourceHandler * cppResult = cppSelf->QtMobility::QVersitContactImporter::resourceHandler();
            pyResult = Shiboken::Converter<QtMobility::QVersitResourceHandler * >::toPython(cppResult);
            Shiboken::setParent(self, pyResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QVersitContactImporterFunc_setPropertyHandler(PyObject* self, PyObject* arg)
{
    QtMobility::QVersitContactImporter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitContactImporter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setPropertyHandler(QtMobility::QVersitContactImporterPropertyHandler*)
    if (Shiboken::Converter<QtMobility::QVersitContactImporterPropertyHandler * >::isConvertible(arg)) {
        overloadId = 0; // setPropertyHandler(QtMobility::QVersitContactImporterPropertyHandler*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitContactImporterFunc_setPropertyHandler_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QVersitContactImporterPropertyHandler* cpp_arg0 = Shiboken::Converter<QtMobility::QVersitContactImporterPropertyHandler* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setPropertyHandler(QtMobility::QVersitContactImporterPropertyHandler*)
            cppSelf->QtMobility::QVersitContactImporter::setPropertyHandler(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QVersitContactImporterFunc_setPropertyHandler_TypeError:
        const char* overloads[] = {"QtMobility.Versit.QtMobility::QVersitContactImporterPropertyHandler", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Versit.QVersitContactImporter.setPropertyHandler", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QVersitContactImporterFunc_setResourceHandler(PyObject* self, PyObject* arg)
{
    QtMobility::QVersitContactImporter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QVersitContactImporter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setResourceHandler(QtMobility::QVersitResourceHandler*)
    if (Shiboken::Converter<QtMobility::QVersitResourceHandler * >::isConvertible(arg)) {
        overloadId = 0; // setResourceHandler(QtMobility::QVersitResourceHandler*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QVersitContactImporterFunc_setResourceHandler_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QVersitResourceHandler* cpp_arg0 = Shiboken::Converter<QtMobility::QVersitResourceHandler* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setResourceHandler(QtMobility::QVersitResourceHandler*)
            cppSelf->QtMobility::QVersitContactImporter::setResourceHandler(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QVersitContactImporterFunc_setResourceHandler_TypeError:
        const char* overloads[] = {"QtMobility.Versit.QtMobility::QVersitResourceHandler", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Versit.QVersitContactImporter.setResourceHandler", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QVersitContactImporter_methods[] = {
    {"contacts", (PyCFunction)SbkQtMobility_QVersitContactImporterFunc_contacts, METH_NOARGS},
    {"errors", (PyCFunction)SbkQtMobility_QVersitContactImporterFunc_errors, METH_NOARGS},
    {"importDocuments", (PyCFunction)SbkQtMobility_QVersitContactImporterFunc_importDocuments, METH_O},
    {"propertyHandler", (PyCFunction)SbkQtMobility_QVersitContactImporterFunc_propertyHandler, METH_NOARGS},
    {"resourceHandler", (PyCFunction)SbkQtMobility_QVersitContactImporterFunc_resourceHandler, METH_NOARGS},
    {"setPropertyHandler", (PyCFunction)SbkQtMobility_QVersitContactImporterFunc_setPropertyHandler, METH_O},
    {"setResourceHandler", (PyCFunction)SbkQtMobility_QVersitContactImporterFunc_setResourceHandler, METH_O},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QVersitContactImporter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Versit.QVersitContactImporter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QVersitContactImporter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QVersitContactImporter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QVersitContactImporter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QVersitContactImporter",
    /*user_data*/           0
};
} //extern

static PyGetSetDef SbkQtMobility_Versit_QtMobility_QVersitContactImporter_Error_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Versit_QtMobility_QVersitContactImporter_Error_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Versit_QtMobility_QVersitContactImporter_Error_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Error",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Versit_QtMobility_QVersitContactImporter_Error_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Versit_QtMobility_QVersitContactImporter_Error_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Versit_QtMobility_QVersitContactImporter_Error_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QVersitContactImporter(PyObject* module)
{
    SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITCONTACTIMPORTER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QVersitContactImporter_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QVersitContactImporter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QVersitContactImporter_Type));
    PyModule_AddObject(module, "QVersitContactImporter",
        ((PyObject*)&SbkQtMobility_QVersitContactImporter_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Error
    SbkQtMobility_VersitTypes[SBK_QTMOBILITY_QVERSITCONTACTIMPORTER_ERROR_IDX] = &SbkQtMobility_Versit_QtMobility_QVersitContactImporter_Error_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Versit_QtMobility_QVersitContactImporter_Error_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Versit_QtMobility_QVersitContactImporter_Error_Type);
    PyDict_SetItemString(SbkQtMobility_QVersitContactImporter_Type.super.ht_type.tp_dict,
            "Error",((PyObject*)&SbkQtMobility_Versit_QtMobility_QVersitContactImporter_Error_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitContactImporter_Error_Type,
        (long) QtMobility::QVersitContactImporter::NoError, "NoError");
    PyDict_SetItemString(SbkQtMobility_QVersitContactImporter_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitContactImporter_Error_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitContactImporter_Error_Type,
        (long) QtMobility::QVersitContactImporter::InvalidDocumentError, "InvalidDocumentError");
    PyDict_SetItemString(SbkQtMobility_QVersitContactImporter_Type.super.ht_type.tp_dict,
        "InvalidDocumentError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitContactImporter_Error_Type.tp_dict,
        "InvalidDocumentError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Versit_QtMobility_QVersitContactImporter_Error_Type,
        (long) QtMobility::QVersitContactImporter::EmptyDocumentError, "EmptyDocumentError");
    PyDict_SetItemString(SbkQtMobility_QVersitContactImporter_Type.super.ht_type.tp_dict,
        "EmptyDocumentError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Versit_QtMobility_QVersitContactImporter_Error_Type.tp_dict,
        "EmptyDocumentError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QVersitContactImporter::Error");


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QVersitContactImporter >("QtMobility::QVersitContactImporter");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QVersitContactImporter >("QtMobility::QVersitContactImporter*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QVersitContactImporter >(typeid(QtMobility::QVersitContactImporter).name());
    PySide::initQtMetaType<QtMobility::QVersitContactImporter >();
}

