/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_SYSTEMINFO_PYTHON_H
#define SBK_SYSTEMINFO_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#include <qsignal.h>
// Module Includes
#include <pyside_qtcore_python.h>
#include <pyside_qtnetwork_python.h>

// Binded library includes
#include <qsysteminfo.h>
// Conversion Includes - Primitive Types
#include <QString>
#include <signalmanager.h>
#include <typeresolver.h>
#include <QtConcurrentFilter>
#include <QTextDocument>

// Conversion Includes - Container Types
#include <QList>
#include <QMap>
#include <QStack>
#include <QMultiMap>
#include <QVector>
#include <QPair>
#include <pysideconversions.h>
#include <QSet>
#include <qqueue.h>
#include <QStringList>
#include <qlinkedlist.h>

// Type indices
#define SBK_QTMOBILITY_QSYSTEMSCREENSAVER_IDX                        0
#define SBK_QTMOBILITY_QSYSTEMDEVICEINFO_IDX                         1
#define SBK_QTMOBILITY_QSYSTEMDEVICEINFO_INPUTMETHOD_IDX             2
#define SBK_QFLAGS_QTMOBILITY_QSYSTEMDEVICEINFO_INPUTMETHOD__IDX     3
#define SBK_QTMOBILITY_QSYSTEMDEVICEINFO_PROFILE_IDX                 4
#define SBK_QTMOBILITY_QSYSTEMDEVICEINFO_SIMSTATUS_IDX               5
#define SBK_QTMOBILITY_QSYSTEMDEVICEINFO_POWERSTATE_IDX              6
#define SBK_QTMOBILITY_QSYSTEMDEVICEINFO_BATTERYSTATUS_IDX           7
#define SBK_QTMOBILITY_QSYSTEMSTORAGEINFO_IDX                        8
#define SBK_QTMOBILITY_QSYSTEMSTORAGEINFO_DRIVETYPE_IDX              9
#define SBK_QTMOBILITY_QSYSTEMDISPLAYINFO_IDX                        10
#define SBK_QTMOBILITY_QSYSTEMNETWORKINFO_IDX                        11
#define SBK_QTMOBILITY_QSYSTEMNETWORKINFO_NETWORKMODE_IDX            12
#define SBK_QTMOBILITY_QSYSTEMNETWORKINFO_NETWORKSTATUS_IDX          13
#define SBK_QTMOBILITY_QSYSTEMINFO_IDX                               14
#define SBK_QTMOBILITY_QSYSTEMINFO_VERSION_IDX                       15
#define SBK_QTMOBILITY_QSYSTEMINFO_FEATURE_IDX                       16
#define SBK_SystemInfo_IDX_COUNT                                     17

// This variable stores all python types exported by this module
extern PyTypeObject** SbkQtMobility_SystemInfoTypes;

// Macros for type check

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<QtMobility::QSystemScreenSaver >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMSCREENSAVER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QSystemDeviceInfo::InputMethod >() { return SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMDEVICEINFO_INPUTMETHOD_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QtMobility::QSystemDeviceInfo::InputMethod> >() { return SbkQtMobility_SystemInfoTypes[SBK_QFLAGS_QTMOBILITY_QSYSTEMDEVICEINFO_INPUTMETHOD__IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QSystemDeviceInfo::Profile >() { return SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMDEVICEINFO_PROFILE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QSystemDeviceInfo::SimStatus >() { return SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMDEVICEINFO_SIMSTATUS_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QSystemDeviceInfo::PowerState >() { return SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMDEVICEINFO_POWERSTATE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QSystemDeviceInfo::BatteryStatus >() { return SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMDEVICEINFO_BATTERYSTATUS_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QSystemDeviceInfo >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMDEVICEINFO_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QSystemStorageInfo::DriveType >() { return SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMSTORAGEINFO_DRIVETYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QSystemStorageInfo >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMSTORAGEINFO_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QSystemDisplayInfo >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMDISPLAYINFO_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QSystemNetworkInfo::NetworkMode >() { return SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMNETWORKINFO_NETWORKMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QSystemNetworkInfo::NetworkStatus >() { return SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMNETWORKINFO_NETWORKSTATUS_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QSystemNetworkInfo >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMNETWORKINFO_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QSystemInfo::Version >() { return SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMINFO_VERSION_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QSystemInfo::Feature >() { return SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMINFO_FEATURE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QSystemInfo >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMINFO_IDX]); }

template<>
inline PyObject* createWrapper<QtMobility::QSystemScreenSaver >(const QtMobility::QSystemScreenSaver* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QSystemScreenSaver >()),const_cast<QtMobility::QSystemScreenSaver*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QSystemDeviceInfo >(const QtMobility::QSystemDeviceInfo* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QSystemDeviceInfo >()),const_cast<QtMobility::QSystemDeviceInfo*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QSystemStorageInfo >(const QtMobility::QSystemStorageInfo* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QSystemStorageInfo >()),const_cast<QtMobility::QSystemStorageInfo*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QSystemDisplayInfo >(const QtMobility::QSystemDisplayInfo* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QSystemDisplayInfo >()),const_cast<QtMobility::QSystemDisplayInfo*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QSystemNetworkInfo >(const QtMobility::QSystemNetworkInfo* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QSystemNetworkInfo >()),const_cast<QtMobility::QSystemNetworkInfo*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QSystemInfo >(const QtMobility::QSystemInfo* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QSystemInfo >()),const_cast<QtMobility::QSystemInfo*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
// Generated converters declarations ----------------------------------

template<>
struct Converter<QtMobility::QSystemScreenSaver* > : ObjectTypeConverter<QtMobility::QSystemScreenSaver >
{
};

template<>
struct Converter<QtMobility::QSystemScreenSaver& > : ObjectTypeReferenceConverter<QtMobility::QSystemScreenSaver >
{
};

template<>
struct Converter<QtMobility::QSystemDeviceInfo::InputMethod > : EnumConverter<QtMobility::QSystemDeviceInfo::InputMethod >
{
};
template<>
struct Converter<QFlags<QtMobility::QSystemDeviceInfo::InputMethod> > : QFlagsConverter<QFlags<QtMobility::QSystemDeviceInfo::InputMethod> >
{
};

template<>
struct Converter<QtMobility::QSystemDeviceInfo::Profile > : EnumConverter<QtMobility::QSystemDeviceInfo::Profile >
{
};

template<>
struct Converter<QtMobility::QSystemDeviceInfo::SimStatus > : EnumConverter<QtMobility::QSystemDeviceInfo::SimStatus >
{
};

template<>
struct Converter<QtMobility::QSystemDeviceInfo::PowerState > : EnumConverter<QtMobility::QSystemDeviceInfo::PowerState >
{
};

template<>
struct Converter<QtMobility::QSystemDeviceInfo::BatteryStatus > : EnumConverter<QtMobility::QSystemDeviceInfo::BatteryStatus >
{
};

template<>
struct Converter<QtMobility::QSystemDeviceInfo* > : ObjectTypeConverter<QtMobility::QSystemDeviceInfo >
{
};

template<>
struct Converter<QtMobility::QSystemDeviceInfo& > : ObjectTypeReferenceConverter<QtMobility::QSystemDeviceInfo >
{
};

template<>
struct Converter<QtMobility::QSystemStorageInfo::DriveType > : EnumConverter<QtMobility::QSystemStorageInfo::DriveType >
{
};

template<>
struct Converter<QtMobility::QSystemStorageInfo* > : ObjectTypeConverter<QtMobility::QSystemStorageInfo >
{
};

template<>
struct Converter<QtMobility::QSystemStorageInfo& > : ObjectTypeReferenceConverter<QtMobility::QSystemStorageInfo >
{
};

template<>
struct Converter<QtMobility::QSystemDisplayInfo* > : ObjectTypeConverter<QtMobility::QSystemDisplayInfo >
{
};

template<>
struct Converter<QtMobility::QSystemDisplayInfo& > : ObjectTypeReferenceConverter<QtMobility::QSystemDisplayInfo >
{
};

template<>
struct Converter<QtMobility::QSystemNetworkInfo::NetworkMode > : EnumConverter<QtMobility::QSystemNetworkInfo::NetworkMode >
{
};

template<>
struct Converter<QtMobility::QSystemNetworkInfo::NetworkStatus > : EnumConverter<QtMobility::QSystemNetworkInfo::NetworkStatus >
{
};

template<>
struct Converter<QtMobility::QSystemNetworkInfo* > : ObjectTypeConverter<QtMobility::QSystemNetworkInfo >
{
};

template<>
struct Converter<QtMobility::QSystemNetworkInfo& > : ObjectTypeReferenceConverter<QtMobility::QSystemNetworkInfo >
{
};

template<>
struct Converter<QtMobility::QSystemInfo::Version > : EnumConverter<QtMobility::QSystemInfo::Version >
{
};

template<>
struct Converter<QtMobility::QSystemInfo::Feature > : EnumConverter<QtMobility::QSystemInfo::Feature >
{
};

template<>
struct Converter<QtMobility::QSystemInfo* > : ObjectTypeConverter<QtMobility::QSystemInfo >
{
};

template<>
struct Converter<QtMobility::QSystemInfo& > : ObjectTypeReferenceConverter<QtMobility::QSystemInfo >
{
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------


#endif // SBK_SYSTEMINFO_PYTHON_H

