/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_systeminfo_python.h"

#include "qtmobility_qsysteminfo_wrapper.h"

// Extra includes
#include <QList>
#include <QStringList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qthread.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QSystemInfoWrapper::QSystemInfoWrapper(QObject * parent) : QtMobility::QSystemInfo(parent), m_metaObject(0) {
    // ... middle
}

void QSystemInfoWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSystemInfoWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QtMobility::QSystemInfo::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QSystemInfoWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSystemInfoWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QtMobility::QSystemInfo::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QSystemInfoWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSystemInfo.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QSystemInfoWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSystemInfo.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

void QSystemInfoWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QSystemInfoWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QSystemInfo::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QSystemInfoWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QSystemInfo::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QSystemInfoWrapper::~QSystemInfoWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QSystemInfo_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QSystemInfo >()))
        return -1;

    QSystemInfoWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "parent" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                propertyKeys.push_back(argName);
            }
        }
    }

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QSystemInfo", &arg))
        return -1;

    // Overloaded function decisor
    // 0: QSystemInfo(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QSystemInfo(QObject*)
    } else if (Shiboken::Converter<QObject * >::isConvertible(arg)) {
        overloadId = 0; // QSystemInfo(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSystemInfo_Init_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "parent");
                if (value) {
                    if (arg)
                        errorArgName = "parent";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.SystemInfo.QSystemInfo(): got multiple values for keyword argument '%s'", errorArgName);
                    return -1;
                }
            }
            if (Shiboken::cppObjectIsInvalid(arg))
                return -1;
            QObject* cpp_arg0 = arg ? Shiboken::Converter<QObject* >::toCpp(arg) : 0;

            if(!PyErr_Occurred()) {
            // QSystemInfo(QObject*)
            cptr = new QSystemInfoWrapper(cpp_arg0);
            Shiboken::setParent(arg, self);
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QSystemInfo >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QSystemInfo_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    PySide::signalUpdateSource(self);
    cptr->metaObject();
    for (std::vector<PyObject*>::size_type i = 0; i < propertyKeys.size(); i++) {
        const char* propName = PyString_AS_STRING(propertyKeys[i]);
        const QMetaObject* mo = cptr->metaObject();
        if (mo->indexOfProperty(propName) != -1) {
            cptr->setProperty(propName, Shiboken::Converter<QVariant>::toCpp(PyDict_GetItem(kwds, propertyKeys[i])));
        } else {
            QString signalSignature = QString("%1()").arg(propName);
            if (mo->indexOfSignal(qPrintable(signalSignature)) != -1) {
                signalSignature = '2' + signalSignature;
                PySide::signal_connect(self, qPrintable(signalSignature), PyDict_GetItem(kwds, propertyKeys[i]));
            } else {
                delete cptr;
                PyErr_Format(PyExc_AttributeError, "'%s' is not a Qt property or a signal", propName);
                return -1;
            };
        }
    }


    return 1;

    SbkQtMobility_QSystemInfo_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.SystemInfo.QSystemInfo", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QSystemInfoFunc_availableLanguages(PyObject* self)
{
    QtMobility::QSystemInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // availableLanguages()
            QStringList cppResult = cppSelf->QtMobility::QSystemInfo::availableLanguages();
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemInfoFunc_connectNotify(PyObject* self, PyObject* arg)
{
    QtMobility::QSystemInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemInfo* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: connectNotify(const char*)
    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        overloadId = 0; // connectNotify(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSystemInfoFunc_connectNotify_TypeError;

    // Call function/method
    {
        {
            const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // connectNotify(const char*)
            cppSelf->QtMobility::QSystemInfo::connectNotify(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QSystemInfoFunc_connectNotify_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.SystemInfo.QSystemInfo.connectNotify", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSystemInfoFunc_currentCountryCode(PyObject* self)
{
    QtMobility::QSystemInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // currentCountryCode()
            QString cppResult = cppSelf->QtMobility::QSystemInfo::currentCountryCode();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemInfoFunc_currentLanguage(PyObject* self)
{
    QtMobility::QSystemInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // currentLanguage()
            QString cppResult = cppSelf->QtMobility::QSystemInfo::currentLanguage();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSystemInfoFunc_disconnectNotify(PyObject* self, PyObject* arg)
{
    QtMobility::QSystemInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemInfo* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: disconnectNotify(const char*)
    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        overloadId = 0; // disconnectNotify(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSystemInfoFunc_disconnectNotify_TypeError;

    // Call function/method
    {
        {
            const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // disconnectNotify(const char*)
            cppSelf->QtMobility::QSystemInfo::disconnectNotify(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QSystemInfoFunc_disconnectNotify_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.SystemInfo.QSystemInfo.disconnectNotify", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSystemInfoFunc_hasFeatureSupported(PyObject* self, PyObject* arg)
{
    QtMobility::QSystemInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemInfo* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: hasFeatureSupported(QtMobility::QSystemInfo::Feature)
    if (Shiboken::Converter<QtMobility::QSystemInfo::Feature >::isConvertible(arg)) {
        overloadId = 0; // hasFeatureSupported(QtMobility::QSystemInfo::Feature)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSystemInfoFunc_hasFeatureSupported_TypeError;

    // Call function/method
    {
        {
            QtMobility::QSystemInfo::Feature cpp_arg0 = Shiboken::Converter<QtMobility::QSystemInfo::Feature >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // hasFeatureSupported(QtMobility::QSystemInfo::Feature)
            bool cppResult = cppSelf->QtMobility::QSystemInfo::hasFeatureSupported(cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QSystemInfoFunc_hasFeatureSupported_TypeError:
        const char* overloads[] = {"QtMobility.SystemInfo.QSystemInfo.Feature", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.SystemInfo.QSystemInfo.hasFeatureSupported", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSystemInfoFunc_version(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QSystemInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSystemInfo* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "parameter" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.SystemInfo.QSystemInfo.version(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.SystemInfo.QSystemInfo.version(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.SystemInfo.QSystemInfo.version(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:version", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: version(QtMobility::QSystemInfo::Version,QString)
    if (Shiboken::Converter<QtMobility::QSystemInfo::Version >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // version(QtMobility::QSystemInfo::Version,QString)
        } else if (Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
            overloadId = 0; // version(QtMobility::QSystemInfo::Version,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSystemInfoFunc_version_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "parameter");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "parameter";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.SystemInfo.QSystemInfo.version(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QtMobility::QSystemInfo::Version cpp_arg0 = Shiboken::Converter<QtMobility::QSystemInfo::Version >::toCpp(pyargs[0]);
            QString cpp_arg1 = pyargs[1] ? Shiboken::Converter<QString >::toCpp(pyargs[1]) : QString();

            if(!PyErr_Occurred()) {
            // version(QtMobility::QSystemInfo::Version,QString)
            QString cppResult = cppSelf->QtMobility::QSystemInfo::version(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QSystemInfoFunc_version_TypeError:
        const char* overloads[] = {"QtMobility.SystemInfo.QSystemInfo.Version, QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.SystemInfo.QSystemInfo.version", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QSystemInfo_methods[] = {
    {"availableLanguages", (PyCFunction)SbkQtMobility_QSystemInfoFunc_availableLanguages, METH_NOARGS},
    {"connectNotify", (PyCFunction)SbkQtMobility_QSystemInfoFunc_connectNotify, METH_O},
    {"currentCountryCode", (PyCFunction)SbkQtMobility_QSystemInfoFunc_currentCountryCode, METH_NOARGS},
    {"currentLanguage", (PyCFunction)SbkQtMobility_QSystemInfoFunc_currentLanguage, METH_NOARGS},
    {"disconnectNotify", (PyCFunction)SbkQtMobility_QSystemInfoFunc_disconnectNotify, METH_O},
    {"hasFeatureSupported", (PyCFunction)SbkQtMobility_QSystemInfoFunc_hasFeatureSupported, METH_O},
    {"version", (PyCFunction)SbkQtMobility_QSystemInfoFunc_version, METH_VARARGS|METH_KEYWORDS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QSystemInfo_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.SystemInfo.QSystemInfo",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QSystemInfo_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QSystemInfo_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QSystemInfo >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QSystemInfo*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QSystemInfo_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QSystemInfo*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QSystemInfo_Type;
    return 0;
}

static PyGetSetDef SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Version_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Version_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Version_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Version",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Version_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Version_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Version_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Feature",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QSystemInfo(PyObject* module)
{
    SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMINFO_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QSystemInfo_Type);

    SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQtMobility_QSystemInfo_Type.type_discovery = &SbkQtMobility_QSystemInfo_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]), &SbkQtMobility_QSystemInfo_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QSystemInfo_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QSystemInfo_Type));
    PyModule_AddObject(module, "QSystemInfo",
        ((PyObject*)&SbkQtMobility_QSystemInfo_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Version
    SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMINFO_VERSION_IDX] = &SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Version_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Version_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Version_Type);
    PyDict_SetItemString(SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_dict,
            "Version",((PyObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Version_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Version_Type,
        (long) QtMobility::QSystemInfo::Os, "Os");
    PyDict_SetItemString(SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_dict,
        "Os", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Version_Type.tp_dict,
        "Os", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Version_Type,
        (long) QtMobility::QSystemInfo::QtCore, "QtCore");
    PyDict_SetItemString(SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_dict,
        "QtCore", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Version_Type.tp_dict,
        "QtCore", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Version_Type,
        (long) QtMobility::QSystemInfo::Firmware, "Firmware");
    PyDict_SetItemString(SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_dict,
        "Firmware", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Version_Type.tp_dict,
        "Firmware", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QSystemInfo::Version");

    // init enum class: Feature
    SbkQtMobility_SystemInfoTypes[SBK_QTMOBILITY_QSYSTEMINFO_FEATURE_IDX] = &SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type);
    PyDict_SetItemString(SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_dict,
            "Feature",((PyObject*)&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type,
        (long) QtMobility::QSystemInfo::BluetoothFeature, "BluetoothFeature");
    PyDict_SetItemString(SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_dict,
        "BluetoothFeature", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type.tp_dict,
        "BluetoothFeature", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type,
        (long) QtMobility::QSystemInfo::CameraFeature, "CameraFeature");
    PyDict_SetItemString(SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_dict,
        "CameraFeature", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type.tp_dict,
        "CameraFeature", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type,
        (long) QtMobility::QSystemInfo::FmradioFeature, "FmradioFeature");
    PyDict_SetItemString(SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_dict,
        "FmradioFeature", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type.tp_dict,
        "FmradioFeature", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type,
        (long) QtMobility::QSystemInfo::IrFeature, "IrFeature");
    PyDict_SetItemString(SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_dict,
        "IrFeature", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type.tp_dict,
        "IrFeature", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type,
        (long) QtMobility::QSystemInfo::LedFeature, "LedFeature");
    PyDict_SetItemString(SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_dict,
        "LedFeature", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type.tp_dict,
        "LedFeature", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type,
        (long) QtMobility::QSystemInfo::MemcardFeature, "MemcardFeature");
    PyDict_SetItemString(SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_dict,
        "MemcardFeature", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type.tp_dict,
        "MemcardFeature", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type,
        (long) QtMobility::QSystemInfo::UsbFeature, "UsbFeature");
    PyDict_SetItemString(SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_dict,
        "UsbFeature", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type.tp_dict,
        "UsbFeature", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type,
        (long) QtMobility::QSystemInfo::VibFeature, "VibFeature");
    PyDict_SetItemString(SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_dict,
        "VibFeature", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type.tp_dict,
        "VibFeature", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type,
        (long) QtMobility::QSystemInfo::WlanFeature, "WlanFeature");
    PyDict_SetItemString(SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_dict,
        "WlanFeature", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type.tp_dict,
        "WlanFeature", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type,
        (long) QtMobility::QSystemInfo::SimFeature, "SimFeature");
    PyDict_SetItemString(SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_dict,
        "SimFeature", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type.tp_dict,
        "SimFeature", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type,
        (long) QtMobility::QSystemInfo::LocationFeature, "LocationFeature");
    PyDict_SetItemString(SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_dict,
        "LocationFeature", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type.tp_dict,
        "LocationFeature", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type,
        (long) QtMobility::QSystemInfo::VideoOutFeature, "VideoOutFeature");
    PyDict_SetItemString(SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_dict,
        "VideoOutFeature", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type.tp_dict,
        "VideoOutFeature", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type,
        (long) QtMobility::QSystemInfo::HapticsFeature, "HapticsFeature");
    PyDict_SetItemString(SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_dict,
        "HapticsFeature", enum_item);
    PyDict_SetItemString(SbkQtMobility_SystemInfo_QtMobility_QSystemInfo_Feature_Type.tp_dict,
        "HapticsFeature", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QSystemInfo::Feature");

    // Initialize signals
    PyObject* signal_item;

    signal_item = PySide::signalNew("currentLanguageChanged", "const QString&", NULL);
    PyDict_SetItemString(SbkQtMobility_QSystemInfo_Type.super.ht_type.tp_dict, "currentLanguageChanged", signal_item);
    Py_DECREF(signal_item);


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QSystemInfo >("QtMobility::QSystemInfo*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QSystemInfo >(typeid(QtMobility::QSystemInfo).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QSystemInfo >(typeid(QSystemInfoWrapper).name());
    PySide::initQtMetaType<QtMobility::QSystemInfo* >();
}

