/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_SERVICEFRAMEWORK_PYTHON_H
#define SBK_SERVICEFRAMEWORK_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#include <qsignal.h>
// Module Includes
#include <pyside_qtcore_python.h>

// Binded library includes
#include <qservicefilter.h>
#include <qservicecontext.h>
#include <qservicemanager.h>
#include <qabstractsecuritysession.h>
#include <qservice.h>
#include <qserviceinterfacedescriptor.h>
#include <qserviceplugininterface.h>
// Conversion Includes - Primitive Types
#include <QString>
#include <signalmanager.h>
#include <typeresolver.h>
#include <QtConcurrentFilter>
#include <QTextDocument>

// Conversion Includes - Container Types
#include <QList>
#include <QMap>
#include <QStack>
#include <QMultiMap>
#include <QVector>
#include <QPair>
#include <pysideconversions.h>
#include <QSet>
#include <qqueue.h>
#include <QStringList>
#include <qlinkedlist.h>

// Type indices
#define SBK_QTMOBILITY_QSERVICE_IDX                                  0
#define SBK_QTMOBILITY_QSERVICE_SCOPE_IDX                            1
#define SBK_QTMOBILITY_QSERVICEPLUGININTERFACE_IDX                   2
#define SBK_QTMOBILITY_QSERVICEINTERFACEDESCRIPTOR_IDX               3
#define SBK_QTMOBILITY_QSERVICEINTERFACEDESCRIPTOR_ATTRIBUTE_IDX     4
#define SBK_QTMOBILITY_QSERVICEFILTER_IDX                            5
#define SBK_QTMOBILITY_QSERVICEFILTER_CAPABILITYMATCHRULE_IDX        6
#define SBK_QTMOBILITY_QSERVICEFILTER_VERSIONMATCHRULE_IDX           7
#define SBK_QTMOBILITY_QSERVICEMANAGER_IDX                           8
#define SBK_QTMOBILITY_QSERVICEMANAGER_ERROR_IDX                     9
#define SBK_QTMOBILITY_QABSTRACTSECURITYSESSION_IDX                  10
#define SBK_QTMOBILITY_QSERVICECONTEXT_IDX                           11
#define SBK_QTMOBILITY_QSERVICECONTEXT_CONTEXTTYPE_IDX               12
#define SBK_ServiceFramework_IDX_COUNT                               13

// This variable stores all python types exported by this module
extern PyTypeObject** SbkQtMobility_ServiceFrameworkTypes;

// Macros for type check

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<QtMobility::QService::Scope >() { return SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICE_SCOPE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QServicePluginInterface >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICEPLUGININTERFACE_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QServiceInterfaceDescriptor::Attribute >() { return SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICEINTERFACEDESCRIPTOR_ATTRIBUTE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QServiceInterfaceDescriptor >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICEINTERFACEDESCRIPTOR_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QServiceFilter::CapabilityMatchRule >() { return SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICEFILTER_CAPABILITYMATCHRULE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QServiceFilter::VersionMatchRule >() { return SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICEFILTER_VERSIONMATCHRULE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QServiceFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICEFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QServiceManager::Error >() { return SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICEMANAGER_ERROR_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QServiceManager >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICEMANAGER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QAbstractSecuritySession >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QABSTRACTSECURITYSESSION_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QServiceContext::ContextType >() { return SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICECONTEXT_CONTEXTTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QServiceContext >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICECONTEXT_IDX]); }

template<>
inline PyObject* createWrapper<QtMobility::QServiceManager >(const QtMobility::QServiceManager* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QServiceManager >()),const_cast<QtMobility::QServiceManager*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QAbstractSecuritySession >(const QtMobility::QAbstractSecuritySession* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QAbstractSecuritySession >()),const_cast<QtMobility::QAbstractSecuritySession*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QServiceContext >(const QtMobility::QServiceContext* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QServiceContext >()),const_cast<QtMobility::QServiceContext*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
// Generated converters declarations ----------------------------------

template<>
struct Converter<QtMobility::QService::Scope > : EnumConverter<QtMobility::QService::Scope >
{
};

template<>
struct Converter<QtMobility::QServicePluginInterface* > : ObjectTypeConverter<QtMobility::QServicePluginInterface >
{
};

template<>
struct Converter<QtMobility::QServicePluginInterface& > : ObjectTypeReferenceConverter<QtMobility::QServicePluginInterface >
{
};

template<>
struct Converter<QtMobility::QServiceInterfaceDescriptor::Attribute > : EnumConverter<QtMobility::QServiceInterfaceDescriptor::Attribute >
{
};

template<>
struct Converter<QtMobility::QServiceInterfaceDescriptor > : ValueTypeConverter<QtMobility::QServiceInterfaceDescriptor >
{
};

template<>
struct Converter<QtMobility::QServiceFilter::CapabilityMatchRule > : EnumConverter<QtMobility::QServiceFilter::CapabilityMatchRule >
{
};

template<>
struct Converter<QtMobility::QServiceFilter::VersionMatchRule > : EnumConverter<QtMobility::QServiceFilter::VersionMatchRule >
{
};

template<>
struct Converter<QtMobility::QServiceFilter > : ValueTypeConverter<QtMobility::QServiceFilter >
{
};

template<>
struct Converter<QtMobility::QServiceManager::Error > : EnumConverter<QtMobility::QServiceManager::Error >
{
};

template<>
struct Converter<QtMobility::QServiceManager* > : ObjectTypeConverter<QtMobility::QServiceManager >
{
};

template<>
struct Converter<QtMobility::QServiceManager& > : ObjectTypeReferenceConverter<QtMobility::QServiceManager >
{
};

template<>
struct Converter<QtMobility::QAbstractSecuritySession* > : ObjectTypeConverter<QtMobility::QAbstractSecuritySession >
{
};

template<>
struct Converter<QtMobility::QAbstractSecuritySession& > : ObjectTypeReferenceConverter<QtMobility::QAbstractSecuritySession >
{
};

template<>
struct Converter<QtMobility::QServiceContext::ContextType > : EnumConverter<QtMobility::QServiceContext::ContextType >
{
};

template<>
struct Converter<QtMobility::QServiceContext* > : ObjectTypeConverter<QtMobility::QServiceContext >
{
};

template<>
struct Converter<QtMobility::QServiceContext& > : ObjectTypeReferenceConverter<QtMobility::QServiceContext >
{
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------


#endif // SBK_SERVICEFRAMEWORK_PYTHON_H

