/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_serviceframework_python.h"

#include "qtmobility_qserviceplugininterface_wrapper.h"

// Extra includes
#include <qabstractsecuritysession.h>
#include <qobject.h>
#include <qservicecontext.h>
#include <qserviceinterfacedescriptor.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QServicePluginInterfaceWrapper::QServicePluginInterfaceWrapper() : QtMobility::QServicePluginInterface() {
    // ... middle
}

QObject * QServicePluginInterfaceWrapper::createInstance(const QtMobility::QServiceInterfaceDescriptor & descriptor, QtMobility::QServiceContext * context, QtMobility::QAbstractSecuritySession * session)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createInstance"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QServicePluginInterface.createInstance()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNN)",
        Shiboken::Converter<const QtMobility::QServiceInterfaceDescriptor & >::toPython(descriptor),
        Shiboken::Converter<QtMobility::QServiceContext * >::toPython(context),
        Shiboken::Converter<QtMobility::QAbstractSecuritySession * >::toPython(session)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QObject * >::isConvertible(pyResult);
    typeIsValid = typeIsValid || (pyResult == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QServicePluginInterface.createInstance", SbkType<QObject * >()->tp_name, pyResult->ob_type->tp_name);
        return 0;
    }
    QObject * cppResult(Shiboken::Converter<QObject * >::toCpp(pyResult));
    return cppResult;
}

void QServicePluginInterfaceWrapper::installService()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "installService"));
    if (py_override.isNull()) {
        return this->QtMobility::QServicePluginInterface::installService();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QServicePluginInterfaceWrapper::uninstallService()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "uninstallService"));
    if (py_override.isNull()) {
        return this->QtMobility::QServicePluginInterface::uninstallService();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

QServicePluginInterfaceWrapper::~QServicePluginInterfaceWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QServicePluginInterface_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QServicePluginInterface >()))
        return -1;

    QServicePluginInterfaceWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICEPLUGININTERFACE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QtMobility::QServicePluginInterface' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // QServicePluginInterface()
            cptr = new QServicePluginInterfaceWrapper();
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QServicePluginInterface >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject* SbkQtMobility_QServicePluginInterfaceFunc_createInstance(PyObject* self, PyObject* args)
{
    QtMobility::QServicePluginInterface* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServicePluginInterface* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createInstance", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: createInstance(QtMobility::QServiceInterfaceDescriptor,QtMobility::QServiceContext*,QtMobility::QAbstractSecuritySession*)
    if (numArgs == 3 && Shiboken::Converter<const QtMobility::QServiceInterfaceDescriptor & >::isConvertible(pyargs[0]) && Shiboken::Converter<QtMobility::QServiceContext * >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QAbstractSecuritySession * >::isConvertible(pyargs[2])) {
        overloadId = 0; // createInstance(QtMobility::QServiceInterfaceDescriptor,QtMobility::QServiceContext*,QtMobility::QAbstractSecuritySession*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServicePluginInterfaceFunc_createInstance_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QServiceInterfaceDescriptor* cpp_arg0 = Shiboken::Converter<QtMobility::QServiceInterfaceDescriptor* >::toCpp(pyargs[0]);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QtMobility::QServiceContext* cpp_arg1 = Shiboken::Converter<QtMobility::QServiceContext* >::toCpp(pyargs[1]);
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QtMobility::QAbstractSecuritySession* cpp_arg2 = Shiboken::Converter<QtMobility::QAbstractSecuritySession* >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // createInstance(QtMobility::QServiceInterfaceDescriptor,QtMobility::QServiceContext*,QtMobility::QAbstractSecuritySession*)
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QServicePluginInterface.createInstance()' not implemented.");
                return 0;
            }
            QObject * cppResult = cppSelf->createInstance(*cpp_arg0, cpp_arg1, cpp_arg2);
            pyResult = Shiboken::Converter<QObject * >::toPython(cppResult);
            Shiboken::setParent(self, pyResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QServicePluginInterfaceFunc_createInstance_TypeError:
        const char* overloads[] = {"QtMobility.ServiceFramework.QtMobility::QServiceInterfaceDescriptor, QtMobility.ServiceFramework.QtMobility::QServiceContext, QtMobility.ServiceFramework.QtMobility::QAbstractSecuritySession", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.ServiceFramework.QServicePluginInterface.createInstance", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QServicePluginInterfaceFunc_installService(PyObject* self)
{
    QtMobility::QServicePluginInterface* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServicePluginInterface* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // installService()
            cppSelf->QtMobility::QServicePluginInterface::installService();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QServicePluginInterfaceFunc_uninstallService(PyObject* self)
{
    QtMobility::QServicePluginInterface* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServicePluginInterface* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // uninstallService()
            cppSelf->QtMobility::QServicePluginInterface::uninstallService();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQtMobility_QServicePluginInterface_methods[] = {
    {"createInstance", (PyCFunction)SbkQtMobility_QServicePluginInterfaceFunc_createInstance, METH_VARARGS},
    {"installService", (PyCFunction)SbkQtMobility_QServicePluginInterfaceFunc_installService, METH_NOARGS},
    {"uninstallService", (PyCFunction)SbkQtMobility_QServicePluginInterfaceFunc_uninstallService, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QServicePluginInterface_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.ServiceFramework.QServicePluginInterface",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QServicePluginInterface_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QServicePluginInterface_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QServicePluginInterface >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QServicePluginInterface*",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QServicePluginInterface(PyObject* module)
{
    SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICEPLUGININTERFACE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QServicePluginInterface_Type);

    // Fill type discovery information

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QServicePluginInterface_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QServicePluginInterface_Type));
    PyModule_AddObject(module, "QServicePluginInterface",
        ((PyObject*)&SbkQtMobility_QServicePluginInterface_Type));


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QServicePluginInterface >("QtMobility::QServicePluginInterface*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QServicePluginInterface >(typeid(QtMobility::QServicePluginInterface).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QServicePluginInterface >(typeid(QServicePluginInterfaceWrapper).name());
    PySide::initQtMetaType<QtMobility::QServicePluginInterface* >();
}

