/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_serviceframework_python.h"

#include "qtmobility_qservicefilter_wrapper.h"

// Extra includes
#include <QStringList>
#include <qservicefilter.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QServiceFilter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QServiceFilter >()))
        return -1;

    QtMobility::QServiceFilter* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "rule", "version" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 2, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceFilter(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return -1;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 3) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceFilter(): too many arguments");
        return -1;
    }

    if (!PyArg_ParseTuple(args, "|OOO:QServiceFilter", &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    // Overloaded function decisor
    // 0: QServiceFilter()
    // 1: QServiceFilter(QString,QString,QtMobility::QServiceFilter::VersionMatchRule)
    // 2: QServiceFilter(QtMobility::QServiceFilter)
    if (numArgs == 0) {
        overloadId = 0; // QServiceFilter()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QServiceFilter & >::isConvertible(pyargs[0])) {
        overloadId = 2; // QServiceFilter(QtMobility::QServiceFilter)
    } else if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // QServiceFilter(QString,QString,QtMobility::QServiceFilter::VersionMatchRule)
        } else if (Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
            if (numArgs == 2) {
                overloadId = 1; // QServiceFilter(QString,QString,QtMobility::QServiceFilter::VersionMatchRule)
            } else if (Shiboken::Converter<QtMobility::QServiceFilter::VersionMatchRule >::isConvertible(pyargs[2])) {
                overloadId = 1; // QServiceFilter(QString,QString,QtMobility::QServiceFilter::VersionMatchRule)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceFilter_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QServiceFilter()
            {

                if(!PyErr_Occurred()) {
                // QServiceFilter()
                cptr = new QtMobility::QServiceFilter();
                }
                break;
            }
            case 1: // QServiceFilter(QString,QString,QtMobility::QServiceFilter::VersionMatchRule)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "version");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "version";
                        else
                            pyargs[1] = value;
                    }
                    value = PyDict_GetItemString(kwds, "rule");
                    if (value) {
                        if (pyargs[2])
                            errorArgName = "rule";
                        else
                            pyargs[2] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceFilter(): got multiple values for keyword argument '%s'", errorArgName);
                        return -1;
                    }
                }
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
                QString cpp_arg1 = pyargs[1] ? Shiboken::Converter<QString >::toCpp(pyargs[1]) : QString();
                QtMobility::QServiceFilter::VersionMatchRule cpp_arg2 = pyargs[2] ? Shiboken::Converter<QtMobility::QServiceFilter::VersionMatchRule >::toCpp(pyargs[2]) : QtMobility::QServiceFilter::MinimumVersionMatch;

                if(!PyErr_Occurred()) {
                // QServiceFilter(QString,QString,QtMobility::QServiceFilter::VersionMatchRule)
                cptr = new QtMobility::QServiceFilter(cpp_arg0, cpp_arg1, cpp_arg2);
                }
                break;
            }
            case 2: // QServiceFilter(QtMobility::QServiceFilter)
            {
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return -1;
                QtMobility::QServiceFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QServiceFilter* >::toCpp(pyargs[0]);

                if(!PyErr_Occurred()) {
                // QServiceFilter(QtMobility::QServiceFilter)
                cptr = new QtMobility::QServiceFilter(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QServiceFilter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QServiceFilter_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QServiceFilter_Init_TypeError:
        const char* overloads[] = {"", "QString, QString = QString(), QtMobility.ServiceFramework.QtMobility::QServiceFilter.VersionMatchRule = QServiceFilter.MinimumVersionMatch", "QtMobility.ServiceFramework.QtMobility::QServiceFilter", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.ServiceFramework.QServiceFilter", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QServiceFilterFunc_capabilities(PyObject* self)
{
    QtMobility::QServiceFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // capabilities()const
            QStringList cppResult = cppSelf->QtMobility::QServiceFilter::capabilities();
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QServiceFilterFunc_capabilityMatchRule(PyObject* self)
{
    QtMobility::QServiceFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // capabilityMatchRule()const
            QtMobility::QServiceFilter::CapabilityMatchRule cppResult = cppSelf->QtMobility::QServiceFilter::capabilityMatchRule();
            pyResult = Shiboken::Converter<QtMobility::QServiceFilter::CapabilityMatchRule >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QServiceFilterFunc_clearCustomAttribute(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QServiceFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceFilter* >::toCpp(self);

    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "key" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceFilter.clearCustomAttribute(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceFilter.clearCustomAttribute(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:clearCustomAttribute", &arg))
        return 0;


    // Overloaded function decisor
    // 0: clearCustomAttribute(QString)
    if (numArgs == 0) {
        overloadId = 0; // clearCustomAttribute(QString)
    } else if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // clearCustomAttribute(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceFilterFunc_clearCustomAttribute_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "key");
                if (value) {
                    if (arg)
                        errorArgName = "key";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceFilter.clearCustomAttribute(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QString cpp_arg0 = arg ? Shiboken::Converter<QString >::toCpp(arg) : QString();

            if(!PyErr_Occurred()) {
            // clearCustomAttribute(QString)
            cppSelf->QtMobility::QServiceFilter::clearCustomAttribute(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QServiceFilterFunc_clearCustomAttribute_TypeError:
        const char* overloads[] = {"QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.ServiceFramework.QServiceFilter.clearCustomAttribute", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QServiceFilterFunc_customAttribute(PyObject* self, PyObject* arg)
{
    QtMobility::QServiceFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceFilter* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: customAttribute(QString)const
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // customAttribute(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceFilterFunc_customAttribute_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // customAttribute(QString)const
            QString cppResult = cppSelf->QtMobility::QServiceFilter::customAttribute(cpp_arg0);
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QServiceFilterFunc_customAttribute_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.ServiceFramework.QServiceFilter.customAttribute", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QServiceFilterFunc_customAttributes(PyObject* self)
{
    QtMobility::QServiceFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // customAttributes()const
            QStringList cppResult = cppSelf->QtMobility::QServiceFilter::customAttributes();
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QServiceFilterFunc_interfaceName(PyObject* self)
{
    QtMobility::QServiceFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // interfaceName()const
            QString cppResult = cppSelf->QtMobility::QServiceFilter::interfaceName();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QServiceFilterFunc_majorVersion(PyObject* self)
{
    QtMobility::QServiceFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // majorVersion()const
            int cppResult = cppSelf->QtMobility::QServiceFilter::majorVersion();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QServiceFilterFunc_minorVersion(PyObject* self)
{
    QtMobility::QServiceFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // minorVersion()const
            int cppResult = cppSelf->QtMobility::QServiceFilter::minorVersion();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QServiceFilterFunc_serviceName(PyObject* self)
{
    QtMobility::QServiceFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // serviceName()const
            QString cppResult = cppSelf->QtMobility::QServiceFilter::serviceName();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QServiceFilterFunc_setCapabilities(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QServiceFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceFilter* >::toCpp(self);

    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "capabilities" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceFilter.setCapabilities(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceFilter.setCapabilities(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceFilter.setCapabilities(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:setCapabilities", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: setCapabilities(QtMobility::QServiceFilter::CapabilityMatchRule,QStringList)
    if (Shiboken::Converter<QtMobility::QServiceFilter::CapabilityMatchRule >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // setCapabilities(QtMobility::QServiceFilter::CapabilityMatchRule,QStringList)
        } else if (Shiboken::Converter< QStringList  >::isConvertible(pyargs[1])) {
            overloadId = 0; // setCapabilities(QtMobility::QServiceFilter::CapabilityMatchRule,QStringList)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceFilterFunc_setCapabilities_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "capabilities");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "capabilities";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceFilter.setCapabilities(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QtMobility::QServiceFilter::CapabilityMatchRule cpp_arg0 = Shiboken::Converter<QtMobility::QServiceFilter::CapabilityMatchRule >::toCpp(pyargs[0]);
            QStringList cpp_arg1 = pyargs[1] ? Shiboken::Converter<QStringList >::toCpp(pyargs[1]) : QStringList();

            if(!PyErr_Occurred()) {
            // setCapabilities(QtMobility::QServiceFilter::CapabilityMatchRule,QStringList)
            cppSelf->QtMobility::QServiceFilter::setCapabilities(cpp_arg0, cpp_arg1);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QServiceFilterFunc_setCapabilities_TypeError:
        const char* overloads[] = {"QtMobility.ServiceFramework.QtMobility::QServiceFilter.CapabilityMatchRule, list = QStringList()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.ServiceFramework.QServiceFilter.setCapabilities", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QServiceFilterFunc_setCustomAttribute(PyObject* self, PyObject* args)
{
    QtMobility::QServiceFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceFilter* >::toCpp(self);

    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setCustomAttribute", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: setCustomAttribute(QString,QString)
    if (numArgs == 2 && Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
        overloadId = 0; // setCustomAttribute(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceFilterFunc_setCustomAttribute_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // setCustomAttribute(QString,QString)
            cppSelf->QtMobility::QServiceFilter::setCustomAttribute(cpp_arg0, cpp_arg1);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QServiceFilterFunc_setCustomAttribute_TypeError:
        const char* overloads[] = {"QString, QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.ServiceFramework.QServiceFilter.setCustomAttribute", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QServiceFilterFunc_setInterface(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QServiceFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceFilter* >::toCpp(self);

    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "rule", "version" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 2, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceFilter.setInterface(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 3) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceFilter.setInterface(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceFilter.setInterface(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setInterface", &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: setInterface(QString,QString,QtMobility::QServiceFilter::VersionMatchRule)
    if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // setInterface(QString,QString,QtMobility::QServiceFilter::VersionMatchRule)
        } else if (Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
            if (numArgs == 2) {
                overloadId = 0; // setInterface(QString,QString,QtMobility::QServiceFilter::VersionMatchRule)
            } else if (Shiboken::Converter<QtMobility::QServiceFilter::VersionMatchRule >::isConvertible(pyargs[2])) {
                overloadId = 0; // setInterface(QString,QString,QtMobility::QServiceFilter::VersionMatchRule)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceFilterFunc_setInterface_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "version");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "version";
                    else
                        pyargs[1] = value;
                }
                value = PyDict_GetItemString(kwds, "rule");
                if (value) {
                    if (pyargs[2])
                        errorArgName = "rule";
                    else
                        pyargs[2] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.ServiceFramework.QServiceFilter.setInterface(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            QString cpp_arg1 = pyargs[1] ? Shiboken::Converter<QString >::toCpp(pyargs[1]) : QString();
            QtMobility::QServiceFilter::VersionMatchRule cpp_arg2 = pyargs[2] ? Shiboken::Converter<QtMobility::QServiceFilter::VersionMatchRule >::toCpp(pyargs[2]) : QtMobility::QServiceFilter::MinimumVersionMatch;

            if(!PyErr_Occurred()) {
            // setInterface(QString,QString,QtMobility::QServiceFilter::VersionMatchRule)
            cppSelf->QtMobility::QServiceFilter::setInterface(cpp_arg0, cpp_arg1, cpp_arg2);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QServiceFilterFunc_setInterface_TypeError:
        const char* overloads[] = {"QString, QString = QString(), QtMobility.ServiceFramework.QtMobility::QServiceFilter.VersionMatchRule = QServiceFilter.MinimumVersionMatch", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.ServiceFramework.QServiceFilter.setInterface", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QServiceFilterFunc_setServiceName(PyObject* self, PyObject* arg)
{
    QtMobility::QServiceFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setServiceName(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setServiceName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QServiceFilterFunc_setServiceName_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setServiceName(QString)
            cppSelf->QtMobility::QServiceFilter::setServiceName(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QServiceFilterFunc_setServiceName_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.ServiceFramework.QServiceFilter.setServiceName", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QServiceFilterFunc_versionMatchRule(PyObject* self)
{
    QtMobility::QServiceFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QServiceFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // versionMatchRule()const
            QtMobility::QServiceFilter::VersionMatchRule cppResult = cppSelf->QtMobility::QServiceFilter::versionMatchRule();
            pyResult = Shiboken::Converter<QtMobility::QServiceFilter::VersionMatchRule >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QServiceFilter_methods[] = {
    {"capabilities", (PyCFunction)SbkQtMobility_QServiceFilterFunc_capabilities, METH_NOARGS},
    {"capabilityMatchRule", (PyCFunction)SbkQtMobility_QServiceFilterFunc_capabilityMatchRule, METH_NOARGS},
    {"clearCustomAttribute", (PyCFunction)SbkQtMobility_QServiceFilterFunc_clearCustomAttribute, METH_VARARGS|METH_KEYWORDS},
    {"customAttribute", (PyCFunction)SbkQtMobility_QServiceFilterFunc_customAttribute, METH_O},
    {"customAttributes", (PyCFunction)SbkQtMobility_QServiceFilterFunc_customAttributes, METH_NOARGS},
    {"interfaceName", (PyCFunction)SbkQtMobility_QServiceFilterFunc_interfaceName, METH_NOARGS},
    {"majorVersion", (PyCFunction)SbkQtMobility_QServiceFilterFunc_majorVersion, METH_NOARGS},
    {"minorVersion", (PyCFunction)SbkQtMobility_QServiceFilterFunc_minorVersion, METH_NOARGS},
    {"serviceName", (PyCFunction)SbkQtMobility_QServiceFilterFunc_serviceName, METH_NOARGS},
    {"setCapabilities", (PyCFunction)SbkQtMobility_QServiceFilterFunc_setCapabilities, METH_VARARGS|METH_KEYWORDS},
    {"setCustomAttribute", (PyCFunction)SbkQtMobility_QServiceFilterFunc_setCustomAttribute, METH_VARARGS},
    {"setInterface", (PyCFunction)SbkQtMobility_QServiceFilterFunc_setInterface, METH_VARARGS|METH_KEYWORDS},
    {"setServiceName", (PyCFunction)SbkQtMobility_QServiceFilterFunc_setServiceName, METH_O},
    {"versionMatchRule", (PyCFunction)SbkQtMobility_QServiceFilterFunc_versionMatchRule, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QServiceFilter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.ServiceFramework.QServiceFilter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QServiceFilter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QServiceFilter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QServiceFilter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QServiceFilter",
    /*user_data*/           0
};
} //extern

static PyGetSetDef SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_CapabilityMatchRule_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_CapabilityMatchRule_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_CapabilityMatchRule_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CapabilityMatchRule",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_CapabilityMatchRule_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_CapabilityMatchRule_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_CapabilityMatchRule_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_VersionMatchRule_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_VersionMatchRule_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_VersionMatchRule_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "VersionMatchRule",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_VersionMatchRule_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_VersionMatchRule_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_VersionMatchRule_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QServiceFilter(PyObject* module)
{
    SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICEFILTER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QServiceFilter_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QServiceFilter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QServiceFilter_Type));
    PyModule_AddObject(module, "QServiceFilter",
        ((PyObject*)&SbkQtMobility_QServiceFilter_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: CapabilityMatchRule
    SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICEFILTER_CAPABILITYMATCHRULE_IDX] = &SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_CapabilityMatchRule_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_CapabilityMatchRule_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_CapabilityMatchRule_Type);
    PyDict_SetItemString(SbkQtMobility_QServiceFilter_Type.super.ht_type.tp_dict,
            "CapabilityMatchRule",((PyObject*)&SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_CapabilityMatchRule_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_CapabilityMatchRule_Type,
        (long) QtMobility::QServiceFilter::MatchMinimum, "MatchMinimum");
    PyDict_SetItemString(SbkQtMobility_QServiceFilter_Type.super.ht_type.tp_dict,
        "MatchMinimum", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_CapabilityMatchRule_Type.tp_dict,
        "MatchMinimum", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_CapabilityMatchRule_Type,
        (long) QtMobility::QServiceFilter::MatchLoadable, "MatchLoadable");
    PyDict_SetItemString(SbkQtMobility_QServiceFilter_Type.super.ht_type.tp_dict,
        "MatchLoadable", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_CapabilityMatchRule_Type.tp_dict,
        "MatchLoadable", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QServiceFilter::CapabilityMatchRule");

    // init enum class: VersionMatchRule
    SbkQtMobility_ServiceFrameworkTypes[SBK_QTMOBILITY_QSERVICEFILTER_VERSIONMATCHRULE_IDX] = &SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_VersionMatchRule_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_VersionMatchRule_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_VersionMatchRule_Type);
    PyDict_SetItemString(SbkQtMobility_QServiceFilter_Type.super.ht_type.tp_dict,
            "VersionMatchRule",((PyObject*)&SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_VersionMatchRule_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_VersionMatchRule_Type,
        (long) QtMobility::QServiceFilter::ExactVersionMatch, "ExactVersionMatch");
    PyDict_SetItemString(SbkQtMobility_QServiceFilter_Type.super.ht_type.tp_dict,
        "ExactVersionMatch", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_VersionMatchRule_Type.tp_dict,
        "ExactVersionMatch", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_VersionMatchRule_Type,
        (long) QtMobility::QServiceFilter::MinimumVersionMatch, "MinimumVersionMatch");
    PyDict_SetItemString(SbkQtMobility_QServiceFilter_Type.super.ht_type.tp_dict,
        "MinimumVersionMatch", enum_item);
    PyDict_SetItemString(SbkQtMobility_ServiceFramework_QtMobility_QServiceFilter_VersionMatchRule_Type.tp_dict,
        "MinimumVersionMatch", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QServiceFilter::VersionMatchRule");


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QServiceFilter >("QtMobility::QServiceFilter");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QServiceFilter >("QtMobility::QServiceFilter*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QServiceFilter >(typeid(QtMobility::QServiceFilter).name());
    PySide::initQtMetaType<QtMobility::QServiceFilter >();
}

