/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_SENSORS_PYTHON_H
#define SBK_SENSORS_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#include <qsignal.h>
// Module Includes
#include <pyside_qtcore_python.h>

// Binded library includes
#include <qproximitysensor.h>
#include <qsensorplugin.h>
#include <qcompass.h>
#include <qmagnetometer.h>
#include <qsensorbackend.h>
#include <qorientationsensor.h>
#include <qtapsensor.h>
#include <qsensormanager.h>
#include <qrotationsensor.h>
#include <qambientlightsensor.h>
#include <qsensor.h>
#include <qaccelerometer.h>
// Conversion Includes - Primitive Types
#include <QString>
#include <signalmanager.h>
#include <typeresolver.h>
#include <QtConcurrentFilter>
#include <qtimestamp>
#include <QTextDocument>

// Conversion Includes - Container Types
#include <QList>
#include <QMap>
#include <QStack>
#include <QMultiMap>
#include <QVector>
#include <QPair>
#include <pysideconversions.h>
#include <QSet>
#include <qqueue.h>
#include <QStringList>
#include <qlinkedlist.h>

// Type indices
#define SBK_QTMOBILITY_QSENSORPLUGININTERFACE_IDX                    0
#define SBK_QTMOBILITY_QSENSORBACKENDFACTORY_IDX                     1
#define SBK_QTMOBILITY_QSENSORMANAGER_IDX                            2
#define SBK_QTMOBILITY_QOUTPUTRANGE_IDX                              3
#define SBK_QTMOBILITY_QSENSORFILTER_IDX                             4
#define SBK_QTMOBILITY_QPROXIMITYFILTER_IDX                          5
#define SBK_QTMOBILITY_QACCELEROMETERFILTER_IDX                      6
#define SBK_QTMOBILITY_QORIENTATIONFILTER_IDX                        7
#define SBK_QTMOBILITY_QMAGNETOMETERFILTER_IDX                       8
#define SBK_QTMOBILITY_QTAPFILTER_IDX                                9
#define SBK_QTMOBILITY_QCOMPASSFILTER_IDX                            10
#define SBK_QTMOBILITY_QROTATIONFILTER_IDX                           11
#define SBK_QTMOBILITY_QAMBIENTLIGHTFILTER_IDX                       12
#define SBK_QTMOBILITY_QSENSORREADING_IDX                            13
#define SBK_QTMOBILITY_QPROXIMITYREADING_IDX                         14
#define SBK_QTMOBILITY_QACCELEROMETERREADING_IDX                     15
#define SBK_QTMOBILITY_QORIENTATIONREADING_IDX                       16
#define SBK_QTMOBILITY_QORIENTATIONREADING_ORIENTATION_IDX           17
#define SBK_QTMOBILITY_QMAGNETOMETERREADING_IDX                      18
#define SBK_QTMOBILITY_QTAPREADING_IDX                               19
#define SBK_QTMOBILITY_QTAPREADING_TAPDIRECTION_IDX                  20
#define SBK_QTMOBILITY_QCOMPASSREADING_IDX                           21
#define SBK_QTMOBILITY_QROTATIONREADING_IDX                          22
#define SBK_QTMOBILITY_QAMBIENTLIGHTREADING_IDX                      23
#define SBK_QTMOBILITY_QAMBIENTLIGHTREADING_LIGHTLEVEL_IDX           24
#define SBK_QTMOBILITY_QSENSOR_IDX                                   25
#define SBK_QTMOBILITY_QACCELEROMETER_IDX                            26
#define SBK_QTMOBILITY_QORIENTATIONSENSOR_IDX                        27
#define SBK_QTMOBILITY_QMAGNETOMETER_IDX                             28
#define SBK_QTMOBILITY_QTAPSENSOR_IDX                                29
#define SBK_QTMOBILITY_QCOMPASS_IDX                                  30
#define SBK_QTMOBILITY_QROTATIONSENSOR_IDX                           31
#define SBK_QTMOBILITY_QAMBIENTLIGHTSENSOR_IDX                       32
#define SBK_QTMOBILITY_QPROXIMITYSENSOR_IDX                          33
#define SBK_QTMOBILITY_QSENSORBACKEND_IDX                            34
#define SBK_Sensors_IDX_COUNT                                        35

// This variable stores all python types exported by this module
extern PyTypeObject** SbkQtMobility_SensorsTypes;

// Macros for type check

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<QtMobility::QSensorPluginInterface >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QSENSORPLUGININTERFACE_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QSensorBackendFactory >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QSENSORBACKENDFACTORY_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QSensorManager >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QSENSORMANAGER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::qoutputrange >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QOUTPUTRANGE_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QSensorFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QSENSORFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QProximityFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QPROXIMITYFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QAccelerometerFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QACCELEROMETERFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QOrientationFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QORIENTATIONFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QMagnetometerFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QMAGNETOMETERFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QTapFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QTAPFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QCompassFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QCOMPASSFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QRotationFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QROTATIONFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QAmbientLightFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QAMBIENTLIGHTFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QSensorReading >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QSENSORREADING_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QProximityReading >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QPROXIMITYREADING_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QAccelerometerReading >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QACCELEROMETERREADING_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QOrientationReading::Orientation >() { return SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QORIENTATIONREADING_ORIENTATION_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QOrientationReading >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QORIENTATIONREADING_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QMagnetometerReading >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QMAGNETOMETERREADING_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QTapReading::TapDirection >() { return SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QTAPREADING_TAPDIRECTION_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QTapReading >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QTAPREADING_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QCompassReading >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QCOMPASSREADING_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QRotationReading >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QROTATIONREADING_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QAmbientLightReading::LightLevel >() { return SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QAMBIENTLIGHTREADING_LIGHTLEVEL_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QAmbientLightReading >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QAMBIENTLIGHTREADING_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QSensor >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QSENSOR_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QAccelerometer >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QACCELEROMETER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QOrientationSensor >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QORIENTATIONSENSOR_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QMagnetometer >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QMAGNETOMETER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QTapSensor >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QTAPSENSOR_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QCompass >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QCOMPASS_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QRotationSensor >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QROTATIONSENSOR_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QAmbientLightSensor >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QAMBIENTLIGHTSENSOR_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QProximitySensor >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QPROXIMITYSENSOR_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QSensorBackend >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QSENSORBACKEND_IDX]); }

template<>
inline PyObject* createWrapper<QtMobility::QSensorReading >(const QtMobility::QSensorReading* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QSensorReading >()),const_cast<QtMobility::QSensorReading*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QProximityReading >(const QtMobility::QProximityReading* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QProximityReading >()),const_cast<QtMobility::QProximityReading*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QAccelerometerReading >(const QtMobility::QAccelerometerReading* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QAccelerometerReading >()),const_cast<QtMobility::QAccelerometerReading*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QOrientationReading >(const QtMobility::QOrientationReading* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QOrientationReading >()),const_cast<QtMobility::QOrientationReading*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QMagnetometerReading >(const QtMobility::QMagnetometerReading* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QMagnetometerReading >()),const_cast<QtMobility::QMagnetometerReading*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QTapReading >(const QtMobility::QTapReading* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QTapReading >()),const_cast<QtMobility::QTapReading*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QCompassReading >(const QtMobility::QCompassReading* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QCompassReading >()),const_cast<QtMobility::QCompassReading*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QRotationReading >(const QtMobility::QRotationReading* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QRotationReading >()),const_cast<QtMobility::QRotationReading*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QAmbientLightReading >(const QtMobility::QAmbientLightReading* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QAmbientLightReading >()),const_cast<QtMobility::QAmbientLightReading*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QSensor >(const QtMobility::QSensor* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QSensor >()),const_cast<QtMobility::QSensor*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QAccelerometer >(const QtMobility::QAccelerometer* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QAccelerometer >()),const_cast<QtMobility::QAccelerometer*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QOrientationSensor >(const QtMobility::QOrientationSensor* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QOrientationSensor >()),const_cast<QtMobility::QOrientationSensor*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QMagnetometer >(const QtMobility::QMagnetometer* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QMagnetometer >()),const_cast<QtMobility::QMagnetometer*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QTapSensor >(const QtMobility::QTapSensor* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QTapSensor >()),const_cast<QtMobility::QTapSensor*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QCompass >(const QtMobility::QCompass* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QCompass >()),const_cast<QtMobility::QCompass*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QRotationSensor >(const QtMobility::QRotationSensor* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QRotationSensor >()),const_cast<QtMobility::QRotationSensor*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QAmbientLightSensor >(const QtMobility::QAmbientLightSensor* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QAmbientLightSensor >()),const_cast<QtMobility::QAmbientLightSensor*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QProximitySensor >(const QtMobility::QProximitySensor* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QProximitySensor >()),const_cast<QtMobility::QProximitySensor*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QSensorBackend >(const QtMobility::QSensorBackend* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QSensorBackend >()),const_cast<QtMobility::QSensorBackend*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
// Generated converters declarations ----------------------------------

template<>
struct Converter<QtMobility::QSensorPluginInterface* > : ObjectTypeConverter<QtMobility::QSensorPluginInterface >
{
};

template<>
struct Converter<QtMobility::QSensorPluginInterface& > : ObjectTypeReferenceConverter<QtMobility::QSensorPluginInterface >
{
};

template<>
struct Converter<QtMobility::QSensorBackendFactory* > : ObjectTypeConverter<QtMobility::QSensorBackendFactory >
{
};

template<>
struct Converter<QtMobility::QSensorBackendFactory& > : ObjectTypeReferenceConverter<QtMobility::QSensorBackendFactory >
{
};

template<>
struct Converter<QtMobility::QSensorManager > : ValueTypeConverter<QtMobility::QSensorManager >
{
};

template<>
struct Converter<QtMobility::qoutputrange > : ValueTypeConverter<QtMobility::qoutputrange >
{
};

template<>
struct Converter<QtMobility::QSensorFilter* > : ObjectTypeConverter<QtMobility::QSensorFilter >
{
};

template<>
struct Converter<QtMobility::QSensorFilter& > : ObjectTypeReferenceConverter<QtMobility::QSensorFilter >
{
};

template<>
struct Converter<QtMobility::QProximityFilter* > : ObjectTypeConverter<QtMobility::QProximityFilter >
{
};

template<>
struct Converter<QtMobility::QProximityFilter& > : ObjectTypeReferenceConverter<QtMobility::QProximityFilter >
{
};

template<>
struct Converter<QtMobility::QAccelerometerFilter* > : ObjectTypeConverter<QtMobility::QAccelerometerFilter >
{
};

template<>
struct Converter<QtMobility::QAccelerometerFilter& > : ObjectTypeReferenceConverter<QtMobility::QAccelerometerFilter >
{
};

template<>
struct Converter<QtMobility::QOrientationFilter* > : ObjectTypeConverter<QtMobility::QOrientationFilter >
{
};

template<>
struct Converter<QtMobility::QOrientationFilter& > : ObjectTypeReferenceConverter<QtMobility::QOrientationFilter >
{
};

template<>
struct Converter<QtMobility::QMagnetometerFilter* > : ObjectTypeConverter<QtMobility::QMagnetometerFilter >
{
};

template<>
struct Converter<QtMobility::QMagnetometerFilter& > : ObjectTypeReferenceConverter<QtMobility::QMagnetometerFilter >
{
};

template<>
struct Converter<QtMobility::QTapFilter* > : ObjectTypeConverter<QtMobility::QTapFilter >
{
};

template<>
struct Converter<QtMobility::QTapFilter& > : ObjectTypeReferenceConverter<QtMobility::QTapFilter >
{
};

template<>
struct Converter<QtMobility::QCompassFilter* > : ObjectTypeConverter<QtMobility::QCompassFilter >
{
};

template<>
struct Converter<QtMobility::QCompassFilter& > : ObjectTypeReferenceConverter<QtMobility::QCompassFilter >
{
};

template<>
struct Converter<QtMobility::QRotationFilter* > : ObjectTypeConverter<QtMobility::QRotationFilter >
{
};

template<>
struct Converter<QtMobility::QRotationFilter& > : ObjectTypeReferenceConverter<QtMobility::QRotationFilter >
{
};

template<>
struct Converter<QtMobility::QAmbientLightFilter* > : ObjectTypeConverter<QtMobility::QAmbientLightFilter >
{
};

template<>
struct Converter<QtMobility::QAmbientLightFilter& > : ObjectTypeReferenceConverter<QtMobility::QAmbientLightFilter >
{
};

template<>
struct Converter<QtMobility::QSensorReading* > : ObjectTypeConverter<QtMobility::QSensorReading >
{
};

template<>
struct Converter<QtMobility::QSensorReading& > : ObjectTypeReferenceConverter<QtMobility::QSensorReading >
{
};

template<>
struct Converter<QtMobility::QProximityReading* > : ObjectTypeConverter<QtMobility::QProximityReading >
{
};

template<>
struct Converter<QtMobility::QProximityReading& > : ObjectTypeReferenceConverter<QtMobility::QProximityReading >
{
};

template<>
struct Converter<QtMobility::QAccelerometerReading* > : ObjectTypeConverter<QtMobility::QAccelerometerReading >
{
};

template<>
struct Converter<QtMobility::QAccelerometerReading& > : ObjectTypeReferenceConverter<QtMobility::QAccelerometerReading >
{
};

template<>
struct Converter<QtMobility::QOrientationReading::Orientation > : EnumConverter<QtMobility::QOrientationReading::Orientation >
{
};

template<>
struct Converter<QtMobility::QOrientationReading* > : ObjectTypeConverter<QtMobility::QOrientationReading >
{
};

template<>
struct Converter<QtMobility::QOrientationReading& > : ObjectTypeReferenceConverter<QtMobility::QOrientationReading >
{
};

template<>
struct Converter<QtMobility::QMagnetometerReading* > : ObjectTypeConverter<QtMobility::QMagnetometerReading >
{
};

template<>
struct Converter<QtMobility::QMagnetometerReading& > : ObjectTypeReferenceConverter<QtMobility::QMagnetometerReading >
{
};

template<>
struct Converter<QtMobility::QTapReading::TapDirection > : EnumConverter<QtMobility::QTapReading::TapDirection >
{
};

template<>
struct Converter<QtMobility::QTapReading* > : ObjectTypeConverter<QtMobility::QTapReading >
{
};

template<>
struct Converter<QtMobility::QTapReading& > : ObjectTypeReferenceConverter<QtMobility::QTapReading >
{
};

template<>
struct Converter<QtMobility::QCompassReading* > : ObjectTypeConverter<QtMobility::QCompassReading >
{
};

template<>
struct Converter<QtMobility::QCompassReading& > : ObjectTypeReferenceConverter<QtMobility::QCompassReading >
{
};

template<>
struct Converter<QtMobility::QRotationReading* > : ObjectTypeConverter<QtMobility::QRotationReading >
{
};

template<>
struct Converter<QtMobility::QRotationReading& > : ObjectTypeReferenceConverter<QtMobility::QRotationReading >
{
};

template<>
struct Converter<QtMobility::QAmbientLightReading::LightLevel > : EnumConverter<QtMobility::QAmbientLightReading::LightLevel >
{
};

template<>
struct Converter<QtMobility::QAmbientLightReading* > : ObjectTypeConverter<QtMobility::QAmbientLightReading >
{
};

template<>
struct Converter<QtMobility::QAmbientLightReading& > : ObjectTypeReferenceConverter<QtMobility::QAmbientLightReading >
{
};

template<>
struct Converter<QtMobility::QSensor* > : ObjectTypeConverter<QtMobility::QSensor >
{
};

template<>
struct Converter<QtMobility::QSensor& > : ObjectTypeReferenceConverter<QtMobility::QSensor >
{
};

template<>
struct Converter<QtMobility::QAccelerometer* > : ObjectTypeConverter<QtMobility::QAccelerometer >
{
};

template<>
struct Converter<QtMobility::QAccelerometer& > : ObjectTypeReferenceConverter<QtMobility::QAccelerometer >
{
};

template<>
struct Converter<QtMobility::QOrientationSensor* > : ObjectTypeConverter<QtMobility::QOrientationSensor >
{
};

template<>
struct Converter<QtMobility::QOrientationSensor& > : ObjectTypeReferenceConverter<QtMobility::QOrientationSensor >
{
};

template<>
struct Converter<QtMobility::QMagnetometer* > : ObjectTypeConverter<QtMobility::QMagnetometer >
{
};

template<>
struct Converter<QtMobility::QMagnetometer& > : ObjectTypeReferenceConverter<QtMobility::QMagnetometer >
{
};

template<>
struct Converter<QtMobility::QTapSensor* > : ObjectTypeConverter<QtMobility::QTapSensor >
{
};

template<>
struct Converter<QtMobility::QTapSensor& > : ObjectTypeReferenceConverter<QtMobility::QTapSensor >
{
};

template<>
struct Converter<QtMobility::QCompass* > : ObjectTypeConverter<QtMobility::QCompass >
{
};

template<>
struct Converter<QtMobility::QCompass& > : ObjectTypeReferenceConverter<QtMobility::QCompass >
{
};

template<>
struct Converter<QtMobility::QRotationSensor* > : ObjectTypeConverter<QtMobility::QRotationSensor >
{
};

template<>
struct Converter<QtMobility::QRotationSensor& > : ObjectTypeReferenceConverter<QtMobility::QRotationSensor >
{
};

template<>
struct Converter<QtMobility::QAmbientLightSensor* > : ObjectTypeConverter<QtMobility::QAmbientLightSensor >
{
};

template<>
struct Converter<QtMobility::QAmbientLightSensor& > : ObjectTypeReferenceConverter<QtMobility::QAmbientLightSensor >
{
};

template<>
struct Converter<QtMobility::QProximitySensor* > : ObjectTypeConverter<QtMobility::QProximitySensor >
{
};

template<>
struct Converter<QtMobility::QProximitySensor& > : ObjectTypeReferenceConverter<QtMobility::QProximitySensor >
{
};

template<>
struct Converter<QtMobility::QSensorBackend* > : ObjectTypeConverter<QtMobility::QSensorBackend >
{
};

template<>
struct Converter<QtMobility::QSensorBackend& > : ObjectTypeReferenceConverter<QtMobility::QSensorBackend >
{
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Conversion rule for: QtMobility::qtimestamp
namespace Shiboken {

template<>
inline PyTypeObject* SbkType<QtMobility::qtimestamp>()
{
    return &PyInt_Type;
}

template<>
struct Converter<QtMobility::qtimestamp>
{
    static bool checkType(PyObject* pyObj)
    {
        return PyInt_Check(pyObj);
    }

    static bool isConvertible(PyObject* pyObj)
    {
        return checkType(pyObj);
    }

    static QtMobility::qtimestamp toCpp(PyObject* pyObj)
    {
        if (checkType(pyObj)) {
            long value = PyLong_AsLong(pyObj);
            return QtMobility::qtimestamp(value);
        }
        return QtMobility::qtimestamp();
    }

    static PyObject* toPython(void* cppObj) { return toPython(*reinterpret_cast<QtMobility::qtimestamp*>(cppObj)); }
    static PyObject* toPython(const QtMobility::qtimestamp& cppObj)
    {
        return PyInt_FromLong((quint64)cppObj);
    }
};
}
// Generated converters implemantations -------------------------------


#endif // SBK_SENSORS_PYTHON_H

