/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_sensors_python.h"

#include "qtmobility_qsensormanager_wrapper.h"

// Extra includes
#include <qbytearray.h>
#include <qsensor.h>
#include <qsensorbackend.h>
#include <qsensormanager.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QSensorManager_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QSensorManager >()))
        return -1;

    QtMobility::QSensorManager* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QSensorManager", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QSensorManager()
    // 1: QSensorManager(QtMobility::QSensorManager)
    if (numArgs == 0) {
        overloadId = 0; // QSensorManager()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QSensorManager & >::isConvertible(arg)) {
        overloadId = 1; // QSensorManager(QtMobility::QSensorManager)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSensorManager_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QSensorManager()
            {

                if(!PyErr_Occurred()) {
                // QSensorManager()
                cptr = new QtMobility::QSensorManager();
                }
                break;
            }
            case 1: // QSensorManager(QtMobility::QSensorManager)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QSensorManager* cpp_arg0 = Shiboken::Converter<QtMobility::QSensorManager* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QSensorManager(QtMobility::QSensorManager)
                cptr = new QtMobility::QSensorManager(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QSensorManager >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QSensorManager_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QSensorManager_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Sensors.QtMobility::QSensorManager", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Sensors.QSensorManager", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QSensorManagerFunc_createBackend(PyObject* self, PyObject* arg)
{
    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: createBackend(QtMobility::QSensor*)
    if (Shiboken::Converter<QtMobility::QSensor * >::isConvertible(arg)) {
        overloadId = 0; // createBackend(QtMobility::QSensor*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSensorManagerFunc_createBackend_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QSensor* cpp_arg0 = Shiboken::Converter<QtMobility::QSensor* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // createBackend(QtMobility::QSensor*)
            QtMobility::QSensorBackend * cppResult = QtMobility::QSensorManager::createBackend(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QSensorBackend * >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QSensorManagerFunc_createBackend_TypeError:
        const char* overloads[] = {"QtMobility.Sensors.QtMobility::QSensor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Sensors.QSensorManager.createBackend", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSensorManagerFunc_registerBackend(PyObject* self, PyObject* args)
{
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "registerBackend", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: registerBackend(QByteArray,QByteArray,QtMobility::QSensorBackendFactory*)
    if (numArgs == 3 && Shiboken::Converter<const QByteArray & >::isConvertible(pyargs[0]) && Shiboken::Converter<const QByteArray & >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QSensorBackendFactory * >::isConvertible(pyargs[2])) {
        overloadId = 0; // registerBackend(QByteArray,QByteArray,QtMobility::QSensorBackendFactory*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSensorManagerFunc_registerBackend_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
            QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
            if (!Shiboken::Converter<QByteArray >::checkType(pyargs[0]))
                cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
            QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QByteArray >::checkType(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QtMobility::QSensorBackendFactory* cpp_arg2 = Shiboken::Converter<QtMobility::QSensorBackendFactory* >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // registerBackend(QByteArray,QByteArray,QtMobility::QSensorBackendFactory*)
            QtMobility::QSensorManager::registerBackend(*cpp_arg0, *cpp_arg1, cpp_arg2);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QSensorManagerFunc_registerBackend_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray, PySide.QtCore.QByteArray, QtMobility.Sensors.QtMobility::QSensorBackendFactory", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Sensors.QSensorManager.registerBackend", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QSensorManager_methods[] = {
    {"createBackend", (PyCFunction)SbkQtMobility_QSensorManagerFunc_createBackend, METH_O|METH_STATIC},
    {"registerBackend", (PyCFunction)SbkQtMobility_QSensorManagerFunc_registerBackend, METH_VARARGS|METH_STATIC},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QSensorManager_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Sensors.QSensorManager",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QSensorManager_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QSensorManager_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QSensorManager >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QSensorManager",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QSensorManager(PyObject* module)
{
    SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QSENSORMANAGER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QSensorManager_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QSensorManager_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QSensorManager_Type));
    PyModule_AddObject(module, "QSensorManager",
        ((PyObject*)&SbkQtMobility_QSensorManager_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QSensorManager >("QtMobility::QSensorManager");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QSensorManager >("QtMobility::QSensorManager*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QSensorManager >(typeid(QtMobility::QSensorManager).name());
    PySide::initQtMetaType<QtMobility::QSensorManager >();
}

