/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_sensors_python.h"

#include "qtmobility_qsensorbackendfactory_wrapper.h"

// Extra includes
#include <qsensor.h>
#include <qsensorbackend.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QSensorBackendFactoryWrapper::QSensorBackendFactoryWrapper() : QtMobility::QSensorBackendFactory() {
    // ... middle
}

QtMobility::QSensorBackend * QSensorBackendFactoryWrapper::createBackend(QtMobility::QSensor * sensor)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createBackend"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSensorBackendFactory.createBackend()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QtMobility::QSensor * >::toPython(sensor)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QtMobility::QSensorBackend * >::isConvertible(pyResult);
    typeIsValid = typeIsValid || (pyResult == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSensorBackendFactory.createBackend", SbkType<QtMobility::QSensorBackend * >()->tp_name, pyResult->ob_type->tp_name);
        return 0;
    }
    QtMobility::QSensorBackend * cppResult(Shiboken::Converter<QtMobility::QSensorBackend * >::toCpp(pyResult));
    return cppResult;
}

QSensorBackendFactoryWrapper::~QSensorBackendFactoryWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QSensorBackendFactory_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QSensorBackendFactory >()))
        return -1;

    QSensorBackendFactoryWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QSENSORBACKENDFACTORY_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QtMobility::QSensorBackendFactory' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // QSensorBackendFactory()
            cptr = new QSensorBackendFactoryWrapper();
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QSensorBackendFactory >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject* SbkQtMobility_QSensorBackendFactoryFunc_createBackend(PyObject* self, PyObject* arg)
{
    QtMobility::QSensorBackendFactory* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensorBackendFactory* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: createBackend(QtMobility::QSensor*)
    if (Shiboken::Converter<QtMobility::QSensor * >::isConvertible(arg)) {
        overloadId = 0; // createBackend(QtMobility::QSensor*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSensorBackendFactoryFunc_createBackend_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QSensor* cpp_arg0 = Shiboken::Converter<QtMobility::QSensor* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // createBackend(QtMobility::QSensor*)
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSensorBackendFactory.createBackend()' not implemented.");
                return 0;
            }
            QtMobility::QSensorBackend * cppResult = cppSelf->createBackend(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QSensorBackend * >::toPython(cppResult);
            Shiboken::setParent(self, pyResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QSensorBackendFactoryFunc_createBackend_TypeError:
        const char* overloads[] = {"QtMobility.Sensors.QtMobility::QSensor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Sensors.QSensorBackendFactory.createBackend", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QSensorBackendFactory_methods[] = {
    {"createBackend", (PyCFunction)SbkQtMobility_QSensorBackendFactoryFunc_createBackend, METH_O},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QSensorBackendFactory_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Sensors.QSensorBackendFactory",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QSensorBackendFactory_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QSensorBackendFactory_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QSensorBackendFactory >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QSensorBackendFactory*",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QSensorBackendFactory(PyObject* module)
{
    SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QSENSORBACKENDFACTORY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QSensorBackendFactory_Type);

    // Fill type discovery information

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QSensorBackendFactory_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QSensorBackendFactory_Type));
    PyModule_AddObject(module, "QSensorBackendFactory",
        ((PyObject*)&SbkQtMobility_QSensorBackendFactory_Type));


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QSensorBackendFactory >("QtMobility::QSensorBackendFactory*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QSensorBackendFactory >(typeid(QtMobility::QSensorBackendFactory).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QSensorBackendFactory >(typeid(QSensorBackendFactoryWrapper).name());
    PySide::initQtMetaType<QtMobility::QSensorBackendFactory* >();
}

