/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_sensors_python.h"

#include "qtmobility_qsensor_wrapper.h"

// Extra includes
#include <QList>
#include <QPair>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsensor.h>
#include <qthread.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QSensorWrapper::QSensorWrapper(const QByteArray & type, QObject * parent) : QtMobility::QSensor(type, parent), m_metaObject(0) {
    // ... middle
}

void QSensorWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSensorWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QSensorWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSensorWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QSensorWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSensor.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QSensorWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSensor.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

void QSensorWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QSensorWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QSensor::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QSensorWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QSensor::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QSensorWrapper::~QSensorWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QSensor_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QSensor >()))
        return -1;

    QSensorWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "parent" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                propertyKeys.push_back(argName);
            }
        }
    }

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Sensors.QSensor(): not enough arguments");
        return -1;
    }

    if (!PyArg_ParseTuple(args, "|OO:QSensor", &(pyargs[0]), &(pyargs[1])))
        return -1;

    // Overloaded function decisor
    // 0: QSensor(QByteArray,QObject*)
    if (Shiboken::Converter<const QByteArray & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // QSensor(QByteArray,QObject*)
        } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
            overloadId = 0; // QSensor(QByteArray,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSensor_Init_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "parent");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "parent";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Sensors.QSensor(): got multiple values for keyword argument '%s'", errorArgName);
                    return -1;
                }
            }
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return -1;
            std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
            QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
            if (!Shiboken::Converter<QByteArray >::checkType(pyargs[0]))
                cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = pyargs[1] ? Shiboken::Converter<QObject* >::toCpp(pyargs[1]) : 0;

            if(!PyErr_Occurred()) {
            // QSensor(QByteArray,QObject*)
            cptr = new QSensorWrapper(*cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[1], self);
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QSensor >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QSensor_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    PySide::signalUpdateSource(self);
    cptr->metaObject();
    for (std::vector<PyObject*>::size_type i = 0; i < propertyKeys.size(); i++) {
        const char* propName = PyString_AS_STRING(propertyKeys[i]);
        const QMetaObject* mo = cptr->metaObject();
        if (mo->indexOfProperty(propName) != -1) {
            cptr->setProperty(propName, Shiboken::Converter<QVariant>::toCpp(PyDict_GetItem(kwds, propertyKeys[i])));
        } else {
            QString signalSignature = QString("%1()").arg(propName);
            if (mo->indexOfSignal(qPrintable(signalSignature)) != -1) {
                signalSignature = '2' + signalSignature;
                PySide::signal_connect(self, qPrintable(signalSignature), PyDict_GetItem(kwds, propertyKeys[i]));
            } else {
                delete cptr;
                PyErr_Format(PyExc_AttributeError, "'%s' is not a Qt property or a signal", propName);
                return -1;
            };
        }
    }


    return 1;

    SbkQtMobility_QSensor_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray, PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Sensors.QSensor", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QSensorFunc_addFilter(PyObject* self, PyObject* arg)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: addFilter(QtMobility::QSensorFilter*)
    if (Shiboken::Converter<QtMobility::QSensorFilter * >::isConvertible(arg)) {
        overloadId = 0; // addFilter(QtMobility::QSensorFilter*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSensorFunc_addFilter_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QSensorFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QSensorFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // addFilter(QtMobility::QSensorFilter*)
            cppSelf->QtMobility::QSensor::addFilter(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QSensorFunc_addFilter_TypeError:
        const char* overloads[] = {"QtMobility.Sensors.QtMobility::QSensorFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Sensors.QSensor.addFilter", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSensorFunc_availableDataRates(PyObject* self)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // availableDataRates()const
            QList<QPair<int, int > > cppResult = cppSelf->QtMobility::QSensor::availableDataRates();
            pyResult = Shiboken::Converter<QList<QPair<int, int > > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSensorFunc_connectToBackend(PyObject* self)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // connectToBackend()
            bool cppResult = cppSelf->QtMobility::QSensor::connectToBackend();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSensorFunc_dataRate(PyObject* self)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // dataRate()const
            int cppResult = cppSelf->QtMobility::QSensor::dataRate();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSensorFunc_defaultSensorForType(PyObject* self, PyObject* arg)
{
    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: defaultSensorForType(QByteArray)
    if (Shiboken::Converter<const QByteArray & >::isConvertible(arg)) {
        overloadId = 0; // defaultSensorForType(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSensorFunc_defaultSensorForType_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
            QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
            if (!Shiboken::Converter<QByteArray >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // defaultSensorForType(QByteArray)
            QByteArray cppResult = QtMobility::QSensor::defaultSensorForType(*cpp_arg0);
            pyResult = Shiboken::Converter<QByteArray >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QSensorFunc_defaultSensorForType_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Sensors.QSensor.defaultSensorForType", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSensorFunc_description(PyObject* self)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // description()const
            QString cppResult = cppSelf->QtMobility::QSensor::description();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSensorFunc_error(PyObject* self)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // error()const
            int cppResult = cppSelf->QtMobility::QSensor::error();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSensorFunc_identifier(PyObject* self)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // identifier()const
            QByteArray cppResult = cppSelf->QtMobility::QSensor::identifier();
            pyResult = Shiboken::Converter<QByteArray >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSensorFunc_isActive(PyObject* self)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isActive()const
            bool cppResult = cppSelf->QtMobility::QSensor::isActive();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSensorFunc_isBusy(PyObject* self)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isBusy()const
            bool cppResult = cppSelf->QtMobility::QSensor::isBusy();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSensorFunc_isConnectedToBackend(PyObject* self)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isConnectedToBackend()const
            bool cppResult = cppSelf->QtMobility::QSensor::isConnectedToBackend();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSensorFunc_outputRange(PyObject* self)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // outputRange()const
            int cppResult = cppSelf->QtMobility::QSensor::outputRange();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSensorFunc_outputRanges(PyObject* self)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // outputRanges()const
            QList<QtMobility::qoutputrange > cppResult = cppSelf->QtMobility::QSensor::outputRanges();
            pyResult = Shiboken::Converter<QList<QtMobility::qoutputrange > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSensorFunc_reading(PyObject* self)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // reading()const
            QtMobility::QSensorReading * cppResult = cppSelf->QtMobility::QSensor::reading();
            pyResult = Shiboken::Converter<QtMobility::QSensorReading * >::toPython(cppResult);
            Shiboken::setParent(self, pyResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSensorFunc_removeFilter(PyObject* self, PyObject* arg)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: removeFilter(QtMobility::QSensorFilter*)
    if (Shiboken::Converter<QtMobility::QSensorFilter * >::isConvertible(arg)) {
        overloadId = 0; // removeFilter(QtMobility::QSensorFilter*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSensorFunc_removeFilter_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QSensorFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QSensorFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // removeFilter(QtMobility::QSensorFilter*)
            cppSelf->QtMobility::QSensor::removeFilter(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QSensorFunc_removeFilter_TypeError:
        const char* overloads[] = {"QtMobility.Sensors.QtMobility::QSensorFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Sensors.QSensor.removeFilter", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSensorFunc_sensorTypes(PyObject* self)
{
    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // sensorTypes()
            QList<QByteArray > cppResult = QtMobility::QSensor::sensorTypes();
            pyResult = Shiboken::Converter<QList<QByteArray > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSensorFunc_sensorsForType(PyObject* self, PyObject* arg)
{
    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: sensorsForType(QByteArray)
    if (Shiboken::Converter<const QByteArray & >::isConvertible(arg)) {
        overloadId = 0; // sensorsForType(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSensorFunc_sensorsForType_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
            QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
            if (!Shiboken::Converter<QByteArray >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // sensorsForType(QByteArray)
            QList<QByteArray > cppResult = QtMobility::QSensor::sensorsForType(*cpp_arg0);
            pyResult = Shiboken::Converter<QList<QByteArray > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QSensorFunc_sensorsForType_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Sensors.QSensor.sensorsForType", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSensorFunc_setDataRate(PyObject* self, PyObject* arg)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setDataRate(int)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setDataRate(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSensorFunc_setDataRate_TypeError;

    // Call function/method
    {
        {
            int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setDataRate(int)
            cppSelf->QtMobility::QSensor::setDataRate(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QSensorFunc_setDataRate_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Sensors.QSensor.setDataRate", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSensorFunc_setIdentifier(PyObject* self, PyObject* arg)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setIdentifier(QByteArray)
    if (Shiboken::Converter<const QByteArray & >::isConvertible(arg)) {
        overloadId = 0; // setIdentifier(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSensorFunc_setIdentifier_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
            QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
            if (!Shiboken::Converter<QByteArray >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // setIdentifier(QByteArray)
            cppSelf->QtMobility::QSensor::setIdentifier(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QSensorFunc_setIdentifier_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Sensors.QSensor.setIdentifier", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSensorFunc_setOutputRange(PyObject* self, PyObject* arg)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setOutputRange(int)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setOutputRange(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QSensorFunc_setOutputRange_TypeError;

    // Call function/method
    {
        {
            int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setOutputRange(int)
            cppSelf->QtMobility::QSensor::setOutputRange(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QSensorFunc_setOutputRange_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Sensors.QSensor.setOutputRange", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QSensorFunc_start(PyObject* self)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // start()
            bool cppResult = cppSelf->QtMobility::QSensor::start();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QSensorFunc_stop(PyObject* self)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // stop()
            cppSelf->QtMobility::QSensor::stop();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QSensorFunc_type(PyObject* self)
{
    QtMobility::QSensor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QSensor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // type()const
            QByteArray cppResult = cppSelf->QtMobility::QSensor::type();
            pyResult = Shiboken::Converter<QByteArray >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QSensor_methods[] = {
    {"addFilter", (PyCFunction)SbkQtMobility_QSensorFunc_addFilter, METH_O},
    {"availableDataRates", (PyCFunction)SbkQtMobility_QSensorFunc_availableDataRates, METH_NOARGS},
    {"connectToBackend", (PyCFunction)SbkQtMobility_QSensorFunc_connectToBackend, METH_NOARGS},
    {"dataRate", (PyCFunction)SbkQtMobility_QSensorFunc_dataRate, METH_NOARGS},
    {"defaultSensorForType", (PyCFunction)SbkQtMobility_QSensorFunc_defaultSensorForType, METH_O|METH_STATIC},
    {"description", (PyCFunction)SbkQtMobility_QSensorFunc_description, METH_NOARGS},
    {"error", (PyCFunction)SbkQtMobility_QSensorFunc_error, METH_NOARGS},
    {"identifier", (PyCFunction)SbkQtMobility_QSensorFunc_identifier, METH_NOARGS},
    {"isActive", (PyCFunction)SbkQtMobility_QSensorFunc_isActive, METH_NOARGS},
    {"isBusy", (PyCFunction)SbkQtMobility_QSensorFunc_isBusy, METH_NOARGS},
    {"isConnectedToBackend", (PyCFunction)SbkQtMobility_QSensorFunc_isConnectedToBackend, METH_NOARGS},
    {"outputRange", (PyCFunction)SbkQtMobility_QSensorFunc_outputRange, METH_NOARGS},
    {"outputRanges", (PyCFunction)SbkQtMobility_QSensorFunc_outputRanges, METH_NOARGS},
    {"reading", (PyCFunction)SbkQtMobility_QSensorFunc_reading, METH_NOARGS},
    {"removeFilter", (PyCFunction)SbkQtMobility_QSensorFunc_removeFilter, METH_O},
    {"sensorTypes", (PyCFunction)SbkQtMobility_QSensorFunc_sensorTypes, METH_NOARGS|METH_STATIC},
    {"sensorsForType", (PyCFunction)SbkQtMobility_QSensorFunc_sensorsForType, METH_O|METH_STATIC},
    {"setDataRate", (PyCFunction)SbkQtMobility_QSensorFunc_setDataRate, METH_O},
    {"setIdentifier", (PyCFunction)SbkQtMobility_QSensorFunc_setIdentifier, METH_O},
    {"setOutputRange", (PyCFunction)SbkQtMobility_QSensorFunc_setOutputRange, METH_O},
    {"start", (PyCFunction)SbkQtMobility_QSensorFunc_start, METH_NOARGS},
    {"stop", (PyCFunction)SbkQtMobility_QSensorFunc_stop, METH_NOARGS},
    {"type", (PyCFunction)SbkQtMobility_QSensorFunc_type, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QSensor_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Sensors.QSensor",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QSensor_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QSensor_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QSensor >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QSensor*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QSensor_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QSensor*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QSensor_Type;
    return 0;
}


void init_QtMobility_QSensor(PyObject* module)
{
    SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QSENSOR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QSensor_Type);

    SbkQtMobility_QSensor_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQtMobility_QSensor_Type.type_discovery = &SbkQtMobility_QSensor_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]), &SbkQtMobility_QSensor_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QSensor_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QSensor_Type));
    PyModule_AddObject(module, "QSensor",
        ((PyObject*)&SbkQtMobility_QSensor_Type));

    // Initialize signals
    PyObject* signal_item;

    signal_item = PySide::signalNew("readingChanged", "void", NULL);
    PyDict_SetItemString(SbkQtMobility_QSensor_Type.super.ht_type.tp_dict, "readingChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("busyChanged", "void", NULL);
    PyDict_SetItemString(SbkQtMobility_QSensor_Type.super.ht_type.tp_dict, "busyChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("sensorError", "int", NULL);
    PyDict_SetItemString(SbkQtMobility_QSensor_Type.super.ht_type.tp_dict, "sensorError", signal_item);
    Py_DECREF(signal_item);


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QSensor >("QtMobility::QSensor*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QSensor >(typeid(QtMobility::QSensor).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QSensor >(typeid(QSensorWrapper).name());
    PySide::initQtMetaType<QtMobility::QSensor* >();
}

