/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_sensors_python.h"

#include "qtmobility_qmagnetometerreading_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsensor.h>
#include <qthread.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QMagnetometerReadingWrapper::QMagnetometerReadingWrapper(QObject * parent) : QtMobility::QMagnetometerReading(parent), m_metaObject(0) {
    // ... middle
}

void QMagnetometerReadingWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMagnetometerReadingWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QMagnetometerReadingWrapper::copyValuesFrom(QtMobility::QSensorReading * other)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "copyValuesFrom"));
    if (py_override.isNull()) {
        return this->QtMobility::QMagnetometerReading::copyValuesFrom(other);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QtMobility::QSensorReading * >::toPython(other)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QMagnetometerReadingWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMagnetometerReadingWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QMagnetometerReadingWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMagnetometerReading.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QMagnetometerReadingWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMagnetometerReading.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

void QMagnetometerReadingWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QMagnetometerReadingWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QMagnetometerReading::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QMagnetometerReadingWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QMagnetometerReading::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QMagnetometerReadingWrapper::~QMagnetometerReadingWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QMagnetometerReading_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QMagnetometerReading >()))
        return -1;

    QMagnetometerReadingWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "parent" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                propertyKeys.push_back(argName);
            }
        }
    }

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QMagnetometerReading", &arg))
        return -1;

    // Overloaded function decisor
    // 0: QMagnetometerReading(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QMagnetometerReading(QObject*)
    } else if (Shiboken::Converter<QObject * >::isConvertible(arg)) {
        overloadId = 0; // QMagnetometerReading(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMagnetometerReading_Init_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "parent");
                if (value) {
                    if (arg)
                        errorArgName = "parent";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Sensors.QMagnetometerReading(): got multiple values for keyword argument '%s'", errorArgName);
                    return -1;
                }
            }
            if (Shiboken::cppObjectIsInvalid(arg))
                return -1;
            QObject* cpp_arg0 = arg ? Shiboken::Converter<QObject* >::toCpp(arg) : 0;

            if(!PyErr_Occurred()) {
            // QMagnetometerReading(QObject*)
            cptr = new QMagnetometerReadingWrapper(cpp_arg0);
            Shiboken::setParent(arg, self);
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QMagnetometerReading >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QMagnetometerReading_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    PySide::signalUpdateSource(self);
    cptr->metaObject();
    for (std::vector<PyObject*>::size_type i = 0; i < propertyKeys.size(); i++) {
        const char* propName = PyString_AS_STRING(propertyKeys[i]);
        const QMetaObject* mo = cptr->metaObject();
        if (mo->indexOfProperty(propName) != -1) {
            cptr->setProperty(propName, Shiboken::Converter<QVariant>::toCpp(PyDict_GetItem(kwds, propertyKeys[i])));
        } else {
            QString signalSignature = QString("%1()").arg(propName);
            if (mo->indexOfSignal(qPrintable(signalSignature)) != -1) {
                signalSignature = '2' + signalSignature;
                PySide::signal_connect(self, qPrintable(signalSignature), PyDict_GetItem(kwds, propertyKeys[i]));
            } else {
                delete cptr;
                PyErr_Format(PyExc_AttributeError, "'%s' is not a Qt property or a signal", propName);
                return -1;
            };
        }
    }


    return 1;

    SbkQtMobility_QMagnetometerReading_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Sensors.QMagnetometerReading", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QMagnetometerReadingFunc_calibrationLevel(PyObject* self)
{
    QtMobility::QMagnetometerReading* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMagnetometerReading* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // calibrationLevel()const
            qreal cppResult = cppSelf->QtMobility::QMagnetometerReading::calibrationLevel();
            pyResult = Shiboken::Converter<double >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMagnetometerReadingFunc_copyValuesFrom(PyObject* self, PyObject* arg)
{
    QtMobility::QMagnetometerReading* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMagnetometerReading* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: copyValuesFrom(QtMobility::QSensorReading*)
    if (Shiboken::Converter<QtMobility::QSensorReading * >::isConvertible(arg)) {
        overloadId = 0; // copyValuesFrom(QtMobility::QSensorReading*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMagnetometerReadingFunc_copyValuesFrom_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QSensorReading* cpp_arg0 = Shiboken::Converter<QtMobility::QSensorReading* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // copyValuesFrom(QtMobility::QSensorReading*)
            cppSelf->QtMobility::QMagnetometerReading::copyValuesFrom(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMagnetometerReadingFunc_copyValuesFrom_TypeError:
        const char* overloads[] = {"QtMobility.Sensors.QtMobility::QSensorReading", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Sensors.QMagnetometerReading.copyValuesFrom", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMagnetometerReadingFunc_setCalibrationLevel(PyObject* self, PyObject* arg)
{
    QtMobility::QMagnetometerReading* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMagnetometerReading* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setCalibrationLevel(qreal)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setCalibrationLevel(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMagnetometerReadingFunc_setCalibrationLevel_TypeError;

    // Call function/method
    {
        {
            qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setCalibrationLevel(qreal)
            cppSelf->QtMobility::QMagnetometerReading::setCalibrationLevel(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMagnetometerReadingFunc_setCalibrationLevel_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Sensors.QMagnetometerReading.setCalibrationLevel", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMagnetometerReadingFunc_setX(PyObject* self, PyObject* arg)
{
    QtMobility::QMagnetometerReading* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMagnetometerReading* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setX(qreal)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setX(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMagnetometerReadingFunc_setX_TypeError;

    // Call function/method
    {
        {
            qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setX(qreal)
            cppSelf->QtMobility::QMagnetometerReading::setX(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMagnetometerReadingFunc_setX_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Sensors.QMagnetometerReading.setX", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMagnetometerReadingFunc_setY(PyObject* self, PyObject* arg)
{
    QtMobility::QMagnetometerReading* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMagnetometerReading* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setY(qreal)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setY(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMagnetometerReadingFunc_setY_TypeError;

    // Call function/method
    {
        {
            qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setY(qreal)
            cppSelf->QtMobility::QMagnetometerReading::setY(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMagnetometerReadingFunc_setY_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Sensors.QMagnetometerReading.setY", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMagnetometerReadingFunc_setZ(PyObject* self, PyObject* arg)
{
    QtMobility::QMagnetometerReading* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMagnetometerReading* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setZ(qreal)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setZ(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMagnetometerReadingFunc_setZ_TypeError;

    // Call function/method
    {
        {
            qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setZ(qreal)
            cppSelf->QtMobility::QMagnetometerReading::setZ(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMagnetometerReadingFunc_setZ_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Sensors.QMagnetometerReading.setZ", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMagnetometerReadingFunc_x(PyObject* self)
{
    QtMobility::QMagnetometerReading* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMagnetometerReading* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // x()const
            qreal cppResult = cppSelf->QtMobility::QMagnetometerReading::x();
            pyResult = Shiboken::Converter<double >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMagnetometerReadingFunc_y(PyObject* self)
{
    QtMobility::QMagnetometerReading* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMagnetometerReading* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // y()const
            qreal cppResult = cppSelf->QtMobility::QMagnetometerReading::y();
            pyResult = Shiboken::Converter<double >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMagnetometerReadingFunc_z(PyObject* self)
{
    QtMobility::QMagnetometerReading* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMagnetometerReading* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // z()const
            qreal cppResult = cppSelf->QtMobility::QMagnetometerReading::z();
            pyResult = Shiboken::Converter<double >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QMagnetometerReading_methods[] = {
    {"calibrationLevel", (PyCFunction)SbkQtMobility_QMagnetometerReadingFunc_calibrationLevel, METH_NOARGS},
    {"copyValuesFrom", (PyCFunction)SbkQtMobility_QMagnetometerReadingFunc_copyValuesFrom, METH_O},
    {"setCalibrationLevel", (PyCFunction)SbkQtMobility_QMagnetometerReadingFunc_setCalibrationLevel, METH_O},
    {"setX", (PyCFunction)SbkQtMobility_QMagnetometerReadingFunc_setX, METH_O},
    {"setY", (PyCFunction)SbkQtMobility_QMagnetometerReadingFunc_setY, METH_O},
    {"setZ", (PyCFunction)SbkQtMobility_QMagnetometerReadingFunc_setZ, METH_O},
    {"x", (PyCFunction)SbkQtMobility_QMagnetometerReadingFunc_x, METH_NOARGS},
    {"y", (PyCFunction)SbkQtMobility_QMagnetometerReadingFunc_y, METH_NOARGS},
    {"z", (PyCFunction)SbkQtMobility_QMagnetometerReadingFunc_z, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QMagnetometerReading_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Sensors.QMagnetometerReading",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QMagnetometerReading_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QMagnetometerReading_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QMagnetometerReading >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QMagnetometerReading*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QMagnetometerReading_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QMagnetometerReading*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QMagnetometerReading_Type;
    return 0;
}


void init_QtMobility_QMagnetometerReading(PyObject* module)
{
    SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QMAGNETOMETERREADING_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QMagnetometerReading_Type);

    SbkQtMobility_QMagnetometerReading_Type.super.ht_type.tp_base = SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QSENSORREADING_IDX];
    // Fill type discovery information
    SbkQtMobility_QMagnetometerReading_Type.type_discovery = &SbkQtMobility_QMagnetometerReading_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkQtMobility_SensorsTypes[SBK_QTMOBILITY_QSENSORREADING_IDX]), &SbkQtMobility_QMagnetometerReading_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QMagnetometerReading_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QMagnetometerReading_Type));
    PyModule_AddObject(module, "QMagnetometerReading",
        ((PyObject*)&SbkQtMobility_QMagnetometerReading_Type));


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMagnetometerReading >("QtMobility::QMagnetometerReading*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMagnetometerReading >(typeid(QtMobility::QMagnetometerReading).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMagnetometerReading >(typeid(QMagnetometerReadingWrapper).name());
    PySide::initQtMetaType<QtMobility::QMagnetometerReading* >();
}

