/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_publishsubscribe_python.h"

#include "qtmobility_qvaluespacepublisher_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qthread.h>
#include <quuid.h>
#include <qvaluespacepublisher.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QValueSpacePublisherWrapper::QValueSpacePublisherWrapper(QFlags<QtMobility::QValueSpace::LayerOption> filter, const QString & path, QObject * parent) : QtMobility::QValueSpacePublisher(filter, path, parent), m_metaObject(0) {
    // ... middle
}

QValueSpacePublisherWrapper::QValueSpacePublisherWrapper(const QString & path, QObject * parent) : QtMobility::QValueSpacePublisher(path, parent), m_metaObject(0) {
    // ... middle
}

QValueSpacePublisherWrapper::QValueSpacePublisherWrapper(const QUuid & uuid, const QString & path, QObject * parent) : QtMobility::QValueSpacePublisher(uuid, path, parent), m_metaObject(0) {
    // ... middle
}

void QValueSpacePublisherWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QValueSpacePublisherWrapper::connectNotify(const char * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QtMobility::QValueSpacePublisher::connectNotify(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QValueSpacePublisherWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QValueSpacePublisherWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QValueSpacePublisherWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QValueSpacePublisher.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QValueSpacePublisherWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QValueSpacePublisher.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

void QValueSpacePublisherWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QValueSpacePublisherWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QValueSpacePublisher::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QValueSpacePublisherWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QValueSpacePublisher::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QValueSpacePublisherWrapper::~QValueSpacePublisherWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QValueSpacePublisher_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QValueSpacePublisher >()))
        return -1;

    QValueSpacePublisherWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "parent" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                propertyKeys.push_back(argName);
            }
        }
    }

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.PublishSubscribe.QValueSpacePublisher(): not enough arguments");
        return -1;
    }

    if (!PyArg_ParseTuple(args, "|OOO:QValueSpacePublisher", &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    // Overloaded function decisor
    // 0: QValueSpacePublisher(QFlags<QtMobility::QValueSpace::LayerOption>,QString,QObject*)
    // 1: QValueSpacePublisher(QString,QObject*)
    // 2: QValueSpacePublisher(QUuid,QString,QObject*)
    if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // QValueSpacePublisher(QString,QObject*)
        } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
            overloadId = 1; // QValueSpacePublisher(QString,QObject*)
        }
    } else if (numArgs >= 2 && Shiboken::Converter<const QUuid & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
        if (numArgs == 2) {
            overloadId = 2; // QValueSpacePublisher(QUuid,QString,QObject*)
        } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[2])) {
            overloadId = 2; // QValueSpacePublisher(QUuid,QString,QObject*)
        }
    } else if (numArgs >= 2 && Shiboken::Converter<QFlags<QtMobility::QValueSpace::LayerOption> >::isConvertible(pyargs[0]) && Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
        if (numArgs == 2) {
            overloadId = 0; // QValueSpacePublisher(QFlags<QtMobility::QValueSpace::LayerOption>,QString,QObject*)
        } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[2])) {
            overloadId = 0; // QValueSpacePublisher(QFlags<QtMobility::QValueSpace::LayerOption>,QString,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QValueSpacePublisher_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QValueSpacePublisher(QFlags<QtMobility::QValueSpace::LayerOption>,QString,QObject*)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "parent");
                    if (value) {
                        if (pyargs[2])
                            errorArgName = "parent";
                        else
                            pyargs[2] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.PublishSubscribe.QValueSpacePublisher(): got multiple values for keyword argument '%s'", errorArgName);
                        return -1;
                    }
                }
                QFlags<QtMobility::QValueSpace::LayerOption> cpp_arg0 = Shiboken::Converter<QFlags<QtMobility::QValueSpace::LayerOption> >::toCpp(pyargs[0]);
                QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return -1;
                QObject* cpp_arg2 = pyargs[2] ? Shiboken::Converter<QObject* >::toCpp(pyargs[2]) : 0;

                if(!PyErr_Occurred()) {
                // QValueSpacePublisher(QFlags<QtMobility::QValueSpace::LayerOption>,QString,QObject*)
                cptr = new QValueSpacePublisherWrapper(cpp_arg0, cpp_arg1, cpp_arg2);
                Shiboken::setParent(pyargs[2], self);
                }
                break;
            }
            case 1: // QValueSpacePublisher(QString,QObject*)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "parent");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "parent";
                        else
                            pyargs[1] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.PublishSubscribe.QValueSpacePublisher(): got multiple values for keyword argument '%s'", errorArgName);
                        return -1;
                    }
                }
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
                if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                    return -1;
                QObject* cpp_arg1 = pyargs[1] ? Shiboken::Converter<QObject* >::toCpp(pyargs[1]) : 0;

                if(!PyErr_Occurred()) {
                // QValueSpacePublisher(QString,QObject*)
                cptr = new QValueSpacePublisherWrapper(cpp_arg0, cpp_arg1);
                Shiboken::setParent(pyargs[1], self);
                }
                break;
            }
            case 2: // QValueSpacePublisher(QUuid,QString,QObject*)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "parent");
                    if (value) {
                        if (pyargs[2])
                            errorArgName = "parent";
                        else
                            pyargs[2] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.PublishSubscribe.QValueSpacePublisher(): got multiple values for keyword argument '%s'", errorArgName);
                        return -1;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return -1;
                std::auto_ptr<QUuid > cpp_arg0_auto_ptr;
                QUuid* cpp_arg0 = Shiboken::Converter<QUuid* >::toCpp(pyargs[0]);
                if (!Shiboken::Converter<QUuid >::checkType(pyargs[0]))
                    cpp_arg0_auto_ptr = std::auto_ptr<QUuid >(cpp_arg0);
                QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return -1;
                QObject* cpp_arg2 = pyargs[2] ? Shiboken::Converter<QObject* >::toCpp(pyargs[2]) : 0;

                if(!PyErr_Occurred()) {
                // QValueSpacePublisher(QUuid,QString,QObject*)
                cptr = new QValueSpacePublisherWrapper(*cpp_arg0, cpp_arg1, cpp_arg2);
                Shiboken::setParent(pyargs[2], self);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QValueSpacePublisher >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QValueSpacePublisher_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    PySide::signalUpdateSource(self);
    cptr->metaObject();
    for (std::vector<PyObject*>::size_type i = 0; i < propertyKeys.size(); i++) {
        const char* propName = PyString_AS_STRING(propertyKeys[i]);
        const QMetaObject* mo = cptr->metaObject();
        if (mo->indexOfProperty(propName) != -1) {
            cptr->setProperty(propName, Shiboken::Converter<QVariant>::toCpp(PyDict_GetItem(kwds, propertyKeys[i])));
        } else {
            QString signalSignature = QString("%1()").arg(propName);
            if (mo->indexOfSignal(qPrintable(signalSignature)) != -1) {
                signalSignature = '2' + signalSignature;
                PySide::signal_connect(self, qPrintable(signalSignature), PyDict_GetItem(kwds, propertyKeys[i]));
            } else {
                delete cptr;
                PyErr_Format(PyExc_AttributeError, "'%s' is not a Qt property or a signal", propName);
                return -1;
            };
        }
    }


    return 1;

    SbkQtMobility_QValueSpacePublisher_Init_TypeError:
        const char* overloads[] = {"QtMobility.PublishSubscribe.QtMobility::QValueSpace.LayerOptions, QString, PySide.QtCore.QObject = None", "QString, PySide.QtCore.QObject = None", "PySide.QtCore.QUuid, QString, PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.PublishSubscribe.QValueSpacePublisher", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QValueSpacePublisherFunc_connectNotify(PyObject* self, PyObject* arg)
{
    QtMobility::QValueSpacePublisher* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QValueSpacePublisher* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: connectNotify(const char*)
    if (Shiboken::Converter<const char * >::isConvertible(arg)) {
        overloadId = 0; // connectNotify(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QValueSpacePublisherFunc_connectNotify_TypeError;

    // Call function/method
    {
        {
            const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // connectNotify(const char*)
            cppSelf->QtMobility::QValueSpacePublisher::connectNotify(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QValueSpacePublisherFunc_connectNotify_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.PublishSubscribe.QValueSpacePublisher.connectNotify", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QValueSpacePublisherFunc_isConnected(PyObject* self)
{
    QtMobility::QValueSpacePublisher* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QValueSpacePublisher* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isConnected()const
            bool cppResult = cppSelf->QtMobility::QValueSpacePublisher::isConnected();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QValueSpacePublisherFunc_path(PyObject* self)
{
    QtMobility::QValueSpacePublisher* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QValueSpacePublisher* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // path()const
            QString cppResult = cppSelf->QtMobility::QValueSpacePublisher::path();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QValueSpacePublisherFunc_resetValue(PyObject* self, PyObject* arg)
{
    QtMobility::QValueSpacePublisher* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QValueSpacePublisher* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: resetValue(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // resetValue(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QValueSpacePublisherFunc_resetValue_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // resetValue(QString)
            cppSelf->QtMobility::QValueSpacePublisher::resetValue(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QValueSpacePublisherFunc_resetValue_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.PublishSubscribe.QValueSpacePublisher.resetValue", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QValueSpacePublisherFunc_setValue(PyObject* self, PyObject* args)
{
    QtMobility::QValueSpacePublisher* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QValueSpacePublisher* >::toCpp(self);

    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setValue", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: setValue(QString,QVariant)
    if (numArgs == 2 && Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant >::isConvertible(pyargs[1])) {
        overloadId = 0; // setValue(QString,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QValueSpacePublisherFunc_setValue_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            QVariant cpp_arg1 = Shiboken::Converter<QVariant >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // setValue(QString,QVariant)
            cppSelf->QtMobility::QValueSpacePublisher::setValue(cpp_arg0, cpp_arg1);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QValueSpacePublisherFunc_setValue_TypeError:
        const char* overloads[] = {"QString, QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.PublishSubscribe.QValueSpacePublisher.setValue", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QValueSpacePublisherFunc_sync(PyObject* self)
{
    QtMobility::QValueSpacePublisher* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QValueSpacePublisher* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // sync()
            cppSelf->QtMobility::QValueSpacePublisher::sync();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQtMobility_QValueSpacePublisher_methods[] = {
    {"connectNotify", (PyCFunction)SbkQtMobility_QValueSpacePublisherFunc_connectNotify, METH_O},
    {"isConnected", (PyCFunction)SbkQtMobility_QValueSpacePublisherFunc_isConnected, METH_NOARGS},
    {"path", (PyCFunction)SbkQtMobility_QValueSpacePublisherFunc_path, METH_NOARGS},
    {"resetValue", (PyCFunction)SbkQtMobility_QValueSpacePublisherFunc_resetValue, METH_O},
    {"setValue", (PyCFunction)SbkQtMobility_QValueSpacePublisherFunc_setValue, METH_VARARGS},
    {"sync", (PyCFunction)SbkQtMobility_QValueSpacePublisherFunc_sync, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QValueSpacePublisher_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.PublishSubscribe.QValueSpacePublisher",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QValueSpacePublisher_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QValueSpacePublisher_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QValueSpacePublisher >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QValueSpacePublisher*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QValueSpacePublisher_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QValueSpacePublisher*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QValueSpacePublisher_Type;
    return 0;
}


void init_QtMobility_QValueSpacePublisher(PyObject* module)
{
    SbkQtMobility_PublishSubscribeTypes[SBK_QTMOBILITY_QVALUESPACEPUBLISHER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QValueSpacePublisher_Type);

    SbkQtMobility_QValueSpacePublisher_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQtMobility_QValueSpacePublisher_Type.type_discovery = &SbkQtMobility_QValueSpacePublisher_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]), &SbkQtMobility_QValueSpacePublisher_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QValueSpacePublisher_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QValueSpacePublisher_Type));
    PyModule_AddObject(module, "QValueSpacePublisher",
        ((PyObject*)&SbkQtMobility_QValueSpacePublisher_Type));

    // Initialize signals
    PyObject* signal_item;

    signal_item = PySide::signalNew("interestChanged", "const QString&,bool", NULL);
    PyDict_SetItemString(SbkQtMobility_QValueSpacePublisher_Type.super.ht_type.tp_dict, "interestChanged", signal_item);
    Py_DECREF(signal_item);


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QValueSpacePublisher >("QtMobility::QValueSpacePublisher*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QValueSpacePublisher >(typeid(QtMobility::QValueSpacePublisher).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QValueSpacePublisher >(typeid(QValueSpacePublisherWrapper).name());
    PySide::initQtMetaType<QtMobility::QValueSpacePublisher* >();
}

