/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_publishsubscribe_python.h"

#include "qtmobility_qvaluespace_wrapper.h"

// Extra includes
#include <QList>
#include <quuid.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static PyObject* SbkQtMobility_QValueSpaceFunc_availableLayers(PyObject* self)
{
    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // availableLayers()
            QList<QUuid > cppResult = QtMobility::QValueSpace::availableLayers();
            pyResult = Shiboken::Converter<QList<QUuid > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QValueSpaceFunc_initValueSpaceServer(PyObject* self)
{

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // initValueSpaceServer()
            QtMobility::QValueSpace::initValueSpaceServer();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQtMobility_QValueSpace_methods[] = {
    {"availableLayers", (PyCFunction)SbkQtMobility_QValueSpaceFunc_availableLayers, METH_NOARGS|METH_STATIC},
    {"initValueSpaceServer", (PyCFunction)SbkQtMobility_QValueSpaceFunc_initValueSpaceServer, METH_NOARGS|METH_STATIC},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QValueSpace_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.PublishSubscribe.QValueSpace",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QValueSpace_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              0,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            0,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QValueSpace",
    /*user_data*/           0
};
} //extern

PyObject* SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption___and__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QValueSpace::LayerOptions >::checkType(self) && Shiboken::Converter<QtMobility::QValueSpace::LayerOptions >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "&", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QValueSpace::LayerOptions >::toPython(
        Shiboken::Converter<QtMobility::QValueSpace::LayerOptions>::toCpp(self)
        & Shiboken::Converter< QtMobility::QValueSpace::LayerOptions >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption___or__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QValueSpace::LayerOptions >::checkType(self) && Shiboken::Converter<QtMobility::QValueSpace::LayerOptions >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "|", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QValueSpace::LayerOptions >::toPython(
        Shiboken::Converter<QtMobility::QValueSpace::LayerOptions>::toCpp(self)
        | Shiboken::Converter< QtMobility::QValueSpace::LayerOptions >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption___xor__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QValueSpace::LayerOptions >::checkType(self) && Shiboken::Converter<QtMobility::QValueSpace::LayerOptions >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "^", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QValueSpace::LayerOptions >::toPython(
        Shiboken::Converter<QtMobility::QValueSpace::LayerOptions>::toCpp(self)
        ^ Shiboken::Converter< QtMobility::QValueSpace::LayerOptions >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QtMobility::QValueSpace::LayerOptions >::toPython(
        ~Shiboken::Converter<QtMobility::QValueSpace::LayerOptions >::toCpp(self)
    );
}


static PyNumberMethods SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption___and__,
    /*nb_xor*/                  (binaryfunc)SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption___xor__,
    /*nb_or*/                   (binaryfunc)SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "LayerOption",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyTypeObject SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOptions_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "LayerOptions",
    /*tp_basicsize*/        0,
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_Type.tp_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT | Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              PyInt_Type.tp_new,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};



void init_QtMobility_QValueSpace(PyObject* module)
{
    SbkQtMobility_PublishSubscribeTypes[SBK_QTMOBILITY_QVALUESPACE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QValueSpace_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QValueSpace_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QValueSpace_Type));
    PyModule_AddObject(module, "QValueSpace",
        ((PyObject*)&SbkQtMobility_QValueSpace_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: LayerOption
    SbkQtMobility_PublishSubscribeTypes[SBK_QTMOBILITY_QVALUESPACE_LAYEROPTION_IDX] = &SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_Type);
    PyDict_SetItemString(SbkQtMobility_QValueSpace_Type.super.ht_type.tp_dict,
            "LayerOption",((PyObject*)&SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_Type));

    // init flags class: QFlags<QtMobility::QValueSpace::LayerOption>
    SbkQtMobility_PublishSubscribeTypes[SBK_QFLAGS_QTMOBILITY_QVALUESPACE_LAYEROPTION__IDX] = &SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOptions_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOptions_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOptions_Type);
    PyDict_SetItemString(SbkQtMobility_QValueSpace_Type.super.ht_type.tp_dict,
            "LayerOptions",((PyObject*)&SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOptions_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_Type,
        (long) QtMobility::QValueSpace::UnspecifiedLayer, "UnspecifiedLayer");
    PyDict_SetItemString(SbkQtMobility_QValueSpace_Type.super.ht_type.tp_dict,
        "UnspecifiedLayer", enum_item);
    PyDict_SetItemString(SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_Type.tp_dict,
        "UnspecifiedLayer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_Type,
        (long) QtMobility::QValueSpace::PermanentLayer, "PermanentLayer");
    PyDict_SetItemString(SbkQtMobility_QValueSpace_Type.super.ht_type.tp_dict,
        "PermanentLayer", enum_item);
    PyDict_SetItemString(SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_Type.tp_dict,
        "PermanentLayer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_Type,
        (long) QtMobility::QValueSpace::TransientLayer, "TransientLayer");
    PyDict_SetItemString(SbkQtMobility_QValueSpace_Type.super.ht_type.tp_dict,
        "TransientLayer", enum_item);
    PyDict_SetItemString(SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_Type.tp_dict,
        "TransientLayer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_Type,
        (long) QtMobility::QValueSpace::WritableLayer, "WritableLayer");
    PyDict_SetItemString(SbkQtMobility_QValueSpace_Type.super.ht_type.tp_dict,
        "WritableLayer", enum_item);
    PyDict_SetItemString(SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_Type.tp_dict,
        "WritableLayer", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_Type,
        (long) QtMobility::QValueSpace::ReadOnlyLayer, "ReadOnlyLayer");
    PyDict_SetItemString(SbkQtMobility_QValueSpace_Type.super.ht_type.tp_dict,
        "ReadOnlyLayer", enum_item);
    PyDict_SetItemString(SbkQtMobility_PublishSubscribe_QtMobility_QValueSpace_LayerOption_Type.tp_dict,
        "ReadOnlyLayer", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QValueSpace::LayerOption");


}

