/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_PUBLISHSUBSCRIBE_PYTHON_H
#define SBK_PUBLISHSUBSCRIBE_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#include <qsignal.h>
// Module Includes
#include <pyside_qtcore_python.h>

// Binded library includes
#include <qvaluespacepublisher.h>
#include <qvaluespace.h>
#include <qvaluespacesubscriber.h>
// Conversion Includes - Primitive Types
#include <QString>
#include <signalmanager.h>
#include <typeresolver.h>
#include <QtConcurrentFilter>
#include <QTextDocument>

// Conversion Includes - Container Types
#include <QList>
#include <QMap>
#include <QStack>
#include <QMultiMap>
#include <QVector>
#include <QPair>
#include <pysideconversions.h>
#include <QSet>
#include <qqueue.h>
#include <QStringList>
#include <qlinkedlist.h>

// Type indices
#define SBK_QTMOBILITY_QVALUESPACE_IDX                               0
#define SBK_QTMOBILITY_QVALUESPACE_LAYEROPTION_IDX                   1
#define SBK_QFLAGS_QTMOBILITY_QVALUESPACE_LAYEROPTION__IDX           2
#define SBK_QTMOBILITY_QVALUESPACESUBSCRIBER_IDX                     3
#define SBK_QTMOBILITY_QVALUESPACEPUBLISHER_IDX                      4
#define SBK_PublishSubscribe_IDX_COUNT                               5

// This variable stores all python types exported by this module
extern PyTypeObject** SbkQtMobility_PublishSubscribeTypes;

// Macros for type check

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<QtMobility::QValueSpace::LayerOption >() { return SbkQtMobility_PublishSubscribeTypes[SBK_QTMOBILITY_QVALUESPACE_LAYEROPTION_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QtMobility::QValueSpace::LayerOption> >() { return SbkQtMobility_PublishSubscribeTypes[SBK_QFLAGS_QTMOBILITY_QVALUESPACE_LAYEROPTION__IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QValueSpaceSubscriber >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_PublishSubscribeTypes[SBK_QTMOBILITY_QVALUESPACESUBSCRIBER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QValueSpacePublisher >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_PublishSubscribeTypes[SBK_QTMOBILITY_QVALUESPACEPUBLISHER_IDX]); }

template<>
inline PyObject* createWrapper<QtMobility::QValueSpaceSubscriber >(const QtMobility::QValueSpaceSubscriber* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QValueSpaceSubscriber >()),const_cast<QtMobility::QValueSpaceSubscriber*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QValueSpacePublisher >(const QtMobility::QValueSpacePublisher* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QValueSpacePublisher >()),const_cast<QtMobility::QValueSpacePublisher*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
// Generated converters declarations ----------------------------------

template<>
struct Converter<QtMobility::QValueSpace::LayerOption > : EnumConverter<QtMobility::QValueSpace::LayerOption >
{
};
template<>
struct Converter<QFlags<QtMobility::QValueSpace::LayerOption> > : QFlagsConverter<QFlags<QtMobility::QValueSpace::LayerOption> >
{
};

template<>
struct Converter<QtMobility::QValueSpaceSubscriber* > : ObjectTypeConverter<QtMobility::QValueSpaceSubscriber >
{
};

template<>
struct Converter<QtMobility::QValueSpaceSubscriber& > : ObjectTypeReferenceConverter<QtMobility::QValueSpaceSubscriber >
{
};

template<>
struct Converter<QtMobility::QValueSpacePublisher* > : ObjectTypeConverter<QtMobility::QValueSpacePublisher >
{
};

template<>
struct Converter<QtMobility::QValueSpacePublisher& > : ObjectTypeReferenceConverter<QtMobility::QValueSpacePublisher >
{
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------


#endif // SBK_PUBLISHSUBSCRIBE_PYTHON_H

