/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_messaging_python.h"

#include "qtmobility_qmessageservice_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qmessage.h>
#include <qmessageaccountid.h>
#include <qmessagecontentcontainerid.h>
#include <qmessagefilter.h>
#include <qmessageid.h>
#include <qmessagesortorder.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qthread.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QMessageServiceWrapper::QMessageServiceWrapper(QObject * parent) : QtMobility::QMessageService(parent), m_metaObject(0) {
    // ... middle
}

void QMessageServiceWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMessageServiceWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QMessageServiceWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMessageServiceWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QMessageServiceWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMessageService.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QMessageServiceWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMessageService.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

void QMessageServiceWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QMessageServiceWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QMessageService::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QMessageServiceWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QMessageService::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QMessageServiceWrapper::~QMessageServiceWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QMessageService_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QMessageService >()))
        return -1;

    QMessageServiceWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "parent" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                propertyKeys.push_back(argName);
            }
        }
    }

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QMessageService", &arg))
        return -1;

    // Overloaded function decisor
    // 0: QMessageService(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QMessageService(QObject*)
    } else if (Shiboken::Converter<QObject * >::isConvertible(arg)) {
        overloadId = 0; // QMessageService(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageService_Init_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "parent");
                if (value) {
                    if (arg)
                        errorArgName = "parent";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageService(): got multiple values for keyword argument '%s'", errorArgName);
                    return -1;
                }
            }
            if (Shiboken::cppObjectIsInvalid(arg))
                return -1;
            QObject* cpp_arg0 = arg ? Shiboken::Converter<QObject* >::toCpp(arg) : 0;

            if(!PyErr_Occurred()) {
            // QMessageService(QObject*)
            cptr = new QMessageServiceWrapper(cpp_arg0);
            Shiboken::setParent(arg, self);
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QMessageService >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QMessageService_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    PySide::signalUpdateSource(self);
    cptr->metaObject();
    for (std::vector<PyObject*>::size_type i = 0; i < propertyKeys.size(); i++) {
        const char* propName = PyString_AS_STRING(propertyKeys[i]);
        const QMetaObject* mo = cptr->metaObject();
        if (mo->indexOfProperty(propName) != -1) {
            cptr->setProperty(propName, Shiboken::Converter<QVariant>::toCpp(PyDict_GetItem(kwds, propertyKeys[i])));
        } else {
            QString signalSignature = QString("%1()").arg(propName);
            if (mo->indexOfSignal(qPrintable(signalSignature)) != -1) {
                signalSignature = '2' + signalSignature;
                PySide::signal_connect(self, qPrintable(signalSignature), PyDict_GetItem(kwds, propertyKeys[i]));
            } else {
                delete cptr;
                PyErr_Format(PyExc_AttributeError, "'%s' is not a Qt property or a signal", propName);
                return -1;
            };
        }
    }


    return 1;

    SbkQtMobility_QMessageService_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageService", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QMessageServiceFunc_cancel(PyObject* self)
{
    QtMobility::QMessageService* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageService* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // cancel()
            cppSelf->QtMobility::QMessageService::cancel();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QMessageServiceFunc_compose(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageService* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageService* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: compose(QtMobility::QMessage)
    if (Shiboken::Converter<const QtMobility::QMessage & >::isConvertible(arg)) {
        overloadId = 0; // compose(QtMobility::QMessage)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageServiceFunc_compose_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QtMobility::QMessage > cpp_arg0_auto_ptr;
            QtMobility::QMessage* cpp_arg0 = Shiboken::Converter<QtMobility::QMessage* >::toCpp(arg);
            if (!Shiboken::Converter<QtMobility::QMessage >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessage >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // compose(QtMobility::QMessage)
            bool cppResult = cppSelf->QtMobility::QMessageService::compose(*cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageServiceFunc_compose_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessage", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageService.compose", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageServiceFunc_countMessages(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QMessageService* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageService* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "filter" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageService.countMessages(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageService.countMessages(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:countMessages", &arg))
        return 0;


    // Overloaded function decisor
    // 0: countMessages(QtMobility::QMessageFilter)
    if (numArgs == 0) {
        overloadId = 0; // countMessages(QtMobility::QMessageFilter)
    } else if (Shiboken::Converter<const QtMobility::QMessageFilter & >::isConvertible(arg)) {
        overloadId = 0; // countMessages(QtMobility::QMessageFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageServiceFunc_countMessages_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "filter");
                if (value) {
                    if (arg)
                        errorArgName = "filter";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageService.countMessages(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageFilter cpp_arg0_tmp = QtMobility::QMessageFilter();
            QtMobility::QMessageFilter* cpp_arg0 = arg ? Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(arg) : &cpp_arg0_tmp;

            if(!PyErr_Occurred()) {
            // countMessages(QtMobility::QMessageFilter)
            bool cppResult = cppSelf->QtMobility::QMessageService::countMessages(*cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageServiceFunc_countMessages_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFilter = QtMobility.QMessageFilter()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageService.countMessages", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageServiceFunc_error(PyObject* self)
{
    QtMobility::QMessageService* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageService* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // error()const
            QtMobility::QMessageManager::Error cppResult = cppSelf->QtMobility::QMessageService::error();
            pyResult = Shiboken::Converter<QtMobility::QMessageManager::Error >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageServiceFunc_exportUpdates(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageService* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageService* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: exportUpdates(QtMobility::QMessageAccountId)
    if (Shiboken::Converter<const QtMobility::QMessageAccountId & >::isConvertible(arg)) {
        overloadId = 0; // exportUpdates(QtMobility::QMessageAccountId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageServiceFunc_exportUpdates_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QtMobility::QMessageAccountId > cpp_arg0_auto_ptr;
            QtMobility::QMessageAccountId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAccountId* >::toCpp(arg);
            if (!Shiboken::Converter<QtMobility::QMessageAccountId >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageAccountId >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // exportUpdates(QtMobility::QMessageAccountId)
            bool cppResult = cppSelf->QtMobility::QMessageService::exportUpdates(*cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageServiceFunc_exportUpdates_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageAccountId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageService.exportUpdates", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageServiceFunc_queryMessages(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QMessageService* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageService* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "filter", "limit", "matchFlags", "offset", "sortOrder" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 5, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageService.queryMessages(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 6) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageService.queryMessages(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOO:queryMessages", &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;


    // Overloaded function decisor
    // 0: queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QtMobility::QMessageSortOrder,uint,uint)
    // 1: queryMessages(QtMobility::QMessageFilter,QtMobility::QMessageSortOrder,uint,uint)
    if (numArgs == 0) {
        overloadId = 1; // queryMessages(QtMobility::QMessageFilter,QtMobility::QMessageSortOrder,uint,uint)
    } else if (Shiboken::Converter<const QtMobility::QMessageFilter & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // queryMessages(QtMobility::QMessageFilter,QtMobility::QMessageSortOrder,uint,uint)
        } else if (Shiboken::Converter<const QtMobility::QMessageSortOrder & >::isConvertible(pyargs[1])) {
            if (numArgs == 2) {
                overloadId = 1; // queryMessages(QtMobility::QMessageFilter,QtMobility::QMessageSortOrder,uint,uint)
            } else if (SbkNumber_Check(pyargs[2])) {
                if (numArgs == 3) {
                    overloadId = 1; // queryMessages(QtMobility::QMessageFilter,QtMobility::QMessageSortOrder,uint,uint)
                } else if (SbkNumber_Check(pyargs[3])) {
                    overloadId = 1; // queryMessages(QtMobility::QMessageFilter,QtMobility::QMessageSortOrder,uint,uint)
                }
            }
        } else if (Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
            if (numArgs == 2) {
                overloadId = 0; // queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QtMobility::QMessageSortOrder,uint,uint)
            } else if (Shiboken::Converter<QFlags<QtMobility::QMessageDataComparator::MatchFlag> >::isConvertible(pyargs[2])) {
                if (numArgs == 3) {
                    overloadId = 0; // queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QtMobility::QMessageSortOrder,uint,uint)
                } else if (Shiboken::Converter<const QtMobility::QMessageSortOrder & >::isConvertible(pyargs[3])) {
                    if (numArgs == 4) {
                        overloadId = 0; // queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QtMobility::QMessageSortOrder,uint,uint)
                    } else if (SbkNumber_Check(pyargs[4])) {
                        if (numArgs == 5) {
                            overloadId = 0; // queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QtMobility::QMessageSortOrder,uint,uint)
                        } else if (SbkNumber_Check(pyargs[5])) {
                            overloadId = 0; // queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QtMobility::QMessageSortOrder,uint,uint)
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageServiceFunc_queryMessages_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QtMobility::QMessageSortOrder,uint,uint)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "matchFlags");
                    if (value) {
                        if (pyargs[2])
                            errorArgName = "matchFlags";
                        else
                            pyargs[2] = value;
                    }
                    value = PyDict_GetItemString(kwds, "sortOrder");
                    if (value) {
                        if (pyargs[3])
                            errorArgName = "sortOrder";
                        else
                            pyargs[3] = value;
                    }
                    value = PyDict_GetItemString(kwds, "limit");
                    if (value) {
                        if (pyargs[4])
                            errorArgName = "limit";
                        else
                            pyargs[4] = value;
                    }
                    value = PyDict_GetItemString(kwds, "offset");
                    if (value) {
                        if (pyargs[5])
                            errorArgName = "offset";
                        else
                            pyargs[5] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageService.queryMessages(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QMessageFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(pyargs[0]);
                QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);
                QFlags<QtMobility::QMessageDataComparator::MatchFlag> cpp_arg2 = pyargs[2] ? Shiboken::Converter<QFlags<QtMobility::QMessageDataComparator::MatchFlag> >::toCpp(pyargs[2]) : QFlags<QtMobility::QMessageDataComparator::MatchFlag>(0);
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return 0;
                QtMobility::QMessageSortOrder cpp_arg3_tmp = QtMobility::QMessageSortOrder();
                QtMobility::QMessageSortOrder* cpp_arg3 = pyargs[3] ? Shiboken::Converter<QtMobility::QMessageSortOrder* >::toCpp(pyargs[3]) : &cpp_arg3_tmp;
                uint cpp_arg4 = pyargs[4] ? Shiboken::Converter<uint >::toCpp(pyargs[4]) : 0;
                uint cpp_arg5 = pyargs[5] ? Shiboken::Converter<uint >::toCpp(pyargs[5]) : 0;

                if(!PyErr_Occurred()) {
                // queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QtMobility::QMessageSortOrder,uint,uint)
                bool cppResult = cppSelf->QtMobility::QMessageService::queryMessages(*cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, cpp_arg4, cpp_arg5);
                pyResult = Shiboken::Converter<bool >::toPython(cppResult);
                }
                break;
            }
            case 1: // queryMessages(QtMobility::QMessageFilter,QtMobility::QMessageSortOrder,uint,uint)
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "filter");
                    if (value) {
                        if (pyargs[0])
                            errorArgName = "filter";
                        else
                            pyargs[0] = value;
                    }
                    value = PyDict_GetItemString(kwds, "sortOrder");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "sortOrder";
                        else
                            pyargs[1] = value;
                    }
                    value = PyDict_GetItemString(kwds, "limit");
                    if (value) {
                        if (pyargs[2])
                            errorArgName = "limit";
                        else
                            pyargs[2] = value;
                    }
                    value = PyDict_GetItemString(kwds, "offset");
                    if (value) {
                        if (pyargs[3])
                            errorArgName = "offset";
                        else
                            pyargs[3] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageService.queryMessages(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QMessageFilter cpp_arg0_tmp = QtMobility::QMessageFilter();
                QtMobility::QMessageFilter* cpp_arg0 = pyargs[0] ? Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(pyargs[0]) : &cpp_arg0_tmp;
                if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                    return 0;
                QtMobility::QMessageSortOrder cpp_arg1_tmp = QtMobility::QMessageSortOrder();
                QtMobility::QMessageSortOrder* cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageSortOrder* >::toCpp(pyargs[1]) : &cpp_arg1_tmp;
                uint cpp_arg2 = pyargs[2] ? Shiboken::Converter<uint >::toCpp(pyargs[2]) : 0;
                uint cpp_arg3 = pyargs[3] ? Shiboken::Converter<uint >::toCpp(pyargs[3]) : 0;

                if(!PyErr_Occurred()) {
                // queryMessages(QtMobility::QMessageFilter,QtMobility::QMessageSortOrder,uint,uint)
                bool cppResult = cppSelf->QtMobility::QMessageService::queryMessages(*cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
                pyResult = Shiboken::Converter<bool >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageServiceFunc_queryMessages_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFilter, QString, QtMobility.Messaging.QtMobility::QMessageDataComparator.MatchFlags = 0, QtMobility.Messaging.QtMobility::QMessageSortOrder = QtMobility.QMessageSortOrder(), unsigned int = 0, unsigned int = 0", "QtMobility.Messaging.QtMobility::QMessageFilter = QtMobility.QMessageFilter(), QtMobility.Messaging.QtMobility::QMessageSortOrder = QtMobility.QMessageSortOrder(), unsigned int = 0, unsigned int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageService.queryMessages", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageServiceFunc_retrieve(PyObject* self, PyObject* args)
{
    QtMobility::QMessageService* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageService* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "retrieve", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: retrieve(QtMobility::QMessageId,QtMobility::QMessageContentContainerId)
    if (numArgs == 2 && Shiboken::Converter<const QtMobility::QMessageId & >::isConvertible(pyargs[0]) && Shiboken::Converter<const QtMobility::QMessageContentContainerId & >::isConvertible(pyargs[1])) {
        overloadId = 0; // retrieve(QtMobility::QMessageId,QtMobility::QMessageContentContainerId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageServiceFunc_retrieve_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            std::auto_ptr<QtMobility::QMessageId > cpp_arg0_auto_ptr;
            QtMobility::QMessageId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageId* >::toCpp(pyargs[0]);
            if (!Shiboken::Converter<QtMobility::QMessageId >::checkType(pyargs[0]))
                cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageId >(cpp_arg0);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QtMobility::QMessageContentContainerId > cpp_arg1_auto_ptr;
            QtMobility::QMessageContentContainerId* cpp_arg1 = Shiboken::Converter<QtMobility::QMessageContentContainerId* >::toCpp(pyargs[1]);
            if (!Shiboken::Converter<QtMobility::QMessageContentContainerId >::checkType(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QtMobility::QMessageContentContainerId >(cpp_arg1);

            if(!PyErr_Occurred()) {
            // retrieve(QtMobility::QMessageId,QtMobility::QMessageContentContainerId)
            bool cppResult = cppSelf->QtMobility::QMessageService::retrieve(*cpp_arg0, *cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageServiceFunc_retrieve_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageId, QtMobility.Messaging.QtMobility::QMessageContentContainerId", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageService.retrieve", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageServiceFunc_retrieveBody(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageService* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageService* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: retrieveBody(QtMobility::QMessageId)
    if (Shiboken::Converter<const QtMobility::QMessageId & >::isConvertible(arg)) {
        overloadId = 0; // retrieveBody(QtMobility::QMessageId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageServiceFunc_retrieveBody_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QtMobility::QMessageId > cpp_arg0_auto_ptr;
            QtMobility::QMessageId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageId* >::toCpp(arg);
            if (!Shiboken::Converter<QtMobility::QMessageId >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageId >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // retrieveBody(QtMobility::QMessageId)
            bool cppResult = cppSelf->QtMobility::QMessageService::retrieveBody(*cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageServiceFunc_retrieveBody_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageService.retrieveBody", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageServiceFunc_retrieveHeader(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageService* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageService* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: retrieveHeader(QtMobility::QMessageId)
    if (Shiboken::Converter<const QtMobility::QMessageId & >::isConvertible(arg)) {
        overloadId = 0; // retrieveHeader(QtMobility::QMessageId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageServiceFunc_retrieveHeader_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QtMobility::QMessageId > cpp_arg0_auto_ptr;
            QtMobility::QMessageId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageId* >::toCpp(arg);
            if (!Shiboken::Converter<QtMobility::QMessageId >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageId >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // retrieveHeader(QtMobility::QMessageId)
            bool cppResult = cppSelf->QtMobility::QMessageService::retrieveHeader(*cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageServiceFunc_retrieveHeader_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageService.retrieveHeader", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageServiceFunc_send(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageService* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageService* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: send(QtMobility::QMessage&)
    if (Shiboken::Converter<QtMobility::QMessage & >::isConvertible(arg)) {
        overloadId = 0; // send(QtMobility::QMessage&)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageServiceFunc_send_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QtMobility::QMessage > cpp_arg0_auto_ptr;
            QtMobility::QMessage* cpp_arg0 = Shiboken::Converter<QtMobility::QMessage* >::toCpp(arg);
            if (!Shiboken::Converter<QtMobility::QMessage >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessage >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // send(QtMobility::QMessage&)
            bool cppResult = cppSelf->QtMobility::QMessageService::send(*cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageServiceFunc_send_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessage", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageService.send", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageServiceFunc_show(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageService* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageService* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: show(QtMobility::QMessageId)
    if (Shiboken::Converter<const QtMobility::QMessageId & >::isConvertible(arg)) {
        overloadId = 0; // show(QtMobility::QMessageId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageServiceFunc_show_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QtMobility::QMessageId > cpp_arg0_auto_ptr;
            QtMobility::QMessageId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageId* >::toCpp(arg);
            if (!Shiboken::Converter<QtMobility::QMessageId >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageId >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // show(QtMobility::QMessageId)
            bool cppResult = cppSelf->QtMobility::QMessageService::show(*cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageServiceFunc_show_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageService.show", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageServiceFunc_state(PyObject* self)
{
    QtMobility::QMessageService* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageService* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // state()const
            QtMobility::QMessageService::State cppResult = cppSelf->QtMobility::QMessageService::state();
            pyResult = Shiboken::Converter<QtMobility::QMessageService::State >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QMessageService_methods[] = {
    {"cancel", (PyCFunction)SbkQtMobility_QMessageServiceFunc_cancel, METH_NOARGS},
    {"compose", (PyCFunction)SbkQtMobility_QMessageServiceFunc_compose, METH_O},
    {"countMessages", (PyCFunction)SbkQtMobility_QMessageServiceFunc_countMessages, METH_VARARGS|METH_KEYWORDS},
    {"error", (PyCFunction)SbkQtMobility_QMessageServiceFunc_error, METH_NOARGS},
    {"exportUpdates", (PyCFunction)SbkQtMobility_QMessageServiceFunc_exportUpdates, METH_O},
    {"queryMessages", (PyCFunction)SbkQtMobility_QMessageServiceFunc_queryMessages, METH_VARARGS|METH_KEYWORDS},
    {"retrieve", (PyCFunction)SbkQtMobility_QMessageServiceFunc_retrieve, METH_VARARGS},
    {"retrieveBody", (PyCFunction)SbkQtMobility_QMessageServiceFunc_retrieveBody, METH_O},
    {"retrieveHeader", (PyCFunction)SbkQtMobility_QMessageServiceFunc_retrieveHeader, METH_O},
    {"send", (PyCFunction)SbkQtMobility_QMessageServiceFunc_send, METH_O},
    {"show", (PyCFunction)SbkQtMobility_QMessageServiceFunc_show, METH_O},
    {"state", (PyCFunction)SbkQtMobility_QMessageServiceFunc_state, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QMessageService_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Messaging.QMessageService",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QMessageService_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QMessageService_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QMessageService >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QMessageService*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QMessageService_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QMessageService*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QMessageService_Type;
    return 0;
}

static PyGetSetDef SbkQtMobility_Messaging_QtMobility_QMessageService_State_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Messaging_QtMobility_QMessageService_State_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Messaging_QtMobility_QMessageService_State_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "State",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Messaging_QtMobility_QMessageService_State_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Messaging_QtMobility_QMessageService_State_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Messaging_QtMobility_QMessageService_State_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QMessageService(PyObject* module)
{
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGESERVICE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QMessageService_Type);

    SbkQtMobility_QMessageService_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQtMobility_QMessageService_Type.type_discovery = &SbkQtMobility_QMessageService_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]), &SbkQtMobility_QMessageService_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QMessageService_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QMessageService_Type));
    PyModule_AddObject(module, "QMessageService",
        ((PyObject*)&SbkQtMobility_QMessageService_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: State
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGESERVICE_STATE_IDX] = &SbkQtMobility_Messaging_QtMobility_QMessageService_State_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Messaging_QtMobility_QMessageService_State_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Messaging_QtMobility_QMessageService_State_Type);
    PyDict_SetItemString(SbkQtMobility_QMessageService_Type.super.ht_type.tp_dict,
            "State",((PyObject*)&SbkQtMobility_Messaging_QtMobility_QMessageService_State_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageService_State_Type,
        (long) QtMobility::QMessageService::InactiveState, "InactiveState");
    PyDict_SetItemString(SbkQtMobility_QMessageService_Type.super.ht_type.tp_dict,
        "InactiveState", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageService_State_Type.tp_dict,
        "InactiveState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageService_State_Type,
        (long) QtMobility::QMessageService::ActiveState, "ActiveState");
    PyDict_SetItemString(SbkQtMobility_QMessageService_Type.super.ht_type.tp_dict,
        "ActiveState", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageService_State_Type.tp_dict,
        "ActiveState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageService_State_Type,
        (long) QtMobility::QMessageService::CanceledState, "CanceledState");
    PyDict_SetItemString(SbkQtMobility_QMessageService_Type.super.ht_type.tp_dict,
        "CanceledState", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageService_State_Type.tp_dict,
        "CanceledState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageService_State_Type,
        (long) QtMobility::QMessageService::FinishedState, "FinishedState");
    PyDict_SetItemString(SbkQtMobility_QMessageService_Type.super.ht_type.tp_dict,
        "FinishedState", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageService_State_Type.tp_dict,
        "FinishedState", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QMessageService::State");

    // Initialize signals
    PyObject* signal_item;

    signal_item = PySide::signalNew("progressChanged", "uint,uint", NULL);
    PyDict_SetItemString(SbkQtMobility_QMessageService_Type.super.ht_type.tp_dict, "progressChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("messagesCounted", "int", NULL);
    PyDict_SetItemString(SbkQtMobility_QMessageService_Type.super.ht_type.tp_dict, "messagesCounted", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("messagesFound", "const QList<QtMobility::QMessageId>&", NULL);
    PyDict_SetItemString(SbkQtMobility_QMessageService_Type.super.ht_type.tp_dict, "messagesFound", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("stateChanged", "QtMobility::QMessageService::State", NULL);
    PyDict_SetItemString(SbkQtMobility_QMessageService_Type.super.ht_type.tp_dict, "stateChanged", signal_item);
    Py_DECREF(signal_item);


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessageService >("QtMobility::QMessageService*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessageService >(typeid(QtMobility::QMessageService).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessageService >(typeid(QMessageServiceWrapper).name());
    PySide::initQtMetaType<QtMobility::QMessageService* >();
}

