/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_messaging_python.h"

#include "qtmobility_qmessagemanager_wrapper.h"

// Extra includes
#include <QList>
#include <QSet>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qmessage.h>
#include <qmessageaccount.h>
#include <qmessageaccountfilter.h>
#include <qmessageaccountid.h>
#include <qmessageaccountsortorder.h>
#include <qmessagefilter.h>
#include <qmessagefolder.h>
#include <qmessagefolderfilter.h>
#include <qmessagefolderid.h>
#include <qmessagefoldersortorder.h>
#include <qmessageid.h>
#include <qmessagesortorder.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qthread.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QMessageManagerWrapper::QMessageManagerWrapper(QObject * parent) : QtMobility::QMessageManager(parent), m_metaObject(0) {
    // ... middle
}

void QMessageManagerWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMessageManagerWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QMessageManagerWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMessageManagerWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QMessageManagerWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMessageManager.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QMessageManagerWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMessageManager.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

void QMessageManagerWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QMessageManagerWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QMessageManager::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QMessageManagerWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QMessageManager::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QMessageManagerWrapper::~QMessageManagerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QMessageManager_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QMessageManager >()))
        return -1;

    QMessageManagerWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "parent" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                propertyKeys.push_back(argName);
            }
        }
    }

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QMessageManager", &arg))
        return -1;

    // Overloaded function decisor
    // 0: QMessageManager(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QMessageManager(QObject*)
    } else if (Shiboken::Converter<QObject * >::isConvertible(arg)) {
        overloadId = 0; // QMessageManager(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageManager_Init_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "parent");
                if (value) {
                    if (arg)
                        errorArgName = "parent";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager(): got multiple values for keyword argument '%s'", errorArgName);
                    return -1;
                }
            }
            if (Shiboken::cppObjectIsInvalid(arg))
                return -1;
            QObject* cpp_arg0 = arg ? Shiboken::Converter<QObject* >::toCpp(arg) : 0;

            if(!PyErr_Occurred()) {
            // QMessageManager(QObject*)
            cptr = new QMessageManagerWrapper(cpp_arg0);
            Shiboken::setParent(arg, self);
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QMessageManager >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QMessageManager_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    PySide::signalUpdateSource(self);
    cptr->metaObject();
    for (std::vector<PyObject*>::size_type i = 0; i < propertyKeys.size(); i++) {
        const char* propName = PyString_AS_STRING(propertyKeys[i]);
        const QMetaObject* mo = cptr->metaObject();
        if (mo->indexOfProperty(propName) != -1) {
            cptr->setProperty(propName, Shiboken::Converter<QVariant>::toCpp(PyDict_GetItem(kwds, propertyKeys[i])));
        } else {
            QString signalSignature = QString("%1()").arg(propName);
            if (mo->indexOfSignal(qPrintable(signalSignature)) != -1) {
                signalSignature = '2' + signalSignature;
                PySide::signal_connect(self, qPrintable(signalSignature), PyDict_GetItem(kwds, propertyKeys[i]));
            } else {
                delete cptr;
                PyErr_Format(PyExc_AttributeError, "'%s' is not a Qt property or a signal", propName);
                return -1;
            };
        }
    }


    return 1;

    SbkQtMobility_QMessageManager_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageManager", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QMessageManagerFunc_account(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: account(QtMobility::QMessageAccountId)const
    if (Shiboken::Converter<const QtMobility::QMessageAccountId & >::isConvertible(arg)) {
        overloadId = 0; // account(QtMobility::QMessageAccountId)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageManagerFunc_account_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QtMobility::QMessageAccountId > cpp_arg0_auto_ptr;
            QtMobility::QMessageAccountId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAccountId* >::toCpp(arg);
            if (!Shiboken::Converter<QtMobility::QMessageAccountId >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageAccountId >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // account(QtMobility::QMessageAccountId)const
            QtMobility::QMessageAccount cppResult = cppSelf->QtMobility::QMessageManager::account(*cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageAccount >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageManagerFunc_account_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageAccountId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageManager.account", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageManagerFunc_addMessage(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: addMessage(QtMobility::QMessage*)
    if (Shiboken::Converter<QtMobility::QMessage * >::isConvertible(arg)) {
        overloadId = 0; // addMessage(QtMobility::QMessage*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageManagerFunc_addMessage_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QtMobility::QMessage > cpp_arg0_auto_ptr;
            QtMobility::QMessage* cpp_arg0 = Shiboken::Converter<QtMobility::QMessage* >::toCpp(arg);
            if (!Shiboken::Converter<QtMobility::QMessage >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessage >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // addMessage(QtMobility::QMessage*)
            bool cppResult = cppSelf->QtMobility::QMessageManager::addMessage(cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageManagerFunc_addMessage_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessage", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageManager.addMessage", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageManagerFunc_countAccounts(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QMessageManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "filter" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.countAccounts(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.countAccounts(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:countAccounts", &arg))
        return 0;


    // Overloaded function decisor
    // 0: countAccounts(QtMobility::QMessageAccountFilter)const
    if (numArgs == 0) {
        overloadId = 0; // countAccounts(QtMobility::QMessageAccountFilter)const
    } else if (Shiboken::Converter<const QtMobility::QMessageAccountFilter & >::isConvertible(arg)) {
        overloadId = 0; // countAccounts(QtMobility::QMessageAccountFilter)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageManagerFunc_countAccounts_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "filter");
                if (value) {
                    if (arg)
                        errorArgName = "filter";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.countAccounts(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageAccountFilter cpp_arg0_tmp = QtMobility::QMessageAccountFilter();
            QtMobility::QMessageAccountFilter* cpp_arg0 = arg ? Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(arg) : &cpp_arg0_tmp;

            if(!PyErr_Occurred()) {
            // countAccounts(QtMobility::QMessageAccountFilter)const
            int cppResult = cppSelf->QtMobility::QMessageManager::countAccounts(*cpp_arg0);
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageManagerFunc_countAccounts_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageAccountFilter = QtMobility.QMessageAccountFilter()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageManager.countAccounts", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageManagerFunc_countFolders(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QMessageManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "filter" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.countFolders(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.countFolders(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:countFolders", &arg))
        return 0;


    // Overloaded function decisor
    // 0: countFolders(QtMobility::QMessageFolderFilter)const
    if (numArgs == 0) {
        overloadId = 0; // countFolders(QtMobility::QMessageFolderFilter)const
    } else if (Shiboken::Converter<const QtMobility::QMessageFolderFilter & >::isConvertible(arg)) {
        overloadId = 0; // countFolders(QtMobility::QMessageFolderFilter)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageManagerFunc_countFolders_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "filter");
                if (value) {
                    if (arg)
                        errorArgName = "filter";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.countFolders(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageFolderFilter cpp_arg0_tmp = QtMobility::QMessageFolderFilter();
            QtMobility::QMessageFolderFilter* cpp_arg0 = arg ? Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(arg) : &cpp_arg0_tmp;

            if(!PyErr_Occurred()) {
            // countFolders(QtMobility::QMessageFolderFilter)const
            int cppResult = cppSelf->QtMobility::QMessageManager::countFolders(*cpp_arg0);
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageManagerFunc_countFolders_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFolderFilter = QtMobility.QMessageFolderFilter()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageManager.countFolders", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageManagerFunc_countMessages(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QMessageManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "filter" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.countMessages(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.countMessages(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:countMessages", &arg))
        return 0;


    // Overloaded function decisor
    // 0: countMessages(QtMobility::QMessageFilter)const
    if (numArgs == 0) {
        overloadId = 0; // countMessages(QtMobility::QMessageFilter)const
    } else if (Shiboken::Converter<const QtMobility::QMessageFilter & >::isConvertible(arg)) {
        overloadId = 0; // countMessages(QtMobility::QMessageFilter)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageManagerFunc_countMessages_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "filter");
                if (value) {
                    if (arg)
                        errorArgName = "filter";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.countMessages(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageFilter cpp_arg0_tmp = QtMobility::QMessageFilter();
            QtMobility::QMessageFilter* cpp_arg0 = arg ? Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(arg) : &cpp_arg0_tmp;

            if(!PyErr_Occurred()) {
            // countMessages(QtMobility::QMessageFilter)const
            int cppResult = cppSelf->QtMobility::QMessageManager::countMessages(*cpp_arg0);
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageManagerFunc_countMessages_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFilter = QtMobility.QMessageFilter()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageManager.countMessages", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageManagerFunc_error(PyObject* self)
{
    QtMobility::QMessageManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageManager* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // error()const
            QtMobility::QMessageManager::Error cppResult = cppSelf->QtMobility::QMessageManager::error();
            pyResult = Shiboken::Converter<QtMobility::QMessageManager::Error >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageManagerFunc_folder(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: folder(QtMobility::QMessageFolderId)const
    if (Shiboken::Converter<const QtMobility::QMessageFolderId & >::isConvertible(arg)) {
        overloadId = 0; // folder(QtMobility::QMessageFolderId)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageManagerFunc_folder_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QtMobility::QMessageFolderId > cpp_arg0_auto_ptr;
            QtMobility::QMessageFolderId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderId* >::toCpp(arg);
            if (!Shiboken::Converter<QtMobility::QMessageFolderId >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageFolderId >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // folder(QtMobility::QMessageFolderId)const
            QtMobility::QMessageFolder cppResult = cppSelf->QtMobility::QMessageManager::folder(*cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageFolder >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageManagerFunc_folder_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFolderId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageManager.folder", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageManagerFunc_message(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: message(QtMobility::QMessageId)const
    if (Shiboken::Converter<const QtMobility::QMessageId & >::isConvertible(arg)) {
        overloadId = 0; // message(QtMobility::QMessageId)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageManagerFunc_message_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QtMobility::QMessageId > cpp_arg0_auto_ptr;
            QtMobility::QMessageId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageId* >::toCpp(arg);
            if (!Shiboken::Converter<QtMobility::QMessageId >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageId >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // message(QtMobility::QMessageId)const
            QtMobility::QMessage cppResult = cppSelf->QtMobility::QMessageManager::message(*cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessage >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageManagerFunc_message_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageManager.message", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageManagerFunc_queryAccounts(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QMessageManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "filter", "limit", "offset", "sortOrder" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 4, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.queryAccounts(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 4) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.queryAccounts(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:queryAccounts", &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;


    // Overloaded function decisor
    // 0: queryAccounts(QtMobility::QMessageAccountFilter,QList<QtMobility::QMessageAccountSortOrder>,uint,uint)const
    // 1: queryAccounts(QtMobility::QMessageAccountFilter,QtMobility::QMessageAccountSortOrder,uint,uint)const
    if (numArgs == 0) {
        overloadId = 1; // queryAccounts(QtMobility::QMessageAccountFilter,QtMobility::QMessageAccountSortOrder,uint,uint)const
    } else if (Shiboken::Converter<const QtMobility::QMessageAccountFilter & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // queryAccounts(QtMobility::QMessageAccountFilter,QtMobility::QMessageAccountSortOrder,uint,uint)const
        } else if (Shiboken::Converter<const QtMobility::QMessageAccountSortOrder & >::isConvertible(pyargs[1])) {
            if (numArgs == 2) {
                overloadId = 1; // queryAccounts(QtMobility::QMessageAccountFilter,QtMobility::QMessageAccountSortOrder,uint,uint)const
            } else if (SbkNumber_Check(pyargs[2])) {
                if (numArgs == 3) {
                    overloadId = 1; // queryAccounts(QtMobility::QMessageAccountFilter,QtMobility::QMessageAccountSortOrder,uint,uint)const
                } else if (SbkNumber_Check(pyargs[3])) {
                    overloadId = 1; // queryAccounts(QtMobility::QMessageAccountFilter,QtMobility::QMessageAccountSortOrder,uint,uint)const
                }
            }
        } else if (Shiboken::Converter< QList<QtMobility::QMessageAccountSortOrder >  >::isConvertible(pyargs[1])) {
            if (numArgs == 2) {
                overloadId = 0; // queryAccounts(QtMobility::QMessageAccountFilter,QList<QtMobility::QMessageAccountSortOrder>,uint,uint)const
            } else if (SbkNumber_Check(pyargs[2])) {
                if (numArgs == 3) {
                    overloadId = 0; // queryAccounts(QtMobility::QMessageAccountFilter,QList<QtMobility::QMessageAccountSortOrder>,uint,uint)const
                } else if (SbkNumber_Check(pyargs[3])) {
                    overloadId = 0; // queryAccounts(QtMobility::QMessageAccountFilter,QList<QtMobility::QMessageAccountSortOrder>,uint,uint)const
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageManagerFunc_queryAccounts_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // queryAccounts(QtMobility::QMessageAccountFilter,QList<QtMobility::QMessageAccountSortOrder>,uint,uint)const
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "limit");
                    if (value) {
                        if (pyargs[2])
                            errorArgName = "limit";
                        else
                            pyargs[2] = value;
                    }
                    value = PyDict_GetItemString(kwds, "offset");
                    if (value) {
                        if (pyargs[3])
                            errorArgName = "offset";
                        else
                            pyargs[3] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.queryAccounts(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QMessageAccountFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(pyargs[0]);
                QList<QtMobility::QMessageAccountSortOrder > cpp_arg1 = Shiboken::Converter<QList<QtMobility::QMessageAccountSortOrder > >::toCpp(pyargs[1]);
                uint cpp_arg2 = pyargs[2] ? Shiboken::Converter<uint >::toCpp(pyargs[2]) : 0;
                uint cpp_arg3 = pyargs[3] ? Shiboken::Converter<uint >::toCpp(pyargs[3]) : 0;

                if(!PyErr_Occurred()) {
                // queryAccounts(QtMobility::QMessageAccountFilter,QList<QtMobility::QMessageAccountSortOrder>,uint,uint)const
                QList<QtMobility::QMessageAccountId > cppResult = cppSelf->QtMobility::QMessageManager::queryAccounts(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                pyResult = Shiboken::Converter<QList<QtMobility::QMessageAccountId > >::toPython(cppResult);
                }
                break;
            }
            case 1: // queryAccounts(QtMobility::QMessageAccountFilter,QtMobility::QMessageAccountSortOrder,uint,uint)const
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "filter");
                    if (value) {
                        if (pyargs[0])
                            errorArgName = "filter";
                        else
                            pyargs[0] = value;
                    }
                    value = PyDict_GetItemString(kwds, "sortOrder");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "sortOrder";
                        else
                            pyargs[1] = value;
                    }
                    value = PyDict_GetItemString(kwds, "limit");
                    if (value) {
                        if (pyargs[2])
                            errorArgName = "limit";
                        else
                            pyargs[2] = value;
                    }
                    value = PyDict_GetItemString(kwds, "offset");
                    if (value) {
                        if (pyargs[3])
                            errorArgName = "offset";
                        else
                            pyargs[3] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.queryAccounts(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QMessageAccountFilter cpp_arg0_tmp = QtMobility::QMessageAccountFilter();
                QtMobility::QMessageAccountFilter* cpp_arg0 = pyargs[0] ? Shiboken::Converter<QtMobility::QMessageAccountFilter* >::toCpp(pyargs[0]) : &cpp_arg0_tmp;
                if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                    return 0;
                QtMobility::QMessageAccountSortOrder cpp_arg1_tmp = QtMobility::QMessageAccountSortOrder();
                QtMobility::QMessageAccountSortOrder* cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageAccountSortOrder* >::toCpp(pyargs[1]) : &cpp_arg1_tmp;
                uint cpp_arg2 = pyargs[2] ? Shiboken::Converter<uint >::toCpp(pyargs[2]) : 0;
                uint cpp_arg3 = pyargs[3] ? Shiboken::Converter<uint >::toCpp(pyargs[3]) : 0;

                if(!PyErr_Occurred()) {
                // queryAccounts(QtMobility::QMessageAccountFilter,QtMobility::QMessageAccountSortOrder,uint,uint)const
                QList<QtMobility::QMessageAccountId > cppResult = cppSelf->QtMobility::QMessageManager::queryAccounts(*cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
                pyResult = Shiboken::Converter<QList<QtMobility::QMessageAccountId > >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageManagerFunc_queryAccounts_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageAccountFilter, list, unsigned int = 0, unsigned int = 0", "QtMobility.Messaging.QtMobility::QMessageAccountFilter = QtMobility.QMessageAccountFilter(), QtMobility.Messaging.QtMobility::QMessageAccountSortOrder = QtMobility.QMessageAccountSortOrder(), unsigned int = 0, unsigned int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageManager.queryAccounts", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageManagerFunc_queryFolders(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QMessageManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "filter", "limit", "offset", "sortOrder" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 4, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.queryFolders(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 4) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.queryFolders(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:queryFolders", &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;


    // Overloaded function decisor
    // 0: queryFolders(QtMobility::QMessageFolderFilter,QList<QtMobility::QMessageFolderSortOrder>,uint,uint)const
    // 1: queryFolders(QtMobility::QMessageFolderFilter,QtMobility::QMessageFolderSortOrder,uint,uint)const
    if (numArgs == 0) {
        overloadId = 1; // queryFolders(QtMobility::QMessageFolderFilter,QtMobility::QMessageFolderSortOrder,uint,uint)const
    } else if (Shiboken::Converter<const QtMobility::QMessageFolderFilter & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // queryFolders(QtMobility::QMessageFolderFilter,QtMobility::QMessageFolderSortOrder,uint,uint)const
        } else if (Shiboken::Converter<const QtMobility::QMessageFolderSortOrder & >::isConvertible(pyargs[1])) {
            if (numArgs == 2) {
                overloadId = 1; // queryFolders(QtMobility::QMessageFolderFilter,QtMobility::QMessageFolderSortOrder,uint,uint)const
            } else if (SbkNumber_Check(pyargs[2])) {
                if (numArgs == 3) {
                    overloadId = 1; // queryFolders(QtMobility::QMessageFolderFilter,QtMobility::QMessageFolderSortOrder,uint,uint)const
                } else if (SbkNumber_Check(pyargs[3])) {
                    overloadId = 1; // queryFolders(QtMobility::QMessageFolderFilter,QtMobility::QMessageFolderSortOrder,uint,uint)const
                }
            }
        } else if (Shiboken::Converter< QList<QtMobility::QMessageFolderSortOrder >  >::isConvertible(pyargs[1])) {
            if (numArgs == 2) {
                overloadId = 0; // queryFolders(QtMobility::QMessageFolderFilter,QList<QtMobility::QMessageFolderSortOrder>,uint,uint)const
            } else if (SbkNumber_Check(pyargs[2])) {
                if (numArgs == 3) {
                    overloadId = 0; // queryFolders(QtMobility::QMessageFolderFilter,QList<QtMobility::QMessageFolderSortOrder>,uint,uint)const
                } else if (SbkNumber_Check(pyargs[3])) {
                    overloadId = 0; // queryFolders(QtMobility::QMessageFolderFilter,QList<QtMobility::QMessageFolderSortOrder>,uint,uint)const
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageManagerFunc_queryFolders_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // queryFolders(QtMobility::QMessageFolderFilter,QList<QtMobility::QMessageFolderSortOrder>,uint,uint)const
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "limit");
                    if (value) {
                        if (pyargs[2])
                            errorArgName = "limit";
                        else
                            pyargs[2] = value;
                    }
                    value = PyDict_GetItemString(kwds, "offset");
                    if (value) {
                        if (pyargs[3])
                            errorArgName = "offset";
                        else
                            pyargs[3] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.queryFolders(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QMessageFolderFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(pyargs[0]);
                QList<QtMobility::QMessageFolderSortOrder > cpp_arg1 = Shiboken::Converter<QList<QtMobility::QMessageFolderSortOrder > >::toCpp(pyargs[1]);
                uint cpp_arg2 = pyargs[2] ? Shiboken::Converter<uint >::toCpp(pyargs[2]) : 0;
                uint cpp_arg3 = pyargs[3] ? Shiboken::Converter<uint >::toCpp(pyargs[3]) : 0;

                if(!PyErr_Occurred()) {
                // queryFolders(QtMobility::QMessageFolderFilter,QList<QtMobility::QMessageFolderSortOrder>,uint,uint)const
                QList<QtMobility::QMessageFolderId > cppResult = cppSelf->QtMobility::QMessageManager::queryFolders(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                pyResult = Shiboken::Converter<QList<QtMobility::QMessageFolderId > >::toPython(cppResult);
                }
                break;
            }
            case 1: // queryFolders(QtMobility::QMessageFolderFilter,QtMobility::QMessageFolderSortOrder,uint,uint)const
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "filter");
                    if (value) {
                        if (pyargs[0])
                            errorArgName = "filter";
                        else
                            pyargs[0] = value;
                    }
                    value = PyDict_GetItemString(kwds, "sortOrder");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "sortOrder";
                        else
                            pyargs[1] = value;
                    }
                    value = PyDict_GetItemString(kwds, "limit");
                    if (value) {
                        if (pyargs[2])
                            errorArgName = "limit";
                        else
                            pyargs[2] = value;
                    }
                    value = PyDict_GetItemString(kwds, "offset");
                    if (value) {
                        if (pyargs[3])
                            errorArgName = "offset";
                        else
                            pyargs[3] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.queryFolders(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QMessageFolderFilter cpp_arg0_tmp = QtMobility::QMessageFolderFilter();
                QtMobility::QMessageFolderFilter* cpp_arg0 = pyargs[0] ? Shiboken::Converter<QtMobility::QMessageFolderFilter* >::toCpp(pyargs[0]) : &cpp_arg0_tmp;
                if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                    return 0;
                QtMobility::QMessageFolderSortOrder cpp_arg1_tmp = QtMobility::QMessageFolderSortOrder();
                QtMobility::QMessageFolderSortOrder* cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageFolderSortOrder* >::toCpp(pyargs[1]) : &cpp_arg1_tmp;
                uint cpp_arg2 = pyargs[2] ? Shiboken::Converter<uint >::toCpp(pyargs[2]) : 0;
                uint cpp_arg3 = pyargs[3] ? Shiboken::Converter<uint >::toCpp(pyargs[3]) : 0;

                if(!PyErr_Occurred()) {
                // queryFolders(QtMobility::QMessageFolderFilter,QtMobility::QMessageFolderSortOrder,uint,uint)const
                QList<QtMobility::QMessageFolderId > cppResult = cppSelf->QtMobility::QMessageManager::queryFolders(*cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
                pyResult = Shiboken::Converter<QList<QtMobility::QMessageFolderId > >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageManagerFunc_queryFolders_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFolderFilter, list, unsigned int = 0, unsigned int = 0", "QtMobility.Messaging.QtMobility::QMessageFolderFilter = QtMobility.QMessageFolderFilter(), QtMobility.Messaging.QtMobility::QMessageFolderSortOrder = QtMobility.QMessageFolderSortOrder(), unsigned int = 0, unsigned int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageManager.queryFolders", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageManagerFunc_queryMessages(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QMessageManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "filter", "limit", "matchFlags", "offset", "sortOrder" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 5, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.queryMessages(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 6) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.queryMessages(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOO:queryMessages", &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;


    // Overloaded function decisor
    // 0: queryMessages(QtMobility::QMessageFilter,QList<QtMobility::QMessageSortOrder>,uint,uint)const
    // 1: queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QList<QtMobility::QMessageSortOrder>,uint,uint)const
    // 2: queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QtMobility::QMessageSortOrder,uint,uint)const
    // 3: queryMessages(QtMobility::QMessageFilter,QtMobility::QMessageSortOrder,uint,uint)const
    if (numArgs == 0) {
        overloadId = 3; // queryMessages(QtMobility::QMessageFilter,QtMobility::QMessageSortOrder,uint,uint)const
    } else if (Shiboken::Converter<const QtMobility::QMessageFilter & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 3; // queryMessages(QtMobility::QMessageFilter,QtMobility::QMessageSortOrder,uint,uint)const
        } else if (Shiboken::Converter<const QtMobility::QMessageSortOrder & >::isConvertible(pyargs[1])) {
            if (numArgs == 2) {
                overloadId = 3; // queryMessages(QtMobility::QMessageFilter,QtMobility::QMessageSortOrder,uint,uint)const
            } else if (SbkNumber_Check(pyargs[2])) {
                if (numArgs == 3) {
                    overloadId = 3; // queryMessages(QtMobility::QMessageFilter,QtMobility::QMessageSortOrder,uint,uint)const
                } else if (SbkNumber_Check(pyargs[3])) {
                    overloadId = 3; // queryMessages(QtMobility::QMessageFilter,QtMobility::QMessageSortOrder,uint,uint)const
                }
            }
        } else if (Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
            if (numArgs == 2) {
                overloadId = 2; // queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QtMobility::QMessageSortOrder,uint,uint)const
            } else if (Shiboken::Converter<QFlags<QtMobility::QMessageDataComparator::MatchFlag> >::isConvertible(pyargs[2])) {
                if (numArgs == 3) {
                    overloadId = 2; // queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QtMobility::QMessageSortOrder,uint,uint)const
                } else if (Shiboken::Converter<const QtMobility::QMessageSortOrder & >::isConvertible(pyargs[3])) {
                    if (numArgs == 4) {
                        overloadId = 2; // queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QtMobility::QMessageSortOrder,uint,uint)const
                    } else if (SbkNumber_Check(pyargs[4])) {
                        if (numArgs == 5) {
                            overloadId = 2; // queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QtMobility::QMessageSortOrder,uint,uint)const
                        } else if (SbkNumber_Check(pyargs[5])) {
                            overloadId = 2; // queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QtMobility::QMessageSortOrder,uint,uint)const
                        }
                    }
                } else if (Shiboken::Converter< QList<QtMobility::QMessageSortOrder >  >::isConvertible(pyargs[3])) {
                    if (numArgs == 4) {
                        overloadId = 1; // queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QList<QtMobility::QMessageSortOrder>,uint,uint)const
                    } else if (SbkNumber_Check(pyargs[4])) {
                        if (numArgs == 5) {
                            overloadId = 1; // queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QList<QtMobility::QMessageSortOrder>,uint,uint)const
                        } else if (SbkNumber_Check(pyargs[5])) {
                            overloadId = 1; // queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QList<QtMobility::QMessageSortOrder>,uint,uint)const
                        }
                    }
                }
            }
        } else if (Shiboken::Converter< QList<QtMobility::QMessageSortOrder >  >::isConvertible(pyargs[1])) {
            if (numArgs == 2) {
                overloadId = 0; // queryMessages(QtMobility::QMessageFilter,QList<QtMobility::QMessageSortOrder>,uint,uint)const
            } else if (SbkNumber_Check(pyargs[2])) {
                if (numArgs == 3) {
                    overloadId = 0; // queryMessages(QtMobility::QMessageFilter,QList<QtMobility::QMessageSortOrder>,uint,uint)const
                } else if (SbkNumber_Check(pyargs[3])) {
                    overloadId = 0; // queryMessages(QtMobility::QMessageFilter,QList<QtMobility::QMessageSortOrder>,uint,uint)const
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageManagerFunc_queryMessages_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // queryMessages(QtMobility::QMessageFilter,QList<QtMobility::QMessageSortOrder>,uint,uint)const
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "limit");
                    if (value) {
                        if (pyargs[2])
                            errorArgName = "limit";
                        else
                            pyargs[2] = value;
                    }
                    value = PyDict_GetItemString(kwds, "offset");
                    if (value) {
                        if (pyargs[3])
                            errorArgName = "offset";
                        else
                            pyargs[3] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.queryMessages(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QMessageFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(pyargs[0]);
                QList<QtMobility::QMessageSortOrder > cpp_arg1 = Shiboken::Converter<QList<QtMobility::QMessageSortOrder > >::toCpp(pyargs[1]);
                uint cpp_arg2 = pyargs[2] ? Shiboken::Converter<uint >::toCpp(pyargs[2]) : 0;
                uint cpp_arg3 = pyargs[3] ? Shiboken::Converter<uint >::toCpp(pyargs[3]) : 0;

                if(!PyErr_Occurred()) {
                // queryMessages(QtMobility::QMessageFilter,QList<QtMobility::QMessageSortOrder>,uint,uint)const
                QList<QtMobility::QMessageId > cppResult = cppSelf->QtMobility::QMessageManager::queryMessages(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                pyResult = Shiboken::Converter<QList<QtMobility::QMessageId > >::toPython(cppResult);
                }
                break;
            }
            case 1: // queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QList<QtMobility::QMessageSortOrder>,uint,uint)const
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "limit");
                    if (value) {
                        if (pyargs[4])
                            errorArgName = "limit";
                        else
                            pyargs[4] = value;
                    }
                    value = PyDict_GetItemString(kwds, "offset");
                    if (value) {
                        if (pyargs[5])
                            errorArgName = "offset";
                        else
                            pyargs[5] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.queryMessages(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QMessageFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(pyargs[0]);
                QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);
                QFlags<QtMobility::QMessageDataComparator::MatchFlag> cpp_arg2 = Shiboken::Converter<QFlags<QtMobility::QMessageDataComparator::MatchFlag> >::toCpp(pyargs[2]);
                QList<QtMobility::QMessageSortOrder > cpp_arg3 = Shiboken::Converter<QList<QtMobility::QMessageSortOrder > >::toCpp(pyargs[3]);
                uint cpp_arg4 = pyargs[4] ? Shiboken::Converter<uint >::toCpp(pyargs[4]) : 0;
                uint cpp_arg5 = pyargs[5] ? Shiboken::Converter<uint >::toCpp(pyargs[5]) : 0;

                if(!PyErr_Occurred()) {
                // queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QList<QtMobility::QMessageSortOrder>,uint,uint)const
                QList<QtMobility::QMessageId > cppResult = cppSelf->QtMobility::QMessageManager::queryMessages(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
                pyResult = Shiboken::Converter<QList<QtMobility::QMessageId > >::toPython(cppResult);
                }
                break;
            }
            case 2: // queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QtMobility::QMessageSortOrder,uint,uint)const
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "matchFlags");
                    if (value) {
                        if (pyargs[2])
                            errorArgName = "matchFlags";
                        else
                            pyargs[2] = value;
                    }
                    value = PyDict_GetItemString(kwds, "sortOrder");
                    if (value) {
                        if (pyargs[3])
                            errorArgName = "sortOrder";
                        else
                            pyargs[3] = value;
                    }
                    value = PyDict_GetItemString(kwds, "limit");
                    if (value) {
                        if (pyargs[4])
                            errorArgName = "limit";
                        else
                            pyargs[4] = value;
                    }
                    value = PyDict_GetItemString(kwds, "offset");
                    if (value) {
                        if (pyargs[5])
                            errorArgName = "offset";
                        else
                            pyargs[5] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.queryMessages(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QMessageFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(pyargs[0]);
                QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);
                QFlags<QtMobility::QMessageDataComparator::MatchFlag> cpp_arg2 = pyargs[2] ? Shiboken::Converter<QFlags<QtMobility::QMessageDataComparator::MatchFlag> >::toCpp(pyargs[2]) : QFlags<QtMobility::QMessageDataComparator::MatchFlag>(0);
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return 0;
                QtMobility::QMessageSortOrder cpp_arg3_tmp = QtMobility::QMessageSortOrder();
                QtMobility::QMessageSortOrder* cpp_arg3 = pyargs[3] ? Shiboken::Converter<QtMobility::QMessageSortOrder* >::toCpp(pyargs[3]) : &cpp_arg3_tmp;
                uint cpp_arg4 = pyargs[4] ? Shiboken::Converter<uint >::toCpp(pyargs[4]) : 0;
                uint cpp_arg5 = pyargs[5] ? Shiboken::Converter<uint >::toCpp(pyargs[5]) : 0;

                if(!PyErr_Occurred()) {
                // queryMessages(QtMobility::QMessageFilter,QString,QFlags<QtMobility::QMessageDataComparator::MatchFlag>,QtMobility::QMessageSortOrder,uint,uint)const
                QList<QtMobility::QMessageId > cppResult = cppSelf->QtMobility::QMessageManager::queryMessages(*cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, cpp_arg4, cpp_arg5);
                pyResult = Shiboken::Converter<QList<QtMobility::QMessageId > >::toPython(cppResult);
                }
                break;
            }
            case 3: // queryMessages(QtMobility::QMessageFilter,QtMobility::QMessageSortOrder,uint,uint)const
            {
                if (kwds) {
                    const char* errorArgName = 0;
                    PyObject* value = PyDict_GetItemString(kwds, "filter");
                    if (value) {
                        if (pyargs[0])
                            errorArgName = "filter";
                        else
                            pyargs[0] = value;
                    }
                    value = PyDict_GetItemString(kwds, "sortOrder");
                    if (value) {
                        if (pyargs[1])
                            errorArgName = "sortOrder";
                        else
                            pyargs[1] = value;
                    }
                    value = PyDict_GetItemString(kwds, "limit");
                    if (value) {
                        if (pyargs[2])
                            errorArgName = "limit";
                        else
                            pyargs[2] = value;
                    }
                    value = PyDict_GetItemString(kwds, "offset");
                    if (value) {
                        if (pyargs[3])
                            errorArgName = "offset";
                        else
                            pyargs[3] = value;
                    }
                    if (errorArgName) {
                        PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.queryMessages(): got multiple values for keyword argument '%s'", errorArgName);
                        return 0;
                    }
                }
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return 0;
                QtMobility::QMessageFilter cpp_arg0_tmp = QtMobility::QMessageFilter();
                QtMobility::QMessageFilter* cpp_arg0 = pyargs[0] ? Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(pyargs[0]) : &cpp_arg0_tmp;
                if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                    return 0;
                QtMobility::QMessageSortOrder cpp_arg1_tmp = QtMobility::QMessageSortOrder();
                QtMobility::QMessageSortOrder* cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageSortOrder* >::toCpp(pyargs[1]) : &cpp_arg1_tmp;
                uint cpp_arg2 = pyargs[2] ? Shiboken::Converter<uint >::toCpp(pyargs[2]) : 0;
                uint cpp_arg3 = pyargs[3] ? Shiboken::Converter<uint >::toCpp(pyargs[3]) : 0;

                if(!PyErr_Occurred()) {
                // queryMessages(QtMobility::QMessageFilter,QtMobility::QMessageSortOrder,uint,uint)const
                QList<QtMobility::QMessageId > cppResult = cppSelf->QtMobility::QMessageManager::queryMessages(*cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
                pyResult = Shiboken::Converter<QList<QtMobility::QMessageId > >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageManagerFunc_queryMessages_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFilter, list, unsigned int = 0, unsigned int = 0", "QtMobility.Messaging.QtMobility::QMessageFilter, QString, QtMobility.Messaging.QtMobility::QMessageDataComparator.MatchFlags, list, unsigned int = 0, unsigned int = 0", "QtMobility.Messaging.QtMobility::QMessageFilter, QString, QtMobility.Messaging.QtMobility::QMessageDataComparator.MatchFlags = 0, QtMobility.Messaging.QtMobility::QMessageSortOrder = QtMobility.QMessageSortOrder(), unsigned int = 0, unsigned int = 0", "QtMobility.Messaging.QtMobility::QMessageFilter = QtMobility.QMessageFilter(), QtMobility.Messaging.QtMobility::QMessageSortOrder = QtMobility.QMessageSortOrder(), unsigned int = 0, unsigned int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageManager.queryMessages", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageManagerFunc_registerNotificationFilter(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: registerNotificationFilter(QtMobility::QMessageFilter)
    if (Shiboken::Converter<const QtMobility::QMessageFilter & >::isConvertible(arg)) {
        overloadId = 0; // registerNotificationFilter(QtMobility::QMessageFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageManagerFunc_registerNotificationFilter_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // registerNotificationFilter(QtMobility::QMessageFilter)
            QtMobility::QMessageManager::NotificationFilterId cppResult = cppSelf->QtMobility::QMessageManager::registerNotificationFilter(*cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageManager::NotificationFilterId >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageManagerFunc_registerNotificationFilter_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageManager.registerNotificationFilter", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageManagerFunc_removeMessage(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QMessageManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "option" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.removeMessage(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.removeMessage(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.removeMessage(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:removeMessage", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: removeMessage(QtMobility::QMessageId,QtMobility::QMessageManager::RemovalOption)
    if (Shiboken::Converter<const QtMobility::QMessageId & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // removeMessage(QtMobility::QMessageId,QtMobility::QMessageManager::RemovalOption)
        } else if (Shiboken::Converter<QtMobility::QMessageManager::RemovalOption >::isConvertible(pyargs[1])) {
            overloadId = 0; // removeMessage(QtMobility::QMessageId,QtMobility::QMessageManager::RemovalOption)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageManagerFunc_removeMessage_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "option");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "option";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.removeMessage(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            std::auto_ptr<QtMobility::QMessageId > cpp_arg0_auto_ptr;
            QtMobility::QMessageId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageId* >::toCpp(pyargs[0]);
            if (!Shiboken::Converter<QtMobility::QMessageId >::checkType(pyargs[0]))
                cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageId >(cpp_arg0);
            QtMobility::QMessageManager::RemovalOption cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageManager::RemovalOption >::toCpp(pyargs[1]) : QtMobility::QMessageManager::RemoveOnOriginatingServer;

            if(!PyErr_Occurred()) {
            // removeMessage(QtMobility::QMessageId,QtMobility::QMessageManager::RemovalOption)
            bool cppResult = cppSelf->QtMobility::QMessageManager::removeMessage(*cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageManagerFunc_removeMessage_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageId, QtMobility.Messaging.QtMobility::QMessageManager.RemovalOption = RemoveOnOriginatingServer", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageManager.removeMessage", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageManagerFunc_removeMessages(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QMessageManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "option" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.removeMessages(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.removeMessages(): too many arguments");
        return 0;
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.removeMessages(): not enough arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|OO:removeMessages", &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: removeMessages(QtMobility::QMessageFilter,QtMobility::QMessageManager::RemovalOption)
    if (Shiboken::Converter<const QtMobility::QMessageFilter & >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // removeMessages(QtMobility::QMessageFilter,QtMobility::QMessageManager::RemovalOption)
        } else if (Shiboken::Converter<QtMobility::QMessageManager::RemovalOption >::isConvertible(pyargs[1])) {
            overloadId = 0; // removeMessages(QtMobility::QMessageFilter,QtMobility::QMessageManager::RemovalOption)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageManagerFunc_removeMessages_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "option");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "option";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageManager.removeMessages(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QMessageFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFilter* >::toCpp(pyargs[0]);
            QtMobility::QMessageManager::RemovalOption cpp_arg1 = pyargs[1] ? Shiboken::Converter<QtMobility::QMessageManager::RemovalOption >::toCpp(pyargs[1]) : QtMobility::QMessageManager::RemoveOnOriginatingServer;

            if(!PyErr_Occurred()) {
            // removeMessages(QtMobility::QMessageFilter,QtMobility::QMessageManager::RemovalOption)
            bool cppResult = cppSelf->QtMobility::QMessageManager::removeMessages(*cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageManagerFunc_removeMessages_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFilter, QtMobility.Messaging.QtMobility::QMessageManager.RemovalOption = RemoveOnOriginatingServer", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageManager.removeMessages", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageManagerFunc_unregisterNotificationFilter(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageManager* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: unregisterNotificationFilter(QtMobility::QMessageManager::NotificationFilterId)
    if (PyInt_Check(arg)) {
        overloadId = 0; // unregisterNotificationFilter(QtMobility::QMessageManager::NotificationFilterId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageManagerFunc_unregisterNotificationFilter_TypeError;

    // Call function/method
    {
        {
            QtMobility::QMessageManager::NotificationFilterId cpp_arg0 = Shiboken::Converter<QtMobility::QMessageManager::NotificationFilterId >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // unregisterNotificationFilter(QtMobility::QMessageManager::NotificationFilterId)
            cppSelf->QtMobility::QMessageManager::unregisterNotificationFilter(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageManagerFunc_unregisterNotificationFilter_TypeError:
        const char* overloads[] = {"QtMobility::QMessageManager::NotificationFilterId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageManager.unregisterNotificationFilter", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageManagerFunc_updateMessage(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: updateMessage(QtMobility::QMessage*)
    if (Shiboken::Converter<QtMobility::QMessage * >::isConvertible(arg)) {
        overloadId = 0; // updateMessage(QtMobility::QMessage*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageManagerFunc_updateMessage_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QtMobility::QMessage > cpp_arg0_auto_ptr;
            QtMobility::QMessage* cpp_arg0 = Shiboken::Converter<QtMobility::QMessage* >::toCpp(arg);
            if (!Shiboken::Converter<QtMobility::QMessage >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessage >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // updateMessage(QtMobility::QMessage*)
            bool cppResult = cppSelf->QtMobility::QMessageManager::updateMessage(cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageManagerFunc_updateMessage_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessage", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageManager.updateMessage", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QMessageManager_methods[] = {
    {"account", (PyCFunction)SbkQtMobility_QMessageManagerFunc_account, METH_O},
    {"addMessage", (PyCFunction)SbkQtMobility_QMessageManagerFunc_addMessage, METH_O},
    {"countAccounts", (PyCFunction)SbkQtMobility_QMessageManagerFunc_countAccounts, METH_VARARGS|METH_KEYWORDS},
    {"countFolders", (PyCFunction)SbkQtMobility_QMessageManagerFunc_countFolders, METH_VARARGS|METH_KEYWORDS},
    {"countMessages", (PyCFunction)SbkQtMobility_QMessageManagerFunc_countMessages, METH_VARARGS|METH_KEYWORDS},
    {"error", (PyCFunction)SbkQtMobility_QMessageManagerFunc_error, METH_NOARGS},
    {"folder", (PyCFunction)SbkQtMobility_QMessageManagerFunc_folder, METH_O},
    {"message", (PyCFunction)SbkQtMobility_QMessageManagerFunc_message, METH_O},
    {"queryAccounts", (PyCFunction)SbkQtMobility_QMessageManagerFunc_queryAccounts, METH_VARARGS|METH_KEYWORDS},
    {"queryFolders", (PyCFunction)SbkQtMobility_QMessageManagerFunc_queryFolders, METH_VARARGS|METH_KEYWORDS},
    {"queryMessages", (PyCFunction)SbkQtMobility_QMessageManagerFunc_queryMessages, METH_VARARGS|METH_KEYWORDS},
    {"registerNotificationFilter", (PyCFunction)SbkQtMobility_QMessageManagerFunc_registerNotificationFilter, METH_O},
    {"removeMessage", (PyCFunction)SbkQtMobility_QMessageManagerFunc_removeMessage, METH_VARARGS|METH_KEYWORDS},
    {"removeMessages", (PyCFunction)SbkQtMobility_QMessageManagerFunc_removeMessages, METH_VARARGS|METH_KEYWORDS},
    {"unregisterNotificationFilter", (PyCFunction)SbkQtMobility_QMessageManagerFunc_unregisterNotificationFilter, METH_O},
    {"updateMessage", (PyCFunction)SbkQtMobility_QMessageManagerFunc_updateMessage, METH_O},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QMessageManager_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Messaging.QMessageManager",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QMessageManager_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QMessageManager_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QMessageManager >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QMessageManager*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QMessageManager_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QMessageManager*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QMessageManager_Type;
    return 0;
}

static PyGetSetDef SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Error",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkQtMobility_Messaging_QtMobility_QMessageManager_RemovalOption_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Messaging_QtMobility_QMessageManager_RemovalOption_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Messaging_QtMobility_QMessageManager_RemovalOption_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "RemovalOption",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Messaging_QtMobility_QMessageManager_RemovalOption_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Messaging_QtMobility_QMessageManager_RemovalOption_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Messaging_QtMobility_QMessageManager_RemovalOption_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QMessageManager(PyObject* module)
{
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEMANAGER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QMessageManager_Type);

    SbkQtMobility_QMessageManager_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQtMobility_QMessageManager_Type.type_discovery = &SbkQtMobility_QMessageManager_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]), &SbkQtMobility_QMessageManager_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QMessageManager_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QMessageManager_Type));
    PyModule_AddObject(module, "QMessageManager",
        ((PyObject*)&SbkQtMobility_QMessageManager_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Error
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEMANAGER_ERROR_IDX] = &SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type);
    PyDict_SetItemString(SbkQtMobility_QMessageManager_Type.super.ht_type.tp_dict,
            "Error",((PyObject*)&SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type,
        (long) QtMobility::QMessageManager::NoError, "NoError");
    PyDict_SetItemString(SbkQtMobility_QMessageManager_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type,
        (long) QtMobility::QMessageManager::InvalidId, "InvalidId");
    PyDict_SetItemString(SbkQtMobility_QMessageManager_Type.super.ht_type.tp_dict,
        "InvalidId", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type.tp_dict,
        "InvalidId", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type,
        (long) QtMobility::QMessageManager::ConstraintFailure, "ConstraintFailure");
    PyDict_SetItemString(SbkQtMobility_QMessageManager_Type.super.ht_type.tp_dict,
        "ConstraintFailure", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type.tp_dict,
        "ConstraintFailure", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type,
        (long) QtMobility::QMessageManager::ContentInaccessible, "ContentInaccessible");
    PyDict_SetItemString(SbkQtMobility_QMessageManager_Type.super.ht_type.tp_dict,
        "ContentInaccessible", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type.tp_dict,
        "ContentInaccessible", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type,
        (long) QtMobility::QMessageManager::NotYetImplemented, "NotYetImplemented");
    PyDict_SetItemString(SbkQtMobility_QMessageManager_Type.super.ht_type.tp_dict,
        "NotYetImplemented", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type.tp_dict,
        "NotYetImplemented", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type,
        (long) QtMobility::QMessageManager::FrameworkFault, "FrameworkFault");
    PyDict_SetItemString(SbkQtMobility_QMessageManager_Type.super.ht_type.tp_dict,
        "FrameworkFault", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type.tp_dict,
        "FrameworkFault", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type,
        (long) QtMobility::QMessageManager::WorkingMemoryOverflow, "WorkingMemoryOverflow");
    PyDict_SetItemString(SbkQtMobility_QMessageManager_Type.super.ht_type.tp_dict,
        "WorkingMemoryOverflow", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type.tp_dict,
        "WorkingMemoryOverflow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type,
        (long) QtMobility::QMessageManager::Busy, "Busy");
    PyDict_SetItemString(SbkQtMobility_QMessageManager_Type.super.ht_type.tp_dict,
        "Busy", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type.tp_dict,
        "Busy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type,
        (long) QtMobility::QMessageManager::RequestIncomplete, "RequestIncomplete");
    PyDict_SetItemString(SbkQtMobility_QMessageManager_Type.super.ht_type.tp_dict,
        "RequestIncomplete", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageManager_Error_Type.tp_dict,
        "RequestIncomplete", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QMessageManager::Error");

    // init enum class: RemovalOption
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEMANAGER_REMOVALOPTION_IDX] = &SbkQtMobility_Messaging_QtMobility_QMessageManager_RemovalOption_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Messaging_QtMobility_QMessageManager_RemovalOption_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Messaging_QtMobility_QMessageManager_RemovalOption_Type);
    PyDict_SetItemString(SbkQtMobility_QMessageManager_Type.super.ht_type.tp_dict,
            "RemovalOption",((PyObject*)&SbkQtMobility_Messaging_QtMobility_QMessageManager_RemovalOption_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageManager_RemovalOption_Type,
        (long) QtMobility::QMessageManager::RemoveLocalCopyOnly, "RemoveLocalCopyOnly");
    PyDict_SetItemString(SbkQtMobility_QMessageManager_Type.super.ht_type.tp_dict,
        "RemoveLocalCopyOnly", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageManager_RemovalOption_Type.tp_dict,
        "RemoveLocalCopyOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Messaging_QtMobility_QMessageManager_RemovalOption_Type,
        (long) QtMobility::QMessageManager::RemoveOnOriginatingServer, "RemoveOnOriginatingServer");
    PyDict_SetItemString(SbkQtMobility_QMessageManager_Type.super.ht_type.tp_dict,
        "RemoveOnOriginatingServer", enum_item);
    PyDict_SetItemString(SbkQtMobility_Messaging_QtMobility_QMessageManager_RemovalOption_Type.tp_dict,
        "RemoveOnOriginatingServer", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QMessageManager::RemovalOption");

    // Initialize signals
    PyObject* signal_item;

    signal_item = PySide::signalNew("messageUpdated", "const QtMobility::QMessageId&,const QSet<QtMobility::QMessageManager::NotificationFilterId>&", NULL);
    PyDict_SetItemString(SbkQtMobility_QMessageManager_Type.super.ht_type.tp_dict, "messageUpdated", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("messageRemoved", "const QtMobility::QMessageId&,const QSet<QtMobility::QMessageManager::NotificationFilterId>&", NULL);
    PyDict_SetItemString(SbkQtMobility_QMessageManager_Type.super.ht_type.tp_dict, "messageRemoved", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("messageAdded", "const QtMobility::QMessageId&,const QSet<QtMobility::QMessageManager::NotificationFilterId>&", NULL);
    PyDict_SetItemString(SbkQtMobility_QMessageManager_Type.super.ht_type.tp_dict, "messageAdded", signal_item);
    Py_DECREF(signal_item);


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessageManager >("QtMobility::QMessageManager*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessageManager >(typeid(QtMobility::QMessageManager).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessageManager >(typeid(QMessageManagerWrapper).name());
    PySide::initQtMetaType<QtMobility::QMessageManager* >();
}

