/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_messaging_python.h"

#include "qtmobility_qmessagefoldersortorder_wrapper.h"

// Extra includes
#include <qmessagefoldersortorder.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QMessageFolderSortOrderWrapper::QMessageFolderSortOrderWrapper() : QtMobility::QMessageFolderSortOrder() {
    // ... middle
}

QMessageFolderSortOrderWrapper::~QMessageFolderSortOrderWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QMessageFolderSortOrder_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QMessageFolderSortOrder >()))
        return -1;

    QMessageFolderSortOrderWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMessageFolderSortOrder", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QMessageFolderSortOrder()
    // 1: QMessageFolderSortOrder(QtMobility::QMessageFolderSortOrder)
    if (numArgs == 0) {
        overloadId = 0; // QMessageFolderSortOrder()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QMessageFolderSortOrder & >::isConvertible(arg)) {
        overloadId = 1; // QMessageFolderSortOrder(QtMobility::QMessageFolderSortOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFolderSortOrder_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QMessageFolderSortOrder()
            {

                if(!PyErr_Occurred()) {
                // QMessageFolderSortOrder()
                cptr = new QMessageFolderSortOrderWrapper();
                }
                break;
            }
            case 1: // QMessageFolderSortOrder(QtMobility::QMessageFolderSortOrder)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QMessageFolderSortOrder* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderSortOrder* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QMessageFolderSortOrder(QtMobility::QMessageFolderSortOrder)
                cptr = new QMessageFolderSortOrderWrapper(*reinterpret_cast<QMessageFolderSortOrderWrapper*>(cpp_arg0));
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QMessageFolderSortOrder >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QMessageFolderSortOrder_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QMessageFolderSortOrder_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Messaging.QtMobility::QMessageFolderSortOrder", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFolderSortOrder", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QMessageFolderSortOrderFunc_byName(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "order" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderSortOrder.byName(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderSortOrder.byName(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:byName", &arg))
        return 0;


    // Overloaded function decisor
    // 0: byName(Qt::SortOrder)
    if (numArgs == 0) {
        overloadId = 0; // byName(Qt::SortOrder)
    } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(arg)) {
        overloadId = 0; // byName(Qt::SortOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFolderSortOrderFunc_byName_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "order");
                if (value) {
                    if (arg)
                        errorArgName = "order";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderSortOrder.byName(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            Qt::SortOrder cpp_arg0 = arg ? Shiboken::Converter<Qt::SortOrder >::toCpp(arg) : Qt::AscendingOrder;

            if(!PyErr_Occurred()) {
            // byName(Qt::SortOrder)
            QtMobility::QMessageFolderSortOrder cppResult = QtMobility::QMessageFolderSortOrder::byName(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageFolderSortOrder >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFolderSortOrderFunc_byName_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.SortOrder = Qt.AscendingOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageFolderSortOrder.byName", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFolderSortOrderFunc_byPath(PyObject* self, PyObject* args, PyObject* kwds)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "order" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderSortOrder.byPath(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderSortOrder.byPath(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:byPath", &arg))
        return 0;


    // Overloaded function decisor
    // 0: byPath(Qt::SortOrder)
    if (numArgs == 0) {
        overloadId = 0; // byPath(Qt::SortOrder)
    } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(arg)) {
        overloadId = 0; // byPath(Qt::SortOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFolderSortOrderFunc_byPath_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "order");
                if (value) {
                    if (arg)
                        errorArgName = "order";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Messaging.QMessageFolderSortOrder.byPath(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            Qt::SortOrder cpp_arg0 = arg ? Shiboken::Converter<Qt::SortOrder >::toCpp(arg) : Qt::AscendingOrder;

            if(!PyErr_Occurred()) {
            // byPath(Qt::SortOrder)
            QtMobility::QMessageFolderSortOrder cppResult = QtMobility::QMessageFolderSortOrder::byPath(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageFolderSortOrder >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFolderSortOrderFunc_byPath_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.SortOrder = Qt.AscendingOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageFolderSortOrder.byPath", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFolderSortOrderFunc_isEmpty(PyObject* self)
{
    QtMobility::QMessageFolderSortOrder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolderSortOrder* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = cppSelf->QtMobility::QMessageFolderSortOrder::isEmpty();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFolderSortOrderFunc_isSupported(PyObject* self)
{
    QtMobility::QMessageFolderSortOrder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolderSortOrder* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isSupported()const
            bool cppResult = cppSelf->QtMobility::QMessageFolderSortOrder::isSupported();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QMessageFolderSortOrder_methods[] = {
    {"byName", (PyCFunction)SbkQtMobility_QMessageFolderSortOrderFunc_byName, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"byPath", (PyCFunction)SbkQtMobility_QMessageFolderSortOrderFunc_byPath, METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"isEmpty", (PyCFunction)SbkQtMobility_QMessageFolderSortOrderFunc_isEmpty, METH_NOARGS},
    {"isSupported", (PyCFunction)SbkQtMobility_QMessageFolderSortOrderFunc_isSupported, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQtMobility_QMessageFolderSortOrderFunc___add__(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageFolderSortOrder* cppSelf = 0;
    bool isReverse = Shiboken::Converter<QtMobility::QMessageFolderSortOrder >::checkType(arg) && !Shiboken::Converter<QtMobility::QMessageFolderSortOrder >::checkType(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolderSortOrder* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__radd__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__radd__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {

    // Overloaded function decisor
    // 0: operator+(QtMobility::QMessageFolderSortOrder)const
    if (!isReverse && Shiboken::Converter<const QtMobility::QMessageFolderSortOrder & >::isConvertible(arg)) {
        overloadId = 0; // operator+(QtMobility::QMessageFolderSortOrder)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFolderSortOrderFunc___add___TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageFolderSortOrder* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderSortOrder* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // operator+(QtMobility::QMessageFolderSortOrder)const
            QtMobility::QMessageFolderSortOrder cppResult = (*cppSelf) + (*cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageFolderSortOrder >::toPython(cppResult);
            }
        }
        }

    } // End of "if (!pyResult)"


    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageFolderSortOrderFunc___add___TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFolderSortOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageFolderSortOrder.__add__", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageFolderSortOrderFunc___iadd__(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageFolderSortOrder* cppSelf = 0;
    bool isReverse = Shiboken::Converter<QtMobility::QMessageFolderSortOrder >::checkType(arg) && !Shiboken::Converter<QtMobility::QMessageFolderSortOrder >::checkType(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolderSortOrder* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: operator+=(QtMobility::QMessageFolderSortOrder)
    if (!isReverse && Shiboken::Converter<const QtMobility::QMessageFolderSortOrder & >::isConvertible(arg)) {
        overloadId = 0; // operator+=(QtMobility::QMessageFolderSortOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFolderSortOrderFunc___iadd___TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QMessageFolderSortOrder* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderSortOrder* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // operator+=(QtMobility::QMessageFolderSortOrder)
            (*cppSelf) += (*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQtMobility_QMessageFolderSortOrderFunc___iadd___TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageFolderSortOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageFolderSortOrder.__iadd__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQtMobility_QMessageFolderSortOrder_as_number = {
    /*nb_add*/                  (binaryfunc)SbkQtMobility_QMessageFolderSortOrderFunc___add__,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)0,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)SbkQtMobility_QMessageFolderSortOrderFunc___iadd__,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQtMobility_QMessageFolderSortOrder_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QMessageFolderSortOrder& cpp_self = *Shiboken::Converter<QtMobility::QMessageFolderSortOrder* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QMessageFolderSortOrder & >::isConvertible(other)) {
                // operator!=(const QtMobility::QMessageFolderSortOrder & other) const
                QtMobility::QMessageFolderSortOrder* cpp_other = Shiboken::Converter<QtMobility::QMessageFolderSortOrder* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageFolderSortOrder  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QMessageFolderSortOrder_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QMessageFolderSortOrder & >::isConvertible(other)) {
                // operator==(const QtMobility::QMessageFolderSortOrder & other) const
                QtMobility::QMessageFolderSortOrder* cpp_other = Shiboken::Converter<QtMobility::QMessageFolderSortOrder* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageFolderSortOrder  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QMessageFolderSortOrder_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QMessageFolderSortOrder_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

static void* SbkQtMobility_QMessageFolderSortOrder_ObjCopierFunc(const void* ptr){
    return new QMessageFolderSortOrderWrapper(*reinterpret_cast<const QtMobility::QMessageFolderSortOrder*>(ptr));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QMessageFolderSortOrder_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Messaging.QMessageFolderSortOrder",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQtMobility_QMessageFolderSortOrder_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QMessageFolderSortOrder_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QMessageFolderSortOrder_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QMessageFolderSortOrder_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQtMobility_QMessageFolderSortOrder_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QMessageFolderSortOrder >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QMessageFolderSortOrder",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QMessageFolderSortOrder(PyObject* module)
{
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEFOLDERSORTORDER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QMessageFolderSortOrder_Type);

    // Fill type discovery information

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QMessageFolderSortOrder_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QMessageFolderSortOrder_Type));
    PyModule_AddObject(module, "QMessageFolderSortOrder",
        ((PyObject*)&SbkQtMobility_QMessageFolderSortOrder_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageFolderSortOrder >("QtMobility::QMessageFolderSortOrder");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessageFolderSortOrder >("QtMobility::QMessageFolderSortOrder*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageFolderSortOrder >(typeid(QtMobility::QMessageFolderSortOrder).name());
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageFolderSortOrder >(typeid(QMessageFolderSortOrderWrapper).name());
    PySide::initQtMetaType<QtMobility::QMessageFolderSortOrder >();
}

