/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_messaging_python.h"

#include "qtmobility_qmessagefolderid_wrapper.h"

// Extra includes
#include <qmessagefolderid.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QMessageFolderId_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QMessageFolderId >()))
        return -1;

    QtMobility::QMessageFolderId* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMessageFolderId", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QMessageFolderId()
    // 1: QMessageFolderId(QString)
    // 2: QMessageFolderId(QtMobility::QMessageFolderId)
    if (numArgs == 0) {
        overloadId = 0; // QMessageFolderId()
    } else if (numArgs == 1 && Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 1; // QMessageFolderId(QString)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QMessageFolderId & >::isConvertible(arg)) {
        overloadId = 2; // QMessageFolderId(QtMobility::QMessageFolderId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageFolderId_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QMessageFolderId()
            {

                if(!PyErr_Occurred()) {
                // QMessageFolderId()
                cptr = new QtMobility::QMessageFolderId();
                }
                break;
            }
            case 1: // QMessageFolderId(QString)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QMessageFolderId(QString)
                cptr = new QtMobility::QMessageFolderId(cpp_arg0);
                }
                break;
            }
            case 2: // QMessageFolderId(QtMobility::QMessageFolderId)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QMessageFolderId > cpp_arg0_auto_ptr;
                QtMobility::QMessageFolderId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageFolderId* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QMessageFolderId >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageFolderId >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QMessageFolderId(QtMobility::QMessageFolderId)
                cptr = new QtMobility::QMessageFolderId(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QMessageFolderId >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QMessageFolderId_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QMessageFolderId_Init_TypeError:
        const char* overloads[] = {"", "QString", "QtMobility.Messaging.QtMobility::QMessageFolderId", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageFolderId", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QMessageFolderIdFunc_isValid(PyObject* self)
{
    QtMobility::QMessageFolderId* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolderId* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = cppSelf->QtMobility::QMessageFolderId::isValid();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageFolderIdFunc_toString(PyObject* self)
{
    QtMobility::QMessageFolderId* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageFolderId* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // toString()const
            QString cppResult = cppSelf->QtMobility::QMessageFolderId::toString();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QMessageFolderId_methods[] = {
    {"isValid", (PyCFunction)SbkQtMobility_QMessageFolderIdFunc_isValid, METH_NOARGS},
    {"toString", (PyCFunction)SbkQtMobility_QMessageFolderIdFunc_toString, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQtMobility_QMessageFolderId_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QMessageFolderId& cpp_self = *Shiboken::Converter<QtMobility::QMessageFolderId* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QMessageFolderId & >::isConvertible(other)) {
                // operator!=(const QtMobility::QMessageFolderId & other) const
                QtMobility::QMessageFolderId* cpp_other = Shiboken::Converter<QtMobility::QMessageFolderId* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageFolderId  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QtMobility::QMessageFolderId >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QtMobility::QMessageFolderId > cpp_other_auto_ptr;
                QtMobility::QMessageFolderId* cpp_other = Shiboken::Converter<QtMobility::QMessageFolderId* >::toCpp(other);
                if (!Shiboken::Converter<QtMobility::QMessageFolderId >::checkType(other))
                    cpp_other_auto_ptr = std::auto_ptr<QtMobility::QMessageFolderId >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QMessageFolderId_RichComparison_TypeError;

            break;
        case Py_LT:
            if (Shiboken::Converter<const QtMobility::QMessageFolderId & >::isConvertible(other)) {
                // operator<(const QtMobility::QMessageFolderId & other) const
                QtMobility::QMessageFolderId* cpp_other = Shiboken::Converter<QtMobility::QMessageFolderId* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageFolderId  >::toCpp(other) : (cpp_self < (*cpp_other));
            } else if (Shiboken::Converter<QtMobility::QMessageFolderId >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QtMobility::QMessageFolderId > cpp_other_auto_ptr;
                QtMobility::QMessageFolderId* cpp_other = Shiboken::Converter<QtMobility::QMessageFolderId* >::toCpp(other);
                if (!Shiboken::Converter<QtMobility::QMessageFolderId >::checkType(other))
                    cpp_other_auto_ptr = std::auto_ptr<QtMobility::QMessageFolderId >(cpp_other);
                result = (cpp_self < (*cpp_other));
            } else goto SbkQtMobility_QMessageFolderId_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QMessageFolderId & >::isConvertible(other)) {
                // operator==(const QtMobility::QMessageFolderId & other) const
                QtMobility::QMessageFolderId* cpp_other = Shiboken::Converter<QtMobility::QMessageFolderId* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageFolderId  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QtMobility::QMessageFolderId >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QtMobility::QMessageFolderId > cpp_other_auto_ptr;
                QtMobility::QMessageFolderId* cpp_other = Shiboken::Converter<QtMobility::QMessageFolderId* >::toCpp(other);
                if (!Shiboken::Converter<QtMobility::QMessageFolderId >::checkType(other))
                    cpp_other_auto_ptr = std::auto_ptr<QtMobility::QMessageFolderId >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QMessageFolderId_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QMessageFolderId_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

static long SbkQtMobility_QMessageFolderId_HashFunc(PyObject* obj){
    return qHash(Shiboken::Converter<QtMobility::QMessageFolderId >::toCpp(obj));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QMessageFolderId_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Messaging.QMessageFolderId",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             &SbkQtMobility_QMessageFolderId_HashFunc,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QMessageFolderId_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QMessageFolderId_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QMessageFolderId_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QMessageFolderId >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QMessageFolderId",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QMessageFolderId(PyObject* module)
{
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEFOLDERID_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QMessageFolderId_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QMessageFolderId_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QMessageFolderId_Type));
    PyModule_AddObject(module, "QMessageFolderId",
        ((PyObject*)&SbkQtMobility_QMessageFolderId_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageFolderId >("QtMobility::QMessageFolderId");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessageFolderId >("QtMobility::QMessageFolderId*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageFolderId >(typeid(QtMobility::QMessageFolderId).name());
    PySide::initQtMetaType<QtMobility::QMessageFolderId >();
}

