/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_messaging_python.h"

#include "qtmobility_qmessagecontentcontainer_wrapper.h"

// Extra includes
#include <QList>
#include <QStringList>
#include <qbytearray.h>
#include <qdatastream.h>
#include <qmessage.h>
#include <qmessagecontentcontainer.h>
#include <qmessagecontentcontainerid.h>
#include <qtextstream.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QMessageContentContainerWrapper::QMessageContentContainerWrapper() : QtMobility::QMessageContentContainer() {
    // ... middle
}

QMessageContentContainerWrapper::~QMessageContentContainerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QMessageContentContainer_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QMessageContentContainer >()))
        return -1;

    QMessageContentContainerWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMessageContentContainer", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QMessageContentContainer()
    // 1: QMessageContentContainer(QtMobility::QMessageContentContainer)
    if (numArgs == 0) {
        overloadId = 0; // QMessageContentContainer()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QMessageContentContainer & >::isConvertible(arg)) {
        overloadId = 1; // QMessageContentContainer(QtMobility::QMessageContentContainer)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageContentContainer_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QMessageContentContainer()
            {

                if(!PyErr_Occurred()) {
                // QMessageContentContainer()
                cptr = new QMessageContentContainerWrapper();
                }
                break;
            }
            case 1: // QMessageContentContainer(QtMobility::QMessageContentContainer)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QMessageContentContainer* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageContentContainer* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QMessageContentContainer(QtMobility::QMessageContentContainer)
                cptr = new QMessageContentContainerWrapper(*reinterpret_cast<QMessageContentContainerWrapper*>(cpp_arg0));
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QMessageContentContainer >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QMessageContentContainer_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QMessageContentContainer_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Messaging.QtMobility::QMessageContentContainer", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageContentContainer", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QMessageContentContainerFunc_contains(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageContentContainer* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageContentContainer* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: contains(QtMobility::QMessageContentContainerId)const
    if (Shiboken::Converter<const QtMobility::QMessageContentContainerId & >::isConvertible(arg)) {
        overloadId = 0; // contains(QtMobility::QMessageContentContainerId)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageContentContainerFunc_contains_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QtMobility::QMessageContentContainerId > cpp_arg0_auto_ptr;
            QtMobility::QMessageContentContainerId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageContentContainerId* >::toCpp(arg);
            if (!Shiboken::Converter<QtMobility::QMessageContentContainerId >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageContentContainerId >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // contains(QtMobility::QMessageContentContainerId)const
            bool cppResult = cppSelf->QtMobility::QMessageContentContainer::contains(*cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageContentContainerFunc_contains_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageContentContainerId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageContentContainer.contains", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageContentContainerFunc_content(PyObject* self)
{
    QtMobility::QMessageContentContainer* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageContentContainer* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // content()const
            QByteArray cppResult = cppSelf->QtMobility::QMessageContentContainer::content();
            pyResult = Shiboken::Converter<QByteArray >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageContentContainerFunc_contentCharset(PyObject* self)
{
    QtMobility::QMessageContentContainer* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageContentContainer* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // contentCharset()const
            QByteArray cppResult = cppSelf->QtMobility::QMessageContentContainer::contentCharset();
            pyResult = Shiboken::Converter<QByteArray >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageContentContainerFunc_contentIds(PyObject* self)
{
    QtMobility::QMessageContentContainer* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageContentContainer* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // contentIds()const
            QList<QtMobility::QMessageContentContainerId > cppResult = cppSelf->QtMobility::QMessageContentContainer::contentIds();
            pyResult = Shiboken::Converter<QList<QtMobility::QMessageContentContainerId > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageContentContainerFunc_contentSubType(PyObject* self)
{
    QtMobility::QMessageContentContainer* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageContentContainer* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // contentSubType()const
            QByteArray cppResult = cppSelf->QtMobility::QMessageContentContainer::contentSubType();
            pyResult = Shiboken::Converter<QByteArray >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageContentContainerFunc_contentType(PyObject* self)
{
    QtMobility::QMessageContentContainer* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageContentContainer* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // contentType()const
            QByteArray cppResult = cppSelf->QtMobility::QMessageContentContainer::contentType();
            pyResult = Shiboken::Converter<QByteArray >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageContentContainerFunc_find(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageContentContainer* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageContentContainer* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: find(QtMobility::QMessageContentContainerId)const
    if (Shiboken::Converter<const QtMobility::QMessageContentContainerId & >::isConvertible(arg)) {
        overloadId = 0; // find(QtMobility::QMessageContentContainerId)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageContentContainerFunc_find_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QtMobility::QMessageContentContainerId > cpp_arg0_auto_ptr;
            QtMobility::QMessageContentContainerId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageContentContainerId* >::toCpp(arg);
            if (!Shiboken::Converter<QtMobility::QMessageContentContainerId >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageContentContainerId >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // find(QtMobility::QMessageContentContainerId)const
            QtMobility::QMessageContentContainer cppResult = cppSelf->QtMobility::QMessageContentContainer::find(*cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QMessageContentContainer >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageContentContainerFunc_find_TypeError:
        const char* overloads[] = {"QtMobility.Messaging.QtMobility::QMessageContentContainerId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageContentContainer.find", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageContentContainerFunc_headerFieldValue(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageContentContainer* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageContentContainer* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: headerFieldValue(QByteArray)const
    if (Shiboken::Converter<const QByteArray & >::isConvertible(arg)) {
        overloadId = 0; // headerFieldValue(QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageContentContainerFunc_headerFieldValue_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
            QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
            if (!Shiboken::Converter<QByteArray >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // headerFieldValue(QByteArray)const
            QString cppResult = cppSelf->QtMobility::QMessageContentContainer::headerFieldValue(*cpp_arg0);
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageContentContainerFunc_headerFieldValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageContentContainer.headerFieldValue", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageContentContainerFunc_headerFieldValues(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageContentContainer* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageContentContainer* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: headerFieldValues(QByteArray)const
    if (Shiboken::Converter<const QByteArray & >::isConvertible(arg)) {
        overloadId = 0; // headerFieldValues(QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageContentContainerFunc_headerFieldValues_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
            QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
            if (!Shiboken::Converter<QByteArray >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // headerFieldValues(QByteArray)const
            QStringList cppResult = cppSelf->QtMobility::QMessageContentContainer::headerFieldValues(*cpp_arg0);
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QMessageContentContainerFunc_headerFieldValues_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageContentContainer.headerFieldValues", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageContentContainerFunc_headerFields(PyObject* self)
{
    QtMobility::QMessageContentContainer* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageContentContainer* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // headerFields()const
            QList<QByteArray > cppResult = cppSelf->QtMobility::QMessageContentContainer::headerFields();
            pyResult = Shiboken::Converter<QList<QByteArray > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageContentContainerFunc_isContentAvailable(PyObject* self)
{
    QtMobility::QMessageContentContainer* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageContentContainer* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isContentAvailable()const
            bool cppResult = cppSelf->QtMobility::QMessageContentContainer::isContentAvailable();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageContentContainerFunc_size(PyObject* self)
{
    QtMobility::QMessageContentContainer* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageContentContainer* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // size()const
            int cppResult = cppSelf->QtMobility::QMessageContentContainer::size();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageContentContainerFunc_suggestedFileName(PyObject* self)
{
    QtMobility::QMessageContentContainer* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageContentContainer* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // suggestedFileName()const
            QByteArray cppResult = cppSelf->QtMobility::QMessageContentContainer::suggestedFileName();
            pyResult = Shiboken::Converter<QByteArray >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageContentContainerFunc_textContent(PyObject* self)
{
    QtMobility::QMessageContentContainer* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageContentContainer* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // textContent()const
            QString cppResult = cppSelf->QtMobility::QMessageContentContainer::textContent();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageContentContainerFunc_writeContent(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageContentContainer* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageContentContainer* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: writeContent(QDataStream&)const
    if (Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        overloadId = 0; // writeContent(QDataStream&)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageContentContainerFunc_writeContent_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // writeContent(QDataStream&)const
            cppSelf->QtMobility::QMessageContentContainer::writeContent(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageContentContainerFunc_writeContent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageContentContainer.writeContent", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QMessageContentContainerFunc_writeTextContent(PyObject* self, PyObject* arg)
{
    QtMobility::QMessageContentContainer* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageContentContainer* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: writeTextContent(QTextStream&)const
    if (Shiboken::Converter<QTextStream & >::isConvertible(arg)) {
        overloadId = 0; // writeTextContent(QTextStream&)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageContentContainerFunc_writeTextContent_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QTextStream* cpp_arg0 = Shiboken::Converter<QTextStream* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // writeTextContent(QTextStream&)const
            cppSelf->QtMobility::QMessageContentContainer::writeTextContent(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QMessageContentContainerFunc_writeTextContent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTextStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Messaging.QMessageContentContainer.writeTextContent", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QMessageContentContainer_methods[] = {
    {"contains", (PyCFunction)SbkQtMobility_QMessageContentContainerFunc_contains, METH_O},
    {"content", (PyCFunction)SbkQtMobility_QMessageContentContainerFunc_content, METH_NOARGS},
    {"contentCharset", (PyCFunction)SbkQtMobility_QMessageContentContainerFunc_contentCharset, METH_NOARGS},
    {"contentIds", (PyCFunction)SbkQtMobility_QMessageContentContainerFunc_contentIds, METH_NOARGS},
    {"contentSubType", (PyCFunction)SbkQtMobility_QMessageContentContainerFunc_contentSubType, METH_NOARGS},
    {"contentType", (PyCFunction)SbkQtMobility_QMessageContentContainerFunc_contentType, METH_NOARGS},
    {"find", (PyCFunction)SbkQtMobility_QMessageContentContainerFunc_find, METH_O},
    {"headerFieldValue", (PyCFunction)SbkQtMobility_QMessageContentContainerFunc_headerFieldValue, METH_O},
    {"headerFieldValues", (PyCFunction)SbkQtMobility_QMessageContentContainerFunc_headerFieldValues, METH_O},
    {"headerFields", (PyCFunction)SbkQtMobility_QMessageContentContainerFunc_headerFields, METH_NOARGS},
    {"isContentAvailable", (PyCFunction)SbkQtMobility_QMessageContentContainerFunc_isContentAvailable, METH_NOARGS},
    {"size", (PyCFunction)SbkQtMobility_QMessageContentContainerFunc_size, METH_NOARGS},
    {"suggestedFileName", (PyCFunction)SbkQtMobility_QMessageContentContainerFunc_suggestedFileName, METH_NOARGS},
    {"textContent", (PyCFunction)SbkQtMobility_QMessageContentContainerFunc_textContent, METH_NOARGS},
    {"writeContent", (PyCFunction)SbkQtMobility_QMessageContentContainerFunc_writeContent, METH_O},
    {"writeTextContent", (PyCFunction)SbkQtMobility_QMessageContentContainerFunc_writeTextContent, METH_O},
    {0} // Sentinel
};

} // extern "C"

static void* SbkQtMobility_QMessageContentContainer_ObjCopierFunc(const void* ptr){
    return new QMessageContentContainerWrapper(*reinterpret_cast<const QtMobility::QMessageContentContainer*>(ptr));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QMessageContentContainer_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Messaging.QMessageContentContainer",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QMessageContentContainer_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QMessageContentContainer_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQtMobility_QMessageContentContainer_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QMessageContentContainer >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QMessageContentContainer",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QMessageContentContainer(PyObject* module)
{
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGECONTENTCONTAINER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QMessageContentContainer_Type);

    // Fill type discovery information

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QMessageContentContainer_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QMessageContentContainer_Type));
    PyModule_AddObject(module, "QMessageContentContainer",
        ((PyObject*)&SbkQtMobility_QMessageContentContainer_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageContentContainer >("QtMobility::QMessageContentContainer");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessageContentContainer >("QtMobility::QMessageContentContainer*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageContentContainer >(typeid(QtMobility::QMessageContentContainer).name());
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageContentContainer >(typeid(QMessageContentContainerWrapper).name());
    PySide::initQtMetaType<QtMobility::QMessageContentContainer >();
}

