/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_messaging_python.h"

#include "qtmobility_qmessageaccountid_wrapper.h"

// Extra includes
#include <qmessageaccountid.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QMessageAccountId_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QMessageAccountId >()))
        return -1;

    QtMobility::QMessageAccountId* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMessageAccountId", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QMessageAccountId()
    // 1: QMessageAccountId(QString)
    // 2: QMessageAccountId(QtMobility::QMessageAccountId)
    if (numArgs == 0) {
        overloadId = 0; // QMessageAccountId()
    } else if (numArgs == 1 && Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 1; // QMessageAccountId(QString)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QMessageAccountId & >::isConvertible(arg)) {
        overloadId = 2; // QMessageAccountId(QtMobility::QMessageAccountId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QMessageAccountId_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QMessageAccountId()
            {

                if(!PyErr_Occurred()) {
                // QMessageAccountId()
                cptr = new QtMobility::QMessageAccountId();
                }
                break;
            }
            case 1: // QMessageAccountId(QString)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QMessageAccountId(QString)
                cptr = new QtMobility::QMessageAccountId(cpp_arg0);
                }
                break;
            }
            case 2: // QMessageAccountId(QtMobility::QMessageAccountId)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QMessageAccountId > cpp_arg0_auto_ptr;
                QtMobility::QMessageAccountId* cpp_arg0 = Shiboken::Converter<QtMobility::QMessageAccountId* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QMessageAccountId >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QMessageAccountId >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QMessageAccountId(QtMobility::QMessageAccountId)
                cptr = new QtMobility::QMessageAccountId(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QMessageAccountId >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QMessageAccountId_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QMessageAccountId_Init_TypeError:
        const char* overloads[] = {"", "QString", "QtMobility.Messaging.QtMobility::QMessageAccountId", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Messaging.QMessageAccountId", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QMessageAccountIdFunc_isValid(PyObject* self)
{
    QtMobility::QMessageAccountId* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAccountId* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = cppSelf->QtMobility::QMessageAccountId::isValid();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QMessageAccountIdFunc_toString(PyObject* self)
{
    QtMobility::QMessageAccountId* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QMessageAccountId* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // toString()const
            QString cppResult = cppSelf->QtMobility::QMessageAccountId::toString();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QMessageAccountId_methods[] = {
    {"isValid", (PyCFunction)SbkQtMobility_QMessageAccountIdFunc_isValid, METH_NOARGS},
    {"toString", (PyCFunction)SbkQtMobility_QMessageAccountIdFunc_toString, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQtMobility_QMessageAccountId_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QMessageAccountId& cpp_self = *Shiboken::Converter<QtMobility::QMessageAccountId* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QMessageAccountId & >::isConvertible(other)) {
                // operator!=(const QtMobility::QMessageAccountId & other) const
                QtMobility::QMessageAccountId* cpp_other = Shiboken::Converter<QtMobility::QMessageAccountId* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageAccountId  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QtMobility::QMessageAccountId >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QtMobility::QMessageAccountId > cpp_other_auto_ptr;
                QtMobility::QMessageAccountId* cpp_other = Shiboken::Converter<QtMobility::QMessageAccountId* >::toCpp(other);
                if (!Shiboken::Converter<QtMobility::QMessageAccountId >::checkType(other))
                    cpp_other_auto_ptr = std::auto_ptr<QtMobility::QMessageAccountId >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QMessageAccountId_RichComparison_TypeError;

            break;
        case Py_LT:
            if (Shiboken::Converter<const QtMobility::QMessageAccountId & >::isConvertible(other)) {
                // operator<(const QtMobility::QMessageAccountId & other) const
                QtMobility::QMessageAccountId* cpp_other = Shiboken::Converter<QtMobility::QMessageAccountId* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageAccountId  >::toCpp(other) : (cpp_self < (*cpp_other));
            } else if (Shiboken::Converter<QtMobility::QMessageAccountId >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QtMobility::QMessageAccountId > cpp_other_auto_ptr;
                QtMobility::QMessageAccountId* cpp_other = Shiboken::Converter<QtMobility::QMessageAccountId* >::toCpp(other);
                if (!Shiboken::Converter<QtMobility::QMessageAccountId >::checkType(other))
                    cpp_other_auto_ptr = std::auto_ptr<QtMobility::QMessageAccountId >(cpp_other);
                result = (cpp_self < (*cpp_other));
            } else goto SbkQtMobility_QMessageAccountId_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QMessageAccountId & >::isConvertible(other)) {
                // operator==(const QtMobility::QMessageAccountId & other) const
                QtMobility::QMessageAccountId* cpp_other = Shiboken::Converter<QtMobility::QMessageAccountId* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QMessageAccountId  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QtMobility::QMessageAccountId >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QtMobility::QMessageAccountId > cpp_other_auto_ptr;
                QtMobility::QMessageAccountId* cpp_other = Shiboken::Converter<QtMobility::QMessageAccountId* >::toCpp(other);
                if (!Shiboken::Converter<QtMobility::QMessageAccountId >::checkType(other))
                    cpp_other_auto_ptr = std::auto_ptr<QtMobility::QMessageAccountId >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QMessageAccountId_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QMessageAccountId_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

static long SbkQtMobility_QMessageAccountId_HashFunc(PyObject* obj){
    return qHash(Shiboken::Converter<QtMobility::QMessageAccountId >::toCpp(obj));
}

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QMessageAccountId_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Messaging.QMessageAccountId",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             &SbkQtMobility_QMessageAccountId_HashFunc,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QMessageAccountId_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QMessageAccountId_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QMessageAccountId_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QMessageAccountId >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QMessageAccountId",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QMessageAccountId(PyObject* module)
{
    SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEACCOUNTID_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QMessageAccountId_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QMessageAccountId_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QMessageAccountId_Type));
    PyModule_AddObject(module, "QMessageAccountId",
        ((PyObject*)&SbkQtMobility_QMessageAccountId_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageAccountId >("QtMobility::QMessageAccountId");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QMessageAccountId >("QtMobility::QMessageAccountId*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageAccountId >(typeid(QtMobility::QMessageAccountId).name());
    PySide::initQtMetaType<QtMobility::QMessageAccountId >();
}

