/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_MESSAGING_PYTHON_H
#define SBK_MESSAGING_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#include <qsignal.h>
// Module Includes
#include <pyside_qtcore_python.h>

// Binded library includes
#include <qmessagemanager.h>
#include <qmessagefolderfilter.h>
#include <qmessagecontentcontainerid.h>
#include <qmessagedatacomparator.h>
#include <qmessagefilter.h>
#include <qmessageaccount.h>
#include <qmessageid.h>
#include <qmessageaccountfilter.h>
#include <qmessageaddress.h>
#include <qmessagefolder.h>
#include <qmessagefolderid.h>
#include <qmessagesortorder.h>
#include <qmessagefoldersortorder.h>
#include <qmessageservice.h>
#include <qmessageaccountid.h>
#include <qmessageaccountsortorder.h>
#include <qmessagecontentcontainer.h>
#include <qmessage.h>
// Conversion Includes - Primitive Types
#include <QString>
#include <signalmanager.h>
#include <typeresolver.h>
#include <QtConcurrentFilter>
#include <QTextDocument>

// Conversion Includes - Container Types
#include <QList>
#include <QMap>
#include <QStack>
#include <QMultiMap>
#include <QVector>
#include <QPair>
#include <pysideconversions.h>
#include <QSet>
#include <qqueue.h>
#include <QStringList>
#include <qlinkedlist.h>

// Type indices
#define SBK_QTMOBILITY_QMESSAGEDATACOMPARATOR_IDX                    0
#define SBK_QTMOBILITY_QMESSAGEDATACOMPARATOR_INCLUSIONCOMPARATOR_IDX 1
#define SBK_QTMOBILITY_QMESSAGEDATACOMPARATOR_EQUALITYCOMPARATOR_IDX 2
#define SBK_QTMOBILITY_QMESSAGEDATACOMPARATOR_RELATIONCOMPARATOR_IDX 3
#define SBK_QTMOBILITY_QMESSAGEDATACOMPARATOR_MATCHFLAG_IDX          4
#define SBK_QFLAGS_QTMOBILITY_QMESSAGEDATACOMPARATOR_MATCHFLAG__IDX  5
#define SBK_QTMOBILITY_QMESSAGEFILTER_IDX                            6
#define SBK_QTMOBILITY_QMESSAGEFOLDER_IDX                            7
#define SBK_QTMOBILITY_QMESSAGEFOLDERFILTER_IDX                      8
#define SBK_QTMOBILITY_QMESSAGEACCOUNTFILTER_IDX                     9
#define SBK_QTMOBILITY_QMESSAGEACCOUNT_IDX                           10
#define SBK_QTMOBILITY_QMESSAGEADDRESS_IDX                           11
#define SBK_QTMOBILITY_QMESSAGEADDRESS_TYPE_IDX                      12
#define SBK_QTMOBILITY_QMESSAGECONTENTCONTAINER_IDX                  13
#define SBK_QTMOBILITY_QMESSAGEACCOUNTID_IDX                         14
#define SBK_QTMOBILITY_QMESSAGECONTENTCONTAINERID_IDX                15
#define SBK_QTMOBILITY_QMESSAGEFOLDERID_IDX                          16
#define SBK_QTMOBILITY_QMESSAGEID_IDX                                17
#define SBK_QTMOBILITY_QMESSAGESORTORDER_IDX                         18
#define SBK_QTMOBILITY_QMESSAGEFOLDERSORTORDER_IDX                   19
#define SBK_QTMOBILITY_QMESSAGEACCOUNTSORTORDER_IDX                  20
#define SBK_QTMOBILITY_QMESSAGESERVICE_IDX                           21
#define SBK_QTMOBILITY_QMESSAGESERVICE_STATE_IDX                     22
#define SBK_QTMOBILITY_QMESSAGEMANAGER_IDX                           23
#define SBK_QTMOBILITY_QMESSAGEMANAGER_ERROR_IDX                     24
#define SBK_QTMOBILITY_QMESSAGEMANAGER_REMOVALOPTION_IDX             25
#define SBK_QTMOBILITY_QMESSAGE_IDX                                  26
#define SBK_QTMOBILITY_QMESSAGE_STANDARDFOLDER_IDX                   27
#define SBK_QTMOBILITY_QMESSAGE_RESPONSETYPE_IDX                     28
#define SBK_QTMOBILITY_QMESSAGE_PRIORITY_IDX                         29
#define SBK_QTMOBILITY_QMESSAGE_TYPE_IDX                             30
#define SBK_QFLAGS_QTMOBILITY_QMESSAGE_TYPE__IDX                     31
#define SBK_QTMOBILITY_QMESSAGE_STATUS_IDX                           32
#define SBK_QFLAGS_QTMOBILITY_QMESSAGE_STATUS__IDX                   33
#define SBK_Messaging_IDX_COUNT                                      34

// This variable stores all python types exported by this module
extern PyTypeObject** SbkQtMobility_MessagingTypes;

// Macros for type check

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<QtMobility::QMessageDataComparator::InclusionComparator >() { return SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEDATACOMPARATOR_INCLUSIONCOMPARATOR_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageDataComparator::EqualityComparator >() { return SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEDATACOMPARATOR_EQUALITYCOMPARATOR_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageDataComparator::RelationComparator >() { return SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEDATACOMPARATOR_RELATIONCOMPARATOR_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageDataComparator::MatchFlag >() { return SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEDATACOMPARATOR_MATCHFLAG_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QtMobility::QMessageDataComparator::MatchFlag> >() { return SbkQtMobility_MessagingTypes[SBK_QFLAGS_QTMOBILITY_QMESSAGEDATACOMPARATOR_MATCHFLAG__IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageFolder >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEFOLDER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageFolderFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEFOLDERFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageAccountFilter >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEACCOUNTFILTER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageAccount >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEACCOUNT_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageAddress::Type >() { return SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEADDRESS_TYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageAddress >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEADDRESS_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageContentContainer >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGECONTENTCONTAINER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageAccountId >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEACCOUNTID_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageContentContainerId >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGECONTENTCONTAINERID_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageFolderId >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEFOLDERID_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageId >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEID_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageSortOrder >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGESORTORDER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageFolderSortOrder >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEFOLDERSORTORDER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageAccountSortOrder >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEACCOUNTSORTORDER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageService::State >() { return SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGESERVICE_STATE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageService >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGESERVICE_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageManager::Error >() { return SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEMANAGER_ERROR_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageManager::RemovalOption >() { return SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEMANAGER_REMOVALOPTION_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QMessageManager >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGEMANAGER_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QMessage::StandardFolder >() { return SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGE_STANDARDFOLDER_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QMessage::ResponseType >() { return SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGE_RESPONSETYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QMessage::Priority >() { return SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGE_PRIORITY_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QMessage::Type >() { return SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGE_TYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QtMobility::QMessage::Type> >() { return SbkQtMobility_MessagingTypes[SBK_QFLAGS_QTMOBILITY_QMESSAGE_TYPE__IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QMessage::Status >() { return SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGE_STATUS_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QtMobility::QMessage::Status> >() { return SbkQtMobility_MessagingTypes[SBK_QFLAGS_QTMOBILITY_QMESSAGE_STATUS__IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QMessage >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_MessagingTypes[SBK_QTMOBILITY_QMESSAGE_IDX]); }

template<>
inline PyObject* createWrapper<QtMobility::QMessageService >(const QtMobility::QMessageService* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QMessageService >()),const_cast<QtMobility::QMessageService*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QMessageManager >(const QtMobility::QMessageManager* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QMessageManager >()),const_cast<QtMobility::QMessageManager*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
// Generated converters declarations ----------------------------------

template<>
struct Converter<QtMobility::QMessageDataComparator::InclusionComparator > : EnumConverter<QtMobility::QMessageDataComparator::InclusionComparator >
{
};

template<>
struct Converter<QtMobility::QMessageDataComparator::EqualityComparator > : EnumConverter<QtMobility::QMessageDataComparator::EqualityComparator >
{
};

template<>
struct Converter<QtMobility::QMessageDataComparator::RelationComparator > : EnumConverter<QtMobility::QMessageDataComparator::RelationComparator >
{
};

template<>
struct Converter<QtMobility::QMessageDataComparator::MatchFlag > : EnumConverter<QtMobility::QMessageDataComparator::MatchFlag >
{
};
template<>
struct Converter<QFlags<QtMobility::QMessageDataComparator::MatchFlag> > : QFlagsConverter<QFlags<QtMobility::QMessageDataComparator::MatchFlag> >
{
};

template <>
struct SbkTypeInfo<QtMobility::QMessageFilter >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QtMobility::QMessageFilter > : ValueTypeConverter<QtMobility::QMessageFilter >
{
};

template <>
struct SbkTypeInfo<QtMobility::QMessageFolder >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QtMobility::QMessageFolder > : ValueTypeConverter<QtMobility::QMessageFolder >
{
    static QtMobility::QMessageFolder toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template <>
struct SbkTypeInfo<QtMobility::QMessageFolderFilter >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QtMobility::QMessageFolderFilter > : ValueTypeConverter<QtMobility::QMessageFolderFilter >
{
};

template <>
struct SbkTypeInfo<QtMobility::QMessageAccountFilter >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QtMobility::QMessageAccountFilter > : ValueTypeConverter<QtMobility::QMessageAccountFilter >
{
};

template <>
struct SbkTypeInfo<QtMobility::QMessageAccount >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QtMobility::QMessageAccount > : ValueTypeConverter<QtMobility::QMessageAccount >
{
    static QtMobility::QMessageAccount toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QMessageAddress::Type > : EnumConverter<QtMobility::QMessageAddress::Type >
{
};

template <>
struct SbkTypeInfo<QtMobility::QMessageAddress >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QtMobility::QMessageAddress > : ValueTypeConverter<QtMobility::QMessageAddress >
{
};

template <>
struct SbkTypeInfo<QtMobility::QMessageContentContainer >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QtMobility::QMessageContentContainer > : ValueTypeConverter<QtMobility::QMessageContentContainer >
{
};

template<>
struct Converter<QtMobility::QMessageAccountId > : ValueTypeConverter<QtMobility::QMessageAccountId >
{
    static QtMobility::QMessageAccountId toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QMessageContentContainerId > : ValueTypeConverter<QtMobility::QMessageContentContainerId >
{
    static QtMobility::QMessageContentContainerId toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QMessageFolderId > : ValueTypeConverter<QtMobility::QMessageFolderId >
{
    static QtMobility::QMessageFolderId toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QtMobility::QMessageId > : ValueTypeConverter<QtMobility::QMessageId >
{
    static QtMobility::QMessageId toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template <>
struct SbkTypeInfo<QtMobility::QMessageSortOrder >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QtMobility::QMessageSortOrder > : ValueTypeConverter<QtMobility::QMessageSortOrder >
{
};

template <>
struct SbkTypeInfo<QtMobility::QMessageFolderSortOrder >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QtMobility::QMessageFolderSortOrder > : ValueTypeConverter<QtMobility::QMessageFolderSortOrder >
{
};

template <>
struct SbkTypeInfo<QtMobility::QMessageAccountSortOrder >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QtMobility::QMessageAccountSortOrder > : ValueTypeConverter<QtMobility::QMessageAccountSortOrder >
{
};

template<>
struct Converter<QtMobility::QMessageService::State > : EnumConverter<QtMobility::QMessageService::State >
{
};

template<>
struct Converter<QtMobility::QMessageService* > : ObjectTypeConverter<QtMobility::QMessageService >
{
};

template<>
struct Converter<QtMobility::QMessageService& > : ObjectTypeReferenceConverter<QtMobility::QMessageService >
{
};

template<>
struct Converter<QtMobility::QMessageManager::Error > : EnumConverter<QtMobility::QMessageManager::Error >
{
};

template<>
struct Converter<QtMobility::QMessageManager::RemovalOption > : EnumConverter<QtMobility::QMessageManager::RemovalOption >
{
};

template<>
struct Converter<QtMobility::QMessageManager* > : ObjectTypeConverter<QtMobility::QMessageManager >
{
};

template<>
struct Converter<QtMobility::QMessageManager& > : ObjectTypeReferenceConverter<QtMobility::QMessageManager >
{
};

template<>
struct Converter<QtMobility::QMessage::StandardFolder > : EnumConverter<QtMobility::QMessage::StandardFolder >
{
};

template<>
struct Converter<QtMobility::QMessage::ResponseType > : EnumConverter<QtMobility::QMessage::ResponseType >
{
};

template<>
struct Converter<QtMobility::QMessage::Priority > : EnumConverter<QtMobility::QMessage::Priority >
{
};

template<>
struct Converter<QtMobility::QMessage::Type > : EnumConverter<QtMobility::QMessage::Type >
{
};
template<>
struct Converter<QFlags<QtMobility::QMessage::Type> > : QFlagsConverter<QFlags<QtMobility::QMessage::Type> >
{
};

template<>
struct Converter<QtMobility::QMessage::Status > : EnumConverter<QtMobility::QMessage::Status >
{
};
template<>
struct Converter<QFlags<QtMobility::QMessage::Status> > : QFlagsConverter<QFlags<QtMobility::QMessage::Status> >
{
};

template <>
struct SbkTypeInfo<QtMobility::QMessage >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QtMobility::QMessage > : ValueTypeConverter<QtMobility::QMessage >
{
    static QtMobility::QMessage toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------

inline bool Shiboken::Converter<QtMobility::QMessageFolder >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QMessageFolder >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QMessageFolder >());
    return Shiboken::Converter<const QtMobility::QMessageFolderId & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QMessageFolder Shiboken::Converter<QtMobility::QMessageFolder >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QMessageFolder)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QMessageFolder >());
        if (Shiboken::Converter<const QtMobility::QMessageFolderId & >::checkType(pyobj))
            return QtMobility::QMessageFolder(Shiboken::Converter<const QtMobility::QMessageFolderId & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QMessageFolder* cptr = reinterpret_cast<QtMobility::QMessageFolder*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QMessageFolder > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QMessageFolder* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QMessageAccount >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QMessageAccount >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QMessageAccount >());
    return Shiboken::Converter<const QtMobility::QMessageAccountId & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QMessageAccount Shiboken::Converter<QtMobility::QMessageAccount >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QMessageAccount)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QMessageAccount >());
        if (Shiboken::Converter<const QtMobility::QMessageAccountId & >::checkType(pyobj))
            return QtMobility::QMessageAccount(Shiboken::Converter<const QtMobility::QMessageAccountId & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QMessageAccount* cptr = reinterpret_cast<QtMobility::QMessageAccount*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QMessageAccount > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QMessageAccount* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QMessageAccountId >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QMessageAccountId >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QMessageAccountId >());
    return Shiboken::Converter<QString >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QMessageAccountId Shiboken::Converter<QtMobility::QMessageAccountId >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QMessageAccountId)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QMessageAccountId >());
        if (Shiboken::Converter<QString >::checkType(pyobj))
            return QtMobility::QMessageAccountId(Shiboken::Converter<QString >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QMessageAccountId* cptr = reinterpret_cast<QtMobility::QMessageAccountId*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QMessageAccountId > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QMessageAccountId* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QMessageContentContainerId >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QMessageContentContainerId >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QMessageContentContainerId >());
    return Shiboken::Converter<QString >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QMessageContentContainerId Shiboken::Converter<QtMobility::QMessageContentContainerId >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QMessageContentContainerId)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QMessageContentContainerId >());
        if (Shiboken::Converter<QString >::checkType(pyobj))
            return QtMobility::QMessageContentContainerId(Shiboken::Converter<QString >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QMessageContentContainerId* cptr = reinterpret_cast<QtMobility::QMessageContentContainerId*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QMessageContentContainerId > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QMessageContentContainerId* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QMessageFolderId >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QMessageFolderId >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QMessageFolderId >());
    return Shiboken::Converter<QString >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QMessageFolderId Shiboken::Converter<QtMobility::QMessageFolderId >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QMessageFolderId)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QMessageFolderId >());
        if (Shiboken::Converter<QString >::checkType(pyobj))
            return QtMobility::QMessageFolderId(Shiboken::Converter<QString >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QMessageFolderId* cptr = reinterpret_cast<QtMobility::QMessageFolderId*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QMessageFolderId > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QMessageFolderId* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QMessageId >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QMessageId >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QMessageId >());
    return Shiboken::Converter<QString >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QMessageId Shiboken::Converter<QtMobility::QMessageId >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QMessageId)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QMessageId >());
        if (Shiboken::Converter<QString >::checkType(pyobj))
            return QtMobility::QMessageId(Shiboken::Converter<QString >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QMessageId* cptr = reinterpret_cast<QtMobility::QMessageId*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QMessageId > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QMessageId* >::toCpp(pyobj);
}

inline bool Shiboken::Converter<QtMobility::QMessage >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QtMobility::QMessage >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QMessage >());
    return Shiboken::Converter<const QtMobility::QMessageId & >::checkType(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QtMobility::QMessage Shiboken::Converter<QtMobility::QMessage >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QtMobility::QMessage)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QMessage >());
        if (Shiboken::Converter<const QtMobility::QMessageId & >::checkType(pyobj))
            return QtMobility::QMessage(Shiboken::Converter<const QtMobility::QMessageId & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QtMobility::QMessage* cptr = reinterpret_cast<QtMobility::QMessage*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QtMobility::QMessage > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QtMobility::QMessage* >::toCpp(pyobj);
}


#endif // SBK_MESSAGING_PYTHON_H

