/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#include <Python.h>
#include <shiboken.h>
#include <algorithm>
#include "qtmobility_messaging_python.h"


// Global functions ------------------------------------------------------------

static PyMethodDef Messaging_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_QtMobility_QMessageDataComparator(PyObject* module);
void init_QtMobility_QMessageFilter(PyObject* module);
void init_QtMobility_QMessageFolder(PyObject* module);
void init_QtMobility_QMessageFolderFilter(PyObject* module);
void init_QtMobility_QMessageAccountFilter(PyObject* module);
void init_QtMobility_QMessageAccount(PyObject* module);
void init_QtMobility_QMessageAddress(PyObject* module);
void init_QtMobility_QMessageContentContainer(PyObject* module);
void init_QtMobility_QMessageAccountId(PyObject* module);
void init_QtMobility_QMessageContentContainerId(PyObject* module);
void init_QtMobility_QMessageFolderId(PyObject* module);
void init_QtMobility_QMessageId(PyObject* module);
void init_QtMobility_QMessageSortOrder(PyObject* module);
void init_QtMobility_QMessageFolderSortOrder(PyObject* module);
void init_QtMobility_QMessageAccountSortOrder(PyObject* module);
void init_QtMobility_QMessageService(PyObject* module);
void init_QtMobility_QMessageManager(PyObject* module);
void init_QtMobility_QMessage(PyObject* module);

PyTypeObject** SbkQtMobility_MessagingTypes;

PyTypeObject** SbkPySide_QtCoreTypes;

// Module initialization ------------------------------------------------------------

#if defined _WIN32 || defined __CYGWIN__
    #define SBK_EXPORT_MODULE __declspec(dllexport)
#elif __GNUC__ >= 4
    #define SBK_EXPORT_MODULE __attribute__ ((visibility("default")))
#else
    #define SBK_EXPORT_MODULE
#endif

extern "C" SBK_EXPORT_MODULE void initMessaging()
{
    if (!Shiboken::importModule("PySide.QtCore", &SbkPySide_QtCoreTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtCore");
        return;
    }

    Shiboken::initShiboken();
    PyObject* module = Py_InitModule("Messaging", Messaging_methods);

    // Create a CObject containing the API pointer array's address
    static PyTypeObject* cppApi[SBK_Messaging_IDX_COUNT];
    SbkQtMobility_MessagingTypes = cppApi;
    PyObject* cppApiObject = PyCObject_FromVoidPtr(reinterpret_cast<void*>(cppApi), 0);
    PyModule_AddObject(module, "_Cpp_Api", cppApiObject);

    // Initialize classes in the type system
    init_QtMobility_QMessageDataComparator(module);
    init_QtMobility_QMessageFilter(module);
    init_QtMobility_QMessageFolder(module);
    init_QtMobility_QMessageFolderFilter(module);
    init_QtMobility_QMessageAccountFilter(module);
    init_QtMobility_QMessageAccount(module);
    init_QtMobility_QMessageAddress(module);
    init_QtMobility_QMessageContentContainer(module);
    init_QtMobility_QMessageAccountId(module);
    init_QtMobility_QMessageContentContainerId(module);
    init_QtMobility_QMessageFolderId(module);
    init_QtMobility_QMessageId(module);
    init_QtMobility_QMessageSortOrder(module);
    init_QtMobility_QMessageFolderSortOrder(module);
    init_QtMobility_QMessageAccountSortOrder(module);
    init_QtMobility_QMessageService(module);
    init_QtMobility_QMessageManager(module);
    init_QtMobility_QMessage(module);

    // Register primitive types on TypeResolver
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QMessageManager::NotificationFilterId >("QtMobility::QMessageManager::NotificationFilterId");
    Shiboken::TypeResolver::createValueTypeResolver<QSet<QtMobility::QMessageManager::NotificationFilterId> >("QSet<QtMobility::QMessageManager::NotificationFilterId>");
    Shiboken::TypeResolver::createValueTypeResolver<QList<QtMobility::QMessageId> >("QList<QtMobility::QMessageId>");

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module Messaging");
    }
}

