/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_location_python.h"

#include "qtmobility_qnmeapositioninfosource_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qgeopositioninfo.h>
#include <qgeopositioninfosource.h>
#include <qiodevice.h>
#include <qnmeapositioninfosource.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qthread.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QNmeaPositionInfoSourceWrapper::QNmeaPositionInfoSourceWrapper(QtMobility::QNmeaPositionInfoSource::UpdateMode updateMode, QObject * parent) : QtMobility::QNmeaPositionInfoSource(updateMode, parent), m_metaObject(0) {
    // ... middle
}

void QNmeaPositionInfoSourceWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QNmeaPositionInfoSourceWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QNmeaPositionInfoSourceWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QNmeaPositionInfoSourceWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QNmeaPositionInfoSourceWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QNmeaPositionInfoSource.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QNmeaPositionInfoSourceWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QNmeaPositionInfoSource.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

QtMobility::QGeoPositionInfo QNmeaPositionInfoSourceWrapper::lastKnownPosition(bool fromSatellitePositioningMethodsOnly) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "lastKnownPosition"));
    if (py_override.isNull()) {
        return this->QtMobility::QNmeaPositionInfoSource::lastKnownPosition(fromSatellitePositioningMethodsOnly);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<bool >::toPython(fromSatellitePositioningMethodsOnly)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QtMobility::QGeoPositionInfo();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QtMobility::QGeoPositionInfo >::isConvertible(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QNmeaPositionInfoSource.lastKnownPosition", SbkType<QtMobility::QGeoPositionInfo >()->tp_name, pyResult->ob_type->tp_name);
        return QtMobility::QGeoPositionInfo();
    }
    QtMobility::QGeoPositionInfo cppResult(Shiboken::Converter<QtMobility::QGeoPositionInfo >::toCpp(pyResult));
    return cppResult;
}

int QNmeaPositionInfoSourceWrapper::minimumUpdateInterval() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumUpdateInterval"));
    if (py_override.isNull()) {
        return this->QtMobility::QNmeaPositionInfoSource::minimumUpdateInterval();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QNmeaPositionInfoSource.minimumUpdateInterval", "int", pyResult->ob_type->tp_name);
        return int(0);
    }
    int cppResult(Shiboken::Converter<int >::toCpp(pyResult));
    return cppResult;
}

bool QNmeaPositionInfoSourceWrapper::parsePosInfoFromNmeaData(const char * data, int size, QtMobility::QGeoPositionInfo * posInfo, bool * hasFix)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "parsePosInfoFromNmeaData"));
    if (py_override.isNull()) {
        return this->QtMobility::QNmeaPositionInfoSource::parsePosInfoFromNmeaData(data, size, posInfo, hasFix);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NiNN)",
        Shiboken::Converter<const char * >::toPython(data),
        size,
        Shiboken::Converter<QtMobility::QGeoPositionInfo * >::toPython(posInfo),
        Shiboken::Converter<bool * >::toPython(hasFix)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QNmeaPositionInfoSource.parsePosInfoFromNmeaData", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

void QNmeaPositionInfoSourceWrapper::requestUpdate(int timeout)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "requestUpdate"));
    if (py_override.isNull()) {
        return this->QtMobility::QNmeaPositionInfoSource::requestUpdate(timeout);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        timeout
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QNmeaPositionInfoSourceWrapper::setPreferredPositioningMethods(QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> methods)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setPreferredPositioningMethods"));
    if (py_override.isNull()) {
        return this->QtMobility::QGeoPositionInfoSource::setPreferredPositioningMethods(methods);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> >::toPython(methods)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QNmeaPositionInfoSourceWrapper::setUpdateInterval(int msec)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setUpdateInterval"));
    if (py_override.isNull()) {
        return this->QtMobility::QNmeaPositionInfoSource::setUpdateInterval(msec);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        msec
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QNmeaPositionInfoSourceWrapper::startUpdates()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startUpdates"));
    if (py_override.isNull()) {
        return this->QtMobility::QNmeaPositionInfoSource::startUpdates();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QNmeaPositionInfoSourceWrapper::stopUpdates()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "stopUpdates"));
    if (py_override.isNull()) {
        return this->QtMobility::QNmeaPositionInfoSource::stopUpdates();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> QNmeaPositionInfoSourceWrapper::supportedPositioningMethods() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "supportedPositioningMethods"));
    if (py_override.isNull()) {
        return this->QtMobility::QNmeaPositionInfoSource::supportedPositioningMethods();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> >::isConvertible(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QNmeaPositionInfoSource.supportedPositioningMethods", SbkType<QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> >()->tp_name, pyResult->ob_type->tp_name);
        return QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod>();
    }
    QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> cppResult(Shiboken::Converter<QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> >::toCpp(pyResult));
    return cppResult;
}

void QNmeaPositionInfoSourceWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QNmeaPositionInfoSourceWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QNmeaPositionInfoSource::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QNmeaPositionInfoSourceWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QNmeaPositionInfoSource::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QNmeaPositionInfoSourceWrapper::~QNmeaPositionInfoSourceWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QNmeaPositionInfoSource_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QNmeaPositionInfoSource >()))
        return -1;

    QNmeaPositionInfoSourceWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "parent" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                propertyKeys.push_back(argName);
            }
        }
    }

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Location.QNmeaPositionInfoSource(): not enough arguments");
        return -1;
    }

    if (!PyArg_ParseTuple(args, "|OO:QNmeaPositionInfoSource", &(pyargs[0]), &(pyargs[1])))
        return -1;

    // Overloaded function decisor
    // 0: QNmeaPositionInfoSource(QtMobility::QNmeaPositionInfoSource::UpdateMode,QObject*)
    if (Shiboken::Converter<QtMobility::QNmeaPositionInfoSource::UpdateMode >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 0; // QNmeaPositionInfoSource(QtMobility::QNmeaPositionInfoSource::UpdateMode,QObject*)
        } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
            overloadId = 0; // QNmeaPositionInfoSource(QtMobility::QNmeaPositionInfoSource::UpdateMode,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QNmeaPositionInfoSource_Init_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "parent");
                if (value) {
                    if (pyargs[1])
                        errorArgName = "parent";
                    else
                        pyargs[1] = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Location.QNmeaPositionInfoSource(): got multiple values for keyword argument '%s'", errorArgName);
                    return -1;
                }
            }
            QtMobility::QNmeaPositionInfoSource::UpdateMode cpp_arg0 = Shiboken::Converter<QtMobility::QNmeaPositionInfoSource::UpdateMode >::toCpp(pyargs[0]);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = pyargs[1] ? Shiboken::Converter<QObject* >::toCpp(pyargs[1]) : 0;

            if(!PyErr_Occurred()) {
            // QNmeaPositionInfoSource(QtMobility::QNmeaPositionInfoSource::UpdateMode,QObject*)
            cptr = new QNmeaPositionInfoSourceWrapper(cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[1], self);
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QNmeaPositionInfoSource >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QNmeaPositionInfoSource_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    PySide::signalUpdateSource(self);
    cptr->metaObject();
    for (std::vector<PyObject*>::size_type i = 0; i < propertyKeys.size(); i++) {
        const char* propName = PyString_AS_STRING(propertyKeys[i]);
        const QMetaObject* mo = cptr->metaObject();
        if (mo->indexOfProperty(propName) != -1) {
            cptr->setProperty(propName, Shiboken::Converter<QVariant>::toCpp(PyDict_GetItem(kwds, propertyKeys[i])));
        } else {
            QString signalSignature = QString("%1()").arg(propName);
            if (mo->indexOfSignal(qPrintable(signalSignature)) != -1) {
                signalSignature = '2' + signalSignature;
                PySide::signal_connect(self, qPrintable(signalSignature), PyDict_GetItem(kwds, propertyKeys[i]));
            } else {
                delete cptr;
                PyErr_Format(PyExc_AttributeError, "'%s' is not a Qt property or a signal", propName);
                return -1;
            };
        }
    }


    return 1;

    SbkQtMobility_QNmeaPositionInfoSource_Init_TypeError:
        const char* overloads[] = {"QtMobility.Location.QNmeaPositionInfoSource.UpdateMode, PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Location.QNmeaPositionInfoSource", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QNmeaPositionInfoSourceFunc_device(PyObject* self)
{
    QtMobility::QNmeaPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNmeaPositionInfoSource* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // device()const
            QIODevice * cppResult = cppSelf->QtMobility::QNmeaPositionInfoSource::device();
            pyResult = Shiboken::Converter<QIODevice * >::toPython(cppResult);
            Shiboken::setParent(self, pyResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNmeaPositionInfoSourceFunc_lastKnownPosition(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QNmeaPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNmeaPositionInfoSource* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "fromSatellitePositioningMethodsOnly" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Location.QNmeaPositionInfoSource.lastKnownPosition(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Location.QNmeaPositionInfoSource.lastKnownPosition(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:lastKnownPosition", &arg))
        return 0;


    // Overloaded function decisor
    // 0: lastKnownPosition(bool)const
    if (numArgs == 0) {
        overloadId = 0; // lastKnownPosition(bool)const
    } else if (SbkNumber_Check(arg)) {
        overloadId = 0; // lastKnownPosition(bool)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QNmeaPositionInfoSourceFunc_lastKnownPosition_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "fromSatellitePositioningMethodsOnly");
                if (value) {
                    if (arg)
                        errorArgName = "fromSatellitePositioningMethodsOnly";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Location.QNmeaPositionInfoSource.lastKnownPosition(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            bool cpp_arg0 = arg ? Shiboken::Converter<bool >::toCpp(arg) : false;

            if(!PyErr_Occurred()) {
            // lastKnownPosition(bool)const
            QtMobility::QGeoPositionInfo cppResult = cppSelf->QtMobility::QNmeaPositionInfoSource::lastKnownPosition(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QGeoPositionInfo >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QNmeaPositionInfoSourceFunc_lastKnownPosition_TypeError:
        const char* overloads[] = {"bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QNmeaPositionInfoSource.lastKnownPosition", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QNmeaPositionInfoSourceFunc_minimumUpdateInterval(PyObject* self)
{
    QtMobility::QNmeaPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNmeaPositionInfoSource* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // minimumUpdateInterval()const
            int cppResult = cppSelf->QtMobility::QNmeaPositionInfoSource::minimumUpdateInterval();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNmeaPositionInfoSourceFunc_parsePosInfoFromNmeaData(PyObject* self, PyObject* args)
{
    QtMobility::QNmeaPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNmeaPositionInfoSource* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "parsePosInfoFromNmeaData", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;


    // Overloaded function decisor
    // 0: parsePosInfoFromNmeaData(const char*,int,QtMobility::QGeoPositionInfo*,bool*)
    if (numArgs == 4 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && SbkNumber_Check(pyargs[1]) && Shiboken::Converter<QtMobility::QGeoPositionInfo * >::isConvertible(pyargs[2]) && PyBool_Check(pyargs[3])) {
        overloadId = 0; // parsePosInfoFromNmeaData(const char*,int,QtMobility::QGeoPositionInfo*,bool*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QNmeaPositionInfoSourceFunc_parsePosInfoFromNmeaData_TypeError;

    // Call function/method
    {
        {
            const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QtMobility::QGeoPositionInfo* cpp_arg2 = Shiboken::Converter<QtMobility::QGeoPositionInfo* >::toCpp(pyargs[2]);
            bool * cpp_arg3 = Shiboken::Converter<bool * >::toCpp(pyargs[3]);

            if(!PyErr_Occurred()) {
            // parsePosInfoFromNmeaData(const char*,int,QtMobility::QGeoPositionInfo*,bool*)
            bool cppResult = cppSelf->QtMobility::QNmeaPositionInfoSource::parsePosInfoFromNmeaData(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QNmeaPositionInfoSourceFunc_parsePosInfoFromNmeaData_TypeError:
        const char* overloads[] = {"str, int, QtMobility.Location.QGeoPositionInfo, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Location.QNmeaPositionInfoSource.parsePosInfoFromNmeaData", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QNmeaPositionInfoSourceFunc_requestUpdate(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QNmeaPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNmeaPositionInfoSource* >::toCpp(self);

    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "timeout" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Location.QNmeaPositionInfoSource.requestUpdate(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Location.QNmeaPositionInfoSource.requestUpdate(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:requestUpdate", &arg))
        return 0;


    // Overloaded function decisor
    // 0: requestUpdate(int)
    if (numArgs == 0) {
        overloadId = 0; // requestUpdate(int)
    } else if (SbkNumber_Check(arg)) {
        overloadId = 0; // requestUpdate(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QNmeaPositionInfoSourceFunc_requestUpdate_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "timeout");
                if (value) {
                    if (arg)
                        errorArgName = "timeout";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Location.QNmeaPositionInfoSource.requestUpdate(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            int cpp_arg0 = arg ? Shiboken::Converter<int >::toCpp(arg) : 0;

            if(!PyErr_Occurred()) {
            // requestUpdate(int)
            cppSelf->QtMobility::QNmeaPositionInfoSource::requestUpdate(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QNmeaPositionInfoSourceFunc_requestUpdate_TypeError:
        const char* overloads[] = {"int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QNmeaPositionInfoSource.requestUpdate", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QNmeaPositionInfoSourceFunc_setDevice(PyObject* self, PyObject* arg)
{
    QtMobility::QNmeaPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNmeaPositionInfoSource* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setDevice(QIODevice*)
    if (Shiboken::Converter<QIODevice * >::isConvertible(arg)) {
        overloadId = 0; // setDevice(QIODevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QNmeaPositionInfoSourceFunc_setDevice_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setDevice(QIODevice*)
            cppSelf->QtMobility::QNmeaPositionInfoSource::setDevice(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QNmeaPositionInfoSourceFunc_setDevice_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QNmeaPositionInfoSource.setDevice", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QNmeaPositionInfoSourceFunc_setUpdateInterval(PyObject* self, PyObject* arg)
{
    QtMobility::QNmeaPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNmeaPositionInfoSource* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setUpdateInterval(int)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setUpdateInterval(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QNmeaPositionInfoSourceFunc_setUpdateInterval_TypeError;

    // Call function/method
    {
        {
            int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setUpdateInterval(int)
            cppSelf->QtMobility::QNmeaPositionInfoSource::setUpdateInterval(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QNmeaPositionInfoSourceFunc_setUpdateInterval_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QNmeaPositionInfoSource.setUpdateInterval", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QNmeaPositionInfoSourceFunc_startUpdates(PyObject* self)
{
    QtMobility::QNmeaPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNmeaPositionInfoSource* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // startUpdates()
            cppSelf->QtMobility::QNmeaPositionInfoSource::startUpdates();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QNmeaPositionInfoSourceFunc_stopUpdates(PyObject* self)
{
    QtMobility::QNmeaPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNmeaPositionInfoSource* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // stopUpdates()
            cppSelf->QtMobility::QNmeaPositionInfoSource::stopUpdates();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QNmeaPositionInfoSourceFunc_supportedPositioningMethods(PyObject* self)
{
    QtMobility::QNmeaPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNmeaPositionInfoSource* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // supportedPositioningMethods()const
            QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> cppResult = cppSelf->QtMobility::QNmeaPositionInfoSource::supportedPositioningMethods();
            pyResult = Shiboken::Converter<QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNmeaPositionInfoSourceFunc_updateMode(PyObject* self)
{
    QtMobility::QNmeaPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNmeaPositionInfoSource* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // updateMode()const
            QtMobility::QNmeaPositionInfoSource::UpdateMode cppResult = cppSelf->QtMobility::QNmeaPositionInfoSource::updateMode();
            pyResult = Shiboken::Converter<QtMobility::QNmeaPositionInfoSource::UpdateMode >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QNmeaPositionInfoSource_methods[] = {
    {"device", (PyCFunction)SbkQtMobility_QNmeaPositionInfoSourceFunc_device, METH_NOARGS},
    {"lastKnownPosition", (PyCFunction)SbkQtMobility_QNmeaPositionInfoSourceFunc_lastKnownPosition, METH_VARARGS|METH_KEYWORDS},
    {"minimumUpdateInterval", (PyCFunction)SbkQtMobility_QNmeaPositionInfoSourceFunc_minimumUpdateInterval, METH_NOARGS},
    {"parsePosInfoFromNmeaData", (PyCFunction)SbkQtMobility_QNmeaPositionInfoSourceFunc_parsePosInfoFromNmeaData, METH_VARARGS},
    {"requestUpdate", (PyCFunction)SbkQtMobility_QNmeaPositionInfoSourceFunc_requestUpdate, METH_VARARGS|METH_KEYWORDS},
    {"setDevice", (PyCFunction)SbkQtMobility_QNmeaPositionInfoSourceFunc_setDevice, METH_O},
    {"setUpdateInterval", (PyCFunction)SbkQtMobility_QNmeaPositionInfoSourceFunc_setUpdateInterval, METH_O},
    {"startUpdates", (PyCFunction)SbkQtMobility_QNmeaPositionInfoSourceFunc_startUpdates, METH_NOARGS},
    {"stopUpdates", (PyCFunction)SbkQtMobility_QNmeaPositionInfoSourceFunc_stopUpdates, METH_NOARGS},
    {"supportedPositioningMethods", (PyCFunction)SbkQtMobility_QNmeaPositionInfoSourceFunc_supportedPositioningMethods, METH_NOARGS},
    {"updateMode", (PyCFunction)SbkQtMobility_QNmeaPositionInfoSourceFunc_updateMode, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QNmeaPositionInfoSource_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Location.QNmeaPositionInfoSource",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QNmeaPositionInfoSource_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QNmeaPositionInfoSource_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QNmeaPositionInfoSource >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QNmeaPositionInfoSource*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QNmeaPositionInfoSource_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QNmeaPositionInfoSource*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QNmeaPositionInfoSource_Type;
    return 0;
}

static PyGetSetDef SbkQtMobility_Location_QtMobility_QNmeaPositionInfoSource_UpdateMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Location_QtMobility_QNmeaPositionInfoSource_UpdateMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Location_QtMobility_QNmeaPositionInfoSource_UpdateMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "UpdateMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Location_QtMobility_QNmeaPositionInfoSource_UpdateMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Location_QtMobility_QNmeaPositionInfoSource_UpdateMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Location_QtMobility_QNmeaPositionInfoSource_UpdateMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QNmeaPositionInfoSource(PyObject* module)
{
    SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QNMEAPOSITIONINFOSOURCE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QNmeaPositionInfoSource_Type);

    SbkQtMobility_QNmeaPositionInfoSource_Type.super.ht_type.tp_base = SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOPOSITIONINFOSOURCE_IDX];
    // Fill type discovery information
    SbkQtMobility_QNmeaPositionInfoSource_Type.type_discovery = &SbkQtMobility_QNmeaPositionInfoSource_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOPOSITIONINFOSOURCE_IDX]), &SbkQtMobility_QNmeaPositionInfoSource_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QNmeaPositionInfoSource_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QNmeaPositionInfoSource_Type));
    PyModule_AddObject(module, "QNmeaPositionInfoSource",
        ((PyObject*)&SbkQtMobility_QNmeaPositionInfoSource_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: UpdateMode
    SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QNMEAPOSITIONINFOSOURCE_UPDATEMODE_IDX] = &SbkQtMobility_Location_QtMobility_QNmeaPositionInfoSource_UpdateMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Location_QtMobility_QNmeaPositionInfoSource_UpdateMode_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Location_QtMobility_QNmeaPositionInfoSource_UpdateMode_Type);
    PyDict_SetItemString(SbkQtMobility_QNmeaPositionInfoSource_Type.super.ht_type.tp_dict,
            "UpdateMode",((PyObject*)&SbkQtMobility_Location_QtMobility_QNmeaPositionInfoSource_UpdateMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QNmeaPositionInfoSource_UpdateMode_Type,
        (long) QtMobility::QNmeaPositionInfoSource::RealTimeMode, "RealTimeMode");
    PyDict_SetItemString(SbkQtMobility_QNmeaPositionInfoSource_Type.super.ht_type.tp_dict,
        "RealTimeMode", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QNmeaPositionInfoSource_UpdateMode_Type.tp_dict,
        "RealTimeMode", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QNmeaPositionInfoSource_UpdateMode_Type,
        (long) QtMobility::QNmeaPositionInfoSource::SimulationMode, "SimulationMode");
    PyDict_SetItemString(SbkQtMobility_QNmeaPositionInfoSource_Type.super.ht_type.tp_dict,
        "SimulationMode", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QNmeaPositionInfoSource_UpdateMode_Type.tp_dict,
        "SimulationMode", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QNmeaPositionInfoSource::UpdateMode");


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QNmeaPositionInfoSource >("QtMobility::QNmeaPositionInfoSource*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QNmeaPositionInfoSource >(typeid(QtMobility::QNmeaPositionInfoSource).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QNmeaPositionInfoSource >(typeid(QNmeaPositionInfoSourceWrapper).name());
    PySide::initQtMetaType<QtMobility::QNmeaPositionInfoSource* >();
}

