/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_location_python.h"

#include "qtmobility_qgeosatelliteinfosource_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qgeosatelliteinfo.h>
#include <qgeosatelliteinfosource.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qthread.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QGeoSatelliteInfoSourceWrapper::QGeoSatelliteInfoSourceWrapper(QObject * parent) : QtMobility::QGeoSatelliteInfoSource(parent), m_metaObject(0) {
    // ... middle
}

void QGeoSatelliteInfoSourceWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGeoSatelliteInfoSourceWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QGeoSatelliteInfoSourceWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGeoSatelliteInfoSourceWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QGeoSatelliteInfoSourceWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGeoSatelliteInfoSource.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QGeoSatelliteInfoSourceWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGeoSatelliteInfoSource.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

void QGeoSatelliteInfoSourceWrapper::requestUpdate(int timeout)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "requestUpdate"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.requestUpdate()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        timeout
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QGeoSatelliteInfoSourceWrapper::startUpdates()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startUpdates"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.startUpdates()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QGeoSatelliteInfoSourceWrapper::stopUpdates()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "stopUpdates"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.stopUpdates()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QGeoSatelliteInfoSourceWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QGeoSatelliteInfoSourceWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QGeoSatelliteInfoSource::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QGeoSatelliteInfoSourceWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QGeoSatelliteInfoSource::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QGeoSatelliteInfoSourceWrapper::~QGeoSatelliteInfoSourceWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QGeoSatelliteInfoSource_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QGeoSatelliteInfoSource >()))
        return -1;

    QGeoSatelliteInfoSourceWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOSATELLITEINFOSOURCE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QtMobility::QGeoSatelliteInfoSource' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
                propertyKeys.push_back(argName);
        }
    }

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGeoSatelliteInfoSource", 1, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QGeoSatelliteInfoSource(QObject*)
    if (numArgs == 1 && Shiboken::Converter<QObject * >::isConvertible(arg)) {
        overloadId = 0; // QGeoSatelliteInfoSource(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoSatelliteInfoSource_Init_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return -1;
            QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // QGeoSatelliteInfoSource(QObject*)
            cptr = new QGeoSatelliteInfoSourceWrapper(cpp_arg0);
            Shiboken::setParent(arg, self);
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QGeoSatelliteInfoSource >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QGeoSatelliteInfoSource_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    PySide::signalUpdateSource(self);
    cptr->metaObject();
    for (std::vector<PyObject*>::size_type i = 0; i < propertyKeys.size(); i++) {
        const char* propName = PyString_AS_STRING(propertyKeys[i]);
        const QMetaObject* mo = cptr->metaObject();
        if (mo->indexOfProperty(propName) != -1) {
            cptr->setProperty(propName, Shiboken::Converter<QVariant>::toCpp(PyDict_GetItem(kwds, propertyKeys[i])));
        } else {
            QString signalSignature = QString("%1()").arg(propName);
            if (mo->indexOfSignal(qPrintable(signalSignature)) != -1) {
                signalSignature = '2' + signalSignature;
                PySide::signal_connect(self, qPrintable(signalSignature), PyDict_GetItem(kwds, propertyKeys[i]));
            } else {
                delete cptr;
                PyErr_Format(PyExc_AttributeError, "'%s' is not a Qt property or a signal", propName);
                return -1;
            };
        }
    }


    return 1;

    SbkQtMobility_QGeoSatelliteInfoSource_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Location.QGeoSatelliteInfoSource", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QGeoSatelliteInfoSourceFunc_createDefaultSource(PyObject* self, PyObject* arg)
{
    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: createDefaultSource(QObject*)
    if (Shiboken::Converter<QObject * >::isConvertible(arg)) {
        overloadId = 0; // createDefaultSource(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoSatelliteInfoSourceFunc_createDefaultSource_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // createDefaultSource(QObject*)
            QtMobility::QGeoSatelliteInfoSource * cppResult = QtMobility::QGeoSatelliteInfoSource::createDefaultSource(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QGeoSatelliteInfoSource * >::toPython(cppResult);
            Shiboken::setParent(arg, pyResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QGeoSatelliteInfoSourceFunc_createDefaultSource_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoSatelliteInfoSource.createDefaultSource", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoSatelliteInfoSourceFunc_requestUpdate(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QGeoSatelliteInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoSatelliteInfoSource* >::toCpp(self);

    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "timeout" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Location.QGeoSatelliteInfoSource.requestUpdate(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Location.QGeoSatelliteInfoSource.requestUpdate(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:requestUpdate", &arg))
        return 0;


    // Overloaded function decisor
    // 0: requestUpdate(int)
    if (numArgs == 0) {
        overloadId = 0; // requestUpdate(int)
    } else if (SbkNumber_Check(arg)) {
        overloadId = 0; // requestUpdate(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoSatelliteInfoSourceFunc_requestUpdate_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "timeout");
                if (value) {
                    if (arg)
                        errorArgName = "timeout";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Location.QGeoSatelliteInfoSource.requestUpdate(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            int cpp_arg0 = arg ? Shiboken::Converter<int >::toCpp(arg) : 0;

            if(!PyErr_Occurred()) {
            // requestUpdate(int)
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.requestUpdate()' not implemented.");
                return 0;
            }
            cppSelf->requestUpdate(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QGeoSatelliteInfoSourceFunc_requestUpdate_TypeError:
        const char* overloads[] = {"int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoSatelliteInfoSource.requestUpdate", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoSatelliteInfoSourceFunc_startUpdates(PyObject* self)
{
    QtMobility::QGeoSatelliteInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoSatelliteInfoSource* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // startUpdates()
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.startUpdates()' not implemented.");
                return 0;
            }
            cppSelf->startUpdates();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QGeoSatelliteInfoSourceFunc_stopUpdates(PyObject* self)
{
    QtMobility::QGeoSatelliteInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoSatelliteInfoSource* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // stopUpdates()
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.stopUpdates()' not implemented.");
                return 0;
            }
            cppSelf->stopUpdates();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQtMobility_QGeoSatelliteInfoSource_methods[] = {
    {"createDefaultSource", (PyCFunction)SbkQtMobility_QGeoSatelliteInfoSourceFunc_createDefaultSource, METH_O|METH_STATIC},
    {"requestUpdate", (PyCFunction)SbkQtMobility_QGeoSatelliteInfoSourceFunc_requestUpdate, METH_VARARGS|METH_KEYWORDS},
    {"startUpdates", (PyCFunction)SbkQtMobility_QGeoSatelliteInfoSourceFunc_startUpdates, METH_NOARGS},
    {"stopUpdates", (PyCFunction)SbkQtMobility_QGeoSatelliteInfoSourceFunc_stopUpdates, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QGeoSatelliteInfoSource_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Location.QGeoSatelliteInfoSource",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QGeoSatelliteInfoSource_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QGeoSatelliteInfoSource_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QGeoSatelliteInfoSource >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QGeoSatelliteInfoSource*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QGeoSatelliteInfoSource_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QGeoSatelliteInfoSource*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QGeoSatelliteInfoSource_Type;
    return 0;
}


void init_QtMobility_QGeoSatelliteInfoSource(PyObject* module)
{
    SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOSATELLITEINFOSOURCE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QGeoSatelliteInfoSource_Type);

    SbkQtMobility_QGeoSatelliteInfoSource_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQtMobility_QGeoSatelliteInfoSource_Type.type_discovery = &SbkQtMobility_QGeoSatelliteInfoSource_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]), &SbkQtMobility_QGeoSatelliteInfoSource_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QGeoSatelliteInfoSource_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QGeoSatelliteInfoSource_Type));
    PyModule_AddObject(module, "QGeoSatelliteInfoSource",
        ((PyObject*)&SbkQtMobility_QGeoSatelliteInfoSource_Type));

    // Initialize signals
    PyObject* signal_item;

    signal_item = PySide::signalNew("satellitesInUseUpdated", "const QList<QtMobility::QGeoSatelliteInfo>&", NULL);
    PyDict_SetItemString(SbkQtMobility_QGeoSatelliteInfoSource_Type.super.ht_type.tp_dict, "satellitesInUseUpdated", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("requestTimeout", "void", NULL);
    PyDict_SetItemString(SbkQtMobility_QGeoSatelliteInfoSource_Type.super.ht_type.tp_dict, "requestTimeout", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("satellitesInViewUpdated", "const QList<QtMobility::QGeoSatelliteInfo>&", NULL);
    PyDict_SetItemString(SbkQtMobility_QGeoSatelliteInfoSource_Type.super.ht_type.tp_dict, "satellitesInViewUpdated", signal_item);
    Py_DECREF(signal_item);


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QGeoSatelliteInfoSource >("QtMobility::QGeoSatelliteInfoSource*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QGeoSatelliteInfoSource >(typeid(QtMobility::QGeoSatelliteInfoSource).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QGeoSatelliteInfoSource >(typeid(QGeoSatelliteInfoSourceWrapper).name());
    PySide::initQtMetaType<QtMobility::QGeoSatelliteInfoSource* >();
}

