/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_location_python.h"

#include "qtmobility_qgeopositioninfosource_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qgeopositioninfo.h>
#include <qgeopositioninfosource.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qthread.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QGeoPositionInfoSourceWrapper::QGeoPositionInfoSourceWrapper(QObject * parent) : QtMobility::QGeoPositionInfoSource(parent), m_metaObject(0) {
    // ... middle
}

void QGeoPositionInfoSourceWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGeoPositionInfoSourceWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QGeoPositionInfoSourceWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGeoPositionInfoSourceWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QGeoPositionInfoSourceWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGeoPositionInfoSource.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QGeoPositionInfoSourceWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGeoPositionInfoSource.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

QtMobility::QGeoPositionInfo QGeoPositionInfoSourceWrapper::lastKnownPosition(bool fromSatellitePositioningMethodsOnly) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "lastKnownPosition"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.lastKnownPosition()' not implemented.");
        return QtMobility::QGeoPositionInfo();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<bool >::toPython(fromSatellitePositioningMethodsOnly)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QtMobility::QGeoPositionInfo();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QtMobility::QGeoPositionInfo >::isConvertible(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGeoPositionInfoSource.lastKnownPosition", SbkType<QtMobility::QGeoPositionInfo >()->tp_name, pyResult->ob_type->tp_name);
        return QtMobility::QGeoPositionInfo();
    }
    QtMobility::QGeoPositionInfo cppResult(Shiboken::Converter<QtMobility::QGeoPositionInfo >::toCpp(pyResult));
    return cppResult;
}

int QGeoPositionInfoSourceWrapper::minimumUpdateInterval() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumUpdateInterval"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.minimumUpdateInterval()' not implemented.");
        return int(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGeoPositionInfoSource.minimumUpdateInterval", "int", pyResult->ob_type->tp_name);
        return int(0);
    }
    int cppResult(Shiboken::Converter<int >::toCpp(pyResult));
    return cppResult;
}

void QGeoPositionInfoSourceWrapper::requestUpdate(int timeout)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "requestUpdate"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.requestUpdate()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        timeout
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QGeoPositionInfoSourceWrapper::setPreferredPositioningMethods(QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> methods)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setPreferredPositioningMethods"));
    if (py_override.isNull()) {
        return this->QtMobility::QGeoPositionInfoSource::setPreferredPositioningMethods(methods);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> >::toPython(methods)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QGeoPositionInfoSourceWrapper::setUpdateInterval(int msec)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setUpdateInterval"));
    if (py_override.isNull()) {
        return this->QtMobility::QGeoPositionInfoSource::setUpdateInterval(msec);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        msec
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QGeoPositionInfoSourceWrapper::startUpdates()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startUpdates"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.startUpdates()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QGeoPositionInfoSourceWrapper::stopUpdates()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "stopUpdates"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.stopUpdates()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> QGeoPositionInfoSourceWrapper::supportedPositioningMethods() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "supportedPositioningMethods"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.supportedPositioningMethods()' not implemented.");
        return QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod>();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> >::isConvertible(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGeoPositionInfoSource.supportedPositioningMethods", SbkType<QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> >()->tp_name, pyResult->ob_type->tp_name);
        return QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod>();
    }
    QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> cppResult(Shiboken::Converter<QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> >::toCpp(pyResult));
    return cppResult;
}

void QGeoPositionInfoSourceWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QGeoPositionInfoSourceWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QGeoPositionInfoSource::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QGeoPositionInfoSourceWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QGeoPositionInfoSource::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QGeoPositionInfoSourceWrapper::~QGeoPositionInfoSourceWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QGeoPositionInfoSource_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QGeoPositionInfoSource >()))
        return -1;

    QGeoPositionInfoSourceWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOPOSITIONINFOSOURCE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QtMobility::QGeoPositionInfoSource' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
                propertyKeys.push_back(argName);
        }
    }

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGeoPositionInfoSource", 1, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QGeoPositionInfoSource(QObject*)
    if (numArgs == 1 && Shiboken::Converter<QObject * >::isConvertible(arg)) {
        overloadId = 0; // QGeoPositionInfoSource(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoPositionInfoSource_Init_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return -1;
            QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // QGeoPositionInfoSource(QObject*)
            cptr = new QGeoPositionInfoSourceWrapper(cpp_arg0);
            Shiboken::setParent(arg, self);
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QGeoPositionInfoSource >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QGeoPositionInfoSource_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    PySide::signalUpdateSource(self);
    cptr->metaObject();
    for (std::vector<PyObject*>::size_type i = 0; i < propertyKeys.size(); i++) {
        const char* propName = PyString_AS_STRING(propertyKeys[i]);
        const QMetaObject* mo = cptr->metaObject();
        if (mo->indexOfProperty(propName) != -1) {
            cptr->setProperty(propName, Shiboken::Converter<QVariant>::toCpp(PyDict_GetItem(kwds, propertyKeys[i])));
        } else {
            QString signalSignature = QString("%1()").arg(propName);
            if (mo->indexOfSignal(qPrintable(signalSignature)) != -1) {
                signalSignature = '2' + signalSignature;
                PySide::signal_connect(self, qPrintable(signalSignature), PyDict_GetItem(kwds, propertyKeys[i]));
            } else {
                delete cptr;
                PyErr_Format(PyExc_AttributeError, "'%s' is not a Qt property or a signal", propName);
                return -1;
            };
        }
    }


    return 1;

    SbkQtMobility_QGeoPositionInfoSource_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Location.QGeoPositionInfoSource", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QGeoPositionInfoSourceFunc_createDefaultSource(PyObject* self, PyObject* arg)
{
    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: createDefaultSource(QObject*)
    if (Shiboken::Converter<QObject * >::isConvertible(arg)) {
        overloadId = 0; // createDefaultSource(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoPositionInfoSourceFunc_createDefaultSource_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // createDefaultSource(QObject*)
            QtMobility::QGeoPositionInfoSource * cppResult = QtMobility::QGeoPositionInfoSource::createDefaultSource(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QGeoPositionInfoSource * >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QGeoPositionInfoSourceFunc_createDefaultSource_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoPositionInfoSource.createDefaultSource", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoPositionInfoSourceFunc_lastKnownPosition(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QGeoPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoPositionInfoSource* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "fromSatellitePositioningMethodsOnly" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Location.QGeoPositionInfoSource.lastKnownPosition(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Location.QGeoPositionInfoSource.lastKnownPosition(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:lastKnownPosition", &arg))
        return 0;


    // Overloaded function decisor
    // 0: lastKnownPosition(bool)const
    if (numArgs == 0) {
        overloadId = 0; // lastKnownPosition(bool)const
    } else if (SbkNumber_Check(arg)) {
        overloadId = 0; // lastKnownPosition(bool)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoPositionInfoSourceFunc_lastKnownPosition_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "fromSatellitePositioningMethodsOnly");
                if (value) {
                    if (arg)
                        errorArgName = "fromSatellitePositioningMethodsOnly";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Location.QGeoPositionInfoSource.lastKnownPosition(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            bool cpp_arg0 = arg ? Shiboken::Converter<bool >::toCpp(arg) : false;

            if(!PyErr_Occurred()) {
            // lastKnownPosition(bool)const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.lastKnownPosition()' not implemented.");
                return 0;
            }
            QtMobility::QGeoPositionInfo cppResult = cppSelf->lastKnownPosition(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QGeoPositionInfo >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QGeoPositionInfoSourceFunc_lastKnownPosition_TypeError:
        const char* overloads[] = {"bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoPositionInfoSource.lastKnownPosition", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoPositionInfoSourceFunc_minimumUpdateInterval(PyObject* self)
{
    QtMobility::QGeoPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoPositionInfoSource* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // minimumUpdateInterval()const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.minimumUpdateInterval()' not implemented.");
                return 0;
            }
            int cppResult = cppSelf->minimumUpdateInterval();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QGeoPositionInfoSourceFunc_preferredPositioningMethods(PyObject* self)
{
    QtMobility::QGeoPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoPositionInfoSource* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // preferredPositioningMethods()const
            QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> cppResult = cppSelf->QtMobility::QGeoPositionInfoSource::preferredPositioningMethods();
            pyResult = Shiboken::Converter<QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QGeoPositionInfoSourceFunc_requestUpdate(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QGeoPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoPositionInfoSource* >::toCpp(self);

    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "timeout" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Location.QGeoPositionInfoSource.requestUpdate(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Location.QGeoPositionInfoSource.requestUpdate(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:requestUpdate", &arg))
        return 0;


    // Overloaded function decisor
    // 0: requestUpdate(int)
    if (numArgs == 0) {
        overloadId = 0; // requestUpdate(int)
    } else if (SbkNumber_Check(arg)) {
        overloadId = 0; // requestUpdate(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoPositionInfoSourceFunc_requestUpdate_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "timeout");
                if (value) {
                    if (arg)
                        errorArgName = "timeout";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Location.QGeoPositionInfoSource.requestUpdate(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            int cpp_arg0 = arg ? Shiboken::Converter<int >::toCpp(arg) : 0;

            if(!PyErr_Occurred()) {
            // requestUpdate(int)
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.requestUpdate()' not implemented.");
                return 0;
            }
            cppSelf->requestUpdate(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QGeoPositionInfoSourceFunc_requestUpdate_TypeError:
        const char* overloads[] = {"int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoPositionInfoSource.requestUpdate", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoPositionInfoSourceFunc_setPreferredPositioningMethods(PyObject* self, PyObject* arg)
{
    QtMobility::QGeoPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoPositionInfoSource* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setPreferredPositioningMethods(QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod>)
    if (Shiboken::Converter<QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> >::isConvertible(arg)) {
        overloadId = 0; // setPreferredPositioningMethods(QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoPositionInfoSourceFunc_setPreferredPositioningMethods_TypeError;

    // Call function/method
    {
        {
            QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> cpp_arg0 = Shiboken::Converter<QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setPreferredPositioningMethods(QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod>)
            cppSelf->QtMobility::QGeoPositionInfoSource::setPreferredPositioningMethods(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QGeoPositionInfoSourceFunc_setPreferredPositioningMethods_TypeError:
        const char* overloads[] = {"QtMobility.Location.QGeoPositionInfoSource.PositioningMethods", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoPositionInfoSource.setPreferredPositioningMethods", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoPositionInfoSourceFunc_setUpdateInterval(PyObject* self, PyObject* arg)
{
    QtMobility::QGeoPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoPositionInfoSource* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setUpdateInterval(int)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setUpdateInterval(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoPositionInfoSourceFunc_setUpdateInterval_TypeError;

    // Call function/method
    {
        {
            int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setUpdateInterval(int)
            cppSelf->QtMobility::QGeoPositionInfoSource::setUpdateInterval(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QGeoPositionInfoSourceFunc_setUpdateInterval_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoPositionInfoSource.setUpdateInterval", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoPositionInfoSourceFunc_startUpdates(PyObject* self)
{
    QtMobility::QGeoPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoPositionInfoSource* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // startUpdates()
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.startUpdates()' not implemented.");
                return 0;
            }
            cppSelf->startUpdates();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QGeoPositionInfoSourceFunc_stopUpdates(PyObject* self)
{
    QtMobility::QGeoPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoPositionInfoSource* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // stopUpdates()
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.stopUpdates()' not implemented.");
                return 0;
            }
            cppSelf->stopUpdates();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQtMobility_QGeoPositionInfoSourceFunc_supportedPositioningMethods(PyObject* self)
{
    QtMobility::QGeoPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoPositionInfoSource* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // supportedPositioningMethods()const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSource.supportedPositioningMethods()' not implemented.");
                return 0;
            }
            QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> cppResult = cppSelf->supportedPositioningMethods();
            pyResult = Shiboken::Converter<QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QGeoPositionInfoSourceFunc_updateInterval(PyObject* self)
{
    QtMobility::QGeoPositionInfoSource* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoPositionInfoSource* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // updateInterval()const
            int cppResult = cppSelf->QtMobility::QGeoPositionInfoSource::updateInterval();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QGeoPositionInfoSource_methods[] = {
    {"createDefaultSource", (PyCFunction)SbkQtMobility_QGeoPositionInfoSourceFunc_createDefaultSource, METH_O|METH_STATIC},
    {"lastKnownPosition", (PyCFunction)SbkQtMobility_QGeoPositionInfoSourceFunc_lastKnownPosition, METH_VARARGS|METH_KEYWORDS},
    {"minimumUpdateInterval", (PyCFunction)SbkQtMobility_QGeoPositionInfoSourceFunc_minimumUpdateInterval, METH_NOARGS},
    {"preferredPositioningMethods", (PyCFunction)SbkQtMobility_QGeoPositionInfoSourceFunc_preferredPositioningMethods, METH_NOARGS},
    {"requestUpdate", (PyCFunction)SbkQtMobility_QGeoPositionInfoSourceFunc_requestUpdate, METH_VARARGS|METH_KEYWORDS},
    {"setPreferredPositioningMethods", (PyCFunction)SbkQtMobility_QGeoPositionInfoSourceFunc_setPreferredPositioningMethods, METH_O},
    {"setUpdateInterval", (PyCFunction)SbkQtMobility_QGeoPositionInfoSourceFunc_setUpdateInterval, METH_O},
    {"startUpdates", (PyCFunction)SbkQtMobility_QGeoPositionInfoSourceFunc_startUpdates, METH_NOARGS},
    {"stopUpdates", (PyCFunction)SbkQtMobility_QGeoPositionInfoSourceFunc_stopUpdates, METH_NOARGS},
    {"supportedPositioningMethods", (PyCFunction)SbkQtMobility_QGeoPositionInfoSourceFunc_supportedPositioningMethods, METH_NOARGS},
    {"updateInterval", (PyCFunction)SbkQtMobility_QGeoPositionInfoSourceFunc_updateInterval, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QGeoPositionInfoSource_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Location.QGeoPositionInfoSource",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QGeoPositionInfoSource_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QGeoPositionInfoSource_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QGeoPositionInfoSource >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QGeoPositionInfoSource*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QGeoPositionInfoSource_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QGeoPositionInfoSource*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QGeoPositionInfoSource_Type;
    return 0;
}

PyObject* SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod___and__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QGeoPositionInfoSource::PositioningMethods >::checkType(self) && Shiboken::Converter<QtMobility::QGeoPositionInfoSource::PositioningMethods >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "&", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QGeoPositionInfoSource::PositioningMethods >::toPython(
        Shiboken::Converter<QtMobility::QGeoPositionInfoSource::PositioningMethods>::toCpp(self)
        & Shiboken::Converter< QtMobility::QGeoPositionInfoSource::PositioningMethods >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod___or__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QGeoPositionInfoSource::PositioningMethods >::checkType(self) && Shiboken::Converter<QtMobility::QGeoPositionInfoSource::PositioningMethods >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "|", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QGeoPositionInfoSource::PositioningMethods >::toPython(
        Shiboken::Converter<QtMobility::QGeoPositionInfoSource::PositioningMethods>::toCpp(self)
        | Shiboken::Converter< QtMobility::QGeoPositionInfoSource::PositioningMethods >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod___xor__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QGeoPositionInfoSource::PositioningMethods >::checkType(self) && Shiboken::Converter<QtMobility::QGeoPositionInfoSource::PositioningMethods >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "^", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QGeoPositionInfoSource::PositioningMethods >::toPython(
        Shiboken::Converter<QtMobility::QGeoPositionInfoSource::PositioningMethods>::toCpp(self)
        ^ Shiboken::Converter< QtMobility::QGeoPositionInfoSource::PositioningMethods >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QtMobility::QGeoPositionInfoSource::PositioningMethods >::toPython(
        ~Shiboken::Converter<QtMobility::QGeoPositionInfoSource::PositioningMethods >::toCpp(self)
    );
}


static PyNumberMethods SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod___and__,
    /*nb_xor*/                  (binaryfunc)SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod___xor__,
    /*nb_or*/                   (binaryfunc)SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PositioningMethod",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyTypeObject SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethods_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PositioningMethods",
    /*tp_basicsize*/        0,
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod_Type.tp_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT | Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              PyInt_Type.tp_new,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};



void init_QtMobility_QGeoPositionInfoSource(PyObject* module)
{
    SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOPOSITIONINFOSOURCE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QGeoPositionInfoSource_Type);

    SbkQtMobility_QGeoPositionInfoSource_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQtMobility_QGeoPositionInfoSource_Type.type_discovery = &SbkQtMobility_QGeoPositionInfoSource_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]), &SbkQtMobility_QGeoPositionInfoSource_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QGeoPositionInfoSource_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QGeoPositionInfoSource_Type));
    PyModule_AddObject(module, "QGeoPositionInfoSource",
        ((PyObject*)&SbkQtMobility_QGeoPositionInfoSource_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: PositioningMethod
    SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX] = &SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod_Type);
    PyDict_SetItemString(SbkQtMobility_QGeoPositionInfoSource_Type.super.ht_type.tp_dict,
            "PositioningMethod",((PyObject*)&SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod_Type));

    // init flags class: QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod>
    SbkQtMobility_LocationTypes[SBK_QFLAGS_QTMOBILITY_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD__IDX] = &SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethods_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethods_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethods_Type);
    PyDict_SetItemString(SbkQtMobility_QGeoPositionInfoSource_Type.super.ht_type.tp_dict,
            "PositioningMethods",((PyObject*)&SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethods_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod_Type,
        (long) QtMobility::QGeoPositionInfoSource::SatellitePositioningMethods, "SatellitePositioningMethods");
    PyDict_SetItemString(SbkQtMobility_QGeoPositionInfoSource_Type.super.ht_type.tp_dict,
        "SatellitePositioningMethods", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod_Type.tp_dict,
        "SatellitePositioningMethods", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod_Type,
        (long) QtMobility::QGeoPositionInfoSource::NonSatellitePositioningMethods, "NonSatellitePositioningMethods");
    PyDict_SetItemString(SbkQtMobility_QGeoPositionInfoSource_Type.super.ht_type.tp_dict,
        "NonSatellitePositioningMethods", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod_Type.tp_dict,
        "NonSatellitePositioningMethods", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod_Type,
        (long) QtMobility::QGeoPositionInfoSource::AllPositioningMethods, "AllPositioningMethods");
    PyDict_SetItemString(SbkQtMobility_QGeoPositionInfoSource_Type.super.ht_type.tp_dict,
        "AllPositioningMethods", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoPositionInfoSource_PositioningMethod_Type.tp_dict,
        "AllPositioningMethods", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QGeoPositionInfoSource::PositioningMethod");

    // Initialize signals
    PyObject* signal_item;

    signal_item = PySide::signalNew("positionUpdated", "const QtMobility::QGeoPositionInfo&", NULL);
    PyDict_SetItemString(SbkQtMobility_QGeoPositionInfoSource_Type.super.ht_type.tp_dict, "positionUpdated", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("updateTimeout", "void", NULL);
    PyDict_SetItemString(SbkQtMobility_QGeoPositionInfoSource_Type.super.ht_type.tp_dict, "updateTimeout", signal_item);
    Py_DECREF(signal_item);


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QGeoPositionInfoSource >("QtMobility::QGeoPositionInfoSource*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QGeoPositionInfoSource >(typeid(QtMobility::QGeoPositionInfoSource).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QGeoPositionInfoSource >(typeid(QGeoPositionInfoSourceWrapper).name());
    PySide::initQtMetaType<QtMobility::QGeoPositionInfoSource* >();
}

