/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_location_python.h"

#include "qtmobility_qgeopositioninfo_wrapper.h"

// Extra includes
#include <qdatetime.h>
#include <qgeocoordinate.h>
#include <qgeopositioninfo.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QGeoPositionInfo_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QGeoPositionInfo >()))
        return -1;

    QtMobility::QGeoPositionInfo* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGeoPositionInfo", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    // Overloaded function decisor
    // 0: QGeoPositionInfo()
    // 1: QGeoPositionInfo(QtMobility::QGeoCoordinate,QDateTime)
    // 2: QGeoPositionInfo(QtMobility::QGeoPositionInfo)
    if (numArgs == 0) {
        overloadId = 0; // QGeoPositionInfo()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QGeoPositionInfo & >::isConvertible(pyargs[0])) {
        overloadId = 2; // QGeoPositionInfo(QtMobility::QGeoPositionInfo)
    } else if (numArgs == 2 && Shiboken::Converter<const QtMobility::QGeoCoordinate & >::isConvertible(pyargs[0]) && Shiboken::Converter<const QDateTime & >::isConvertible(pyargs[1])) {
        overloadId = 1; // QGeoPositionInfo(QtMobility::QGeoCoordinate,QDateTime)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoPositionInfo_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QGeoPositionInfo()
            {

                if(!PyErr_Occurred()) {
                // QGeoPositionInfo()
                cptr = new QtMobility::QGeoPositionInfo();
                }
                break;
            }
            case 1: // QGeoPositionInfo(QtMobility::QGeoCoordinate,QDateTime)
            {
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return -1;
                QtMobility::QGeoCoordinate* cpp_arg0 = Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(pyargs[0]);
                if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                    return -1;
                QDateTime* cpp_arg1 = Shiboken::Converter<QDateTime* >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // QGeoPositionInfo(QtMobility::QGeoCoordinate,QDateTime)
                cptr = new QtMobility::QGeoPositionInfo(*cpp_arg0, *cpp_arg1);
                }
                break;
            }
            case 2: // QGeoPositionInfo(QtMobility::QGeoPositionInfo)
            {
                if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                    return -1;
                QtMobility::QGeoPositionInfo* cpp_arg0 = Shiboken::Converter<QtMobility::QGeoPositionInfo* >::toCpp(pyargs[0]);

                if(!PyErr_Occurred()) {
                // QGeoPositionInfo(QtMobility::QGeoPositionInfo)
                cptr = new QtMobility::QGeoPositionInfo(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QGeoPositionInfo >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QGeoPositionInfo_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QGeoPositionInfo_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Location.QGeoCoordinate, PySide.QtCore.QDateTime", "QtMobility.Location.QGeoPositionInfo", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Location.QGeoPositionInfo", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QGeoPositionInfoFunc_attribute(PyObject* self, PyObject* arg)
{
    QtMobility::QGeoPositionInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoPositionInfo* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: attribute(QtMobility::QGeoPositionInfo::Attribute)const
    if (Shiboken::Converter<QtMobility::QGeoPositionInfo::Attribute >::isConvertible(arg)) {
        overloadId = 0; // attribute(QtMobility::QGeoPositionInfo::Attribute)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoPositionInfoFunc_attribute_TypeError;

    // Call function/method
    {
        {
            QtMobility::QGeoPositionInfo::Attribute cpp_arg0 = Shiboken::Converter<QtMobility::QGeoPositionInfo::Attribute >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // attribute(QtMobility::QGeoPositionInfo::Attribute)const
            qreal cppResult = cppSelf->QtMobility::QGeoPositionInfo::attribute(cpp_arg0);
            pyResult = Shiboken::Converter<double >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QGeoPositionInfoFunc_attribute_TypeError:
        const char* overloads[] = {"QtMobility.Location.QGeoPositionInfo.Attribute", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoPositionInfo.attribute", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoPositionInfoFunc_coordinate(PyObject* self)
{
    QtMobility::QGeoPositionInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoPositionInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // coordinate()const
            QtMobility::QGeoCoordinate cppResult = cppSelf->QtMobility::QGeoPositionInfo::coordinate();
            pyResult = Shiboken::Converter<QtMobility::QGeoCoordinate >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QGeoPositionInfoFunc_hasAttribute(PyObject* self, PyObject* arg)
{
    QtMobility::QGeoPositionInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoPositionInfo* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: hasAttribute(QtMobility::QGeoPositionInfo::Attribute)const
    if (Shiboken::Converter<QtMobility::QGeoPositionInfo::Attribute >::isConvertible(arg)) {
        overloadId = 0; // hasAttribute(QtMobility::QGeoPositionInfo::Attribute)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoPositionInfoFunc_hasAttribute_TypeError;

    // Call function/method
    {
        {
            QtMobility::QGeoPositionInfo::Attribute cpp_arg0 = Shiboken::Converter<QtMobility::QGeoPositionInfo::Attribute >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // hasAttribute(QtMobility::QGeoPositionInfo::Attribute)const
            bool cppResult = cppSelf->QtMobility::QGeoPositionInfo::hasAttribute(cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QGeoPositionInfoFunc_hasAttribute_TypeError:
        const char* overloads[] = {"QtMobility.Location.QGeoPositionInfo.Attribute", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoPositionInfo.hasAttribute", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoPositionInfoFunc_isValid(PyObject* self)
{
    QtMobility::QGeoPositionInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoPositionInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = cppSelf->QtMobility::QGeoPositionInfo::isValid();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QGeoPositionInfoFunc_removeAttribute(PyObject* self, PyObject* arg)
{
    QtMobility::QGeoPositionInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoPositionInfo* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: removeAttribute(QtMobility::QGeoPositionInfo::Attribute)
    if (Shiboken::Converter<QtMobility::QGeoPositionInfo::Attribute >::isConvertible(arg)) {
        overloadId = 0; // removeAttribute(QtMobility::QGeoPositionInfo::Attribute)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoPositionInfoFunc_removeAttribute_TypeError;

    // Call function/method
    {
        {
            QtMobility::QGeoPositionInfo::Attribute cpp_arg0 = Shiboken::Converter<QtMobility::QGeoPositionInfo::Attribute >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // removeAttribute(QtMobility::QGeoPositionInfo::Attribute)
            cppSelf->QtMobility::QGeoPositionInfo::removeAttribute(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QGeoPositionInfoFunc_removeAttribute_TypeError:
        const char* overloads[] = {"QtMobility.Location.QGeoPositionInfo.Attribute", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoPositionInfo.removeAttribute", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoPositionInfoFunc_setAttribute(PyObject* self, PyObject* args)
{
    QtMobility::QGeoPositionInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoPositionInfo* >::toCpp(self);

    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setAttribute", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: setAttribute(QtMobility::QGeoPositionInfo::Attribute,qreal)
    if (numArgs == 2 && Shiboken::Converter<QtMobility::QGeoPositionInfo::Attribute >::isConvertible(pyargs[0]) && SbkNumber_Check(pyargs[1])) {
        overloadId = 0; // setAttribute(QtMobility::QGeoPositionInfo::Attribute,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoPositionInfoFunc_setAttribute_TypeError;

    // Call function/method
    {
        {
            QtMobility::QGeoPositionInfo::Attribute cpp_arg0 = Shiboken::Converter<QtMobility::QGeoPositionInfo::Attribute >::toCpp(pyargs[0]);
            qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // setAttribute(QtMobility::QGeoPositionInfo::Attribute,qreal)
            cppSelf->QtMobility::QGeoPositionInfo::setAttribute(cpp_arg0, cpp_arg1);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QGeoPositionInfoFunc_setAttribute_TypeError:
        const char* overloads[] = {"QtMobility.Location.QGeoPositionInfo.Attribute, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Location.QGeoPositionInfo.setAttribute", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoPositionInfoFunc_setCoordinate(PyObject* self, PyObject* arg)
{
    QtMobility::QGeoPositionInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoPositionInfo* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setCoordinate(QtMobility::QGeoCoordinate)
    if (Shiboken::Converter<const QtMobility::QGeoCoordinate & >::isConvertible(arg)) {
        overloadId = 0; // setCoordinate(QtMobility::QGeoCoordinate)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoPositionInfoFunc_setCoordinate_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QGeoCoordinate* cpp_arg0 = Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setCoordinate(QtMobility::QGeoCoordinate)
            cppSelf->QtMobility::QGeoPositionInfo::setCoordinate(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QGeoPositionInfoFunc_setCoordinate_TypeError:
        const char* overloads[] = {"QtMobility.Location.QGeoCoordinate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoPositionInfo.setCoordinate", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoPositionInfoFunc_setTimestamp(PyObject* self, PyObject* arg)
{
    QtMobility::QGeoPositionInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoPositionInfo* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setTimestamp(QDateTime)
    if (Shiboken::Converter<const QDateTime & >::isConvertible(arg)) {
        overloadId = 0; // setTimestamp(QDateTime)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoPositionInfoFunc_setTimestamp_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setTimestamp(QDateTime)
            cppSelf->QtMobility::QGeoPositionInfo::setTimestamp(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QGeoPositionInfoFunc_setTimestamp_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoPositionInfo.setTimestamp", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoPositionInfoFunc_timestamp(PyObject* self)
{
    QtMobility::QGeoPositionInfo* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoPositionInfo* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // timestamp()const
            QDateTime cppResult = cppSelf->QtMobility::QGeoPositionInfo::timestamp();
            pyResult = Shiboken::Converter<QDateTime >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QGeoPositionInfo_methods[] = {
    {"attribute", (PyCFunction)SbkQtMobility_QGeoPositionInfoFunc_attribute, METH_O},
    {"coordinate", (PyCFunction)SbkQtMobility_QGeoPositionInfoFunc_coordinate, METH_NOARGS},
    {"hasAttribute", (PyCFunction)SbkQtMobility_QGeoPositionInfoFunc_hasAttribute, METH_O},
    {"isValid", (PyCFunction)SbkQtMobility_QGeoPositionInfoFunc_isValid, METH_NOARGS},
    {"removeAttribute", (PyCFunction)SbkQtMobility_QGeoPositionInfoFunc_removeAttribute, METH_O},
    {"setAttribute", (PyCFunction)SbkQtMobility_QGeoPositionInfoFunc_setAttribute, METH_VARARGS},
    {"setCoordinate", (PyCFunction)SbkQtMobility_QGeoPositionInfoFunc_setCoordinate, METH_O},
    {"setTimestamp", (PyCFunction)SbkQtMobility_QGeoPositionInfoFunc_setTimestamp, METH_O},
    {"timestamp", (PyCFunction)SbkQtMobility_QGeoPositionInfoFunc_timestamp, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQtMobility_QGeoPositionInfo_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QGeoPositionInfo& cpp_self = *Shiboken::Converter<QtMobility::QGeoPositionInfo* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QGeoPositionInfo & >::isConvertible(other)) {
                // operator!=(const QtMobility::QGeoPositionInfo & other) const
                QtMobility::QGeoPositionInfo* cpp_other = Shiboken::Converter<QtMobility::QGeoPositionInfo* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QGeoPositionInfo  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QGeoPositionInfo_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QGeoPositionInfo & >::isConvertible(other)) {
                // operator==(const QtMobility::QGeoPositionInfo & other) const
                QtMobility::QGeoPositionInfo* cpp_other = Shiboken::Converter<QtMobility::QGeoPositionInfo* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QGeoPositionInfo  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QGeoPositionInfo_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QGeoPositionInfo_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QGeoPositionInfo_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Location.QGeoPositionInfo",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QGeoPositionInfo_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QGeoPositionInfo_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QGeoPositionInfo_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QGeoPositionInfo >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QGeoPositionInfo",
    /*user_data*/           0
};
} //extern

static PyGetSetDef SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Attribute",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QGeoPositionInfo(PyObject* module)
{
    SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOPOSITIONINFO_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QGeoPositionInfo_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QGeoPositionInfo_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QGeoPositionInfo_Type));
    PyModule_AddObject(module, "QGeoPositionInfo",
        ((PyObject*)&SbkQtMobility_QGeoPositionInfo_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Attribute
    SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOPOSITIONINFO_ATTRIBUTE_IDX] = &SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_Type);
    PyDict_SetItemString(SbkQtMobility_QGeoPositionInfo_Type.super.ht_type.tp_dict,
            "Attribute",((PyObject*)&SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_Type,
        (long) QtMobility::QGeoPositionInfo::Direction, "Direction");
    PyDict_SetItemString(SbkQtMobility_QGeoPositionInfo_Type.super.ht_type.tp_dict,
        "Direction", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_Type.tp_dict,
        "Direction", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_Type,
        (long) QtMobility::QGeoPositionInfo::GroundSpeed, "GroundSpeed");
    PyDict_SetItemString(SbkQtMobility_QGeoPositionInfo_Type.super.ht_type.tp_dict,
        "GroundSpeed", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_Type.tp_dict,
        "GroundSpeed", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_Type,
        (long) QtMobility::QGeoPositionInfo::VerticalSpeed, "VerticalSpeed");
    PyDict_SetItemString(SbkQtMobility_QGeoPositionInfo_Type.super.ht_type.tp_dict,
        "VerticalSpeed", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_Type.tp_dict,
        "VerticalSpeed", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_Type,
        (long) QtMobility::QGeoPositionInfo::MagneticVariation, "MagneticVariation");
    PyDict_SetItemString(SbkQtMobility_QGeoPositionInfo_Type.super.ht_type.tp_dict,
        "MagneticVariation", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_Type.tp_dict,
        "MagneticVariation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_Type,
        (long) QtMobility::QGeoPositionInfo::HorizontalAccuracy, "HorizontalAccuracy");
    PyDict_SetItemString(SbkQtMobility_QGeoPositionInfo_Type.super.ht_type.tp_dict,
        "HorizontalAccuracy", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_Type.tp_dict,
        "HorizontalAccuracy", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_Type,
        (long) QtMobility::QGeoPositionInfo::VerticalAccuracy, "VerticalAccuracy");
    PyDict_SetItemString(SbkQtMobility_QGeoPositionInfo_Type.super.ht_type.tp_dict,
        "VerticalAccuracy", enum_item);
    PyDict_SetItemString(SbkQtMobility_Location_QtMobility_QGeoPositionInfo_Attribute_Type.tp_dict,
        "VerticalAccuracy", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QGeoPositionInfo::Attribute");


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QGeoPositionInfo >("QtMobility::QGeoPositionInfo");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QGeoPositionInfo >("QtMobility::QGeoPositionInfo*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QGeoPositionInfo >(typeid(QtMobility::QGeoPositionInfo).name());
    PySide::initQtMetaType<QtMobility::QGeoPositionInfo >();
}

