/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_location_python.h"

#include "qtmobility_qgeoareamonitor_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qgeoareamonitor.h>
#include <qgeocoordinate.h>
#include <qgeopositioninfo.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qthread.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QGeoAreaMonitorWrapper::QGeoAreaMonitorWrapper(QObject * parent) : QtMobility::QGeoAreaMonitor(parent), m_metaObject(0) {
    // ... middle
}

void QGeoAreaMonitorWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGeoAreaMonitorWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QGeoAreaMonitorWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGeoAreaMonitorWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QGeoAreaMonitorWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGeoAreaMonitor.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QGeoAreaMonitorWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGeoAreaMonitor.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

void QGeoAreaMonitorWrapper::setCenter(const QtMobility::QGeoCoordinate & coordinate)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setCenter"));
    if (py_override.isNull()) {
        return this->QtMobility::QGeoAreaMonitor::setCenter(coordinate);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const QtMobility::QGeoCoordinate & >::toPython(coordinate)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QGeoAreaMonitorWrapper::setRadius(qreal radius)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setRadius"));
    if (py_override.isNull()) {
        return this->QtMobility::QGeoAreaMonitor::setRadius(radius);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(d)",
        Shiboken::Converter<double >::toPython(radius)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QGeoAreaMonitorWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QGeoAreaMonitorWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QGeoAreaMonitor::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QGeoAreaMonitorWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QGeoAreaMonitor::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QGeoAreaMonitorWrapper::~QGeoAreaMonitorWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QGeoAreaMonitor_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QGeoAreaMonitor >()))
        return -1;

    QGeoAreaMonitorWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
                propertyKeys.push_back(argName);
        }
    }

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGeoAreaMonitor", 1, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QGeoAreaMonitor(QObject*)
    if (numArgs == 1 && Shiboken::Converter<QObject * >::isConvertible(arg)) {
        overloadId = 0; // QGeoAreaMonitor(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoAreaMonitor_Init_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return -1;
            QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // QGeoAreaMonitor(QObject*)
            cptr = new QGeoAreaMonitorWrapper(cpp_arg0);
            Shiboken::setParent(arg, self);
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QGeoAreaMonitor >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QGeoAreaMonitor_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    PySide::signalUpdateSource(self);
    cptr->metaObject();
    for (std::vector<PyObject*>::size_type i = 0; i < propertyKeys.size(); i++) {
        const char* propName = PyString_AS_STRING(propertyKeys[i]);
        const QMetaObject* mo = cptr->metaObject();
        if (mo->indexOfProperty(propName) != -1) {
            cptr->setProperty(propName, Shiboken::Converter<QVariant>::toCpp(PyDict_GetItem(kwds, propertyKeys[i])));
        } else {
            QString signalSignature = QString("%1()").arg(propName);
            if (mo->indexOfSignal(qPrintable(signalSignature)) != -1) {
                signalSignature = '2' + signalSignature;
                PySide::signal_connect(self, qPrintable(signalSignature), PyDict_GetItem(kwds, propertyKeys[i]));
            } else {
                delete cptr;
                PyErr_Format(PyExc_AttributeError, "'%s' is not a Qt property or a signal", propName);
                return -1;
            };
        }
    }


    return 1;

    SbkQtMobility_QGeoAreaMonitor_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Location.QGeoAreaMonitor", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QGeoAreaMonitorFunc_center(PyObject* self)
{
    QtMobility::QGeoAreaMonitor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoAreaMonitor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // center()const
            QtMobility::QGeoCoordinate cppResult = cppSelf->QtMobility::QGeoAreaMonitor::center();
            pyResult = Shiboken::Converter<QtMobility::QGeoCoordinate >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QGeoAreaMonitorFunc_createDefaultMonitor(PyObject* self, PyObject* arg)
{
    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: createDefaultMonitor(QObject*)
    if (Shiboken::Converter<QObject * >::isConvertible(arg)) {
        overloadId = 0; // createDefaultMonitor(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoAreaMonitorFunc_createDefaultMonitor_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // createDefaultMonitor(QObject*)
            QtMobility::QGeoAreaMonitor * cppResult = QtMobility::QGeoAreaMonitor::createDefaultMonitor(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QGeoAreaMonitor * >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QGeoAreaMonitorFunc_createDefaultMonitor_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoAreaMonitor.createDefaultMonitor", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoAreaMonitorFunc_radius(PyObject* self)
{
    QtMobility::QGeoAreaMonitor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoAreaMonitor* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // radius()const
            qreal cppResult = cppSelf->QtMobility::QGeoAreaMonitor::radius();
            pyResult = Shiboken::Converter<double >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QGeoAreaMonitorFunc_setCenter(PyObject* self, PyObject* arg)
{
    QtMobility::QGeoAreaMonitor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoAreaMonitor* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setCenter(QtMobility::QGeoCoordinate)
    if (Shiboken::Converter<const QtMobility::QGeoCoordinate & >::isConvertible(arg)) {
        overloadId = 0; // setCenter(QtMobility::QGeoCoordinate)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoAreaMonitorFunc_setCenter_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QGeoCoordinate* cpp_arg0 = Shiboken::Converter<QtMobility::QGeoCoordinate* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setCenter(QtMobility::QGeoCoordinate)
            cppSelf->QtMobility::QGeoAreaMonitor::setCenter(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QGeoAreaMonitorFunc_setCenter_TypeError:
        const char* overloads[] = {"QtMobility.Location.QGeoCoordinate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoAreaMonitor.setCenter", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QGeoAreaMonitorFunc_setRadius(PyObject* self, PyObject* arg)
{
    QtMobility::QGeoAreaMonitor* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QGeoAreaMonitor* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setRadius(qreal)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setRadius(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QGeoAreaMonitorFunc_setRadius_TypeError;

    // Call function/method
    {
        {
            qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setRadius(qreal)
            cppSelf->QtMobility::QGeoAreaMonitor::setRadius(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QGeoAreaMonitorFunc_setRadius_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Location.QGeoAreaMonitor.setRadius", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QGeoAreaMonitor_methods[] = {
    {"center", (PyCFunction)SbkQtMobility_QGeoAreaMonitorFunc_center, METH_NOARGS},
    {"createDefaultMonitor", (PyCFunction)SbkQtMobility_QGeoAreaMonitorFunc_createDefaultMonitor, METH_O|METH_STATIC},
    {"radius", (PyCFunction)SbkQtMobility_QGeoAreaMonitorFunc_radius, METH_NOARGS},
    {"setCenter", (PyCFunction)SbkQtMobility_QGeoAreaMonitorFunc_setCenter, METH_O},
    {"setRadius", (PyCFunction)SbkQtMobility_QGeoAreaMonitorFunc_setRadius, METH_O},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QGeoAreaMonitor_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Location.QGeoAreaMonitor",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QGeoAreaMonitor_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QGeoAreaMonitor_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QGeoAreaMonitor >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QGeoAreaMonitor*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QGeoAreaMonitor_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QGeoAreaMonitor*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QGeoAreaMonitor_Type;
    return 0;
}


void init_QtMobility_QGeoAreaMonitor(PyObject* module)
{
    SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOAREAMONITOR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QGeoAreaMonitor_Type);

    SbkQtMobility_QGeoAreaMonitor_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQtMobility_QGeoAreaMonitor_Type.type_discovery = &SbkQtMobility_QGeoAreaMonitor_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]), &SbkQtMobility_QGeoAreaMonitor_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QGeoAreaMonitor_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QGeoAreaMonitor_Type));
    PyModule_AddObject(module, "QGeoAreaMonitor",
        ((PyObject*)&SbkQtMobility_QGeoAreaMonitor_Type));

    // Initialize signals
    PyObject* signal_item;

    signal_item = PySide::signalNew("areaEntered", "const QtMobility::QGeoPositionInfo&", NULL);
    PyDict_SetItemString(SbkQtMobility_QGeoAreaMonitor_Type.super.ht_type.tp_dict, "areaEntered", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("areaExited", "const QtMobility::QGeoPositionInfo&", NULL);
    PyDict_SetItemString(SbkQtMobility_QGeoAreaMonitor_Type.super.ht_type.tp_dict, "areaExited", signal_item);
    Py_DECREF(signal_item);


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QGeoAreaMonitor >("QtMobility::QGeoAreaMonitor*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QGeoAreaMonitor >(typeid(QtMobility::QGeoAreaMonitor).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QGeoAreaMonitor >(typeid(QGeoAreaMonitorWrapper).name());
    PySide::initQtMetaType<QtMobility::QGeoAreaMonitor* >();
}

