/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_LOCATION_PYTHON_H
#define SBK_LOCATION_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#include <qsignal.h>
// Module Includes
#include <pyside_qtcore_python.h>

// Binded library includes
#include <qgeosatelliteinfosource.h>
#include <qgeopositioninfosource.h>
#include <qgeoareamonitor.h>
#include <qgeopositioninfo.h>
#include <qgeocoordinate.h>
#include <qnmeapositioninfosource.h>
#include <qgeosatelliteinfo.h>
// Conversion Includes - Primitive Types
#include <QString>
#include <signalmanager.h>
#include <typeresolver.h>
#include <QtConcurrentFilter>
#include <QTextDocument>

// Conversion Includes - Container Types
#include <QList>
#include <QMap>
#include <QStack>
#include <QMultiMap>
#include <QVector>
#include <QPair>
#include <pysideconversions.h>
#include <QSet>
#include <qqueue.h>
#include <QStringList>
#include <qlinkedlist.h>

// Type indices
#define SBK_QTMOBILITY_QGEOSATELLITEINFO_IDX                         0
#define SBK_QTMOBILITY_QGEOSATELLITEINFO_ATTRIBUTE_IDX               1
#define SBK_QTMOBILITY_QGEOCOORDINATE_IDX                            2
#define SBK_QTMOBILITY_QGEOCOORDINATE_COORDINATEFORMAT_IDX           3
#define SBK_QTMOBILITY_QGEOCOORDINATE_COORDINATETYPE_IDX             4
#define SBK_QTMOBILITY_QGEOPOSITIONINFO_IDX                          5
#define SBK_QTMOBILITY_QGEOPOSITIONINFO_ATTRIBUTE_IDX                6
#define SBK_QTMOBILITY_QGEOSATELLITEINFOSOURCE_IDX                   7
#define SBK_QTMOBILITY_QGEOPOSITIONINFOSOURCE_IDX                    8
#define SBK_QTMOBILITY_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX  9
#define SBK_QFLAGS_QTMOBILITY_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD__IDX 10
#define SBK_QTMOBILITY_QNMEAPOSITIONINFOSOURCE_IDX                   11
#define SBK_QTMOBILITY_QNMEAPOSITIONINFOSOURCE_UPDATEMODE_IDX        12
#define SBK_QTMOBILITY_QGEOAREAMONITOR_IDX                           13
#define SBK_Location_IDX_COUNT                                       14

// This variable stores all python types exported by this module
extern PyTypeObject** SbkQtMobility_LocationTypes;

// Macros for type check

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<QtMobility::QGeoSatelliteInfo::Attribute >() { return SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOSATELLITEINFO_ATTRIBUTE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QGeoSatelliteInfo >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOSATELLITEINFO_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QGeoCoordinate::CoordinateFormat >() { return SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOCOORDINATE_COORDINATEFORMAT_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QGeoCoordinate::CoordinateType >() { return SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOCOORDINATE_COORDINATETYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QGeoCoordinate >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOCOORDINATE_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QGeoPositionInfo::Attribute >() { return SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOPOSITIONINFO_ATTRIBUTE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QGeoPositionInfo >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOPOSITIONINFO_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QGeoSatelliteInfoSource >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOSATELLITEINFOSOURCE_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QGeoPositionInfoSource::PositioningMethod >() { return SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> >() { return SbkQtMobility_LocationTypes[SBK_QFLAGS_QTMOBILITY_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD__IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QGeoPositionInfoSource >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOPOSITIONINFOSOURCE_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QNmeaPositionInfoSource::UpdateMode >() { return SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QNMEAPOSITIONINFOSOURCE_UPDATEMODE_IDX]; }
template<> inline PyTypeObject* SbkType<QtMobility::QNmeaPositionInfoSource >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QNMEAPOSITIONINFOSOURCE_IDX]); }
template<> inline PyTypeObject* SbkType<QtMobility::QGeoAreaMonitor >() { return reinterpret_cast<PyTypeObject*>(SbkQtMobility_LocationTypes[SBK_QTMOBILITY_QGEOAREAMONITOR_IDX]); }

template<>
inline PyObject* createWrapper<QtMobility::QGeoSatelliteInfoSource >(const QtMobility::QGeoSatelliteInfoSource* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QGeoSatelliteInfoSource >()),const_cast<QtMobility::QGeoSatelliteInfoSource*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QGeoPositionInfoSource >(const QtMobility::QGeoPositionInfoSource* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QGeoPositionInfoSource >()),const_cast<QtMobility::QGeoPositionInfoSource*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QNmeaPositionInfoSource >(const QtMobility::QNmeaPositionInfoSource* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QNmeaPositionInfoSource >()),const_cast<QtMobility::QNmeaPositionInfoSource*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
template<>
inline PyObject* createWrapper<QtMobility::QGeoAreaMonitor >(const QtMobility::QGeoAreaMonitor* cppobj, bool hasOwnership, bool isExactType)
{
    PyObject* pyObj = Shiboken::SbkBaseWrapper_New(reinterpret_cast<SbkBaseWrapperType*>(SbkType<QtMobility::QGeoAreaMonitor >()),const_cast<QtMobility::QGeoAreaMonitor*>(cppobj), hasOwnership, isExactType);
    PySide::signalUpdateSource(pyObj);
    return pyObj;
}
// Generated converters declarations ----------------------------------

template<>
struct Converter<QtMobility::QGeoSatelliteInfo::Attribute > : EnumConverter<QtMobility::QGeoSatelliteInfo::Attribute >
{
};

template<>
struct Converter<QtMobility::QGeoSatelliteInfo > : ValueTypeConverter<QtMobility::QGeoSatelliteInfo >
{
};

template<>
struct Converter<QtMobility::QGeoCoordinate::CoordinateFormat > : EnumConverter<QtMobility::QGeoCoordinate::CoordinateFormat >
{
};

template<>
struct Converter<QtMobility::QGeoCoordinate::CoordinateType > : EnumConverter<QtMobility::QGeoCoordinate::CoordinateType >
{
};

template<>
struct Converter<QtMobility::QGeoCoordinate > : ValueTypeConverter<QtMobility::QGeoCoordinate >
{
};

template<>
struct Converter<QtMobility::QGeoPositionInfo::Attribute > : EnumConverter<QtMobility::QGeoPositionInfo::Attribute >
{
};

template<>
struct Converter<QtMobility::QGeoPositionInfo > : ValueTypeConverter<QtMobility::QGeoPositionInfo >
{
};

template<>
struct Converter<QtMobility::QGeoSatelliteInfoSource* > : ObjectTypeConverter<QtMobility::QGeoSatelliteInfoSource >
{
};

template<>
struct Converter<QtMobility::QGeoSatelliteInfoSource& > : ObjectTypeReferenceConverter<QtMobility::QGeoSatelliteInfoSource >
{
};

template<>
struct Converter<QtMobility::QGeoPositionInfoSource::PositioningMethod > : EnumConverter<QtMobility::QGeoPositionInfoSource::PositioningMethod >
{
};
template<>
struct Converter<QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> > : QFlagsConverter<QFlags<QtMobility::QGeoPositionInfoSource::PositioningMethod> >
{
};

template<>
struct Converter<QtMobility::QGeoPositionInfoSource* > : ObjectTypeConverter<QtMobility::QGeoPositionInfoSource >
{
};

template<>
struct Converter<QtMobility::QGeoPositionInfoSource& > : ObjectTypeReferenceConverter<QtMobility::QGeoPositionInfoSource >
{
};

template<>
struct Converter<QtMobility::QNmeaPositionInfoSource::UpdateMode > : EnumConverter<QtMobility::QNmeaPositionInfoSource::UpdateMode >
{
};

template<>
struct Converter<QtMobility::QNmeaPositionInfoSource* > : ObjectTypeConverter<QtMobility::QNmeaPositionInfoSource >
{
};

template<>
struct Converter<QtMobility::QNmeaPositionInfoSource& > : ObjectTypeReferenceConverter<QtMobility::QNmeaPositionInfoSource >
{
};

template<>
struct Converter<QtMobility::QGeoAreaMonitor* > : ObjectTypeConverter<QtMobility::QGeoAreaMonitor >
{
};

template<>
struct Converter<QtMobility::QGeoAreaMonitor& > : ObjectTypeReferenceConverter<QtMobility::QGeoAreaMonitor >
{
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------


#endif // SBK_LOCATION_PYTHON_H

