/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#include <Python.h>
#include <shiboken.h>
#include <algorithm>
#include "qtmobility_location_python.h"


// Global functions ------------------------------------------------------------

static PyMethodDef Location_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_QtMobility_QGeoSatelliteInfo(PyObject* module);
void init_QtMobility_QGeoCoordinate(PyObject* module);
void init_QtMobility_QGeoPositionInfo(PyObject* module);
void init_QtMobility_QGeoSatelliteInfoSource(PyObject* module);
void init_QtMobility_QGeoPositionInfoSource(PyObject* module);
void init_QtMobility_QNmeaPositionInfoSource(PyObject* module);
void init_QtMobility_QGeoAreaMonitor(PyObject* module);

PyTypeObject** SbkQtMobility_LocationTypes;

PyTypeObject** SbkPySide_QtCoreTypes;

// Module initialization ------------------------------------------------------------

#if defined _WIN32 || defined __CYGWIN__
    #define SBK_EXPORT_MODULE __declspec(dllexport)
#elif __GNUC__ >= 4
    #define SBK_EXPORT_MODULE __attribute__ ((visibility("default")))
#else
    #define SBK_EXPORT_MODULE
#endif

extern "C" SBK_EXPORT_MODULE void initLocation()
{
    if (!Shiboken::importModule("PySide.QtCore", &SbkPySide_QtCoreTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtCore");
        return;
    }

    Shiboken::initShiboken();
    PyObject* module = Py_InitModule("Location", Location_methods);

    // Create a CObject containing the API pointer array's address
    static PyTypeObject* cppApi[SBK_Location_IDX_COUNT];
    SbkQtMobility_LocationTypes = cppApi;
    PyObject* cppApiObject = PyCObject_FromVoidPtr(reinterpret_cast<void*>(cppApi), 0);
    PyModule_AddObject(module, "_Cpp_Api", cppApiObject);

    // Initialize classes in the type system
    init_QtMobility_QGeoSatelliteInfo(module);
    init_QtMobility_QGeoCoordinate(module);
    init_QtMobility_QGeoPositionInfo(module);
    init_QtMobility_QGeoSatelliteInfoSource(module);
    init_QtMobility_QGeoPositionInfoSource(module);
    init_QtMobility_QNmeaPositionInfoSource(module);
    init_QtMobility_QGeoAreaMonitor(module);

    // Register primitive types on TypeResolver
    Shiboken::TypeResolver::createValueTypeResolver<QList<QtMobility::QGeoSatelliteInfo> >("QList<QtMobility::QGeoSatelliteInfo>");

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module Location");
    }
}

