/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontacttimestamp_wrapper.h"

// Extra includes
#include <QMap>
#include <QStringList>
#include <qcontactdetail.h>
#include <qcontacttimestamp.h>
#include <qdatetime.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactTimestamp_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactTimestamp >()))
        return -1;

    QtMobility::QContactTimestamp* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactTimestamp", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactTimestamp(QtMobility::QContactTimestamp)
    // 1: QContactTimestamp()
    // 2: QContactTimestamp(QtMobility::QContactDetail)
    if (numArgs == 0) {
        overloadId = 1; // QContactTimestamp()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(arg)) {
        overloadId = 2; // QContactTimestamp(QtMobility::QContactDetail)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactTimestamp & >::isConvertible(arg)) {
        overloadId = 0; // QContactTimestamp(QtMobility::QContactTimestamp)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactTimestamp_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactTimestamp(QtMobility::QContactTimestamp)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactTimestamp > cpp_arg0_auto_ptr;
                QtMobility::QContactTimestamp* cpp_arg0 = Shiboken::Converter<QtMobility::QContactTimestamp* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactTimestamp >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactTimestamp >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactTimestamp(QtMobility::QContactTimestamp)
                cptr = new QtMobility::QContactTimestamp(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactTimestamp()
            {

                if(!PyErr_Occurred()) {
                // QContactTimestamp()
                cptr = new QtMobility::QContactTimestamp();
                }
                break;
            }
            case 2: // QContactTimestamp(QtMobility::QContactDetail)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactTimestamp(QtMobility::QContactDetail)
                cptr = new QtMobility::QContactTimestamp(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactTimestamp >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactTimestamp_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactTimestamp_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactTimestamp", "", "QtMobility.Contacts.QtMobility::QContactDetail", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactTimestamp", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactTimestampFunc_created(PyObject* self)
{
    QtMobility::QContactTimestamp* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactTimestamp* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // created()const
            QDateTime cppResult = cppSelf->QtMobility::QContactTimestamp::created();
            pyResult = Shiboken::Converter<QDateTime >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactTimestampFunc_lastModified(PyObject* self)
{
    QtMobility::QContactTimestamp* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactTimestamp* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // lastModified()const
            QDateTime cppResult = cppSelf->QtMobility::QContactTimestamp::lastModified();
            pyResult = Shiboken::Converter<QDateTime >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactTimestampFunc_setCreated(PyObject* self, PyObject* arg)
{
    QtMobility::QContactTimestamp* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactTimestamp* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setCreated(QDateTime)
    if (Shiboken::Converter<const QDateTime & >::isConvertible(arg)) {
        overloadId = 0; // setCreated(QDateTime)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactTimestampFunc_setCreated_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setCreated(QDateTime)
            cppSelf->QtMobility::QContactTimestamp::setCreated(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactTimestampFunc_setCreated_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactTimestamp.setCreated", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactTimestampFunc_setLastModified(PyObject* self, PyObject* arg)
{
    QtMobility::QContactTimestamp* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactTimestamp* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setLastModified(QDateTime)
    if (Shiboken::Converter<const QDateTime & >::isConvertible(arg)) {
        overloadId = 0; // setLastModified(QDateTime)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactTimestampFunc_setLastModified_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setLastModified(QDateTime)
            cppSelf->QtMobility::QContactTimestamp::setLastModified(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactTimestampFunc_setLastModified_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactTimestamp.setLastModified", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QContactTimestamp_methods[] = {
    {"created", (PyCFunction)SbkQtMobility_QContactTimestampFunc_created, METH_NOARGS},
    {"lastModified", (PyCFunction)SbkQtMobility_QContactTimestampFunc_lastModified, METH_NOARGS},
    {"setCreated", (PyCFunction)SbkQtMobility_QContactTimestampFunc_setCreated, METH_O},
    {"setLastModified", (PyCFunction)SbkQtMobility_QContactTimestampFunc_setLastModified, METH_O},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactTimestamp_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactTimestamp",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactTimestamp_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactTimestamp_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactTimestamp >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactTimestamp",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactTimestamp(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTTIMESTAMP_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactTimestamp_Type);

    SbkQtMobility_QContactTimestamp_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactTimestamp_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactTimestamp_Type));
    PyModule_AddObject(module, "QContactTimestamp",
        ((PyObject*)&SbkQtMobility_QContactTimestamp_Type));

    PyDict_SetItemString(SbkQtMobility_QContactTimestamp_Type.super.ht_type.tp_dict, "FieldModificationTimestamp", Shiboken::Converter<QString >::toPython(QtMobility::QContactTimestamp::FieldModificationTimestamp));
    PyDict_SetItemString(SbkQtMobility_QContactTimestamp_Type.super.ht_type.tp_dict, "DefinitionName", Shiboken::Converter<QString >::toPython(QtMobility::QContactTimestamp::DefinitionName));
    PyDict_SetItemString(SbkQtMobility_QContactTimestamp_Type.super.ht_type.tp_dict, "FieldCreationTimestamp", Shiboken::Converter<QString >::toPython(QtMobility::QContactTimestamp::FieldCreationTimestamp));

    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactTimestamp >("QtMobility::QContactTimestamp");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactTimestamp >("QtMobility::QContactTimestamp*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactTimestamp >(typeid(QtMobility::QContactTimestamp).name());
    PySide::initQtMetaType<QtMobility::QContactTimestamp >();
}

