/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactthumbnail_wrapper.h"

// Extra includes
#include <QMap>
#include <QStringList>
#include <qcontactdetail.h>
#include <qcontactthumbnail.h>
#include <qimage.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactThumbnail_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactThumbnail >()))
        return -1;

    QtMobility::QContactThumbnail* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactThumbnail", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactThumbnail(QtMobility::QContactThumbnail)
    // 1: QContactThumbnail()
    // 2: QContactThumbnail(QtMobility::QContactDetail)
    if (numArgs == 0) {
        overloadId = 1; // QContactThumbnail()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(arg)) {
        overloadId = 2; // QContactThumbnail(QtMobility::QContactDetail)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactThumbnail & >::isConvertible(arg)) {
        overloadId = 0; // QContactThumbnail(QtMobility::QContactThumbnail)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactThumbnail_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactThumbnail(QtMobility::QContactThumbnail)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactThumbnail > cpp_arg0_auto_ptr;
                QtMobility::QContactThumbnail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactThumbnail* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactThumbnail >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactThumbnail >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactThumbnail(QtMobility::QContactThumbnail)
                cptr = new QtMobility::QContactThumbnail(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactThumbnail()
            {

                if(!PyErr_Occurred()) {
                // QContactThumbnail()
                cptr = new QtMobility::QContactThumbnail();
                }
                break;
            }
            case 2: // QContactThumbnail(QtMobility::QContactDetail)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactThumbnail(QtMobility::QContactDetail)
                cptr = new QtMobility::QContactThumbnail(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactThumbnail >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactThumbnail_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactThumbnail_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactThumbnail", "", "QtMobility.Contacts.QtMobility::QContactDetail", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactThumbnail", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactThumbnailFunc_setThumbnail(PyObject* self, PyObject* arg)
{
    QtMobility::QContactThumbnail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactThumbnail* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setThumbnail(QImage)
    if (Shiboken::Converter<const QImage & >::isConvertible(arg)) {
        overloadId = 0; // setThumbnail(QImage)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactThumbnailFunc_setThumbnail_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QImage* cpp_arg0 = Shiboken::Converter<QImage* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setThumbnail(QImage)
            cppSelf->QtMobility::QContactThumbnail::setThumbnail(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactThumbnailFunc_setThumbnail_TypeError:
        const char* overloads[] = {"PySide.QtGui.QImage", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactThumbnail.setThumbnail", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactThumbnailFunc_thumbnail(PyObject* self)
{
    QtMobility::QContactThumbnail* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactThumbnail* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // thumbnail()const
            QImage cppResult = cppSelf->QtMobility::QContactThumbnail::thumbnail();
            pyResult = Shiboken::Converter<QImage >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QContactThumbnail_methods[] = {
    {"setThumbnail", (PyCFunction)SbkQtMobility_QContactThumbnailFunc_setThumbnail, METH_O},
    {"thumbnail", (PyCFunction)SbkQtMobility_QContactThumbnailFunc_thumbnail, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactThumbnail_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactThumbnail",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactThumbnail_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactThumbnail_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactThumbnail >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactThumbnail",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactThumbnail(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTTHUMBNAIL_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactThumbnail_Type);

    SbkQtMobility_QContactThumbnail_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactThumbnail_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactThumbnail_Type));
    PyModule_AddObject(module, "QContactThumbnail",
        ((PyObject*)&SbkQtMobility_QContactThumbnail_Type));

    PyDict_SetItemString(SbkQtMobility_QContactThumbnail_Type.super.ht_type.tp_dict, "FieldThumbnail", Shiboken::Converter<QString >::toPython(QtMobility::QContactThumbnail::FieldThumbnail));
    PyDict_SetItemString(SbkQtMobility_QContactThumbnail_Type.super.ht_type.tp_dict, "DefinitionName", Shiboken::Converter<QString >::toPython(QtMobility::QContactThumbnail::DefinitionName));

    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactThumbnail >("QtMobility::QContactThumbnail");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactThumbnail >("QtMobility::QContactThumbnail*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactThumbnail >(typeid(QtMobility::QContactThumbnail).name());
    PySide::initQtMetaType<QtMobility::QContactThumbnail >();
}

