/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactsortorder_wrapper.h"

// Extra includes
#include <qcontactsortorder.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactSortOrder_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactSortOrder >()))
        return -1;

    QtMobility::QContactSortOrder* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactSortOrder", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactSortOrder()
    // 1: QContactSortOrder(QtMobility::QContactSortOrder)
    if (numArgs == 0) {
        overloadId = 0; // QContactSortOrder()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactSortOrder & >::isConvertible(arg)) {
        overloadId = 1; // QContactSortOrder(QtMobility::QContactSortOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactSortOrder_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactSortOrder()
            {

                if(!PyErr_Occurred()) {
                // QContactSortOrder()
                cptr = new QtMobility::QContactSortOrder();
                }
                break;
            }
            case 1: // QContactSortOrder(QtMobility::QContactSortOrder)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactSortOrder* cpp_arg0 = Shiboken::Converter<QtMobility::QContactSortOrder* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactSortOrder(QtMobility::QContactSortOrder)
                cptr = new QtMobility::QContactSortOrder(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactSortOrder >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactSortOrder_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactSortOrder_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Contacts.QtMobility::QContactSortOrder", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactSortOrder", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactSortOrderFunc_blankPolicy(PyObject* self)
{
    QtMobility::QContactSortOrder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactSortOrder* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // blankPolicy()const
            QtMobility::QContactSortOrder::BlankPolicy cppResult = cppSelf->QtMobility::QContactSortOrder::blankPolicy();
            pyResult = Shiboken::Converter<QtMobility::QContactSortOrder::BlankPolicy >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactSortOrderFunc_caseSensitivity(PyObject* self)
{
    QtMobility::QContactSortOrder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactSortOrder* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // caseSensitivity()const
            Qt::CaseSensitivity cppResult = cppSelf->QtMobility::QContactSortOrder::caseSensitivity();
            pyResult = Shiboken::Converter<Qt::CaseSensitivity >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactSortOrderFunc_detailDefinitionName(PyObject* self)
{
    QtMobility::QContactSortOrder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactSortOrder* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // detailDefinitionName()const
            QString cppResult = cppSelf->QtMobility::QContactSortOrder::detailDefinitionName();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactSortOrderFunc_detailFieldName(PyObject* self)
{
    QtMobility::QContactSortOrder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactSortOrder* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // detailFieldName()const
            QString cppResult = cppSelf->QtMobility::QContactSortOrder::detailFieldName();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactSortOrderFunc_direction(PyObject* self)
{
    QtMobility::QContactSortOrder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactSortOrder* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // direction()const
            Qt::SortOrder cppResult = cppSelf->QtMobility::QContactSortOrder::direction();
            pyResult = Shiboken::Converter<Qt::SortOrder >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactSortOrderFunc_isValid(PyObject* self)
{
    QtMobility::QContactSortOrder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactSortOrder* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = cppSelf->QtMobility::QContactSortOrder::isValid();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactSortOrderFunc_setBlankPolicy(PyObject* self, PyObject* arg)
{
    QtMobility::QContactSortOrder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactSortOrder* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setBlankPolicy(QtMobility::QContactSortOrder::BlankPolicy)
    if (Shiboken::Converter<QtMobility::QContactSortOrder::BlankPolicy >::isConvertible(arg)) {
        overloadId = 0; // setBlankPolicy(QtMobility::QContactSortOrder::BlankPolicy)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactSortOrderFunc_setBlankPolicy_TypeError;

    // Call function/method
    {
        {
            QtMobility::QContactSortOrder::BlankPolicy cpp_arg0 = Shiboken::Converter<QtMobility::QContactSortOrder::BlankPolicy >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setBlankPolicy(QtMobility::QContactSortOrder::BlankPolicy)
            cppSelf->QtMobility::QContactSortOrder::setBlankPolicy(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactSortOrderFunc_setBlankPolicy_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactSortOrder.BlankPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactSortOrder.setBlankPolicy", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactSortOrderFunc_setCaseSensitivity(PyObject* self, PyObject* arg)
{
    QtMobility::QContactSortOrder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactSortOrder* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setCaseSensitivity(Qt::CaseSensitivity)
    if (Shiboken::Converter<Qt::CaseSensitivity >::isConvertible(arg)) {
        overloadId = 0; // setCaseSensitivity(Qt::CaseSensitivity)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactSortOrderFunc_setCaseSensitivity_TypeError;

    // Call function/method
    {
        {
            Qt::CaseSensitivity cpp_arg0 = Shiboken::Converter<Qt::CaseSensitivity >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setCaseSensitivity(Qt::CaseSensitivity)
            cppSelf->QtMobility::QContactSortOrder::setCaseSensitivity(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactSortOrderFunc_setCaseSensitivity_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.CaseSensitivity", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactSortOrder.setCaseSensitivity", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactSortOrderFunc_setDetailDefinitionName(PyObject* self, PyObject* args)
{
    QtMobility::QContactSortOrder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactSortOrder* >::toCpp(self);

    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setDetailDefinitionName", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: setDetailDefinitionName(QString,QString)
    if (numArgs == 2 && Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
        overloadId = 0; // setDetailDefinitionName(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactSortOrderFunc_setDetailDefinitionName_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // setDetailDefinitionName(QString,QString)
            cppSelf->QtMobility::QContactSortOrder::setDetailDefinitionName(cpp_arg0, cpp_arg1);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactSortOrderFunc_setDetailDefinitionName_TypeError:
        const char* overloads[] = {"QString, QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactSortOrder.setDetailDefinitionName", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactSortOrderFunc_setDirection(PyObject* self, PyObject* arg)
{
    QtMobility::QContactSortOrder* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactSortOrder* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setDirection(Qt::SortOrder)
    if (Shiboken::Converter<Qt::SortOrder >::isConvertible(arg)) {
        overloadId = 0; // setDirection(Qt::SortOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactSortOrderFunc_setDirection_TypeError;

    // Call function/method
    {
        {
            Qt::SortOrder cpp_arg0 = Shiboken::Converter<Qt::SortOrder >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setDirection(Qt::SortOrder)
            cppSelf->QtMobility::QContactSortOrder::setDirection(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactSortOrderFunc_setDirection_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.SortOrder", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactSortOrder.setDirection", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QContactSortOrder_methods[] = {
    {"blankPolicy", (PyCFunction)SbkQtMobility_QContactSortOrderFunc_blankPolicy, METH_NOARGS},
    {"caseSensitivity", (PyCFunction)SbkQtMobility_QContactSortOrderFunc_caseSensitivity, METH_NOARGS},
    {"detailDefinitionName", (PyCFunction)SbkQtMobility_QContactSortOrderFunc_detailDefinitionName, METH_NOARGS},
    {"detailFieldName", (PyCFunction)SbkQtMobility_QContactSortOrderFunc_detailFieldName, METH_NOARGS},
    {"direction", (PyCFunction)SbkQtMobility_QContactSortOrderFunc_direction, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQtMobility_QContactSortOrderFunc_isValid, METH_NOARGS},
    {"setBlankPolicy", (PyCFunction)SbkQtMobility_QContactSortOrderFunc_setBlankPolicy, METH_O},
    {"setCaseSensitivity", (PyCFunction)SbkQtMobility_QContactSortOrderFunc_setCaseSensitivity, METH_O},
    {"setDetailDefinitionName", (PyCFunction)SbkQtMobility_QContactSortOrderFunc_setDetailDefinitionName, METH_VARARGS},
    {"setDirection", (PyCFunction)SbkQtMobility_QContactSortOrderFunc_setDirection, METH_O},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQtMobility_QContactSortOrder_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QContactSortOrder& cpp_self = *Shiboken::Converter<QtMobility::QContactSortOrder* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QContactSortOrder & >::isConvertible(other)) {
                // operator!=(const QtMobility::QContactSortOrder & other) const
                QtMobility::QContactSortOrder* cpp_other = Shiboken::Converter<QtMobility::QContactSortOrder* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QContactSortOrder  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QContactSortOrder_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QContactSortOrder & >::isConvertible(other)) {
                // operator==(const QtMobility::QContactSortOrder & other) const
                QtMobility::QContactSortOrder* cpp_other = Shiboken::Converter<QtMobility::QContactSortOrder* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QContactSortOrder  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QContactSortOrder_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QContactSortOrder_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactSortOrder_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactSortOrder",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QContactSortOrder_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactSortOrder_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactSortOrder_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactSortOrder >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactSortOrder",
    /*user_data*/           0
};
} //extern

static PyGetSetDef SbkQtMobility_Contacts_QtMobility_QContactSortOrder_BlankPolicy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Contacts_QtMobility_QContactSortOrder_BlankPolicy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Contacts_QtMobility_QContactSortOrder_BlankPolicy_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "BlankPolicy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Contacts_QtMobility_QContactSortOrder_BlankPolicy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Contacts_QtMobility_QContactSortOrder_BlankPolicy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Contacts_QtMobility_QContactSortOrder_BlankPolicy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QContactSortOrder(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTSORTORDER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactSortOrder_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactSortOrder_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactSortOrder_Type));
    PyModule_AddObject(module, "QContactSortOrder",
        ((PyObject*)&SbkQtMobility_QContactSortOrder_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: BlankPolicy
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTSORTORDER_BLANKPOLICY_IDX] = &SbkQtMobility_Contacts_QtMobility_QContactSortOrder_BlankPolicy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Contacts_QtMobility_QContactSortOrder_BlankPolicy_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Contacts_QtMobility_QContactSortOrder_BlankPolicy_Type);
    PyDict_SetItemString(SbkQtMobility_QContactSortOrder_Type.super.ht_type.tp_dict,
            "BlankPolicy",((PyObject*)&SbkQtMobility_Contacts_QtMobility_QContactSortOrder_BlankPolicy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactSortOrder_BlankPolicy_Type,
        (long) QtMobility::QContactSortOrder::BlanksFirst, "BlanksFirst");
    PyDict_SetItemString(SbkQtMobility_QContactSortOrder_Type.super.ht_type.tp_dict,
        "BlanksFirst", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactSortOrder_BlankPolicy_Type.tp_dict,
        "BlanksFirst", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactSortOrder_BlankPolicy_Type,
        (long) QtMobility::QContactSortOrder::BlanksLast, "BlanksLast");
    PyDict_SetItemString(SbkQtMobility_QContactSortOrder_Type.super.ht_type.tp_dict,
        "BlanksLast", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactSortOrder_BlankPolicy_Type.tp_dict,
        "BlanksLast", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QContactSortOrder::BlankPolicy");


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactSortOrder >("QtMobility::QContactSortOrder");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactSortOrder >("QtMobility::QContactSortOrder*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactSortOrder >(typeid(QtMobility::QContactSortOrder).name());
    PySide::initQtMetaType<QtMobility::QContactSortOrder >();
}

