/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactrelationshipfilter_wrapper.h"

// Extra includes
#include <qcontactfilter.h>
#include <qcontactid.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactRelationshipFilter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactRelationshipFilter >()))
        return -1;

    QtMobility::QContactRelationshipFilter* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactRelationshipFilter", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactRelationshipFilter(QtMobility::QContactRelationshipFilter)
    // 1: QContactRelationshipFilter()
    // 2: QContactRelationshipFilter(QtMobility::QContactFilter)
    if (numArgs == 0) {
        overloadId = 1; // QContactRelationshipFilter()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(arg)) {
        overloadId = 2; // QContactRelationshipFilter(QtMobility::QContactFilter)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactRelationshipFilter & >::isConvertible(arg)) {
        overloadId = 0; // QContactRelationshipFilter(QtMobility::QContactRelationshipFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactRelationshipFilter_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactRelationshipFilter(QtMobility::QContactRelationshipFilter)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactRelationshipFilter > cpp_arg0_auto_ptr;
                QtMobility::QContactRelationshipFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactRelationshipFilter* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactRelationshipFilter >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactRelationshipFilter >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactRelationshipFilter(QtMobility::QContactRelationshipFilter)
                cptr = new QtMobility::QContactRelationshipFilter(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactRelationshipFilter()
            {

                if(!PyErr_Occurred()) {
                // QContactRelationshipFilter()
                cptr = new QtMobility::QContactRelationshipFilter();
                }
                break;
            }
            case 2: // QContactRelationshipFilter(QtMobility::QContactFilter)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactRelationshipFilter(QtMobility::QContactFilter)
                cptr = new QtMobility::QContactRelationshipFilter(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactRelationshipFilter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactRelationshipFilter_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactRelationshipFilter_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactRelationshipFilter", "", "QtMobility.Contacts.QtMobility::QContactFilter", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactRelationshipFilter", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactRelationshipFilterFunc_relatedContactId(PyObject* self)
{
    QtMobility::QContactRelationshipFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactRelationshipFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // relatedContactId()const
            QtMobility::QContactId cppResult = cppSelf->QtMobility::QContactRelationshipFilter::relatedContactId();
            pyResult = Shiboken::Converter<QtMobility::QContactId >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactRelationshipFilterFunc_relatedContactRole(PyObject* self)
{
    QtMobility::QContactRelationshipFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactRelationshipFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // relatedContactRole()const
            QtMobility::QContactRelationship::Role cppResult = cppSelf->QtMobility::QContactRelationshipFilter::relatedContactRole();
            pyResult = Shiboken::Converter<QtMobility::QContactRelationship::Role >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactRelationshipFilterFunc_relationshipType(PyObject* self)
{
    QtMobility::QContactRelationshipFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactRelationshipFilter* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // relationshipType()const
            QString cppResult = cppSelf->QtMobility::QContactRelationshipFilter::relationshipType();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactRelationshipFilterFunc_setRelatedContactId(PyObject* self, PyObject* arg)
{
    QtMobility::QContactRelationshipFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactRelationshipFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setRelatedContactId(QtMobility::QContactId)
    if (Shiboken::Converter<const QtMobility::QContactId & >::isConvertible(arg)) {
        overloadId = 0; // setRelatedContactId(QtMobility::QContactId)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactRelationshipFilterFunc_setRelatedContactId_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactId* cpp_arg0 = Shiboken::Converter<QtMobility::QContactId* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setRelatedContactId(QtMobility::QContactId)
            cppSelf->QtMobility::QContactRelationshipFilter::setRelatedContactId(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactRelationshipFilterFunc_setRelatedContactId_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactId", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactRelationshipFilter.setRelatedContactId", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactRelationshipFilterFunc_setRelatedContactRole(PyObject* self, PyObject* arg)
{
    QtMobility::QContactRelationshipFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactRelationshipFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setRelatedContactRole(QtMobility::QContactRelationship::Role)
    if (Shiboken::Converter<QtMobility::QContactRelationship::Role >::isConvertible(arg)) {
        overloadId = 0; // setRelatedContactRole(QtMobility::QContactRelationship::Role)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactRelationshipFilterFunc_setRelatedContactRole_TypeError;

    // Call function/method
    {
        {
            QtMobility::QContactRelationship::Role cpp_arg0 = Shiboken::Converter<QtMobility::QContactRelationship::Role >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setRelatedContactRole(QtMobility::QContactRelationship::Role)
            cppSelf->QtMobility::QContactRelationshipFilter::setRelatedContactRole(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactRelationshipFilterFunc_setRelatedContactRole_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactRelationship.Role", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactRelationshipFilter.setRelatedContactRole", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactRelationshipFilterFunc_setRelationshipType(PyObject* self, PyObject* arg)
{
    QtMobility::QContactRelationshipFilter* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactRelationshipFilter* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setRelationshipType(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setRelationshipType(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactRelationshipFilterFunc_setRelationshipType_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setRelationshipType(QString)
            cppSelf->QtMobility::QContactRelationshipFilter::setRelationshipType(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactRelationshipFilterFunc_setRelationshipType_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactRelationshipFilter.setRelationshipType", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QContactRelationshipFilter_methods[] = {
    {"relatedContactId", (PyCFunction)SbkQtMobility_QContactRelationshipFilterFunc_relatedContactId, METH_NOARGS},
    {"relatedContactRole", (PyCFunction)SbkQtMobility_QContactRelationshipFilterFunc_relatedContactRole, METH_NOARGS},
    {"relationshipType", (PyCFunction)SbkQtMobility_QContactRelationshipFilterFunc_relationshipType, METH_NOARGS},
    {"setRelatedContactId", (PyCFunction)SbkQtMobility_QContactRelationshipFilterFunc_setRelatedContactId, METH_O},
    {"setRelatedContactRole", (PyCFunction)SbkQtMobility_QContactRelationshipFilterFunc_setRelatedContactRole, METH_O},
    {"setRelationshipType", (PyCFunction)SbkQtMobility_QContactRelationshipFilterFunc_setRelationshipType, METH_O},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactRelationshipFilter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactRelationshipFilter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactRelationshipFilter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactRelationshipFilter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactRelationshipFilter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactRelationshipFilter",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactRelationshipFilter(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTRELATIONSHIPFILTER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactRelationshipFilter_Type);

    SbkQtMobility_QContactRelationshipFilter_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTFILTER_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactRelationshipFilter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactRelationshipFilter_Type));
    PyModule_AddObject(module, "QContactRelationshipFilter",
        ((PyObject*)&SbkQtMobility_QContactRelationshipFilter_Type));


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactRelationshipFilter >("QtMobility::QContactRelationshipFilter");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactRelationshipFilter >("QtMobility::QContactRelationshipFilter*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactRelationshipFilter >(typeid(QtMobility::QContactRelationshipFilter).name());
    PySide::initQtMetaType<QtMobility::QContactRelationshipFilter >();
}

