/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactphonenumber_wrapper.h"

// Extra includes
#include <QMap>
#include <QStringList>
#include <qcontactdetail.h>
#include <qcontactfilter.h>
#include <qcontactphonenumber.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactPhoneNumber_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactPhoneNumber >()))
        return -1;

    QtMobility::QContactPhoneNumber* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactPhoneNumber", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactPhoneNumber(QtMobility::QContactPhoneNumber)
    // 1: QContactPhoneNumber()
    // 2: QContactPhoneNumber(QtMobility::QContactDetail)
    if (numArgs == 0) {
        overloadId = 1; // QContactPhoneNumber()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(arg)) {
        overloadId = 2; // QContactPhoneNumber(QtMobility::QContactDetail)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactPhoneNumber & >::isConvertible(arg)) {
        overloadId = 0; // QContactPhoneNumber(QtMobility::QContactPhoneNumber)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactPhoneNumber_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactPhoneNumber(QtMobility::QContactPhoneNumber)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactPhoneNumber > cpp_arg0_auto_ptr;
                QtMobility::QContactPhoneNumber* cpp_arg0 = Shiboken::Converter<QtMobility::QContactPhoneNumber* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactPhoneNumber >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactPhoneNumber >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactPhoneNumber(QtMobility::QContactPhoneNumber)
                cptr = new QtMobility::QContactPhoneNumber(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactPhoneNumber()
            {

                if(!PyErr_Occurred()) {
                // QContactPhoneNumber()
                cptr = new QtMobility::QContactPhoneNumber();
                }
                break;
            }
            case 2: // QContactPhoneNumber(QtMobility::QContactDetail)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactPhoneNumber(QtMobility::QContactDetail)
                cptr = new QtMobility::QContactPhoneNumber(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactPhoneNumber >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactPhoneNumber_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactPhoneNumber_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactPhoneNumber", "", "QtMobility.Contacts.QtMobility::QContactDetail", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactPhoneNumber", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactPhoneNumberFunc_match(PyObject* self, PyObject* arg)
{
    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: match(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // match(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactPhoneNumberFunc_match_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // match(QString)
            QtMobility::QContactFilter cppResult = QtMobility::QContactPhoneNumber::match(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QContactFilter >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactPhoneNumberFunc_match_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactPhoneNumber.match", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactPhoneNumberFunc_number(PyObject* self)
{
    QtMobility::QContactPhoneNumber* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactPhoneNumber* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // number()const
            QString cppResult = cppSelf->QtMobility::QContactPhoneNumber::number();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactPhoneNumberFunc_setNumber(PyObject* self, PyObject* arg)
{
    QtMobility::QContactPhoneNumber* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactPhoneNumber* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setNumber(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setNumber(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactPhoneNumberFunc_setNumber_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setNumber(QString)
            cppSelf->QtMobility::QContactPhoneNumber::setNumber(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactPhoneNumberFunc_setNumber_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactPhoneNumber.setNumber", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactPhoneNumberFunc_setSubTypes(PyObject* self, PyObject* arg)
{
    QtMobility::QContactPhoneNumber* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactPhoneNumber* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setSubTypes(QString)
    // 1: setSubTypes(QStringList)
    if (Shiboken::Converter< QStringList  >::isConvertible(arg)) {
        overloadId = 1; // setSubTypes(QStringList)
    } else if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setSubTypes(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactPhoneNumberFunc_setSubTypes_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // setSubTypes(QString)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // setSubTypes(QString)
                cppSelf->QtMobility::QContactPhoneNumber::setSubTypes(cpp_arg0);
                }
                break;
            }
            case 1: // setSubTypes(QStringList)
            {
                QStringList cpp_arg0 = Shiboken::Converter<QStringList >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // setSubTypes(QStringList)
                cppSelf->QtMobility::QContactPhoneNumber::setSubTypes(cpp_arg0);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactPhoneNumberFunc_setSubTypes_TypeError:
        const char* overloads[] = {"QString", "list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactPhoneNumber.setSubTypes", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactPhoneNumberFunc_subTypes(PyObject* self)
{
    QtMobility::QContactPhoneNumber* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactPhoneNumber* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // subTypes()const
            QStringList cppResult = cppSelf->QtMobility::QContactPhoneNumber::subTypes();
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QContactPhoneNumber_methods[] = {
    {"match", (PyCFunction)SbkQtMobility_QContactPhoneNumberFunc_match, METH_O|METH_STATIC},
    {"number", (PyCFunction)SbkQtMobility_QContactPhoneNumberFunc_number, METH_NOARGS},
    {"setNumber", (PyCFunction)SbkQtMobility_QContactPhoneNumberFunc_setNumber, METH_O},
    {"setSubTypes", (PyCFunction)SbkQtMobility_QContactPhoneNumberFunc_setSubTypes, METH_O},
    {"subTypes", (PyCFunction)SbkQtMobility_QContactPhoneNumberFunc_subTypes, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactPhoneNumber_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactPhoneNumber",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactPhoneNumber_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactPhoneNumber_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactPhoneNumber >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactPhoneNumber",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactPhoneNumber(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTPHONENUMBER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactPhoneNumber_Type);

    SbkQtMobility_QContactPhoneNumber_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactPhoneNumber_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactPhoneNumber_Type));
    PyModule_AddObject(module, "QContactPhoneNumber",
        ((PyObject*)&SbkQtMobility_QContactPhoneNumber_Type));

    PyDict_SetItemString(SbkQtMobility_QContactPhoneNumber_Type.super.ht_type.tp_dict, "SubTypeMessagingCapable", Shiboken::Converter<QString >::toPython(QtMobility::QContactPhoneNumber::SubTypeMessagingCapable));
    PyDict_SetItemString(SbkQtMobility_QContactPhoneNumber_Type.super.ht_type.tp_dict, "SubTypeAssistant", Shiboken::Converter<QString >::toPython(QtMobility::QContactPhoneNumber::SubTypeAssistant));
    PyDict_SetItemString(SbkQtMobility_QContactPhoneNumber_Type.super.ht_type.tp_dict, "FieldNumber", Shiboken::Converter<QString >::toPython(QtMobility::QContactPhoneNumber::FieldNumber));
    PyDict_SetItemString(SbkQtMobility_QContactPhoneNumber_Type.super.ht_type.tp_dict, "SubTypePager", Shiboken::Converter<QString >::toPython(QtMobility::QContactPhoneNumber::SubTypePager));
    PyDict_SetItemString(SbkQtMobility_QContactPhoneNumber_Type.super.ht_type.tp_dict, "SubTypeVoice", Shiboken::Converter<QString >::toPython(QtMobility::QContactPhoneNumber::SubTypeVoice));
    PyDict_SetItemString(SbkQtMobility_QContactPhoneNumber_Type.super.ht_type.tp_dict, "FieldSubTypes", Shiboken::Converter<QString >::toPython(QtMobility::QContactPhoneNumber::FieldSubTypes));
    PyDict_SetItemString(SbkQtMobility_QContactPhoneNumber_Type.super.ht_type.tp_dict, "SubTypeCar", Shiboken::Converter<QString >::toPython(QtMobility::QContactPhoneNumber::SubTypeCar));
    PyDict_SetItemString(SbkQtMobility_QContactPhoneNumber_Type.super.ht_type.tp_dict, "SubTypeDtmfMenu", Shiboken::Converter<QString >::toPython(QtMobility::QContactPhoneNumber::SubTypeDtmfMenu));
    PyDict_SetItemString(SbkQtMobility_QContactPhoneNumber_Type.super.ht_type.tp_dict, "SubTypeFax", Shiboken::Converter<QString >::toPython(QtMobility::QContactPhoneNumber::SubTypeFax));
    PyDict_SetItemString(SbkQtMobility_QContactPhoneNumber_Type.super.ht_type.tp_dict, "SubTypeBulletinBoardSystem", Shiboken::Converter<QString >::toPython(QtMobility::QContactPhoneNumber::SubTypeBulletinBoardSystem));
    PyDict_SetItemString(SbkQtMobility_QContactPhoneNumber_Type.super.ht_type.tp_dict, "SubTypeLandline", Shiboken::Converter<QString >::toPython(QtMobility::QContactPhoneNumber::SubTypeLandline));
    PyDict_SetItemString(SbkQtMobility_QContactPhoneNumber_Type.super.ht_type.tp_dict, "SubTypeVideo", Shiboken::Converter<QString >::toPython(QtMobility::QContactPhoneNumber::SubTypeVideo));
    PyDict_SetItemString(SbkQtMobility_QContactPhoneNumber_Type.super.ht_type.tp_dict, "SubTypeModem", Shiboken::Converter<QString >::toPython(QtMobility::QContactPhoneNumber::SubTypeModem));
    PyDict_SetItemString(SbkQtMobility_QContactPhoneNumber_Type.super.ht_type.tp_dict, "DefinitionName", Shiboken::Converter<QString >::toPython(QtMobility::QContactPhoneNumber::DefinitionName));
    PyDict_SetItemString(SbkQtMobility_QContactPhoneNumber_Type.super.ht_type.tp_dict, "SubTypeMobile", Shiboken::Converter<QString >::toPython(QtMobility::QContactPhoneNumber::SubTypeMobile));

    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactPhoneNumber >("QtMobility::QContactPhoneNumber");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactPhoneNumber >("QtMobility::QContactPhoneNumber*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactPhoneNumber >(typeid(QtMobility::QContactPhoneNumber).name());
    PySide::initQtMetaType<QtMobility::QContactPhoneNumber >();
}

