/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactonlineaccount_wrapper.h"

// Extra includes
#include <QMap>
#include <QStringList>
#include <qcontactdetail.h>
#include <qcontactonlineaccount.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactOnlineAccount_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactOnlineAccount >()))
        return -1;

    QtMobility::QContactOnlineAccount* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactOnlineAccount", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactOnlineAccount(QtMobility::QContactOnlineAccount)
    // 1: QContactOnlineAccount()
    // 2: QContactOnlineAccount(QtMobility::QContactDetail)
    if (numArgs == 0) {
        overloadId = 1; // QContactOnlineAccount()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(arg)) {
        overloadId = 2; // QContactOnlineAccount(QtMobility::QContactDetail)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactOnlineAccount & >::isConvertible(arg)) {
        overloadId = 0; // QContactOnlineAccount(QtMobility::QContactOnlineAccount)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactOnlineAccount_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactOnlineAccount(QtMobility::QContactOnlineAccount)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactOnlineAccount > cpp_arg0_auto_ptr;
                QtMobility::QContactOnlineAccount* cpp_arg0 = Shiboken::Converter<QtMobility::QContactOnlineAccount* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactOnlineAccount >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactOnlineAccount >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactOnlineAccount(QtMobility::QContactOnlineAccount)
                cptr = new QtMobility::QContactOnlineAccount(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactOnlineAccount()
            {

                if(!PyErr_Occurred()) {
                // QContactOnlineAccount()
                cptr = new QtMobility::QContactOnlineAccount();
                }
                break;
            }
            case 2: // QContactOnlineAccount(QtMobility::QContactDetail)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactOnlineAccount(QtMobility::QContactDetail)
                cptr = new QtMobility::QContactOnlineAccount(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactOnlineAccount >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactOnlineAccount_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactOnlineAccount_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactOnlineAccount", "", "QtMobility.Contacts.QtMobility::QContactDetail", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactOnlineAccount", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactOnlineAccountFunc_accountUri(PyObject* self)
{
    QtMobility::QContactOnlineAccount* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOnlineAccount* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // accountUri()const
            QString cppResult = cppSelf->QtMobility::QContactOnlineAccount::accountUri();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactOnlineAccountFunc_capabilities(PyObject* self)
{
    QtMobility::QContactOnlineAccount* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOnlineAccount* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // capabilities()const
            QStringList cppResult = cppSelf->QtMobility::QContactOnlineAccount::capabilities();
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactOnlineAccountFunc_serviceProvider(PyObject* self)
{
    QtMobility::QContactOnlineAccount* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOnlineAccount* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // serviceProvider()const
            QString cppResult = cppSelf->QtMobility::QContactOnlineAccount::serviceProvider();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactOnlineAccountFunc_setAccountUri(PyObject* self, PyObject* arg)
{
    QtMobility::QContactOnlineAccount* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOnlineAccount* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setAccountUri(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setAccountUri(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactOnlineAccountFunc_setAccountUri_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setAccountUri(QString)
            cppSelf->QtMobility::QContactOnlineAccount::setAccountUri(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactOnlineAccountFunc_setAccountUri_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactOnlineAccount.setAccountUri", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactOnlineAccountFunc_setCapabilities(PyObject* self, PyObject* arg)
{
    QtMobility::QContactOnlineAccount* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOnlineAccount* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setCapabilities(QStringList)
    if (Shiboken::Converter< QStringList  >::isConvertible(arg)) {
        overloadId = 0; // setCapabilities(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactOnlineAccountFunc_setCapabilities_TypeError;

    // Call function/method
    {
        {
            QStringList cpp_arg0 = Shiboken::Converter<QStringList >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setCapabilities(QStringList)
            cppSelf->QtMobility::QContactOnlineAccount::setCapabilities(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactOnlineAccountFunc_setCapabilities_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactOnlineAccount.setCapabilities", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactOnlineAccountFunc_setServiceProvider(PyObject* self, PyObject* arg)
{
    QtMobility::QContactOnlineAccount* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOnlineAccount* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setServiceProvider(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setServiceProvider(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactOnlineAccountFunc_setServiceProvider_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setServiceProvider(QString)
            cppSelf->QtMobility::QContactOnlineAccount::setServiceProvider(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactOnlineAccountFunc_setServiceProvider_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactOnlineAccount.setServiceProvider", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactOnlineAccountFunc_setSubTypes(PyObject* self, PyObject* arg)
{
    QtMobility::QContactOnlineAccount* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOnlineAccount* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setSubTypes(QString)
    // 1: setSubTypes(QStringList)
    if (Shiboken::Converter< QStringList  >::isConvertible(arg)) {
        overloadId = 1; // setSubTypes(QStringList)
    } else if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setSubTypes(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactOnlineAccountFunc_setSubTypes_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // setSubTypes(QString)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // setSubTypes(QString)
                cppSelf->QtMobility::QContactOnlineAccount::setSubTypes(cpp_arg0);
                }
                break;
            }
            case 1: // setSubTypes(QStringList)
            {
                QStringList cpp_arg0 = Shiboken::Converter<QStringList >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // setSubTypes(QStringList)
                cppSelf->QtMobility::QContactOnlineAccount::setSubTypes(cpp_arg0);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactOnlineAccountFunc_setSubTypes_TypeError:
        const char* overloads[] = {"QString", "list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactOnlineAccount.setSubTypes", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactOnlineAccountFunc_subTypes(PyObject* self)
{
    QtMobility::QContactOnlineAccount* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactOnlineAccount* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // subTypes()const
            QStringList cppResult = cppSelf->QtMobility::QContactOnlineAccount::subTypes();
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QContactOnlineAccount_methods[] = {
    {"accountUri", (PyCFunction)SbkQtMobility_QContactOnlineAccountFunc_accountUri, METH_NOARGS},
    {"capabilities", (PyCFunction)SbkQtMobility_QContactOnlineAccountFunc_capabilities, METH_NOARGS},
    {"serviceProvider", (PyCFunction)SbkQtMobility_QContactOnlineAccountFunc_serviceProvider, METH_NOARGS},
    {"setAccountUri", (PyCFunction)SbkQtMobility_QContactOnlineAccountFunc_setAccountUri, METH_O},
    {"setCapabilities", (PyCFunction)SbkQtMobility_QContactOnlineAccountFunc_setCapabilities, METH_O},
    {"setServiceProvider", (PyCFunction)SbkQtMobility_QContactOnlineAccountFunc_setServiceProvider, METH_O},
    {"setSubTypes", (PyCFunction)SbkQtMobility_QContactOnlineAccountFunc_setSubTypes, METH_O},
    {"subTypes", (PyCFunction)SbkQtMobility_QContactOnlineAccountFunc_subTypes, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactOnlineAccount_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactOnlineAccount",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactOnlineAccount_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactOnlineAccount_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactOnlineAccount >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactOnlineAccount",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactOnlineAccount(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTONLINEACCOUNT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactOnlineAccount_Type);

    SbkQtMobility_QContactOnlineAccount_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactOnlineAccount_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactOnlineAccount_Type));
    PyModule_AddObject(module, "QContactOnlineAccount",
        ((PyObject*)&SbkQtMobility_QContactOnlineAccount_Type));

    PyDict_SetItemString(SbkQtMobility_QContactOnlineAccount_Type.super.ht_type.tp_dict, "FieldServiceProvider", Shiboken::Converter<QString >::toPython(QtMobility::QContactOnlineAccount::FieldServiceProvider));
    PyDict_SetItemString(SbkQtMobility_QContactOnlineAccount_Type.super.ht_type.tp_dict, "SubTypeImpp", Shiboken::Converter<QString >::toPython(QtMobility::QContactOnlineAccount::SubTypeImpp));
    PyDict_SetItemString(SbkQtMobility_QContactOnlineAccount_Type.super.ht_type.tp_dict, "FieldSubTypes", Shiboken::Converter<QString >::toPython(QtMobility::QContactOnlineAccount::FieldSubTypes));
    PyDict_SetItemString(SbkQtMobility_QContactOnlineAccount_Type.super.ht_type.tp_dict, "FieldAccountUri", Shiboken::Converter<QString >::toPython(QtMobility::QContactOnlineAccount::FieldAccountUri));
    PyDict_SetItemString(SbkQtMobility_QContactOnlineAccount_Type.super.ht_type.tp_dict, "FieldCapabilities", Shiboken::Converter<QString >::toPython(QtMobility::QContactOnlineAccount::FieldCapabilities));
    PyDict_SetItemString(SbkQtMobility_QContactOnlineAccount_Type.super.ht_type.tp_dict, "SubTypeSip", Shiboken::Converter<QString >::toPython(QtMobility::QContactOnlineAccount::SubTypeSip));
    PyDict_SetItemString(SbkQtMobility_QContactOnlineAccount_Type.super.ht_type.tp_dict, "SubTypeVideoShare", Shiboken::Converter<QString >::toPython(QtMobility::QContactOnlineAccount::SubTypeVideoShare));
    PyDict_SetItemString(SbkQtMobility_QContactOnlineAccount_Type.super.ht_type.tp_dict, "SubTypeSipVoip", Shiboken::Converter<QString >::toPython(QtMobility::QContactOnlineAccount::SubTypeSipVoip));
    PyDict_SetItemString(SbkQtMobility_QContactOnlineAccount_Type.super.ht_type.tp_dict, "DefinitionName", Shiboken::Converter<QString >::toPython(QtMobility::QContactOnlineAccount::DefinitionName));

    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactOnlineAccount >("QtMobility::QContactOnlineAccount");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactOnlineAccount >("QtMobility::QContactOnlineAccount*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactOnlineAccount >(typeid(QtMobility::QContactOnlineAccount).name());
    PySide::initQtMetaType<QtMobility::QContactOnlineAccount >();
}

