/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactname_wrapper.h"

// Extra includes
#include <QMap>
#include <QStringList>
#include <qcontactdetail.h>
#include <qcontactfilter.h>
#include <qcontactname.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactName_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactName >()))
        return -1;

    QtMobility::QContactName* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactName", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactName(QtMobility::QContactName)
    // 1: QContactName()
    // 2: QContactName(QtMobility::QContactDetail)
    if (numArgs == 0) {
        overloadId = 1; // QContactName()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(arg)) {
        overloadId = 2; // QContactName(QtMobility::QContactDetail)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactName & >::isConvertible(arg)) {
        overloadId = 0; // QContactName(QtMobility::QContactName)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactName_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactName(QtMobility::QContactName)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactName > cpp_arg0_auto_ptr;
                QtMobility::QContactName* cpp_arg0 = Shiboken::Converter<QtMobility::QContactName* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactName >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactName >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactName(QtMobility::QContactName)
                cptr = new QtMobility::QContactName(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactName()
            {

                if(!PyErr_Occurred()) {
                // QContactName()
                cptr = new QtMobility::QContactName();
                }
                break;
            }
            case 2: // QContactName(QtMobility::QContactDetail)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactName(QtMobility::QContactDetail)
                cptr = new QtMobility::QContactName(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactName >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactName_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactName_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactName", "", "QtMobility.Contacts.QtMobility::QContactDetail", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactName", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactNameFunc_customLabel(PyObject* self)
{
    QtMobility::QContactName* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactName* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // customLabel()const
            QString cppResult = cppSelf->QtMobility::QContactName::customLabel();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactNameFunc_firstName(PyObject* self)
{
    QtMobility::QContactName* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactName* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // firstName()const
            QString cppResult = cppSelf->QtMobility::QContactName::firstName();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactNameFunc_lastName(PyObject* self)
{
    QtMobility::QContactName* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactName* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // lastName()const
            QString cppResult = cppSelf->QtMobility::QContactName::lastName();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactNameFunc_match(PyObject* self, PyObject* args)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "match", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: match(QString,QString)
    // 1: match(QString)
    if (Shiboken::Converter<QString >::isConvertible(pyargs[0])) {
        if (numArgs == 1) {
            overloadId = 1; // match(QString)
        } else if (numArgs == 2 && Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
            overloadId = 0; // match(QString,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactNameFunc_match_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // match(QString,QString)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
                QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);

                if(!PyErr_Occurred()) {
                // match(QString,QString)
                QtMobility::QContactFilter cppResult = QtMobility::QContactName::match(cpp_arg0, cpp_arg1);
                pyResult = Shiboken::Converter<QtMobility::QContactFilter >::toPython(cppResult);
                }
                break;
            }
            case 1: // match(QString)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);

                if(!PyErr_Occurred()) {
                // match(QString)
                QtMobility::QContactFilter cppResult = QtMobility::QContactName::match(cpp_arg0);
                pyResult = Shiboken::Converter<QtMobility::QContactFilter >::toPython(cppResult);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactNameFunc_match_TypeError:
        const char* overloads[] = {"QString, QString", "QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactName.match", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactNameFunc_middleName(PyObject* self)
{
    QtMobility::QContactName* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactName* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // middleName()const
            QString cppResult = cppSelf->QtMobility::QContactName::middleName();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactNameFunc_prefix(PyObject* self)
{
    QtMobility::QContactName* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactName* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // prefix()const
            QString cppResult = cppSelf->QtMobility::QContactName::prefix();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactNameFunc_setCustomLabel(PyObject* self, PyObject* arg)
{
    QtMobility::QContactName* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactName* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setCustomLabel(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setCustomLabel(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactNameFunc_setCustomLabel_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setCustomLabel(QString)
            cppSelf->QtMobility::QContactName::setCustomLabel(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactNameFunc_setCustomLabel_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactName.setCustomLabel", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactNameFunc_setFirstName(PyObject* self, PyObject* arg)
{
    QtMobility::QContactName* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactName* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setFirstName(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setFirstName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactNameFunc_setFirstName_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setFirstName(QString)
            cppSelf->QtMobility::QContactName::setFirstName(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactNameFunc_setFirstName_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactName.setFirstName", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactNameFunc_setLastName(PyObject* self, PyObject* arg)
{
    QtMobility::QContactName* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactName* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setLastName(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setLastName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactNameFunc_setLastName_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setLastName(QString)
            cppSelf->QtMobility::QContactName::setLastName(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactNameFunc_setLastName_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactName.setLastName", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactNameFunc_setMiddleName(PyObject* self, PyObject* arg)
{
    QtMobility::QContactName* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactName* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setMiddleName(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setMiddleName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactNameFunc_setMiddleName_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setMiddleName(QString)
            cppSelf->QtMobility::QContactName::setMiddleName(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactNameFunc_setMiddleName_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactName.setMiddleName", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactNameFunc_setPrefix(PyObject* self, PyObject* arg)
{
    QtMobility::QContactName* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactName* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setPrefix(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setPrefix(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactNameFunc_setPrefix_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setPrefix(QString)
            cppSelf->QtMobility::QContactName::setPrefix(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactNameFunc_setPrefix_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactName.setPrefix", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactNameFunc_setSuffix(PyObject* self, PyObject* arg)
{
    QtMobility::QContactName* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactName* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setSuffix(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setSuffix(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactNameFunc_setSuffix_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setSuffix(QString)
            cppSelf->QtMobility::QContactName::setSuffix(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactNameFunc_setSuffix_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactName.setSuffix", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactNameFunc_suffix(PyObject* self)
{
    QtMobility::QContactName* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactName* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // suffix()const
            QString cppResult = cppSelf->QtMobility::QContactName::suffix();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QContactName_methods[] = {
    {"customLabel", (PyCFunction)SbkQtMobility_QContactNameFunc_customLabel, METH_NOARGS},
    {"firstName", (PyCFunction)SbkQtMobility_QContactNameFunc_firstName, METH_NOARGS},
    {"lastName", (PyCFunction)SbkQtMobility_QContactNameFunc_lastName, METH_NOARGS},
    {"match", (PyCFunction)SbkQtMobility_QContactNameFunc_match, METH_VARARGS|METH_STATIC},
    {"middleName", (PyCFunction)SbkQtMobility_QContactNameFunc_middleName, METH_NOARGS},
    {"prefix", (PyCFunction)SbkQtMobility_QContactNameFunc_prefix, METH_NOARGS},
    {"setCustomLabel", (PyCFunction)SbkQtMobility_QContactNameFunc_setCustomLabel, METH_O},
    {"setFirstName", (PyCFunction)SbkQtMobility_QContactNameFunc_setFirstName, METH_O},
    {"setLastName", (PyCFunction)SbkQtMobility_QContactNameFunc_setLastName, METH_O},
    {"setMiddleName", (PyCFunction)SbkQtMobility_QContactNameFunc_setMiddleName, METH_O},
    {"setPrefix", (PyCFunction)SbkQtMobility_QContactNameFunc_setPrefix, METH_O},
    {"setSuffix", (PyCFunction)SbkQtMobility_QContactNameFunc_setSuffix, METH_O},
    {"suffix", (PyCFunction)SbkQtMobility_QContactNameFunc_suffix, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactName_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactName",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactName_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactName_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactName >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactName",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactName(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTNAME_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactName_Type);

    SbkQtMobility_QContactName_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactName_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactName_Type));
    PyModule_AddObject(module, "QContactName",
        ((PyObject*)&SbkQtMobility_QContactName_Type));

    PyDict_SetItemString(SbkQtMobility_QContactName_Type.super.ht_type.tp_dict, "FieldMiddleName", Shiboken::Converter<QString >::toPython(QtMobility::QContactName::FieldMiddleName));
    PyDict_SetItemString(SbkQtMobility_QContactName_Type.super.ht_type.tp_dict, "FieldPrefix", Shiboken::Converter<QString >::toPython(QtMobility::QContactName::FieldPrefix));
    PyDict_SetItemString(SbkQtMobility_QContactName_Type.super.ht_type.tp_dict, "FieldLastName", Shiboken::Converter<QString >::toPython(QtMobility::QContactName::FieldLastName));
    PyDict_SetItemString(SbkQtMobility_QContactName_Type.super.ht_type.tp_dict, "FieldCustomLabel", Shiboken::Converter<QString >::toPython(QtMobility::QContactName::FieldCustomLabel));
    PyDict_SetItemString(SbkQtMobility_QContactName_Type.super.ht_type.tp_dict, "FieldSuffix", Shiboken::Converter<QString >::toPython(QtMobility::QContactName::FieldSuffix));
    PyDict_SetItemString(SbkQtMobility_QContactName_Type.super.ht_type.tp_dict, "DefinitionName", Shiboken::Converter<QString >::toPython(QtMobility::QContactName::DefinitionName));
    PyDict_SetItemString(SbkQtMobility_QContactName_Type.super.ht_type.tp_dict, "FieldFirstName", Shiboken::Converter<QString >::toPython(QtMobility::QContactName::FieldFirstName));

    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactName >("QtMobility::QContactName");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactName >("QtMobility::QContactName*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactName >(typeid(QtMobility::QContactName).name());
    PySide::initQtMetaType<QtMobility::QContactName >();
}

