/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactmanagerenginefactory_wrapper.h"

// Extra includes
#include <QList>
#include <QMap>
#include <qcontactmanagerengine.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QContactManagerEngineFactoryWrapper::QContactManagerEngineFactoryWrapper() : QtMobility::QContactManagerEngineFactory() {
    // ... middle
}

QtMobility::QContactManagerEngine * QContactManagerEngineFactoryWrapper::engine(const QMap<QString, QString > & parameters, QtMobility::QContactManager::Error * error)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "engine"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QContactManagerEngineFactory.engine()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter< QMap<QString, QString >  >::toPython(parameters),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QtMobility::QContactManagerEngine * >::isConvertible(pyResult);
    typeIsValid = typeIsValid || (pyResult == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngineFactory.engine", SbkType<QtMobility::QContactManagerEngine * >()->tp_name, pyResult->ob_type->tp_name);
        return 0;
    }
    QtMobility::QContactManagerEngine * cppResult(Shiboken::Converter<QtMobility::QContactManagerEngine * >::toCpp(pyResult));
    return cppResult;
}

QString QContactManagerEngineFactoryWrapper::managerName() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "managerName"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QContactManagerEngineFactory.managerName()' not implemented.");
        return QString();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngineFactory.managerName", "QString", pyResult->ob_type->tp_name);
        return QString();
    }
    QString cppResult(Shiboken::Converter<QString >::toCpp(pyResult));
    return cppResult;
}

QList<int > QContactManagerEngineFactoryWrapper::supportedImplementationVersions() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "supportedImplementationVersions"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngineFactory::supportedImplementationVersions();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QList<int >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<int > >::isConvertible(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngineFactory.supportedImplementationVersions", "list", pyResult->ob_type->tp_name);
        return QList<int >();
    }
    QList<int > cppResult(Shiboken::Converter<QList<int > >::toCpp(pyResult));
    return cppResult;
}

QContactManagerEngineFactoryWrapper::~QContactManagerEngineFactoryWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactManagerEngineFactory_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactManagerEngineFactory >()))
        return -1;

    QContactManagerEngineFactoryWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTMANAGERENGINEFACTORY_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QtMobility::QContactManagerEngineFactory' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // QContactManagerEngineFactory()
            cptr = new QContactManagerEngineFactoryWrapper();
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactManagerEngineFactory >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject* SbkQtMobility_QContactManagerEngineFactoryFunc_engine(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngineFactory* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngineFactory* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "engine", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: engine(QMap<QString,QString>,QtMobility::QContactManager::Error*)
    if (numArgs == 2 && Shiboken::Converter< QMap<QString, QString >  >::isConvertible(pyargs[0]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[1])) {
        overloadId = 0; // engine(QMap<QString,QString>,QtMobility::QContactManager::Error*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFactoryFunc_engine_TypeError;

    // Call function/method
    {
        {
            QMap<QString, QString > cpp_arg0 = Shiboken::Converter<QMap<QString, QString > >::toCpp(pyargs[0]);
            QtMobility::QContactManager::Error * cpp_arg1 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // engine(QMap<QString,QString>,QtMobility::QContactManager::Error*)
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QContactManagerEngineFactory.engine()' not implemented.");
                return 0;
            }
            QtMobility::QContactManagerEngine * cppResult = cppSelf->engine(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<QtMobility::QContactManagerEngine * >::toPython(cppResult);
            Shiboken::setParent(self, pyResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFactoryFunc_engine_TypeError:
        const char* overloads[] = {"dict, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngineFactory.engine", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFactoryFunc_managerName(PyObject* self)
{
    QtMobility::QContactManagerEngineFactory* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngineFactory* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // managerName()const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QContactManagerEngineFactory.managerName()' not implemented.");
                return 0;
            }
            QString cppResult = cppSelf->managerName();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactManagerEngineFactoryFunc_supportedImplementationVersions(PyObject* self)
{
    QtMobility::QContactManagerEngineFactory* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngineFactory* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // supportedImplementationVersions()const
            QList<int > cppResult = cppSelf->QtMobility::QContactManagerEngineFactory::supportedImplementationVersions();
            pyResult = Shiboken::Converter<QList<int > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QContactManagerEngineFactory_methods[] = {
    {"engine", (PyCFunction)SbkQtMobility_QContactManagerEngineFactoryFunc_engine, METH_VARARGS},
    {"managerName", (PyCFunction)SbkQtMobility_QContactManagerEngineFactoryFunc_managerName, METH_NOARGS},
    {"supportedImplementationVersions", (PyCFunction)SbkQtMobility_QContactManagerEngineFactoryFunc_supportedImplementationVersions, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactManagerEngineFactory_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactManagerEngineFactory",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactManagerEngineFactory_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactManagerEngineFactory_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactManagerEngineFactory >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactManagerEngineFactory*",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactManagerEngineFactory(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTMANAGERENGINEFACTORY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactManagerEngineFactory_Type);

    // Fill type discovery information

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactManagerEngineFactory_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactManagerEngineFactory_Type));
    PyModule_AddObject(module, "QContactManagerEngineFactory",
        ((PyObject*)&SbkQtMobility_QContactManagerEngineFactory_Type));


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactManagerEngineFactory >("QtMobility::QContactManagerEngineFactory*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactManagerEngineFactory >(typeid(QtMobility::QContactManagerEngineFactory).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactManagerEngineFactory >(typeid(QContactManagerEngineFactoryWrapper).name());
    PySide::initQtMetaType<QtMobility::QContactManagerEngineFactory* >();
}

