/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef SBK_QCONTACTMANAGERENGINEWRAPPER_H
#define SBK_QCONTACTMANAGERENGINEWRAPPER_H

#define protected public

#include <shiboken.h>

#include <qcontactmanagerengine.h>

namespace PySide { class DynamicQMetaObject; }

class QContactManagerEngineWrapper : public QtMobility::QContactManagerEngine
{
public:
    QContactManagerEngineWrapper();
    virtual bool cancelRequest(QtMobility::QContactAbstractRequest * req);
    virtual void childEvent(QChildEvent * arg__1);
    virtual QtMobility::QContact compatibleContact(const QtMobility::QContact & original, QtMobility::QContactManager::Error * error) const;
    virtual void connectNotify(const char * signal);
    virtual QtMobility::QContact contact(const QtMobility::QContactLocalId & contactId, const QtMobility::QContactFetchHint & fetchHint, QtMobility::QContactManager::Error * error) const;
    virtual QList<QtMobility::QContactLocalId > contactIds(const QtMobility::QContactFilter & filter, const QList<QtMobility::QContactSortOrder > & sortOrders, QtMobility::QContactManager::Error * error) const;
    virtual QList<QtMobility::QContact > contacts(const QtMobility::QContactFilter & filter, const QList<QtMobility::QContactSortOrder > & sortOrders, const QtMobility::QContactFetchHint & fetchHint, QtMobility::QContactManager::Error * error) const;
    virtual void customEvent(QEvent * arg__1);
    virtual QtMobility::QContactDetailDefinition detailDefinition(const QString & definitionId, const QString & contactType, QtMobility::QContactManager::Error * error) const;
    virtual QMap<QString, QtMobility::QContactDetailDefinition > detailDefinitions(const QString & contactType, QtMobility::QContactManager::Error * error) const;
    virtual void disconnectNotify(const char * signal);
    virtual bool event(QEvent * arg__1);
    virtual bool eventFilter(QObject * arg__1, QEvent * arg__2);
    virtual bool hasFeature(QtMobility::QContactManager::ManagerFeature feature, const QString & contactType) const;
    virtual bool isFilterSupported(const QtMobility::QContactFilter & filter) const;
    virtual bool isRelationshipTypeSupported(const QString & relationshipType, const QString & contactType) const;
    virtual QString managerName() const;
    virtual QMap<QString, QString > managerParameters() const;
    virtual int managerVersion() const;
    virtual const QMetaObject * metaObject() const;
    virtual QList<QtMobility::QContactRelationship > relationships(const QString & relationshipType, const QtMobility::QContactId & participantId, QtMobility::QContactRelationship::Role role, QtMobility::QContactManager::Error * error) const;
    virtual bool removeContact(const QtMobility::QContactLocalId & contactId, QtMobility::QContactManager::Error * error);
    virtual bool removeContacts(const QList<QtMobility::QContactLocalId > & contactIds, QMap<int, QtMobility::QContactManager::Error > * errorMap, QtMobility::QContactManager::Error * error);
    virtual bool removeDetailDefinition(const QString & definitionId, const QString & contactType, QtMobility::QContactManager::Error * error);
    virtual bool removeRelationship(const QtMobility::QContactRelationship & relationship, QtMobility::QContactManager::Error * error);
    virtual bool removeRelationships(const QList<QtMobility::QContactRelationship > & relationships, QMap<int, QtMobility::QContactManager::Error > * errorMap, QtMobility::QContactManager::Error * error);
    virtual void requestDestroyed(QtMobility::QContactAbstractRequest * req);
    virtual bool saveContact(QtMobility::QContact * contact, QtMobility::QContactManager::Error * error);
    virtual bool saveContacts(QList<QtMobility::QContact > * contacts, QMap<int, QtMobility::QContactManager::Error > * errorMap, QtMobility::QContactManager::Error * error);
    virtual bool saveDetailDefinition(const QtMobility::QContactDetailDefinition & def, const QString & contactType, QtMobility::QContactManager::Error * error);
    virtual bool saveRelationship(QtMobility::QContactRelationship * relationship, QtMobility::QContactManager::Error * error);
    virtual bool saveRelationships(QList<QtMobility::QContactRelationship > * relationships, QMap<int, QtMobility::QContactManager::Error > * errorMap, QtMobility::QContactManager::Error * error);
    virtual QtMobility::QContactLocalId selfContactId(QtMobility::QContactManager::Error * error) const;
    virtual bool setSelfContactId(const QtMobility::QContactLocalId & contactId, QtMobility::QContactManager::Error * error);
    virtual bool startRequest(QtMobility::QContactAbstractRequest * req);
    virtual QStringList supportedContactTypes() const;
    virtual QList<QVariant::Type > supportedDataTypes() const;
    virtual QString synthesizedDisplayLabel(const QtMobility::QContact & contact, QtMobility::QContactManager::Error * error) const;
    virtual void timerEvent(QTimerEvent * arg__1);
    virtual bool validateContact(const QtMobility::QContact & contact, QtMobility::QContactManager::Error * error) const;
    virtual bool validateDefinition(const QtMobility::QContactDetailDefinition & def, QtMobility::QContactManager::Error * error) const;
    virtual bool waitForRequestFinished(QtMobility::QContactAbstractRequest * req, int msecs);
    virtual ~QContactManagerEngineWrapper();
public:
    virtual int qt_metacall(QMetaObject::Call call, int id, void** args);
private:
    mutable PySide::DynamicQMetaObject* m_metaObject;
};

#endif // SBK_QCONTACTMANAGERENGINEWRAPPER_H

