/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactmanagerengine_wrapper.h"

// Extra includes
#include <QList>
#include <QMap>
#include <QStringList>
#include <qbytearray.h>
#include <qcontact.h>
#include <qcontactabstractrequest.h>
#include <qcontactdetail.h>
#include <qcontactdetaildefinition.h>
#include <qcontactdetaildefinitionfetchrequest.h>
#include <qcontactdetaildefinitionremoverequest.h>
#include <qcontactdetaildefinitionsaverequest.h>
#include <qcontactfetchhint.h>
#include <qcontactfetchrequest.h>
#include <qcontactfilter.h>
#include <qcontactid.h>
#include <qcontactlocalidfetchrequest.h>
#include <qcontactrelationship.h>
#include <qcontactrelationshipfetchrequest.h>
#include <qcontactrelationshipremoverequest.h>
#include <qcontactrelationshipsaverequest.h>
#include <qcontactremoverequest.h>
#include <qcontactsaverequest.h>
#include <qcontactsortorder.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qthread.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QContactManagerEngineWrapper::QContactManagerEngineWrapper() : QtMobility::QContactManagerEngine(), m_metaObject(0) {
    // ... middle
}

bool QContactManagerEngineWrapper::cancelRequest(QtMobility::QContactAbstractRequest * req)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "cancelRequest"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::cancelRequest(req);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QtMobility::QContactAbstractRequest * >::toPython(req)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.cancelRequest", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

void QContactManagerEngineWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QtMobility::QContact QContactManagerEngineWrapper::compatibleContact(const QtMobility::QContact & original, QtMobility::QContactManager::Error * error) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "compatibleContact"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::compatibleContact(original, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<const QtMobility::QContact & >::toPython(original),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QtMobility::QContact();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QtMobility::QContact >::isConvertible(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.compatibleContact", SbkType<QtMobility::QContact >()->tp_name, pyResult->ob_type->tp_name);
        return QtMobility::QContact();
    }
    QtMobility::QContact cppResult(Shiboken::Converter<QtMobility::QContact >::toCpp(pyResult));
    return cppResult;
}

void QContactManagerEngineWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

QtMobility::QContact QContactManagerEngineWrapper::contact(const QtMobility::QContactLocalId & contactId, const QtMobility::QContactFetchHint & fetchHint, QtMobility::QContactManager::Error * error) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contact"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::contact(contactId, fetchHint, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNN)",
        Shiboken::Converter<QtMobility::QContactLocalId >::toPython(contactId),
        Shiboken::Converter<const QtMobility::QContactFetchHint & >::toPython(fetchHint),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QtMobility::QContact();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QtMobility::QContact >::isConvertible(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.contact", SbkType<QtMobility::QContact >()->tp_name, pyResult->ob_type->tp_name);
        return QtMobility::QContact();
    }
    QtMobility::QContact cppResult(Shiboken::Converter<QtMobility::QContact >::toCpp(pyResult));
    return cppResult;
}

QList<QtMobility::QContactLocalId > QContactManagerEngineWrapper::contactIds(const QtMobility::QContactFilter & filter, const QList<QtMobility::QContactSortOrder > & sortOrders, QtMobility::QContactManager::Error * error) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contactIds"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::contactIds(filter, sortOrders, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNN)",
        Shiboken::Converter<const QtMobility::QContactFilter & >::toPython(filter),
        Shiboken::Converter< QList<QtMobility::QContactSortOrder >  >::toPython(sortOrders),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QList<QtMobility::QContactLocalId >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QtMobility::QContactLocalId > >::isConvertible(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.contactIds", "list", pyResult->ob_type->tp_name);
        return QList<QtMobility::QContactLocalId >();
    }
    QList<QtMobility::QContactLocalId > cppResult(Shiboken::Converter<QList<QtMobility::QContactLocalId > >::toCpp(pyResult));
    return cppResult;
}

QList<QtMobility::QContact > QContactManagerEngineWrapper::contacts(const QtMobility::QContactFilter & filter, const QList<QtMobility::QContactSortOrder > & sortOrders, const QtMobility::QContactFetchHint & fetchHint, QtMobility::QContactManager::Error * error) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contacts"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::contacts(filter, sortOrders, fetchHint, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNNN)",
        Shiboken::Converter<const QtMobility::QContactFilter & >::toPython(filter),
        Shiboken::Converter< QList<QtMobility::QContactSortOrder >  >::toPython(sortOrders),
        Shiboken::Converter<const QtMobility::QContactFetchHint & >::toPython(fetchHint),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QList<QtMobility::QContact >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QtMobility::QContact > >::isConvertible(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.contacts", "list", pyResult->ob_type->tp_name);
        return QList<QtMobility::QContact >();
    }
    QList<QtMobility::QContact > cppResult(Shiboken::Converter<QList<QtMobility::QContact > >::toCpp(pyResult));
    return cppResult;
}

void QContactManagerEngineWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QtMobility::QContactDetailDefinition QContactManagerEngineWrapper::detailDefinition(const QString & definitionId, const QString & contactType, QtMobility::QContactManager::Error * error) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "detailDefinition"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::detailDefinition(definitionId, contactType, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNN)",
        Shiboken::Converter<QString >::toPython(definitionId),
        Shiboken::Converter<QString >::toPython(contactType),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QtMobility::QContactDetailDefinition();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QtMobility::QContactDetailDefinition >::isConvertible(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.detailDefinition", SbkType<QtMobility::QContactDetailDefinition >()->tp_name, pyResult->ob_type->tp_name);
        return QtMobility::QContactDetailDefinition();
    }
    QtMobility::QContactDetailDefinition cppResult(Shiboken::Converter<QtMobility::QContactDetailDefinition >::toCpp(pyResult));
    return cppResult;
}

QMap<QString, QtMobility::QContactDetailDefinition > QContactManagerEngineWrapper::detailDefinitions(const QString & contactType, QtMobility::QContactManager::Error * error) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "detailDefinitions"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::detailDefinitions(contactType, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QString >::toPython(contactType),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QMap<QString, QtMobility::QContactDetailDefinition >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QMap<QString, QtMobility::QContactDetailDefinition > >::isConvertible(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.detailDefinitions", "map", pyResult->ob_type->tp_name);
        return QMap<QString, QtMobility::QContactDetailDefinition >();
    }
    QMap<QString, QtMobility::QContactDetailDefinition > cppResult(Shiboken::Converter<QMap<QString, QtMobility::QContactDetailDefinition > >::toCpp(pyResult));
    return cppResult;
}

void QContactManagerEngineWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QContactManagerEngineWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QContactManagerEngineWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

bool QContactManagerEngineWrapper::hasFeature(QtMobility::QContactManager::ManagerFeature feature, const QString & contactType) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasFeature"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::hasFeature(feature, contactType);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QtMobility::QContactManager::ManagerFeature >::toPython(feature),
        Shiboken::Converter<QString >::toPython(contactType)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.hasFeature", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

bool QContactManagerEngineWrapper::isFilterSupported(const QtMobility::QContactFilter & filter) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isFilterSupported"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::isFilterSupported(filter);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const QtMobility::QContactFilter & >::toPython(filter)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.isFilterSupported", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

bool QContactManagerEngineWrapper::isRelationshipTypeSupported(const QString & relationshipType, const QString & contactType) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isRelationshipTypeSupported"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::isRelationshipTypeSupported(relationshipType, contactType);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QString >::toPython(relationshipType),
        Shiboken::Converter<QString >::toPython(contactType)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.isRelationshipTypeSupported", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

QString QContactManagerEngineWrapper::managerName() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "managerName"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QContactManagerEngine.managerName()' not implemented.");
        return QString();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.managerName", "QString", pyResult->ob_type->tp_name);
        return QString();
    }
    QString cppResult(Shiboken::Converter<QString >::toCpp(pyResult));
    return cppResult;
}

QMap<QString, QString > QContactManagerEngineWrapper::managerParameters() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "managerParameters"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::managerParameters();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QMap<QString, QString >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QMap<QString, QString > >::isConvertible(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.managerParameters", "map", pyResult->ob_type->tp_name);
        return QMap<QString, QString >();
    }
    QMap<QString, QString > cppResult(Shiboken::Converter<QMap<QString, QString > >::toCpp(pyResult));
    return cppResult;
}

int QContactManagerEngineWrapper::managerVersion() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "managerVersion"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QContactManagerEngine.managerVersion()' not implemented.");
        return int(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.managerVersion", "int", pyResult->ob_type->tp_name);
        return int(0);
    }
    int cppResult(Shiboken::Converter<int >::toCpp(pyResult));
    return cppResult;
}

QList<QtMobility::QContactRelationship > QContactManagerEngineWrapper::relationships(const QString & relationshipType, const QtMobility::QContactId & participantId, QtMobility::QContactRelationship::Role role, QtMobility::QContactManager::Error * error) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "relationships"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::relationships(relationshipType, participantId, role, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNNN)",
        Shiboken::Converter<QString >::toPython(relationshipType),
        Shiboken::Converter<const QtMobility::QContactId & >::toPython(participantId),
        Shiboken::Converter<QtMobility::QContactRelationship::Role >::toPython(role),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QList<QtMobility::QContactRelationship >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QtMobility::QContactRelationship > >::isConvertible(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.relationships", "list", pyResult->ob_type->tp_name);
        return QList<QtMobility::QContactRelationship >();
    }
    QList<QtMobility::QContactRelationship > cppResult(Shiboken::Converter<QList<QtMobility::QContactRelationship > >::toCpp(pyResult));
    return cppResult;
}

bool QContactManagerEngineWrapper::removeContact(const QtMobility::QContactLocalId & contactId, QtMobility::QContactManager::Error * error)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeContact"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::removeContact(contactId, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QtMobility::QContactLocalId >::toPython(contactId),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.removeContact", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

bool QContactManagerEngineWrapper::removeContacts(const QList<QtMobility::QContactLocalId > & contactIds, QMap<int, QtMobility::QContactManager::Error > * errorMap, QtMobility::QContactManager::Error * error)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeContacts"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::removeContacts(contactIds, errorMap, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNN)",
        Shiboken::Converter< QList<QtMobility::QContactLocalId >  >::toPython(contactIds),
        Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > * >::toPython(errorMap),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.removeContacts", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

bool QContactManagerEngineWrapper::removeDetailDefinition(const QString & definitionId, const QString & contactType, QtMobility::QContactManager::Error * error)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeDetailDefinition"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::removeDetailDefinition(definitionId, contactType, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNN)",
        Shiboken::Converter<QString >::toPython(definitionId),
        Shiboken::Converter<QString >::toPython(contactType),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.removeDetailDefinition", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

bool QContactManagerEngineWrapper::removeRelationship(const QtMobility::QContactRelationship & relationship, QtMobility::QContactManager::Error * error)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeRelationship"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::removeRelationship(relationship, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<const QtMobility::QContactRelationship & >::toPython(relationship),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.removeRelationship", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

bool QContactManagerEngineWrapper::removeRelationships(const QList<QtMobility::QContactRelationship > & relationships, QMap<int, QtMobility::QContactManager::Error > * errorMap, QtMobility::QContactManager::Error * error)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeRelationships"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::removeRelationships(relationships, errorMap, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNN)",
        Shiboken::Converter< QList<QtMobility::QContactRelationship >  >::toPython(relationships),
        Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > * >::toPython(errorMap),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.removeRelationships", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

void QContactManagerEngineWrapper::requestDestroyed(QtMobility::QContactAbstractRequest * req)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "requestDestroyed"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::requestDestroyed(req);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QtMobility::QContactAbstractRequest * >::toPython(req)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QContactManagerEngineWrapper::saveContact(QtMobility::QContact * contact, QtMobility::QContactManager::Error * error)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "saveContact"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::saveContact(contact, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QtMobility::QContact * >::toPython(contact),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.saveContact", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

bool QContactManagerEngineWrapper::saveContacts(QList<QtMobility::QContact > * contacts, QMap<int, QtMobility::QContactManager::Error > * errorMap, QtMobility::QContactManager::Error * error)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "saveContacts"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::saveContacts(contacts, errorMap, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNN)",
        Shiboken::Converter<QList<QtMobility::QContact > * >::toPython(contacts),
        Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > * >::toPython(errorMap),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.saveContacts", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

bool QContactManagerEngineWrapper::saveDetailDefinition(const QtMobility::QContactDetailDefinition & def, const QString & contactType, QtMobility::QContactManager::Error * error)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "saveDetailDefinition"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::saveDetailDefinition(def, contactType, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNN)",
        Shiboken::Converter<const QtMobility::QContactDetailDefinition & >::toPython(def),
        Shiboken::Converter<QString >::toPython(contactType),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.saveDetailDefinition", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

bool QContactManagerEngineWrapper::saveRelationship(QtMobility::QContactRelationship * relationship, QtMobility::QContactManager::Error * error)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "saveRelationship"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::saveRelationship(relationship, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QtMobility::QContactRelationship * >::toPython(relationship),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.saveRelationship", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

bool QContactManagerEngineWrapper::saveRelationships(QList<QtMobility::QContactRelationship > * relationships, QMap<int, QtMobility::QContactManager::Error > * errorMap, QtMobility::QContactManager::Error * error)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "saveRelationships"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::saveRelationships(relationships, errorMap, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NNN)",
        Shiboken::Converter<QList<QtMobility::QContactRelationship > * >::toPython(relationships),
        Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > * >::toPython(errorMap),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.saveRelationships", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

QtMobility::QContactLocalId QContactManagerEngineWrapper::selfContactId(QtMobility::QContactManager::Error * error) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "selfContactId"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::selfContactId(error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QtMobility::QContactLocalId(0);
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QtMobility::QContactLocalId >::isConvertible(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.selfContactId", "QContactLocalId", pyResult->ob_type->tp_name);
        return QtMobility::QContactLocalId(0);
    }
    QtMobility::QContactLocalId cppResult(Shiboken::Converter<QtMobility::QContactLocalId >::toCpp(pyResult));
    return cppResult;
}

bool QContactManagerEngineWrapper::setSelfContactId(const QtMobility::QContactLocalId & contactId, QtMobility::QContactManager::Error * error)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSelfContactId"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::setSelfContactId(contactId, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QtMobility::QContactLocalId >::toPython(contactId),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.setSelfContactId", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

bool QContactManagerEngineWrapper::startRequest(QtMobility::QContactAbstractRequest * req)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startRequest"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::startRequest(req);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QtMobility::QContactAbstractRequest * >::toPython(req)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.startRequest", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

QStringList QContactManagerEngineWrapper::supportedContactTypes() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "supportedContactTypes"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::supportedContactTypes();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QStringList();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStringList >::isConvertible(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.supportedContactTypes", "list", pyResult->ob_type->tp_name);
        return QStringList();
    }
    QStringList cppResult(Shiboken::Converter<QStringList >::toCpp(pyResult));
    return cppResult;
}

QList<QVariant::Type > QContactManagerEngineWrapper::supportedDataTypes() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "supportedDataTypes"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::supportedDataTypes();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QList<QVariant::Type >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QVariant::Type > >::isConvertible(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.supportedDataTypes", "list", pyResult->ob_type->tp_name);
        return QList<QVariant::Type >();
    }
    QList<QVariant::Type > cppResult(Shiboken::Converter<QList<QVariant::Type > >::toCpp(pyResult));
    return cppResult;
}

QString QContactManagerEngineWrapper::synthesizedDisplayLabel(const QtMobility::QContact & contact, QtMobility::QContactManager::Error * error) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "synthesizedDisplayLabel"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::synthesizedDisplayLabel(contact, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<const QtMobility::QContact & >::toPython(contact),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.synthesizedDisplayLabel", "QString", pyResult->ob_type->tp_name);
        return QString();
    }
    QString cppResult(Shiboken::Converter<QString >::toCpp(pyResult));
    return cppResult;
}

void QContactManagerEngineWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QContactManagerEngineWrapper::validateContact(const QtMobility::QContact & contact, QtMobility::QContactManager::Error * error) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "validateContact"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::validateContact(contact, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<const QtMobility::QContact & >::toPython(contact),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.validateContact", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

bool QContactManagerEngineWrapper::validateDefinition(const QtMobility::QContactDetailDefinition & def, QtMobility::QContactManager::Error * error) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "validateDefinition"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::validateDefinition(def, error);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<const QtMobility::QContactDetailDefinition & >::toPython(def),
        Shiboken::Converter<QtMobility::QContactManager::Error * >::toPython(error)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.validateDefinition", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

bool QContactManagerEngineWrapper::waitForRequestFinished(QtMobility::QContactAbstractRequest * req, int msecs)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "waitForRequestFinished"));
    if (py_override.isNull()) {
        return this->QtMobility::QContactManagerEngine::waitForRequestFinished(req, msecs);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Ni)",
        Shiboken::Converter<QtMobility::QContactAbstractRequest * >::toPython(req),
        msecs
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactManagerEngine.waitForRequestFinished", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    return cppResult;
}

const QMetaObject* QContactManagerEngineWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QContactManagerEngine::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QContactManagerEngineWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QContactManagerEngine::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QContactManagerEngineWrapper::~QContactManagerEngineWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactManagerEngine_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactManagerEngine >()))
        return -1;

    QContactManagerEngineWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTMANAGERENGINE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QtMobility::QContactManagerEngine' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
                propertyKeys.push_back(argName);
        }
    }
    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // QContactManagerEngine()
            cptr = new QContactManagerEngineWrapper();
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactManagerEngine >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    PySide::signalUpdateSource(self);
    cptr->metaObject();
    for (std::vector<PyObject*>::size_type i = 0; i < propertyKeys.size(); i++) {
        const char* propName = PyString_AS_STRING(propertyKeys[i]);
        const QMetaObject* mo = cptr->metaObject();
        if (mo->indexOfProperty(propName) != -1) {
            cptr->setProperty(propName, Shiboken::Converter<QVariant>::toCpp(PyDict_GetItem(kwds, propertyKeys[i])));
        } else {
            QString signalSignature = QString("%1()").arg(propName);
            if (mo->indexOfSignal(qPrintable(signalSignature)) != -1) {
                signalSignature = '2' + signalSignature;
                PySide::signal_connect(self, qPrintable(signalSignature), PyDict_GetItem(kwds, propertyKeys[i]));
            } else {
                delete cptr;
                PyErr_Format(PyExc_AttributeError, "'%s' is not a Qt property or a signal", propName);
                return -1;
            };
        }
    }


    return 1;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_addSorted(PyObject* self, PyObject* args)
{
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addSorted", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: addSorted(QList<QtMobility::QContact>*,QtMobility::QContact,QList<QtMobility::QContactSortOrder>)
    if (numArgs == 3 && Shiboken::Converter<QList<QtMobility::QContact > * >::isConvertible(pyargs[0]) && Shiboken::Converter<const QtMobility::QContact & >::isConvertible(pyargs[1]) && Shiboken::Converter< QList<QtMobility::QContactSortOrder >  >::isConvertible(pyargs[2])) {
        overloadId = 0; // addSorted(QList<QtMobility::QContact>*,QtMobility::QContact,QList<QtMobility::QContactSortOrder>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_addSorted_TypeError;

    // Call function/method
    {
        {
            QList<QtMobility::QContact > * cpp_arg0 = Shiboken::Converter<QList<QtMobility::QContact > * >::toCpp(pyargs[0]);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QtMobility::QContact* cpp_arg1 = Shiboken::Converter<QtMobility::QContact* >::toCpp(pyargs[1]);
            QList<QtMobility::QContactSortOrder > cpp_arg2 = Shiboken::Converter<QList<QtMobility::QContactSortOrder > >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // addSorted(QList<QtMobility::QContact>*,QtMobility::QContact,QList<QtMobility::QContactSortOrder>)
            QtMobility::QContactManagerEngine::addSorted(cpp_arg0, *cpp_arg1, cpp_arg2);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactManagerEngineFunc_addSorted_TypeError:
        const char* overloads[] = {"list, QtMobility.Contacts.QtMobility::QContact, list", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.addSorted", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_cancelRequest(PyObject* self, PyObject* arg)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: cancelRequest(QtMobility::QContactAbstractRequest*)
    if (Shiboken::Converter<QtMobility::QContactAbstractRequest * >::isConvertible(arg)) {
        overloadId = 0; // cancelRequest(QtMobility::QContactAbstractRequest*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_cancelRequest_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactAbstractRequest* cpp_arg0 = Shiboken::Converter<QtMobility::QContactAbstractRequest* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // cancelRequest(QtMobility::QContactAbstractRequest*)
            bool cppResult = cppSelf->QtMobility::QContactManagerEngine::cancelRequest(cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_cancelRequest_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactAbstractRequest", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactManagerEngine.cancelRequest", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_canonicalizedFilter(PyObject* self, PyObject* arg)
{
    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: canonicalizedFilter(QtMobility::QContactFilter)
    if (Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(arg)) {
        overloadId = 0; // canonicalizedFilter(QtMobility::QContactFilter)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_canonicalizedFilter_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // canonicalizedFilter(QtMobility::QContactFilter)
            QtMobility::QContactFilter cppResult = QtMobility::QContactManagerEngine::canonicalizedFilter(*cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QContactFilter >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_canonicalizedFilter_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactManagerEngine.canonicalizedFilter", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_compareContact(PyObject* self, PyObject* args)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "compareContact", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: compareContact(QtMobility::QContact,QtMobility::QContact,QList<QtMobility::QContactSortOrder>)
    if (numArgs == 3 && Shiboken::Converter<const QtMobility::QContact & >::isConvertible(pyargs[0]) && Shiboken::Converter<const QtMobility::QContact & >::isConvertible(pyargs[1]) && Shiboken::Converter< QList<QtMobility::QContactSortOrder >  >::isConvertible(pyargs[2])) {
        overloadId = 0; // compareContact(QtMobility::QContact,QtMobility::QContact,QList<QtMobility::QContactSortOrder>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_compareContact_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContact* cpp_arg0 = Shiboken::Converter<QtMobility::QContact* >::toCpp(pyargs[0]);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QtMobility::QContact* cpp_arg1 = Shiboken::Converter<QtMobility::QContact* >::toCpp(pyargs[1]);
            QList<QtMobility::QContactSortOrder > cpp_arg2 = Shiboken::Converter<QList<QtMobility::QContactSortOrder > >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // compareContact(QtMobility::QContact,QtMobility::QContact,QList<QtMobility::QContactSortOrder>)
            int cppResult = QtMobility::QContactManagerEngine::compareContact(*cpp_arg0, *cpp_arg1, cpp_arg2);
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_compareContact_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContact, QtMobility.Contacts.QtMobility::QContact, list", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.compareContact", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_compareVariant(PyObject* self, PyObject* args)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "compareVariant", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: compareVariant(QVariant,QVariant,Qt::CaseSensitivity)
    if (numArgs == 3 && Shiboken::Converter<QVariant >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant >::isConvertible(pyargs[1]) && Shiboken::Converter<Qt::CaseSensitivity >::isConvertible(pyargs[2])) {
        overloadId = 0; // compareVariant(QVariant,QVariant,Qt::CaseSensitivity)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_compareVariant_TypeError;

    // Call function/method
    {
        {
            QVariant cpp_arg0 = Shiboken::Converter<QVariant >::toCpp(pyargs[0]);
            QVariant cpp_arg1 = Shiboken::Converter<QVariant >::toCpp(pyargs[1]);
            Qt::CaseSensitivity cpp_arg2 = Shiboken::Converter<Qt::CaseSensitivity >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // compareVariant(QVariant,QVariant,Qt::CaseSensitivity)
            int cppResult = QtMobility::QContactManagerEngine::compareVariant(cpp_arg0, cpp_arg1, cpp_arg2);
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_compareVariant_TypeError:
        const char* overloads[] = {"QVariant, QVariant, PySide.QtCore.Qt.CaseSensitivity", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.compareVariant", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_compatibleContact(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "compatibleContact", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: compatibleContact(QtMobility::QContact,QtMobility::QContactManager::Error*)const
    if (numArgs == 2 && Shiboken::Converter<const QtMobility::QContact & >::isConvertible(pyargs[0]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[1])) {
        overloadId = 0; // compatibleContact(QtMobility::QContact,QtMobility::QContactManager::Error*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_compatibleContact_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContact* cpp_arg0 = Shiboken::Converter<QtMobility::QContact* >::toCpp(pyargs[0]);
            QtMobility::QContactManager::Error * cpp_arg1 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // compatibleContact(QtMobility::QContact,QtMobility::QContactManager::Error*)const
            QtMobility::QContact cppResult = cppSelf->QtMobility::QContactManagerEngine::compatibleContact(*cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<QtMobility::QContact >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_compatibleContact_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContact, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.compatibleContact", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_contact(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "contact", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: contact(QtMobility::QContactLocalId,QtMobility::QContactFetchHint,QtMobility::QContactManager::Error*)const
    if (numArgs == 3 && Shiboken::Converter<QtMobility::QContactLocalId >::isConvertible(pyargs[0]) && Shiboken::Converter<const QtMobility::QContactFetchHint & >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[2])) {
        overloadId = 0; // contact(QtMobility::QContactLocalId,QtMobility::QContactFetchHint,QtMobility::QContactManager::Error*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_contact_TypeError;

    // Call function/method
    {
        {
            QtMobility::QContactLocalId cpp_arg0 = Shiboken::Converter<QtMobility::QContactLocalId >::toCpp(pyargs[0]);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QtMobility::QContactFetchHint* cpp_arg1 = Shiboken::Converter<QtMobility::QContactFetchHint* >::toCpp(pyargs[1]);
            QtMobility::QContactManager::Error * cpp_arg2 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // contact(QtMobility::QContactLocalId,QtMobility::QContactFetchHint,QtMobility::QContactManager::Error*)const
            QtMobility::QContact cppResult = cppSelf->QtMobility::QContactManagerEngine::contact(cpp_arg0, *cpp_arg1, cpp_arg2);
            pyResult = Shiboken::Converter<QtMobility::QContact >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_contact_TypeError:
        const char* overloads[] = {"QtMobility::QContactLocalId, QtMobility.Contacts.QtMobility::QContactFetchHint, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.contact", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_contactIds(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "contactIds", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: contactIds(QtMobility::QContactFilter,QList<QtMobility::QContactSortOrder>,QtMobility::QContactManager::Error*)const
    if (numArgs == 3 && Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(pyargs[0]) && Shiboken::Converter< QList<QtMobility::QContactSortOrder >  >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[2])) {
        overloadId = 0; // contactIds(QtMobility::QContactFilter,QList<QtMobility::QContactSortOrder>,QtMobility::QContactManager::Error*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_contactIds_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(pyargs[0]);
            QList<QtMobility::QContactSortOrder > cpp_arg1 = Shiboken::Converter<QList<QtMobility::QContactSortOrder > >::toCpp(pyargs[1]);
            QtMobility::QContactManager::Error * cpp_arg2 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // contactIds(QtMobility::QContactFilter,QList<QtMobility::QContactSortOrder>,QtMobility::QContactManager::Error*)const
            QList<QtMobility::QContactLocalId > cppResult = cppSelf->QtMobility::QContactManagerEngine::contactIds(*cpp_arg0, cpp_arg1, cpp_arg2);
            pyResult = Shiboken::Converter<QList<QtMobility::QContactLocalId > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_contactIds_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactFilter, list, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.contactIds", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_contacts(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "contacts", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;


    // Overloaded function decisor
    // 0: contacts(QtMobility::QContactFilter,QList<QtMobility::QContactSortOrder>,QtMobility::QContactFetchHint,QtMobility::QContactManager::Error*)const
    if (numArgs == 4 && Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(pyargs[0]) && Shiboken::Converter< QList<QtMobility::QContactSortOrder >  >::isConvertible(pyargs[1]) && Shiboken::Converter<const QtMobility::QContactFetchHint & >::isConvertible(pyargs[2]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[3])) {
        overloadId = 0; // contacts(QtMobility::QContactFilter,QList<QtMobility::QContactSortOrder>,QtMobility::QContactFetchHint,QtMobility::QContactManager::Error*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_contacts_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(pyargs[0]);
            QList<QtMobility::QContactSortOrder > cpp_arg1 = Shiboken::Converter<QList<QtMobility::QContactSortOrder > >::toCpp(pyargs[1]);
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QtMobility::QContactFetchHint* cpp_arg2 = Shiboken::Converter<QtMobility::QContactFetchHint* >::toCpp(pyargs[2]);
            QtMobility::QContactManager::Error * cpp_arg3 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[3]);

            if(!PyErr_Occurred()) {
            // contacts(QtMobility::QContactFilter,QList<QtMobility::QContactSortOrder>,QtMobility::QContactFetchHint,QtMobility::QContactManager::Error*)const
            QList<QtMobility::QContact > cppResult = cppSelf->QtMobility::QContactManagerEngine::contacts(*cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
            pyResult = Shiboken::Converter<QList<QtMobility::QContact > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_contacts_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactFilter, list, QtMobility.Contacts.QtMobility::QContactFetchHint, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.contacts", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_detailDefinition(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "detailDefinition", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: detailDefinition(QString,QString,QtMobility::QContactManager::Error*)const
    if (numArgs == 3 && Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter<QString >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[2])) {
        overloadId = 0; // detailDefinition(QString,QString,QtMobility::QContactManager::Error*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_detailDefinition_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);
            QtMobility::QContactManager::Error * cpp_arg2 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // detailDefinition(QString,QString,QtMobility::QContactManager::Error*)const
            QtMobility::QContactDetailDefinition cppResult = cppSelf->QtMobility::QContactManagerEngine::detailDefinition(cpp_arg0, cpp_arg1, cpp_arg2);
            pyResult = Shiboken::Converter<QtMobility::QContactDetailDefinition >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_detailDefinition_TypeError:
        const char* overloads[] = {"QString, QString, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.detailDefinition", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_detailDefinitions(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "detailDefinitions", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: detailDefinitions(QString,QtMobility::QContactManager::Error*)const
    if (numArgs == 2 && Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[1])) {
        overloadId = 0; // detailDefinitions(QString,QtMobility::QContactManager::Error*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_detailDefinitions_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            QtMobility::QContactManager::Error * cpp_arg1 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // detailDefinitions(QString,QtMobility::QContactManager::Error*)const
            QMap<QString, QtMobility::QContactDetailDefinition > cppResult = cppSelf->QtMobility::QContactManagerEngine::detailDefinitions(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<QMap<QString, QtMobility::QContactDetailDefinition > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_detailDefinitions_TypeError:
        const char* overloads[] = {"QString, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.detailDefinitions", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_hasFeature(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "hasFeature", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: hasFeature(QtMobility::QContactManager::ManagerFeature,QString)const
    if (numArgs == 2 && Shiboken::Converter<QtMobility::QContactManager::ManagerFeature >::isConvertible(pyargs[0]) && Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
        overloadId = 0; // hasFeature(QtMobility::QContactManager::ManagerFeature,QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_hasFeature_TypeError;

    // Call function/method
    {
        {
            QtMobility::QContactManager::ManagerFeature cpp_arg0 = Shiboken::Converter<QtMobility::QContactManager::ManagerFeature >::toCpp(pyargs[0]);
            QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // hasFeature(QtMobility::QContactManager::ManagerFeature,QString)const
            bool cppResult = cppSelf->QtMobility::QContactManagerEngine::hasFeature(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_hasFeature_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactManager.ManagerFeature, QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.hasFeature", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_isFilterSupported(PyObject* self, PyObject* arg)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: isFilterSupported(QtMobility::QContactFilter)const
    if (Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(arg)) {
        overloadId = 0; // isFilterSupported(QtMobility::QContactFilter)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_isFilterSupported_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // isFilterSupported(QtMobility::QContactFilter)const
            bool cppResult = cppSelf->QtMobility::QContactManagerEngine::isFilterSupported(*cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_isFilterSupported_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactFilter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactManagerEngine.isFilterSupported", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_isRelationshipTypeSupported(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "isRelationshipTypeSupported", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: isRelationshipTypeSupported(QString,QString)const
    if (numArgs == 2 && Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
        overloadId = 0; // isRelationshipTypeSupported(QString,QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_isRelationshipTypeSupported_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // isRelationshipTypeSupported(QString,QString)const
            bool cppResult = cppSelf->QtMobility::QContactManagerEngine::isRelationshipTypeSupported(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_isRelationshipTypeSupported_TypeError:
        const char* overloads[] = {"QString, QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.isRelationshipTypeSupported", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_managerName(PyObject* self)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // managerName()const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QContactManagerEngine.managerName()' not implemented.");
                return 0;
            }
            QString cppResult = cppSelf->managerName();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_managerParameters(PyObject* self)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // managerParameters()const
            QMap<QString, QString > cppResult = cppSelf->QtMobility::QContactManagerEngine::managerParameters();
            pyResult = Shiboken::Converter<QMap<QString, QString > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_managerUri(PyObject* self)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // managerUri()const
            QString cppResult = cppSelf->QtMobility::QContactManagerEngine::managerUri();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_managerVersion(PyObject* self)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // managerVersion()const
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QContactManagerEngine.managerVersion()' not implemented.");
                return 0;
            }
            int cppResult = cppSelf->managerVersion();
            pyResult = Shiboken::Converter<int >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_relationships(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "relationships", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;


    // Overloaded function decisor
    // 0: relationships(QString,QtMobility::QContactId,QtMobility::QContactRelationship::Role,QtMobility::QContactManager::Error*)const
    if (numArgs == 4 && Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter<const QtMobility::QContactId & >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QContactRelationship::Role >::isConvertible(pyargs[2]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[3])) {
        overloadId = 0; // relationships(QString,QtMobility::QContactId,QtMobility::QContactRelationship::Role,QtMobility::QContactManager::Error*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_relationships_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QtMobility::QContactId* cpp_arg1 = Shiboken::Converter<QtMobility::QContactId* >::toCpp(pyargs[1]);
            QtMobility::QContactRelationship::Role cpp_arg2 = Shiboken::Converter<QtMobility::QContactRelationship::Role >::toCpp(pyargs[2]);
            QtMobility::QContactManager::Error * cpp_arg3 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[3]);

            if(!PyErr_Occurred()) {
            // relationships(QString,QtMobility::QContactId,QtMobility::QContactRelationship::Role,QtMobility::QContactManager::Error*)const
            QList<QtMobility::QContactRelationship > cppResult = cppSelf->QtMobility::QContactManagerEngine::relationships(cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
            pyResult = Shiboken::Converter<QList<QtMobility::QContactRelationship > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_relationships_TypeError:
        const char* overloads[] = {"QString, QtMobility.Contacts.QtMobility::QContactId, QtMobility.Contacts.QtMobility::QContactRelationship.Role, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.relationships", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_removeContact(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "removeContact", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: removeContact(QtMobility::QContactLocalId,QtMobility::QContactManager::Error*)
    if (numArgs == 2 && Shiboken::Converter<QtMobility::QContactLocalId >::isConvertible(pyargs[0]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[1])) {
        overloadId = 0; // removeContact(QtMobility::QContactLocalId,QtMobility::QContactManager::Error*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_removeContact_TypeError;

    // Call function/method
    {
        {
            QtMobility::QContactLocalId cpp_arg0 = Shiboken::Converter<QtMobility::QContactLocalId >::toCpp(pyargs[0]);
            QtMobility::QContactManager::Error * cpp_arg1 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // removeContact(QtMobility::QContactLocalId,QtMobility::QContactManager::Error*)
            bool cppResult = cppSelf->QtMobility::QContactManagerEngine::removeContact(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_removeContact_TypeError:
        const char* overloads[] = {"QtMobility::QContactLocalId, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.removeContact", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_removeContacts(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "removeContacts", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: removeContacts(QList<QtMobility::QContactLocalId>,QMap<int,QtMobility::QContactManager::Error>*,QtMobility::QContactManager::Error*)
    if (numArgs == 3 && Shiboken::Converter< QList<QtMobility::QContactLocalId >  >::isConvertible(pyargs[0]) && Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > * >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[2])) {
        overloadId = 0; // removeContacts(QList<QtMobility::QContactLocalId>,QMap<int,QtMobility::QContactManager::Error>*,QtMobility::QContactManager::Error*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_removeContacts_TypeError;

    // Call function/method
    {
        {
            QList<QtMobility::QContactLocalId > cpp_arg0 = Shiboken::Converter<QList<QtMobility::QContactLocalId > >::toCpp(pyargs[0]);
            QMap<int, QtMobility::QContactManager::Error > * cpp_arg1 = Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > * >::toCpp(pyargs[1]);
            QtMobility::QContactManager::Error * cpp_arg2 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // removeContacts(QList<QtMobility::QContactLocalId>,QMap<int,QtMobility::QContactManager::Error>*,QtMobility::QContactManager::Error*)
            bool cppResult = cppSelf->QtMobility::QContactManagerEngine::removeContacts(cpp_arg0, cpp_arg1, cpp_arg2);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_removeContacts_TypeError:
        const char* overloads[] = {"list, dict, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.removeContacts", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_removeDetailDefinition(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "removeDetailDefinition", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: removeDetailDefinition(QString,QString,QtMobility::QContactManager::Error*)
    if (numArgs == 3 && Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter<QString >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[2])) {
        overloadId = 0; // removeDetailDefinition(QString,QString,QtMobility::QContactManager::Error*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_removeDetailDefinition_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(pyargs[0]);
            QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);
            QtMobility::QContactManager::Error * cpp_arg2 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // removeDetailDefinition(QString,QString,QtMobility::QContactManager::Error*)
            bool cppResult = cppSelf->QtMobility::QContactManagerEngine::removeDetailDefinition(cpp_arg0, cpp_arg1, cpp_arg2);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_removeDetailDefinition_TypeError:
        const char* overloads[] = {"QString, QString, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.removeDetailDefinition", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_removeRelationship(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "removeRelationship", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: removeRelationship(QtMobility::QContactRelationship,QtMobility::QContactManager::Error*)
    if (numArgs == 2 && Shiboken::Converter<const QtMobility::QContactRelationship & >::isConvertible(pyargs[0]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[1])) {
        overloadId = 0; // removeRelationship(QtMobility::QContactRelationship,QtMobility::QContactManager::Error*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_removeRelationship_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactRelationship* cpp_arg0 = Shiboken::Converter<QtMobility::QContactRelationship* >::toCpp(pyargs[0]);
            QtMobility::QContactManager::Error * cpp_arg1 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // removeRelationship(QtMobility::QContactRelationship,QtMobility::QContactManager::Error*)
            bool cppResult = cppSelf->QtMobility::QContactManagerEngine::removeRelationship(*cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_removeRelationship_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactRelationship, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.removeRelationship", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_removeRelationships(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "removeRelationships", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: removeRelationships(QList<QtMobility::QContactRelationship>,QMap<int,QtMobility::QContactManager::Error>*,QtMobility::QContactManager::Error*)
    if (numArgs == 3 && Shiboken::Converter< QList<QtMobility::QContactRelationship >  >::isConvertible(pyargs[0]) && Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > * >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[2])) {
        overloadId = 0; // removeRelationships(QList<QtMobility::QContactRelationship>,QMap<int,QtMobility::QContactManager::Error>*,QtMobility::QContactManager::Error*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_removeRelationships_TypeError;

    // Call function/method
    {
        {
            QList<QtMobility::QContactRelationship > cpp_arg0 = Shiboken::Converter<QList<QtMobility::QContactRelationship > >::toCpp(pyargs[0]);
            QMap<int, QtMobility::QContactManager::Error > * cpp_arg1 = Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > * >::toCpp(pyargs[1]);
            QtMobility::QContactManager::Error * cpp_arg2 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // removeRelationships(QList<QtMobility::QContactRelationship>,QMap<int,QtMobility::QContactManager::Error>*,QtMobility::QContactManager::Error*)
            bool cppResult = cppSelf->QtMobility::QContactManagerEngine::removeRelationships(cpp_arg0, cpp_arg1, cpp_arg2);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_removeRelationships_TypeError:
        const char* overloads[] = {"list, dict, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.removeRelationships", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_requestDestroyed(PyObject* self, PyObject* arg)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: requestDestroyed(QtMobility::QContactAbstractRequest*)
    if (Shiboken::Converter<QtMobility::QContactAbstractRequest * >::isConvertible(arg)) {
        overloadId = 0; // requestDestroyed(QtMobility::QContactAbstractRequest*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_requestDestroyed_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactAbstractRequest* cpp_arg0 = Shiboken::Converter<QtMobility::QContactAbstractRequest* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // requestDestroyed(QtMobility::QContactAbstractRequest*)
            cppSelf->QtMobility::QContactManagerEngine::requestDestroyed(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactManagerEngineFunc_requestDestroyed_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactAbstractRequest", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactManagerEngine.requestDestroyed", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_saveContact(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "saveContact", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: saveContact(QtMobility::QContact*,QtMobility::QContactManager::Error*)
    if (numArgs == 2 && Shiboken::Converter<QtMobility::QContact * >::isConvertible(pyargs[0]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[1])) {
        overloadId = 0; // saveContact(QtMobility::QContact*,QtMobility::QContactManager::Error*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_saveContact_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContact* cpp_arg0 = Shiboken::Converter<QtMobility::QContact* >::toCpp(pyargs[0]);
            QtMobility::QContactManager::Error * cpp_arg1 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // saveContact(QtMobility::QContact*,QtMobility::QContactManager::Error*)
            bool cppResult = cppSelf->QtMobility::QContactManagerEngine::saveContact(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_saveContact_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContact, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.saveContact", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_saveContacts(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "saveContacts", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: saveContacts(QList<QtMobility::QContact>*,QMap<int,QtMobility::QContactManager::Error>*,QtMobility::QContactManager::Error*)
    if (numArgs == 3 && Shiboken::Converter<QList<QtMobility::QContact > * >::isConvertible(pyargs[0]) && Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > * >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[2])) {
        overloadId = 0; // saveContacts(QList<QtMobility::QContact>*,QMap<int,QtMobility::QContactManager::Error>*,QtMobility::QContactManager::Error*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_saveContacts_TypeError;

    // Call function/method
    {
        {
            QList<QtMobility::QContact > * cpp_arg0 = Shiboken::Converter<QList<QtMobility::QContact > * >::toCpp(pyargs[0]);
            QMap<int, QtMobility::QContactManager::Error > * cpp_arg1 = Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > * >::toCpp(pyargs[1]);
            QtMobility::QContactManager::Error * cpp_arg2 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // saveContacts(QList<QtMobility::QContact>*,QMap<int,QtMobility::QContactManager::Error>*,QtMobility::QContactManager::Error*)
            bool cppResult = cppSelf->QtMobility::QContactManagerEngine::saveContacts(cpp_arg0, cpp_arg1, cpp_arg2);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_saveContacts_TypeError:
        const char* overloads[] = {"list, dict, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.saveContacts", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_saveDetailDefinition(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "saveDetailDefinition", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: saveDetailDefinition(QtMobility::QContactDetailDefinition,QString,QtMobility::QContactManager::Error*)
    if (numArgs == 3 && Shiboken::Converter<const QtMobility::QContactDetailDefinition & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[2])) {
        overloadId = 0; // saveDetailDefinition(QtMobility::QContactDetailDefinition,QString,QtMobility::QContactManager::Error*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_saveDetailDefinition_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactDetailDefinition* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetailDefinition* >::toCpp(pyargs[0]);
            QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);
            QtMobility::QContactManager::Error * cpp_arg2 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // saveDetailDefinition(QtMobility::QContactDetailDefinition,QString,QtMobility::QContactManager::Error*)
            bool cppResult = cppSelf->QtMobility::QContactManagerEngine::saveDetailDefinition(*cpp_arg0, cpp_arg1, cpp_arg2);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_saveDetailDefinition_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactDetailDefinition, QString, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.saveDetailDefinition", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_saveRelationship(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "saveRelationship", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: saveRelationship(QtMobility::QContactRelationship*,QtMobility::QContactManager::Error*)
    if (numArgs == 2 && Shiboken::Converter<QtMobility::QContactRelationship * >::isConvertible(pyargs[0]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[1])) {
        overloadId = 0; // saveRelationship(QtMobility::QContactRelationship*,QtMobility::QContactManager::Error*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_saveRelationship_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactRelationship* cpp_arg0 = Shiboken::Converter<QtMobility::QContactRelationship* >::toCpp(pyargs[0]);
            QtMobility::QContactManager::Error * cpp_arg1 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // saveRelationship(QtMobility::QContactRelationship*,QtMobility::QContactManager::Error*)
            bool cppResult = cppSelf->QtMobility::QContactManagerEngine::saveRelationship(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_saveRelationship_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactRelationship, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.saveRelationship", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_saveRelationships(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "saveRelationships", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;


    // Overloaded function decisor
    // 0: saveRelationships(QList<QtMobility::QContactRelationship>*,QMap<int,QtMobility::QContactManager::Error>*,QtMobility::QContactManager::Error*)
    if (numArgs == 3 && Shiboken::Converter<QList<QtMobility::QContactRelationship > * >::isConvertible(pyargs[0]) && Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > * >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[2])) {
        overloadId = 0; // saveRelationships(QList<QtMobility::QContactRelationship>*,QMap<int,QtMobility::QContactManager::Error>*,QtMobility::QContactManager::Error*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_saveRelationships_TypeError;

    // Call function/method
    {
        {
            QList<QtMobility::QContactRelationship > * cpp_arg0 = Shiboken::Converter<QList<QtMobility::QContactRelationship > * >::toCpp(pyargs[0]);
            QMap<int, QtMobility::QContactManager::Error > * cpp_arg1 = Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > * >::toCpp(pyargs[1]);
            QtMobility::QContactManager::Error * cpp_arg2 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[2]);

            if(!PyErr_Occurred()) {
            // saveRelationships(QList<QtMobility::QContactRelationship>*,QMap<int,QtMobility::QContactManager::Error>*,QtMobility::QContactManager::Error*)
            bool cppResult = cppSelf->QtMobility::QContactManagerEngine::saveRelationships(cpp_arg0, cpp_arg1, cpp_arg2);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_saveRelationships_TypeError:
        const char* overloads[] = {"list, dict, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.saveRelationships", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_schemaDefinitions(PyObject* self)
{
    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // schemaDefinitions()
            QMap<QString, QMap<QString, QtMobility::QContactDetailDefinition > > cppResult = QtMobility::QContactManagerEngine::schemaDefinitions();
            pyResult = Shiboken::Converter<QMap<QString, QMap<QString, QtMobility::QContactDetailDefinition > > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_selfContactId(PyObject* self, PyObject* arg)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: selfContactId(QtMobility::QContactManager::Error*)const
    if (Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(arg)) {
        overloadId = 0; // selfContactId(QtMobility::QContactManager::Error*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_selfContactId_TypeError;

    // Call function/method
    {
        {
            QtMobility::QContactManager::Error * cpp_arg0 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // selfContactId(QtMobility::QContactManager::Error*)const
            QtMobility::QContactLocalId cppResult = cppSelf->QtMobility::QContactManagerEngine::selfContactId(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QContactLocalId >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_selfContactId_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactManagerEngine.selfContactId", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_setContactDisplayLabel(PyObject* self, PyObject* args)
{
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setContactDisplayLabel", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: setContactDisplayLabel(QtMobility::QContact*,QString)
    if (numArgs == 2 && Shiboken::Converter<QtMobility::QContact * >::isConvertible(pyargs[0]) && Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
        overloadId = 0; // setContactDisplayLabel(QtMobility::QContact*,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_setContactDisplayLabel_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContact* cpp_arg0 = Shiboken::Converter<QtMobility::QContact* >::toCpp(pyargs[0]);
            QString cpp_arg1 = Shiboken::Converter<QString >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // setContactDisplayLabel(QtMobility::QContact*,QString)
            QtMobility::QContactManagerEngine::setContactDisplayLabel(cpp_arg0, cpp_arg1);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactManagerEngineFunc_setContactDisplayLabel_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContact, QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.setContactDisplayLabel", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_setContactRelationships(PyObject* self, PyObject* args)
{
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setContactRelationships", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: setContactRelationships(QtMobility::QContact*,QList<QtMobility::QContactRelationship>)
    if (numArgs == 2 && Shiboken::Converter<QtMobility::QContact * >::isConvertible(pyargs[0]) && Shiboken::Converter< QList<QtMobility::QContactRelationship >  >::isConvertible(pyargs[1])) {
        overloadId = 0; // setContactRelationships(QtMobility::QContact*,QList<QtMobility::QContactRelationship>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_setContactRelationships_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContact* cpp_arg0 = Shiboken::Converter<QtMobility::QContact* >::toCpp(pyargs[0]);
            QList<QtMobility::QContactRelationship > cpp_arg1 = Shiboken::Converter<QList<QtMobility::QContactRelationship > >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // setContactRelationships(QtMobility::QContact*,QList<QtMobility::QContactRelationship>)
            QtMobility::QContactManagerEngine::setContactRelationships(cpp_arg0, cpp_arg1);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactManagerEngineFunc_setContactRelationships_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContact, list", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.setContactRelationships", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_setDetailAccessConstraints(PyObject* self, PyObject* args)
{
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setDetailAccessConstraints", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: setDetailAccessConstraints(QtMobility::QContactDetail*,QFlags<QtMobility::QContactDetail::AccessConstraint>)
    if (numArgs == 2 && Shiboken::Converter<QtMobility::QContactDetail * >::isConvertible(pyargs[0]) && Shiboken::Converter<QFlags<QtMobility::QContactDetail::AccessConstraint> >::isConvertible(pyargs[1])) {
        overloadId = 0; // setDetailAccessConstraints(QtMobility::QContactDetail*,QFlags<QtMobility::QContactDetail::AccessConstraint>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_setDetailAccessConstraints_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(pyargs[0]);
            QFlags<QtMobility::QContactDetail::AccessConstraint> cpp_arg1 = Shiboken::Converter<QFlags<QtMobility::QContactDetail::AccessConstraint> >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // setDetailAccessConstraints(QtMobility::QContactDetail*,QFlags<QtMobility::QContactDetail::AccessConstraint>)
            QtMobility::QContactManagerEngine::setDetailAccessConstraints(cpp_arg0, cpp_arg1);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactManagerEngineFunc_setDetailAccessConstraints_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactDetail, QtMobility.Contacts.QtMobility::QContactDetail.AccessConstraints", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.setDetailAccessConstraints", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_setSelfContactId(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setSelfContactId", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: setSelfContactId(QtMobility::QContactLocalId,QtMobility::QContactManager::Error*)
    if (numArgs == 2 && Shiboken::Converter<QtMobility::QContactLocalId >::isConvertible(pyargs[0]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[1])) {
        overloadId = 0; // setSelfContactId(QtMobility::QContactLocalId,QtMobility::QContactManager::Error*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_setSelfContactId_TypeError;

    // Call function/method
    {
        {
            QtMobility::QContactLocalId cpp_arg0 = Shiboken::Converter<QtMobility::QContactLocalId >::toCpp(pyargs[0]);
            QtMobility::QContactManager::Error * cpp_arg1 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // setSelfContactId(QtMobility::QContactLocalId,QtMobility::QContactManager::Error*)
            bool cppResult = cppSelf->QtMobility::QContactManagerEngine::setSelfContactId(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_setSelfContactId_TypeError:
        const char* overloads[] = {"QtMobility::QContactLocalId, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.setSelfContactId", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_sortContacts(PyObject* self, PyObject* args)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "sortContacts", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: sortContacts(QList<QtMobility::QContact>,QList<QtMobility::QContactSortOrder>)
    if (numArgs == 2 && Shiboken::Converter< QList<QtMobility::QContact >  >::isConvertible(pyargs[0]) && Shiboken::Converter< QList<QtMobility::QContactSortOrder >  >::isConvertible(pyargs[1])) {
        overloadId = 0; // sortContacts(QList<QtMobility::QContact>,QList<QtMobility::QContactSortOrder>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_sortContacts_TypeError;

    // Call function/method
    {
        {
            QList<QtMobility::QContact > cpp_arg0 = Shiboken::Converter<QList<QtMobility::QContact > >::toCpp(pyargs[0]);
            QList<QtMobility::QContactSortOrder > cpp_arg1 = Shiboken::Converter<QList<QtMobility::QContactSortOrder > >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // sortContacts(QList<QtMobility::QContact>,QList<QtMobility::QContactSortOrder>)
            QList<QtMobility::QContactLocalId > cppResult = QtMobility::QContactManagerEngine::sortContacts(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<QList<QtMobility::QContactLocalId > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_sortContacts_TypeError:
        const char* overloads[] = {"list, list", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.sortContacts", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_startRequest(PyObject* self, PyObject* arg)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: startRequest(QtMobility::QContactAbstractRequest*)
    if (Shiboken::Converter<QtMobility::QContactAbstractRequest * >::isConvertible(arg)) {
        overloadId = 0; // startRequest(QtMobility::QContactAbstractRequest*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_startRequest_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactAbstractRequest* cpp_arg0 = Shiboken::Converter<QtMobility::QContactAbstractRequest* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // startRequest(QtMobility::QContactAbstractRequest*)
            bool cppResult = cppSelf->QtMobility::QContactManagerEngine::startRequest(cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_startRequest_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactAbstractRequest", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactManagerEngine.startRequest", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_supportedContactTypes(PyObject* self)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // supportedContactTypes()const
            QStringList cppResult = cppSelf->QtMobility::QContactManagerEngine::supportedContactTypes();
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_supportedDataTypes(PyObject* self)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // supportedDataTypes()const
            QList<QVariant::Type > cppResult = cppSelf->QtMobility::QContactManagerEngine::supportedDataTypes();
            pyResult = Shiboken::Converter<QList<QVariant::Type > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_synthesizedDisplayLabel(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "synthesizedDisplayLabel", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: synthesizedDisplayLabel(QtMobility::QContact,QtMobility::QContactManager::Error*)const
    if (numArgs == 2 && Shiboken::Converter<const QtMobility::QContact & >::isConvertible(pyargs[0]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[1])) {
        overloadId = 0; // synthesizedDisplayLabel(QtMobility::QContact,QtMobility::QContactManager::Error*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_synthesizedDisplayLabel_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContact* cpp_arg0 = Shiboken::Converter<QtMobility::QContact* >::toCpp(pyargs[0]);
            QtMobility::QContactManager::Error * cpp_arg1 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // synthesizedDisplayLabel(QtMobility::QContact,QtMobility::QContactManager::Error*)const
            QString cppResult = cppSelf->QtMobility::QContactManagerEngine::synthesizedDisplayLabel(*cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_synthesizedDisplayLabel_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContact, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.synthesizedDisplayLabel", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_testFilter(PyObject* self, PyObject* args)
{
    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "testFilter", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: testFilter(QtMobility::QContactFilter,QtMobility::QContact)
    if (numArgs == 2 && Shiboken::Converter<const QtMobility::QContactFilter & >::isConvertible(pyargs[0]) && Shiboken::Converter<const QtMobility::QContact & >::isConvertible(pyargs[1])) {
        overloadId = 0; // testFilter(QtMobility::QContactFilter,QtMobility::QContact)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_testFilter_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactFilter* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFilter* >::toCpp(pyargs[0]);
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QtMobility::QContact* cpp_arg1 = Shiboken::Converter<QtMobility::QContact* >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // testFilter(QtMobility::QContactFilter,QtMobility::QContact)
            bool cppResult = QtMobility::QContactManagerEngine::testFilter(*cpp_arg0, *cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_testFilter_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactFilter, QtMobility.Contacts.QtMobility::QContact", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.testFilter", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_updateContactFetchRequest(PyObject* self, PyObject* args)
{
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "updateContactFetchRequest", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;


    // Overloaded function decisor
    // 0: updateContactFetchRequest(QtMobility::QContactFetchRequest*,QList<QtMobility::QContact>,QtMobility::QContactManager::Error,QtMobility::QContactAbstractRequest::State)
    if (numArgs == 4 && Shiboken::Converter<QtMobility::QContactFetchRequest * >::isConvertible(pyargs[0]) && Shiboken::Converter< QList<QtMobility::QContact >  >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QContactManager::Error >::isConvertible(pyargs[2]) && Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::isConvertible(pyargs[3])) {
        overloadId = 0; // updateContactFetchRequest(QtMobility::QContactFetchRequest*,QList<QtMobility::QContact>,QtMobility::QContactManager::Error,QtMobility::QContactAbstractRequest::State)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_updateContactFetchRequest_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactFetchRequest* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFetchRequest* >::toCpp(pyargs[0]);
            QList<QtMobility::QContact > cpp_arg1 = Shiboken::Converter<QList<QtMobility::QContact > >::toCpp(pyargs[1]);
            QtMobility::QContactManager::Error cpp_arg2 = Shiboken::Converter<QtMobility::QContactManager::Error >::toCpp(pyargs[2]);
            QtMobility::QContactAbstractRequest::State cpp_arg3 = Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::toCpp(pyargs[3]);

            if(!PyErr_Occurred()) {
            // updateContactFetchRequest(QtMobility::QContactFetchRequest*,QList<QtMobility::QContact>,QtMobility::QContactManager::Error,QtMobility::QContactAbstractRequest::State)
            QtMobility::QContactManagerEngine::updateContactFetchRequest(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactManagerEngineFunc_updateContactFetchRequest_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactFetchRequest, list, QtMobility.Contacts.QtMobility::QContactManager.Error, QtMobility.Contacts.QtMobility::QContactAbstractRequest.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.updateContactFetchRequest", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_updateContactLocalIdFetchRequest(PyObject* self, PyObject* args)
{
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "updateContactLocalIdFetchRequest", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;


    // Overloaded function decisor
    // 0: updateContactLocalIdFetchRequest(QtMobility::QContactLocalIdFetchRequest*,QList<QtMobility::QContactLocalId>,QtMobility::QContactManager::Error,QtMobility::QContactAbstractRequest::State)
    if (numArgs == 4 && Shiboken::Converter<QtMobility::QContactLocalIdFetchRequest * >::isConvertible(pyargs[0]) && Shiboken::Converter< QList<QtMobility::QContactLocalId >  >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QContactManager::Error >::isConvertible(pyargs[2]) && Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::isConvertible(pyargs[3])) {
        overloadId = 0; // updateContactLocalIdFetchRequest(QtMobility::QContactLocalIdFetchRequest*,QList<QtMobility::QContactLocalId>,QtMobility::QContactManager::Error,QtMobility::QContactAbstractRequest::State)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_updateContactLocalIdFetchRequest_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactLocalIdFetchRequest* cpp_arg0 = Shiboken::Converter<QtMobility::QContactLocalIdFetchRequest* >::toCpp(pyargs[0]);
            QList<QtMobility::QContactLocalId > cpp_arg1 = Shiboken::Converter<QList<QtMobility::QContactLocalId > >::toCpp(pyargs[1]);
            QtMobility::QContactManager::Error cpp_arg2 = Shiboken::Converter<QtMobility::QContactManager::Error >::toCpp(pyargs[2]);
            QtMobility::QContactAbstractRequest::State cpp_arg3 = Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::toCpp(pyargs[3]);

            if(!PyErr_Occurred()) {
            // updateContactLocalIdFetchRequest(QtMobility::QContactLocalIdFetchRequest*,QList<QtMobility::QContactLocalId>,QtMobility::QContactManager::Error,QtMobility::QContactAbstractRequest::State)
            QtMobility::QContactManagerEngine::updateContactLocalIdFetchRequest(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactManagerEngineFunc_updateContactLocalIdFetchRequest_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactLocalIdFetchRequest, list, QtMobility.Contacts.QtMobility::QContactManager.Error, QtMobility.Contacts.QtMobility::QContactAbstractRequest.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.updateContactLocalIdFetchRequest", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_updateContactRemoveRequest(PyObject* self, PyObject* args)
{
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "updateContactRemoveRequest", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;


    // Overloaded function decisor
    // 0: updateContactRemoveRequest(QtMobility::QContactRemoveRequest*,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
    if (numArgs == 4 && Shiboken::Converter<QtMobility::QContactRemoveRequest * >::isConvertible(pyargs[0]) && Shiboken::Converter<QtMobility::QContactManager::Error >::isConvertible(pyargs[1]) && Shiboken::Converter< QMap<int, QtMobility::QContactManager::Error >  >::isConvertible(pyargs[2]) && Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::isConvertible(pyargs[3])) {
        overloadId = 0; // updateContactRemoveRequest(QtMobility::QContactRemoveRequest*,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_updateContactRemoveRequest_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactRemoveRequest* cpp_arg0 = Shiboken::Converter<QtMobility::QContactRemoveRequest* >::toCpp(pyargs[0]);
            QtMobility::QContactManager::Error cpp_arg1 = Shiboken::Converter<QtMobility::QContactManager::Error >::toCpp(pyargs[1]);
            QMap<int, QtMobility::QContactManager::Error > cpp_arg2 = Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > >::toCpp(pyargs[2]);
            QtMobility::QContactAbstractRequest::State cpp_arg3 = Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::toCpp(pyargs[3]);

            if(!PyErr_Occurred()) {
            // updateContactRemoveRequest(QtMobility::QContactRemoveRequest*,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
            QtMobility::QContactManagerEngine::updateContactRemoveRequest(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactManagerEngineFunc_updateContactRemoveRequest_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactRemoveRequest, QtMobility.Contacts.QtMobility::QContactManager.Error, dict, QtMobility.Contacts.QtMobility::QContactAbstractRequest.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.updateContactRemoveRequest", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_updateContactSaveRequest(PyObject* self, PyObject* args)
{
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "updateContactSaveRequest", 5, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;


    // Overloaded function decisor
    // 0: updateContactSaveRequest(QtMobility::QContactSaveRequest*,QList<QtMobility::QContact>,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
    if (numArgs == 5 && Shiboken::Converter<QtMobility::QContactSaveRequest * >::isConvertible(pyargs[0]) && Shiboken::Converter< QList<QtMobility::QContact >  >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QContactManager::Error >::isConvertible(pyargs[2]) && Shiboken::Converter< QMap<int, QtMobility::QContactManager::Error >  >::isConvertible(pyargs[3]) && Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::isConvertible(pyargs[4])) {
        overloadId = 0; // updateContactSaveRequest(QtMobility::QContactSaveRequest*,QList<QtMobility::QContact>,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_updateContactSaveRequest_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactSaveRequest* cpp_arg0 = Shiboken::Converter<QtMobility::QContactSaveRequest* >::toCpp(pyargs[0]);
            QList<QtMobility::QContact > cpp_arg1 = Shiboken::Converter<QList<QtMobility::QContact > >::toCpp(pyargs[1]);
            QtMobility::QContactManager::Error cpp_arg2 = Shiboken::Converter<QtMobility::QContactManager::Error >::toCpp(pyargs[2]);
            QMap<int, QtMobility::QContactManager::Error > cpp_arg3 = Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > >::toCpp(pyargs[3]);
            QtMobility::QContactAbstractRequest::State cpp_arg4 = Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::toCpp(pyargs[4]);

            if(!PyErr_Occurred()) {
            // updateContactSaveRequest(QtMobility::QContactSaveRequest*,QList<QtMobility::QContact>,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
            QtMobility::QContactManagerEngine::updateContactSaveRequest(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactManagerEngineFunc_updateContactSaveRequest_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactSaveRequest, list, QtMobility.Contacts.QtMobility::QContactManager.Error, dict, QtMobility.Contacts.QtMobility::QContactAbstractRequest.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.updateContactSaveRequest", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_updateDefinitionFetchRequest(PyObject* self, PyObject* args)
{
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "updateDefinitionFetchRequest", 5, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;


    // Overloaded function decisor
    // 0: updateDefinitionFetchRequest(QtMobility::QContactDetailDefinitionFetchRequest*,QMap<QString,QtMobility::QContactDetailDefinition>,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
    if (numArgs == 5 && Shiboken::Converter<QtMobility::QContactDetailDefinitionFetchRequest * >::isConvertible(pyargs[0]) && Shiboken::Converter< QMap<QString, QtMobility::QContactDetailDefinition >  >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QContactManager::Error >::isConvertible(pyargs[2]) && Shiboken::Converter< QMap<int, QtMobility::QContactManager::Error >  >::isConvertible(pyargs[3]) && Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::isConvertible(pyargs[4])) {
        overloadId = 0; // updateDefinitionFetchRequest(QtMobility::QContactDetailDefinitionFetchRequest*,QMap<QString,QtMobility::QContactDetailDefinition>,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_updateDefinitionFetchRequest_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactDetailDefinitionFetchRequest* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetailDefinitionFetchRequest* >::toCpp(pyargs[0]);
            QMap<QString, QtMobility::QContactDetailDefinition > cpp_arg1 = Shiboken::Converter<QMap<QString, QtMobility::QContactDetailDefinition > >::toCpp(pyargs[1]);
            QtMobility::QContactManager::Error cpp_arg2 = Shiboken::Converter<QtMobility::QContactManager::Error >::toCpp(pyargs[2]);
            QMap<int, QtMobility::QContactManager::Error > cpp_arg3 = Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > >::toCpp(pyargs[3]);
            QtMobility::QContactAbstractRequest::State cpp_arg4 = Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::toCpp(pyargs[4]);

            if(!PyErr_Occurred()) {
            // updateDefinitionFetchRequest(QtMobility::QContactDetailDefinitionFetchRequest*,QMap<QString,QtMobility::QContactDetailDefinition>,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
            QtMobility::QContactManagerEngine::updateDefinitionFetchRequest(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactManagerEngineFunc_updateDefinitionFetchRequest_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactDetailDefinitionFetchRequest, dict, QtMobility.Contacts.QtMobility::QContactManager.Error, dict, QtMobility.Contacts.QtMobility::QContactAbstractRequest.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.updateDefinitionFetchRequest", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_updateDefinitionRemoveRequest(PyObject* self, PyObject* args)
{
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "updateDefinitionRemoveRequest", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;


    // Overloaded function decisor
    // 0: updateDefinitionRemoveRequest(QtMobility::QContactDetailDefinitionRemoveRequest*,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
    if (numArgs == 4 && Shiboken::Converter<QtMobility::QContactDetailDefinitionRemoveRequest * >::isConvertible(pyargs[0]) && Shiboken::Converter<QtMobility::QContactManager::Error >::isConvertible(pyargs[1]) && Shiboken::Converter< QMap<int, QtMobility::QContactManager::Error >  >::isConvertible(pyargs[2]) && Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::isConvertible(pyargs[3])) {
        overloadId = 0; // updateDefinitionRemoveRequest(QtMobility::QContactDetailDefinitionRemoveRequest*,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_updateDefinitionRemoveRequest_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactDetailDefinitionRemoveRequest* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetailDefinitionRemoveRequest* >::toCpp(pyargs[0]);
            QtMobility::QContactManager::Error cpp_arg1 = Shiboken::Converter<QtMobility::QContactManager::Error >::toCpp(pyargs[1]);
            QMap<int, QtMobility::QContactManager::Error > cpp_arg2 = Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > >::toCpp(pyargs[2]);
            QtMobility::QContactAbstractRequest::State cpp_arg3 = Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::toCpp(pyargs[3]);

            if(!PyErr_Occurred()) {
            // updateDefinitionRemoveRequest(QtMobility::QContactDetailDefinitionRemoveRequest*,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
            QtMobility::QContactManagerEngine::updateDefinitionRemoveRequest(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactManagerEngineFunc_updateDefinitionRemoveRequest_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactDetailDefinitionRemoveRequest, QtMobility.Contacts.QtMobility::QContactManager.Error, dict, QtMobility.Contacts.QtMobility::QContactAbstractRequest.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.updateDefinitionRemoveRequest", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_updateDefinitionSaveRequest(PyObject* self, PyObject* args)
{
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "updateDefinitionSaveRequest", 5, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;


    // Overloaded function decisor
    // 0: updateDefinitionSaveRequest(QtMobility::QContactDetailDefinitionSaveRequest*,QList<QtMobility::QContactDetailDefinition>,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
    if (numArgs == 5 && Shiboken::Converter<QtMobility::QContactDetailDefinitionSaveRequest * >::isConvertible(pyargs[0]) && Shiboken::Converter< QList<QtMobility::QContactDetailDefinition >  >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QContactManager::Error >::isConvertible(pyargs[2]) && Shiboken::Converter< QMap<int, QtMobility::QContactManager::Error >  >::isConvertible(pyargs[3]) && Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::isConvertible(pyargs[4])) {
        overloadId = 0; // updateDefinitionSaveRequest(QtMobility::QContactDetailDefinitionSaveRequest*,QList<QtMobility::QContactDetailDefinition>,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_updateDefinitionSaveRequest_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactDetailDefinitionSaveRequest* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetailDefinitionSaveRequest* >::toCpp(pyargs[0]);
            QList<QtMobility::QContactDetailDefinition > cpp_arg1 = Shiboken::Converter<QList<QtMobility::QContactDetailDefinition > >::toCpp(pyargs[1]);
            QtMobility::QContactManager::Error cpp_arg2 = Shiboken::Converter<QtMobility::QContactManager::Error >::toCpp(pyargs[2]);
            QMap<int, QtMobility::QContactManager::Error > cpp_arg3 = Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > >::toCpp(pyargs[3]);
            QtMobility::QContactAbstractRequest::State cpp_arg4 = Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::toCpp(pyargs[4]);

            if(!PyErr_Occurred()) {
            // updateDefinitionSaveRequest(QtMobility::QContactDetailDefinitionSaveRequest*,QList<QtMobility::QContactDetailDefinition>,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
            QtMobility::QContactManagerEngine::updateDefinitionSaveRequest(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactManagerEngineFunc_updateDefinitionSaveRequest_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactDetailDefinitionSaveRequest, list, QtMobility.Contacts.QtMobility::QContactManager.Error, dict, QtMobility.Contacts.QtMobility::QContactAbstractRequest.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.updateDefinitionSaveRequest", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_updateRelationshipFetchRequest(PyObject* self, PyObject* args)
{
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "updateRelationshipFetchRequest", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;


    // Overloaded function decisor
    // 0: updateRelationshipFetchRequest(QtMobility::QContactRelationshipFetchRequest*,QList<QtMobility::QContactRelationship>,QtMobility::QContactManager::Error,QtMobility::QContactAbstractRequest::State)
    if (numArgs == 4 && Shiboken::Converter<QtMobility::QContactRelationshipFetchRequest * >::isConvertible(pyargs[0]) && Shiboken::Converter< QList<QtMobility::QContactRelationship >  >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QContactManager::Error >::isConvertible(pyargs[2]) && Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::isConvertible(pyargs[3])) {
        overloadId = 0; // updateRelationshipFetchRequest(QtMobility::QContactRelationshipFetchRequest*,QList<QtMobility::QContactRelationship>,QtMobility::QContactManager::Error,QtMobility::QContactAbstractRequest::State)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_updateRelationshipFetchRequest_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactRelationshipFetchRequest* cpp_arg0 = Shiboken::Converter<QtMobility::QContactRelationshipFetchRequest* >::toCpp(pyargs[0]);
            QList<QtMobility::QContactRelationship > cpp_arg1 = Shiboken::Converter<QList<QtMobility::QContactRelationship > >::toCpp(pyargs[1]);
            QtMobility::QContactManager::Error cpp_arg2 = Shiboken::Converter<QtMobility::QContactManager::Error >::toCpp(pyargs[2]);
            QtMobility::QContactAbstractRequest::State cpp_arg3 = Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::toCpp(pyargs[3]);

            if(!PyErr_Occurred()) {
            // updateRelationshipFetchRequest(QtMobility::QContactRelationshipFetchRequest*,QList<QtMobility::QContactRelationship>,QtMobility::QContactManager::Error,QtMobility::QContactAbstractRequest::State)
            QtMobility::QContactManagerEngine::updateRelationshipFetchRequest(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactManagerEngineFunc_updateRelationshipFetchRequest_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactRelationshipFetchRequest, list, QtMobility.Contacts.QtMobility::QContactManager.Error, QtMobility.Contacts.QtMobility::QContactAbstractRequest.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.updateRelationshipFetchRequest", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_updateRelationshipRemoveRequest(PyObject* self, PyObject* args)
{
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "updateRelationshipRemoveRequest", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;


    // Overloaded function decisor
    // 0: updateRelationshipRemoveRequest(QtMobility::QContactRelationshipRemoveRequest*,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
    if (numArgs == 4 && Shiboken::Converter<QtMobility::QContactRelationshipRemoveRequest * >::isConvertible(pyargs[0]) && Shiboken::Converter<QtMobility::QContactManager::Error >::isConvertible(pyargs[1]) && Shiboken::Converter< QMap<int, QtMobility::QContactManager::Error >  >::isConvertible(pyargs[2]) && Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::isConvertible(pyargs[3])) {
        overloadId = 0; // updateRelationshipRemoveRequest(QtMobility::QContactRelationshipRemoveRequest*,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_updateRelationshipRemoveRequest_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactRelationshipRemoveRequest* cpp_arg0 = Shiboken::Converter<QtMobility::QContactRelationshipRemoveRequest* >::toCpp(pyargs[0]);
            QtMobility::QContactManager::Error cpp_arg1 = Shiboken::Converter<QtMobility::QContactManager::Error >::toCpp(pyargs[1]);
            QMap<int, QtMobility::QContactManager::Error > cpp_arg2 = Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > >::toCpp(pyargs[2]);
            QtMobility::QContactAbstractRequest::State cpp_arg3 = Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::toCpp(pyargs[3]);

            if(!PyErr_Occurred()) {
            // updateRelationshipRemoveRequest(QtMobility::QContactRelationshipRemoveRequest*,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
            QtMobility::QContactManagerEngine::updateRelationshipRemoveRequest(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactManagerEngineFunc_updateRelationshipRemoveRequest_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactRelationshipRemoveRequest, QtMobility.Contacts.QtMobility::QContactManager.Error, dict, QtMobility.Contacts.QtMobility::QContactAbstractRequest.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.updateRelationshipRemoveRequest", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_updateRelationshipSaveRequest(PyObject* self, PyObject* args)
{
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "updateRelationshipSaveRequest", 5, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;


    // Overloaded function decisor
    // 0: updateRelationshipSaveRequest(QtMobility::QContactRelationshipSaveRequest*,QList<QtMobility::QContactRelationship>,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
    if (numArgs == 5 && Shiboken::Converter<QtMobility::QContactRelationshipSaveRequest * >::isConvertible(pyargs[0]) && Shiboken::Converter< QList<QtMobility::QContactRelationship >  >::isConvertible(pyargs[1]) && Shiboken::Converter<QtMobility::QContactManager::Error >::isConvertible(pyargs[2]) && Shiboken::Converter< QMap<int, QtMobility::QContactManager::Error >  >::isConvertible(pyargs[3]) && Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::isConvertible(pyargs[4])) {
        overloadId = 0; // updateRelationshipSaveRequest(QtMobility::QContactRelationshipSaveRequest*,QList<QtMobility::QContactRelationship>,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_updateRelationshipSaveRequest_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactRelationshipSaveRequest* cpp_arg0 = Shiboken::Converter<QtMobility::QContactRelationshipSaveRequest* >::toCpp(pyargs[0]);
            QList<QtMobility::QContactRelationship > cpp_arg1 = Shiboken::Converter<QList<QtMobility::QContactRelationship > >::toCpp(pyargs[1]);
            QtMobility::QContactManager::Error cpp_arg2 = Shiboken::Converter<QtMobility::QContactManager::Error >::toCpp(pyargs[2]);
            QMap<int, QtMobility::QContactManager::Error > cpp_arg3 = Shiboken::Converter<QMap<int, QtMobility::QContactManager::Error > >::toCpp(pyargs[3]);
            QtMobility::QContactAbstractRequest::State cpp_arg4 = Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::toCpp(pyargs[4]);

            if(!PyErr_Occurred()) {
            // updateRelationshipSaveRequest(QtMobility::QContactRelationshipSaveRequest*,QList<QtMobility::QContactRelationship>,QtMobility::QContactManager::Error,QMap<int,QtMobility::QContactManager::Error>,QtMobility::QContactAbstractRequest::State)
            QtMobility::QContactManagerEngine::updateRelationshipSaveRequest(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactManagerEngineFunc_updateRelationshipSaveRequest_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactRelationshipSaveRequest, list, QtMobility.Contacts.QtMobility::QContactManager.Error, dict, QtMobility.Contacts.QtMobility::QContactAbstractRequest.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.updateRelationshipSaveRequest", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_updateRequestState(PyObject* self, PyObject* args)
{
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "updateRequestState", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: updateRequestState(QtMobility::QContactAbstractRequest*,QtMobility::QContactAbstractRequest::State)
    if (numArgs == 2 && Shiboken::Converter<QtMobility::QContactAbstractRequest * >::isConvertible(pyargs[0]) && Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::isConvertible(pyargs[1])) {
        overloadId = 0; // updateRequestState(QtMobility::QContactAbstractRequest*,QtMobility::QContactAbstractRequest::State)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_updateRequestState_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactAbstractRequest* cpp_arg0 = Shiboken::Converter<QtMobility::QContactAbstractRequest* >::toCpp(pyargs[0]);
            QtMobility::QContactAbstractRequest::State cpp_arg1 = Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // updateRequestState(QtMobility::QContactAbstractRequest*,QtMobility::QContactAbstractRequest::State)
            QtMobility::QContactManagerEngine::updateRequestState(cpp_arg0, cpp_arg1);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactManagerEngineFunc_updateRequestState_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactAbstractRequest, QtMobility.Contacts.QtMobility::QContactAbstractRequest.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.updateRequestState", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_validateContact(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "validateContact", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: validateContact(QtMobility::QContact,QtMobility::QContactManager::Error*)const
    if (numArgs == 2 && Shiboken::Converter<const QtMobility::QContact & >::isConvertible(pyargs[0]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[1])) {
        overloadId = 0; // validateContact(QtMobility::QContact,QtMobility::QContactManager::Error*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_validateContact_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContact* cpp_arg0 = Shiboken::Converter<QtMobility::QContact* >::toCpp(pyargs[0]);
            QtMobility::QContactManager::Error * cpp_arg1 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // validateContact(QtMobility::QContact,QtMobility::QContactManager::Error*)const
            bool cppResult = cppSelf->QtMobility::QContactManagerEngine::validateContact(*cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_validateContact_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContact, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.validateContact", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_validateDefinition(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "validateDefinition", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: validateDefinition(QtMobility::QContactDetailDefinition,QtMobility::QContactManager::Error*)const
    if (numArgs == 2 && Shiboken::Converter<const QtMobility::QContactDetailDefinition & >::isConvertible(pyargs[0]) && Shiboken::Converter<QtMobility::QContactManager::Error * >::isConvertible(pyargs[1])) {
        overloadId = 0; // validateDefinition(QtMobility::QContactDetailDefinition,QtMobility::QContactManager::Error*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_validateDefinition_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactDetailDefinition* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetailDefinition* >::toCpp(pyargs[0]);
            QtMobility::QContactManager::Error * cpp_arg1 = Shiboken::Converter<QtMobility::QContactManager::Error * >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // validateDefinition(QtMobility::QContactDetailDefinition,QtMobility::QContactManager::Error*)const
            bool cppResult = cppSelf->QtMobility::QContactManagerEngine::validateDefinition(*cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_validateDefinition_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactDetailDefinition, QtMobility.Contacts.QtMobility::QContactManager.Error", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.validateDefinition", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactManagerEngineFunc_waitForRequestFinished(PyObject* self, PyObject* args)
{
    QtMobility::QContactManagerEngine* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactManagerEngine* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "waitForRequestFinished", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;


    // Overloaded function decisor
    // 0: waitForRequestFinished(QtMobility::QContactAbstractRequest*,int)
    if (numArgs == 2 && Shiboken::Converter<QtMobility::QContactAbstractRequest * >::isConvertible(pyargs[0]) && SbkNumber_Check(pyargs[1])) {
        overloadId = 0; // waitForRequestFinished(QtMobility::QContactAbstractRequest*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactManagerEngineFunc_waitForRequestFinished_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(pyargs[0]))
                return 0;
            QtMobility::QContactAbstractRequest* cpp_arg0 = Shiboken::Converter<QtMobility::QContactAbstractRequest* >::toCpp(pyargs[0]);
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);

            if(!PyErr_Occurred()) {
            // waitForRequestFinished(QtMobility::QContactAbstractRequest*,int)
            bool cppResult = cppSelf->QtMobility::QContactManagerEngine::waitForRequestFinished(cpp_arg0, cpp_arg1);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactManagerEngineFunc_waitForRequestFinished_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactAbstractRequest, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactManagerEngine.waitForRequestFinished", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QContactManagerEngine_methods[] = {
    {"addSorted", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_addSorted, METH_VARARGS|METH_STATIC},
    {"cancelRequest", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_cancelRequest, METH_O},
    {"canonicalizedFilter", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_canonicalizedFilter, METH_O|METH_STATIC},
    {"compareContact", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_compareContact, METH_VARARGS|METH_STATIC},
    {"compareVariant", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_compareVariant, METH_VARARGS|METH_STATIC},
    {"compatibleContact", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_compatibleContact, METH_VARARGS},
    {"contact", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_contact, METH_VARARGS},
    {"contactIds", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_contactIds, METH_VARARGS},
    {"contacts", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_contacts, METH_VARARGS},
    {"detailDefinition", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_detailDefinition, METH_VARARGS},
    {"detailDefinitions", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_detailDefinitions, METH_VARARGS},
    {"hasFeature", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_hasFeature, METH_VARARGS},
    {"isFilterSupported", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_isFilterSupported, METH_O},
    {"isRelationshipTypeSupported", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_isRelationshipTypeSupported, METH_VARARGS},
    {"managerName", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_managerName, METH_NOARGS},
    {"managerParameters", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_managerParameters, METH_NOARGS},
    {"managerUri", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_managerUri, METH_NOARGS},
    {"managerVersion", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_managerVersion, METH_NOARGS},
    {"relationships", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_relationships, METH_VARARGS},
    {"removeContact", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_removeContact, METH_VARARGS},
    {"removeContacts", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_removeContacts, METH_VARARGS},
    {"removeDetailDefinition", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_removeDetailDefinition, METH_VARARGS},
    {"removeRelationship", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_removeRelationship, METH_VARARGS},
    {"removeRelationships", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_removeRelationships, METH_VARARGS},
    {"requestDestroyed", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_requestDestroyed, METH_O},
    {"saveContact", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_saveContact, METH_VARARGS},
    {"saveContacts", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_saveContacts, METH_VARARGS},
    {"saveDetailDefinition", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_saveDetailDefinition, METH_VARARGS},
    {"saveRelationship", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_saveRelationship, METH_VARARGS},
    {"saveRelationships", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_saveRelationships, METH_VARARGS},
    {"schemaDefinitions", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_schemaDefinitions, METH_NOARGS|METH_STATIC},
    {"selfContactId", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_selfContactId, METH_O},
    {"setContactDisplayLabel", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_setContactDisplayLabel, METH_VARARGS|METH_STATIC},
    {"setContactRelationships", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_setContactRelationships, METH_VARARGS|METH_STATIC},
    {"setDetailAccessConstraints", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_setDetailAccessConstraints, METH_VARARGS|METH_STATIC},
    {"setSelfContactId", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_setSelfContactId, METH_VARARGS},
    {"sortContacts", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_sortContacts, METH_VARARGS|METH_STATIC},
    {"startRequest", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_startRequest, METH_O},
    {"supportedContactTypes", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_supportedContactTypes, METH_NOARGS},
    {"supportedDataTypes", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_supportedDataTypes, METH_NOARGS},
    {"synthesizedDisplayLabel", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_synthesizedDisplayLabel, METH_VARARGS},
    {"testFilter", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_testFilter, METH_VARARGS|METH_STATIC},
    {"updateContactFetchRequest", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_updateContactFetchRequest, METH_VARARGS|METH_STATIC},
    {"updateContactLocalIdFetchRequest", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_updateContactLocalIdFetchRequest, METH_VARARGS|METH_STATIC},
    {"updateContactRemoveRequest", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_updateContactRemoveRequest, METH_VARARGS|METH_STATIC},
    {"updateContactSaveRequest", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_updateContactSaveRequest, METH_VARARGS|METH_STATIC},
    {"updateDefinitionFetchRequest", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_updateDefinitionFetchRequest, METH_VARARGS|METH_STATIC},
    {"updateDefinitionRemoveRequest", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_updateDefinitionRemoveRequest, METH_VARARGS|METH_STATIC},
    {"updateDefinitionSaveRequest", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_updateDefinitionSaveRequest, METH_VARARGS|METH_STATIC},
    {"updateRelationshipFetchRequest", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_updateRelationshipFetchRequest, METH_VARARGS|METH_STATIC},
    {"updateRelationshipRemoveRequest", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_updateRelationshipRemoveRequest, METH_VARARGS|METH_STATIC},
    {"updateRelationshipSaveRequest", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_updateRelationshipSaveRequest, METH_VARARGS|METH_STATIC},
    {"updateRequestState", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_updateRequestState, METH_VARARGS|METH_STATIC},
    {"validateContact", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_validateContact, METH_VARARGS},
    {"validateDefinition", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_validateDefinition, METH_VARARGS},
    {"waitForRequestFinished", (PyCFunction)SbkQtMobility_QContactManagerEngineFunc_waitForRequestFinished, METH_VARARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactManagerEngine_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactManagerEngine",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactManagerEngine_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactManagerEngine_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactManagerEngine >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactManagerEngine*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QContactManagerEngine_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QContactManagerEngine*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QContactManagerEngine_Type;
    return 0;
}


void init_QtMobility_QContactManagerEngine(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTMANAGERENGINE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactManagerEngine_Type);

    SbkQtMobility_QContactManagerEngine_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQtMobility_QContactManagerEngine_Type.type_discovery = &SbkQtMobility_QContactManagerEngine_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]), &SbkQtMobility_QContactManagerEngine_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactManagerEngine_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactManagerEngine_Type));
    PyModule_AddObject(module, "QContactManagerEngine",
        ((PyObject*)&SbkQtMobility_QContactManagerEngine_Type));

    // Initialize signals
    PyObject* signal_item;

    signal_item = PySide::signalNew("contactsChanged", "const QList<QtMobility::QContactLocalId>&", NULL);
    PyDict_SetItemString(SbkQtMobility_QContactManagerEngine_Type.super.ht_type.tp_dict, "contactsChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("dataChanged", "void", NULL);
    PyDict_SetItemString(SbkQtMobility_QContactManagerEngine_Type.super.ht_type.tp_dict, "dataChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("contactsAdded", "const QList<QtMobility::QContactLocalId>&", NULL);
    PyDict_SetItemString(SbkQtMobility_QContactManagerEngine_Type.super.ht_type.tp_dict, "contactsAdded", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("selfContactIdChanged", "const QtMobility::QContactLocalId&,const QtMobility::QContactLocalId&", NULL);
    PyDict_SetItemString(SbkQtMobility_QContactManagerEngine_Type.super.ht_type.tp_dict, "selfContactIdChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("relationshipsAdded", "const QList<QtMobility::QContactLocalId>&", NULL);
    PyDict_SetItemString(SbkQtMobility_QContactManagerEngine_Type.super.ht_type.tp_dict, "relationshipsAdded", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("contactsRemoved", "const QList<QtMobility::QContactLocalId>&", NULL);
    PyDict_SetItemString(SbkQtMobility_QContactManagerEngine_Type.super.ht_type.tp_dict, "contactsRemoved", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("relationshipsRemoved", "const QList<QtMobility::QContactLocalId>&", NULL);
    PyDict_SetItemString(SbkQtMobility_QContactManagerEngine_Type.super.ht_type.tp_dict, "relationshipsRemoved", signal_item);
    Py_DECREF(signal_item);


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactManagerEngine >("QtMobility::QContactManagerEngine*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactManagerEngine >(typeid(QtMobility::QContactManagerEngine).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactManagerEngine >(typeid(QContactManagerEngineWrapper).name());
    PySide::initQtMetaType<QtMobility::QContactManagerEngine* >();
}

