/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactglobalpresence_wrapper.h"

// Extra includes
#include <QMap>
#include <QStringList>
#include <qcontactdetail.h>
#include <qcontactglobalpresence.h>
#include <qdatetime.h>
#include <qurl.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactGlobalPresence_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactGlobalPresence >()))
        return -1;

    QtMobility::QContactGlobalPresence* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactGlobalPresence", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactGlobalPresence(QtMobility::QContactGlobalPresence)
    // 1: QContactGlobalPresence()
    // 2: QContactGlobalPresence(QtMobility::QContactDetail)
    if (numArgs == 0) {
        overloadId = 1; // QContactGlobalPresence()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(arg)) {
        overloadId = 2; // QContactGlobalPresence(QtMobility::QContactDetail)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactGlobalPresence & >::isConvertible(arg)) {
        overloadId = 0; // QContactGlobalPresence(QtMobility::QContactGlobalPresence)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactGlobalPresence_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactGlobalPresence(QtMobility::QContactGlobalPresence)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactGlobalPresence > cpp_arg0_auto_ptr;
                QtMobility::QContactGlobalPresence* cpp_arg0 = Shiboken::Converter<QtMobility::QContactGlobalPresence* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactGlobalPresence >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactGlobalPresence >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactGlobalPresence(QtMobility::QContactGlobalPresence)
                cptr = new QtMobility::QContactGlobalPresence(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactGlobalPresence()
            {

                if(!PyErr_Occurred()) {
                // QContactGlobalPresence()
                cptr = new QtMobility::QContactGlobalPresence();
                }
                break;
            }
            case 2: // QContactGlobalPresence(QtMobility::QContactDetail)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactGlobalPresence(QtMobility::QContactDetail)
                cptr = new QtMobility::QContactGlobalPresence(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactGlobalPresence >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactGlobalPresence_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactGlobalPresence_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactGlobalPresence", "", "QtMobility.Contacts.QtMobility::QContactDetail", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactGlobalPresence", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactGlobalPresenceFunc_customMessage(PyObject* self)
{
    QtMobility::QContactGlobalPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGlobalPresence* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // customMessage()const
            QString cppResult = cppSelf->QtMobility::QContactGlobalPresence::customMessage();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactGlobalPresenceFunc_nickname(PyObject* self)
{
    QtMobility::QContactGlobalPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGlobalPresence* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // nickname()const
            QString cppResult = cppSelf->QtMobility::QContactGlobalPresence::nickname();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactGlobalPresenceFunc_presenceState(PyObject* self)
{
    QtMobility::QContactGlobalPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGlobalPresence* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // presenceState()const
            QtMobility::QContactPresence::PresenceState cppResult = cppSelf->QtMobility::QContactGlobalPresence::presenceState();
            pyResult = Shiboken::Converter<QtMobility::QContactPresence::PresenceState >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactGlobalPresenceFunc_presenceStateImageUrl(PyObject* self)
{
    QtMobility::QContactGlobalPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGlobalPresence* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // presenceStateImageUrl()const
            QUrl cppResult = cppSelf->QtMobility::QContactGlobalPresence::presenceStateImageUrl();
            pyResult = Shiboken::Converter<QUrl >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactGlobalPresenceFunc_presenceStateText(PyObject* self)
{
    QtMobility::QContactGlobalPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGlobalPresence* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // presenceStateText()const
            QString cppResult = cppSelf->QtMobility::QContactGlobalPresence::presenceStateText();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactGlobalPresenceFunc_setCustomMessage(PyObject* self, PyObject* arg)
{
    QtMobility::QContactGlobalPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGlobalPresence* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setCustomMessage(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setCustomMessage(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactGlobalPresenceFunc_setCustomMessage_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setCustomMessage(QString)
            cppSelf->QtMobility::QContactGlobalPresence::setCustomMessage(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactGlobalPresenceFunc_setCustomMessage_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactGlobalPresence.setCustomMessage", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactGlobalPresenceFunc_setNickname(PyObject* self, PyObject* arg)
{
    QtMobility::QContactGlobalPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGlobalPresence* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setNickname(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setNickname(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactGlobalPresenceFunc_setNickname_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setNickname(QString)
            cppSelf->QtMobility::QContactGlobalPresence::setNickname(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactGlobalPresenceFunc_setNickname_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactGlobalPresence.setNickname", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactGlobalPresenceFunc_setPresenceState(PyObject* self, PyObject* arg)
{
    QtMobility::QContactGlobalPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGlobalPresence* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setPresenceState(QtMobility::QContactPresence::PresenceState)
    if (Shiboken::Converter<QtMobility::QContactPresence::PresenceState >::isConvertible(arg)) {
        overloadId = 0; // setPresenceState(QtMobility::QContactPresence::PresenceState)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactGlobalPresenceFunc_setPresenceState_TypeError;

    // Call function/method
    {
        {
            QtMobility::QContactPresence::PresenceState cpp_arg0 = Shiboken::Converter<QtMobility::QContactPresence::PresenceState >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setPresenceState(QtMobility::QContactPresence::PresenceState)
            cppSelf->QtMobility::QContactGlobalPresence::setPresenceState(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactGlobalPresenceFunc_setPresenceState_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactPresence.PresenceState", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactGlobalPresence.setPresenceState", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactGlobalPresenceFunc_setPresenceStateImageUrl(PyObject* self, PyObject* arg)
{
    QtMobility::QContactGlobalPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGlobalPresence* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setPresenceStateImageUrl(QUrl)
    if (Shiboken::Converter<const QUrl & >::isConvertible(arg)) {
        overloadId = 0; // setPresenceStateImageUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactGlobalPresenceFunc_setPresenceStateImageUrl_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
            QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(arg);
            if (!Shiboken::Converter<QUrl >::checkType(arg))
                cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);

            if(!PyErr_Occurred()) {
            // setPresenceStateImageUrl(QUrl)
            cppSelf->QtMobility::QContactGlobalPresence::setPresenceStateImageUrl(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactGlobalPresenceFunc_setPresenceStateImageUrl_TypeError:
        const char* overloads[] = {"PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactGlobalPresence.setPresenceStateImageUrl", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactGlobalPresenceFunc_setPresenceStateText(PyObject* self, PyObject* arg)
{
    QtMobility::QContactGlobalPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGlobalPresence* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setPresenceStateText(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setPresenceStateText(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactGlobalPresenceFunc_setPresenceStateText_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setPresenceStateText(QString)
            cppSelf->QtMobility::QContactGlobalPresence::setPresenceStateText(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactGlobalPresenceFunc_setPresenceStateText_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactGlobalPresence.setPresenceStateText", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactGlobalPresenceFunc_setTimestamp(PyObject* self, PyObject* arg)
{
    QtMobility::QContactGlobalPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGlobalPresence* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setTimestamp(QDateTime)
    if (Shiboken::Converter<const QDateTime & >::isConvertible(arg)) {
        overloadId = 0; // setTimestamp(QDateTime)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactGlobalPresenceFunc_setTimestamp_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setTimestamp(QDateTime)
            cppSelf->QtMobility::QContactGlobalPresence::setTimestamp(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactGlobalPresenceFunc_setTimestamp_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactGlobalPresence.setTimestamp", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactGlobalPresenceFunc_timestamp(PyObject* self)
{
    QtMobility::QContactGlobalPresence* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGlobalPresence* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // timestamp()const
            QDateTime cppResult = cppSelf->QtMobility::QContactGlobalPresence::timestamp();
            pyResult = Shiboken::Converter<QDateTime >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QContactGlobalPresence_methods[] = {
    {"customMessage", (PyCFunction)SbkQtMobility_QContactGlobalPresenceFunc_customMessage, METH_NOARGS},
    {"nickname", (PyCFunction)SbkQtMobility_QContactGlobalPresenceFunc_nickname, METH_NOARGS},
    {"presenceState", (PyCFunction)SbkQtMobility_QContactGlobalPresenceFunc_presenceState, METH_NOARGS},
    {"presenceStateImageUrl", (PyCFunction)SbkQtMobility_QContactGlobalPresenceFunc_presenceStateImageUrl, METH_NOARGS},
    {"presenceStateText", (PyCFunction)SbkQtMobility_QContactGlobalPresenceFunc_presenceStateText, METH_NOARGS},
    {"setCustomMessage", (PyCFunction)SbkQtMobility_QContactGlobalPresenceFunc_setCustomMessage, METH_O},
    {"setNickname", (PyCFunction)SbkQtMobility_QContactGlobalPresenceFunc_setNickname, METH_O},
    {"setPresenceState", (PyCFunction)SbkQtMobility_QContactGlobalPresenceFunc_setPresenceState, METH_O},
    {"setPresenceStateImageUrl", (PyCFunction)SbkQtMobility_QContactGlobalPresenceFunc_setPresenceStateImageUrl, METH_O},
    {"setPresenceStateText", (PyCFunction)SbkQtMobility_QContactGlobalPresenceFunc_setPresenceStateText, METH_O},
    {"setTimestamp", (PyCFunction)SbkQtMobility_QContactGlobalPresenceFunc_setTimestamp, METH_O},
    {"timestamp", (PyCFunction)SbkQtMobility_QContactGlobalPresenceFunc_timestamp, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactGlobalPresence_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactGlobalPresence",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactGlobalPresence_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactGlobalPresence_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactGlobalPresence >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactGlobalPresence",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactGlobalPresence(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTGLOBALPRESENCE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactGlobalPresence_Type);

    SbkQtMobility_QContactGlobalPresence_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactGlobalPresence_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactGlobalPresence_Type));
    PyModule_AddObject(module, "QContactGlobalPresence",
        ((PyObject*)&SbkQtMobility_QContactGlobalPresence_Type));

    PyDict_SetItemString(SbkQtMobility_QContactGlobalPresence_Type.super.ht_type.tp_dict, "FieldPresenceStateText", Shiboken::Converter<QString >::toPython(QtMobility::QContactGlobalPresence::FieldPresenceStateText));
    PyDict_SetItemString(SbkQtMobility_QContactGlobalPresence_Type.super.ht_type.tp_dict, "FieldPresenceStateImageUrl", Shiboken::Converter<QString >::toPython(QtMobility::QContactGlobalPresence::FieldPresenceStateImageUrl));
    PyDict_SetItemString(SbkQtMobility_QContactGlobalPresence_Type.super.ht_type.tp_dict, "FieldPresenceState", Shiboken::Converter<QString >::toPython(QtMobility::QContactGlobalPresence::FieldPresenceState));
    PyDict_SetItemString(SbkQtMobility_QContactGlobalPresence_Type.super.ht_type.tp_dict, "FieldNickname", Shiboken::Converter<QString >::toPython(QtMobility::QContactGlobalPresence::FieldNickname));
    PyDict_SetItemString(SbkQtMobility_QContactGlobalPresence_Type.super.ht_type.tp_dict, "FieldTimestamp", Shiboken::Converter<QString >::toPython(QtMobility::QContactGlobalPresence::FieldTimestamp));
    PyDict_SetItemString(SbkQtMobility_QContactGlobalPresence_Type.super.ht_type.tp_dict, "FieldCustomMessage", Shiboken::Converter<QString >::toPython(QtMobility::QContactGlobalPresence::FieldCustomMessage));
    PyDict_SetItemString(SbkQtMobility_QContactGlobalPresence_Type.super.ht_type.tp_dict, "DefinitionName", Shiboken::Converter<QString >::toPython(QtMobility::QContactGlobalPresence::DefinitionName));

    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactGlobalPresence >("QtMobility::QContactGlobalPresence");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactGlobalPresence >("QtMobility::QContactGlobalPresence*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactGlobalPresence >(typeid(QtMobility::QContactGlobalPresence).name());
    PySide::initQtMetaType<QtMobility::QContactGlobalPresence >();
}

