/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactgeolocation_wrapper.h"

// Extra includes
#include <QMap>
#include <QStringList>
#include <qcontactdetail.h>
#include <qcontactgeolocation.h>
#include <qdatetime.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactGeoLocation_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactGeoLocation >()))
        return -1;

    QtMobility::QContactGeoLocation* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactGeoLocation", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactGeoLocation(QtMobility::QContactGeoLocation)
    // 1: QContactGeoLocation()
    // 2: QContactGeoLocation(QtMobility::QContactDetail)
    if (numArgs == 0) {
        overloadId = 1; // QContactGeoLocation()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(arg)) {
        overloadId = 2; // QContactGeoLocation(QtMobility::QContactDetail)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactGeoLocation & >::isConvertible(arg)) {
        overloadId = 0; // QContactGeoLocation(QtMobility::QContactGeoLocation)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactGeoLocation_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactGeoLocation(QtMobility::QContactGeoLocation)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactGeoLocation > cpp_arg0_auto_ptr;
                QtMobility::QContactGeoLocation* cpp_arg0 = Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactGeoLocation >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactGeoLocation >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactGeoLocation(QtMobility::QContactGeoLocation)
                cptr = new QtMobility::QContactGeoLocation(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactGeoLocation()
            {

                if(!PyErr_Occurred()) {
                // QContactGeoLocation()
                cptr = new QtMobility::QContactGeoLocation();
                }
                break;
            }
            case 2: // QContactGeoLocation(QtMobility::QContactDetail)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactGeoLocation(QtMobility::QContactDetail)
                cptr = new QtMobility::QContactGeoLocation(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactGeoLocation >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactGeoLocation_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactGeoLocation_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactGeoLocation", "", "QtMobility.Contacts.QtMobility::QContactDetail", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactGeoLocation", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactGeoLocationFunc_accuracy(PyObject* self)
{
    QtMobility::QContactGeoLocation* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // accuracy()const
            double cppResult = cppSelf->QtMobility::QContactGeoLocation::accuracy();
            pyResult = Shiboken::Converter<double >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactGeoLocationFunc_altitude(PyObject* self)
{
    QtMobility::QContactGeoLocation* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // altitude()const
            double cppResult = cppSelf->QtMobility::QContactGeoLocation::altitude();
            pyResult = Shiboken::Converter<double >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactGeoLocationFunc_altitudeAccuracy(PyObject* self)
{
    QtMobility::QContactGeoLocation* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // altitudeAccuracy()const
            double cppResult = cppSelf->QtMobility::QContactGeoLocation::altitudeAccuracy();
            pyResult = Shiboken::Converter<double >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactGeoLocationFunc_heading(PyObject* self)
{
    QtMobility::QContactGeoLocation* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // heading()const
            double cppResult = cppSelf->QtMobility::QContactGeoLocation::heading();
            pyResult = Shiboken::Converter<double >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactGeoLocationFunc_label(PyObject* self)
{
    QtMobility::QContactGeoLocation* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // label()const
            QString cppResult = cppSelf->QtMobility::QContactGeoLocation::label();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactGeoLocationFunc_latitude(PyObject* self)
{
    QtMobility::QContactGeoLocation* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // latitude()const
            double cppResult = cppSelf->QtMobility::QContactGeoLocation::latitude();
            pyResult = Shiboken::Converter<double >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactGeoLocationFunc_longitude(PyObject* self)
{
    QtMobility::QContactGeoLocation* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // longitude()const
            double cppResult = cppSelf->QtMobility::QContactGeoLocation::longitude();
            pyResult = Shiboken::Converter<double >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactGeoLocationFunc_setAccuracy(PyObject* self, PyObject* arg)
{
    QtMobility::QContactGeoLocation* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setAccuracy(double)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setAccuracy(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactGeoLocationFunc_setAccuracy_TypeError;

    // Call function/method
    {
        {
            double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setAccuracy(double)
            cppSelf->QtMobility::QContactGeoLocation::setAccuracy(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactGeoLocationFunc_setAccuracy_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactGeoLocation.setAccuracy", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactGeoLocationFunc_setAltitude(PyObject* self, PyObject* arg)
{
    QtMobility::QContactGeoLocation* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setAltitude(double)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setAltitude(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactGeoLocationFunc_setAltitude_TypeError;

    // Call function/method
    {
        {
            double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setAltitude(double)
            cppSelf->QtMobility::QContactGeoLocation::setAltitude(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactGeoLocationFunc_setAltitude_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactGeoLocation.setAltitude", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactGeoLocationFunc_setAltitudeAccuracy(PyObject* self, PyObject* arg)
{
    QtMobility::QContactGeoLocation* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setAltitudeAccuracy(double)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setAltitudeAccuracy(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactGeoLocationFunc_setAltitudeAccuracy_TypeError;

    // Call function/method
    {
        {
            double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setAltitudeAccuracy(double)
            cppSelf->QtMobility::QContactGeoLocation::setAltitudeAccuracy(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactGeoLocationFunc_setAltitudeAccuracy_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactGeoLocation.setAltitudeAccuracy", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactGeoLocationFunc_setHeading(PyObject* self, PyObject* arg)
{
    QtMobility::QContactGeoLocation* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setHeading(double)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setHeading(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactGeoLocationFunc_setHeading_TypeError;

    // Call function/method
    {
        {
            double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setHeading(double)
            cppSelf->QtMobility::QContactGeoLocation::setHeading(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactGeoLocationFunc_setHeading_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactGeoLocation.setHeading", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactGeoLocationFunc_setLabel(PyObject* self, PyObject* arg)
{
    QtMobility::QContactGeoLocation* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setLabel(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setLabel(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactGeoLocationFunc_setLabel_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setLabel(QString)
            cppSelf->QtMobility::QContactGeoLocation::setLabel(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactGeoLocationFunc_setLabel_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactGeoLocation.setLabel", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactGeoLocationFunc_setLatitude(PyObject* self, PyObject* arg)
{
    QtMobility::QContactGeoLocation* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setLatitude(double)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setLatitude(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactGeoLocationFunc_setLatitude_TypeError;

    // Call function/method
    {
        {
            double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setLatitude(double)
            cppSelf->QtMobility::QContactGeoLocation::setLatitude(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactGeoLocationFunc_setLatitude_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactGeoLocation.setLatitude", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactGeoLocationFunc_setLongitude(PyObject* self, PyObject* arg)
{
    QtMobility::QContactGeoLocation* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setLongitude(double)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setLongitude(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactGeoLocationFunc_setLongitude_TypeError;

    // Call function/method
    {
        {
            double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setLongitude(double)
            cppSelf->QtMobility::QContactGeoLocation::setLongitude(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactGeoLocationFunc_setLongitude_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactGeoLocation.setLongitude", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactGeoLocationFunc_setSpeed(PyObject* self, PyObject* arg)
{
    QtMobility::QContactGeoLocation* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setSpeed(double)
    if (SbkNumber_Check(arg)) {
        overloadId = 0; // setSpeed(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactGeoLocationFunc_setSpeed_TypeError;

    // Call function/method
    {
        {
            double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setSpeed(double)
            cppSelf->QtMobility::QContactGeoLocation::setSpeed(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactGeoLocationFunc_setSpeed_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactGeoLocation.setSpeed", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactGeoLocationFunc_setTimestamp(PyObject* self, PyObject* arg)
{
    QtMobility::QContactGeoLocation* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setTimestamp(QDateTime)
    if (Shiboken::Converter<const QDateTime & >::isConvertible(arg)) {
        overloadId = 0; // setTimestamp(QDateTime)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactGeoLocationFunc_setTimestamp_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setTimestamp(QDateTime)
            cppSelf->QtMobility::QContactGeoLocation::setTimestamp(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactGeoLocationFunc_setTimestamp_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactGeoLocation.setTimestamp", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactGeoLocationFunc_speed(PyObject* self)
{
    QtMobility::QContactGeoLocation* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // speed()const
            double cppResult = cppSelf->QtMobility::QContactGeoLocation::speed();
            pyResult = Shiboken::Converter<double >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactGeoLocationFunc_timestamp(PyObject* self)
{
    QtMobility::QContactGeoLocation* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactGeoLocation* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // timestamp()const
            QDateTime cppResult = cppSelf->QtMobility::QContactGeoLocation::timestamp();
            pyResult = Shiboken::Converter<QDateTime >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QContactGeoLocation_methods[] = {
    {"accuracy", (PyCFunction)SbkQtMobility_QContactGeoLocationFunc_accuracy, METH_NOARGS},
    {"altitude", (PyCFunction)SbkQtMobility_QContactGeoLocationFunc_altitude, METH_NOARGS},
    {"altitudeAccuracy", (PyCFunction)SbkQtMobility_QContactGeoLocationFunc_altitudeAccuracy, METH_NOARGS},
    {"heading", (PyCFunction)SbkQtMobility_QContactGeoLocationFunc_heading, METH_NOARGS},
    {"label", (PyCFunction)SbkQtMobility_QContactGeoLocationFunc_label, METH_NOARGS},
    {"latitude", (PyCFunction)SbkQtMobility_QContactGeoLocationFunc_latitude, METH_NOARGS},
    {"longitude", (PyCFunction)SbkQtMobility_QContactGeoLocationFunc_longitude, METH_NOARGS},
    {"setAccuracy", (PyCFunction)SbkQtMobility_QContactGeoLocationFunc_setAccuracy, METH_O},
    {"setAltitude", (PyCFunction)SbkQtMobility_QContactGeoLocationFunc_setAltitude, METH_O},
    {"setAltitudeAccuracy", (PyCFunction)SbkQtMobility_QContactGeoLocationFunc_setAltitudeAccuracy, METH_O},
    {"setHeading", (PyCFunction)SbkQtMobility_QContactGeoLocationFunc_setHeading, METH_O},
    {"setLabel", (PyCFunction)SbkQtMobility_QContactGeoLocationFunc_setLabel, METH_O},
    {"setLatitude", (PyCFunction)SbkQtMobility_QContactGeoLocationFunc_setLatitude, METH_O},
    {"setLongitude", (PyCFunction)SbkQtMobility_QContactGeoLocationFunc_setLongitude, METH_O},
    {"setSpeed", (PyCFunction)SbkQtMobility_QContactGeoLocationFunc_setSpeed, METH_O},
    {"setTimestamp", (PyCFunction)SbkQtMobility_QContactGeoLocationFunc_setTimestamp, METH_O},
    {"speed", (PyCFunction)SbkQtMobility_QContactGeoLocationFunc_speed, METH_NOARGS},
    {"timestamp", (PyCFunction)SbkQtMobility_QContactGeoLocationFunc_timestamp, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactGeoLocation_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactGeoLocation",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactGeoLocation_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactGeoLocation_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactGeoLocation >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactGeoLocation",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactGeoLocation(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTGEOLOCATION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactGeoLocation_Type);

    SbkQtMobility_QContactGeoLocation_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactGeoLocation_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactGeoLocation_Type));
    PyModule_AddObject(module, "QContactGeoLocation",
        ((PyObject*)&SbkQtMobility_QContactGeoLocation_Type));

    PyDict_SetItemString(SbkQtMobility_QContactGeoLocation_Type.super.ht_type.tp_dict, "FieldLongitude", Shiboken::Converter<QString >::toPython(QtMobility::QContactGeoLocation::FieldLongitude));
    PyDict_SetItemString(SbkQtMobility_QContactGeoLocation_Type.super.ht_type.tp_dict, "FieldAltitudeAccuracy", Shiboken::Converter<QString >::toPython(QtMobility::QContactGeoLocation::FieldAltitudeAccuracy));
    PyDict_SetItemString(SbkQtMobility_QContactGeoLocation_Type.super.ht_type.tp_dict, "FieldSpeed", Shiboken::Converter<QString >::toPython(QtMobility::QContactGeoLocation::FieldSpeed));
    PyDict_SetItemString(SbkQtMobility_QContactGeoLocation_Type.super.ht_type.tp_dict, "FieldLabel", Shiboken::Converter<QString >::toPython(QtMobility::QContactGeoLocation::FieldLabel));
    PyDict_SetItemString(SbkQtMobility_QContactGeoLocation_Type.super.ht_type.tp_dict, "FieldAltitude", Shiboken::Converter<QString >::toPython(QtMobility::QContactGeoLocation::FieldAltitude));
    PyDict_SetItemString(SbkQtMobility_QContactGeoLocation_Type.super.ht_type.tp_dict, "FieldLatitude", Shiboken::Converter<QString >::toPython(QtMobility::QContactGeoLocation::FieldLatitude));
    PyDict_SetItemString(SbkQtMobility_QContactGeoLocation_Type.super.ht_type.tp_dict, "FieldHeading", Shiboken::Converter<QString >::toPython(QtMobility::QContactGeoLocation::FieldHeading));
    PyDict_SetItemString(SbkQtMobility_QContactGeoLocation_Type.super.ht_type.tp_dict, "FieldAccuracy", Shiboken::Converter<QString >::toPython(QtMobility::QContactGeoLocation::FieldAccuracy));
    PyDict_SetItemString(SbkQtMobility_QContactGeoLocation_Type.super.ht_type.tp_dict, "FieldTimestamp", Shiboken::Converter<QString >::toPython(QtMobility::QContactGeoLocation::FieldTimestamp));
    PyDict_SetItemString(SbkQtMobility_QContactGeoLocation_Type.super.ht_type.tp_dict, "DefinitionName", Shiboken::Converter<QString >::toPython(QtMobility::QContactGeoLocation::DefinitionName));

    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactGeoLocation >("QtMobility::QContactGeoLocation");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactGeoLocation >("QtMobility::QContactGeoLocation*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactGeoLocation >(typeid(QtMobility::QContactGeoLocation).name());
    PySide::initQtMetaType<QtMobility::QContactGeoLocation >();
}

