/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactfetchhint_wrapper.h"

// Extra includes
#include <QStringList>
#include <qcontactfetchhint.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactFetchHint_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactFetchHint >()))
        return -1;

    QtMobility::QContactFetchHint* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactFetchHint", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactFetchHint()
    // 1: QContactFetchHint(QtMobility::QContactFetchHint)
    if (numArgs == 0) {
        overloadId = 0; // QContactFetchHint()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactFetchHint & >::isConvertible(arg)) {
        overloadId = 1; // QContactFetchHint(QtMobility::QContactFetchHint)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactFetchHint_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactFetchHint()
            {

                if(!PyErr_Occurred()) {
                // QContactFetchHint()
                cptr = new QtMobility::QContactFetchHint();
                }
                break;
            }
            case 1: // QContactFetchHint(QtMobility::QContactFetchHint)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactFetchHint* cpp_arg0 = Shiboken::Converter<QtMobility::QContactFetchHint* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactFetchHint(QtMobility::QContactFetchHint)
                cptr = new QtMobility::QContactFetchHint(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactFetchHint >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactFetchHint_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactFetchHint_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Contacts.QtMobility::QContactFetchHint", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactFetchHint", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactFetchHintFunc_detailDefinitionsHint(PyObject* self)
{
    QtMobility::QContactFetchHint* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactFetchHint* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // detailDefinitionsHint()const
            QStringList cppResult = cppSelf->QtMobility::QContactFetchHint::detailDefinitionsHint();
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactFetchHintFunc_optimizationHints(PyObject* self)
{
    QtMobility::QContactFetchHint* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactFetchHint* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // optimizationHints()const
            QFlags<QtMobility::QContactFetchHint::OptimizationHint> cppResult = cppSelf->QtMobility::QContactFetchHint::optimizationHints();
            pyResult = Shiboken::Converter<QFlags<QtMobility::QContactFetchHint::OptimizationHint> >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactFetchHintFunc_relationshipTypesHint(PyObject* self)
{
    QtMobility::QContactFetchHint* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactFetchHint* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // relationshipTypesHint()const
            QStringList cppResult = cppSelf->QtMobility::QContactFetchHint::relationshipTypesHint();
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactFetchHintFunc_setDetailDefinitionsHint(PyObject* self, PyObject* arg)
{
    QtMobility::QContactFetchHint* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactFetchHint* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setDetailDefinitionsHint(QStringList)
    if (Shiboken::Converter< QStringList  >::isConvertible(arg)) {
        overloadId = 0; // setDetailDefinitionsHint(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactFetchHintFunc_setDetailDefinitionsHint_TypeError;

    // Call function/method
    {
        {
            QStringList cpp_arg0 = Shiboken::Converter<QStringList >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setDetailDefinitionsHint(QStringList)
            cppSelf->QtMobility::QContactFetchHint::setDetailDefinitionsHint(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactFetchHintFunc_setDetailDefinitionsHint_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactFetchHint.setDetailDefinitionsHint", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactFetchHintFunc_setOptimizationHints(PyObject* self, PyObject* arg)
{
    QtMobility::QContactFetchHint* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactFetchHint* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setOptimizationHints(QFlags<QtMobility::QContactFetchHint::OptimizationHint>)
    if (Shiboken::Converter<QFlags<QtMobility::QContactFetchHint::OptimizationHint> >::isConvertible(arg)) {
        overloadId = 0; // setOptimizationHints(QFlags<QtMobility::QContactFetchHint::OptimizationHint>)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactFetchHintFunc_setOptimizationHints_TypeError;

    // Call function/method
    {
        {
            QFlags<QtMobility::QContactFetchHint::OptimizationHint> cpp_arg0 = Shiboken::Converter<QFlags<QtMobility::QContactFetchHint::OptimizationHint> >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setOptimizationHints(QFlags<QtMobility::QContactFetchHint::OptimizationHint>)
            cppSelf->QtMobility::QContactFetchHint::setOptimizationHints(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactFetchHintFunc_setOptimizationHints_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactFetchHint.OptimizationHints", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactFetchHint.setOptimizationHints", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactFetchHintFunc_setRelationshipTypesHint(PyObject* self, PyObject* arg)
{
    QtMobility::QContactFetchHint* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactFetchHint* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setRelationshipTypesHint(QStringList)
    if (Shiboken::Converter< QStringList  >::isConvertible(arg)) {
        overloadId = 0; // setRelationshipTypesHint(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactFetchHintFunc_setRelationshipTypesHint_TypeError;

    // Call function/method
    {
        {
            QStringList cpp_arg0 = Shiboken::Converter<QStringList >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setRelationshipTypesHint(QStringList)
            cppSelf->QtMobility::QContactFetchHint::setRelationshipTypesHint(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactFetchHintFunc_setRelationshipTypesHint_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactFetchHint.setRelationshipTypesHint", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QContactFetchHint_methods[] = {
    {"detailDefinitionsHint", (PyCFunction)SbkQtMobility_QContactFetchHintFunc_detailDefinitionsHint, METH_NOARGS},
    {"optimizationHints", (PyCFunction)SbkQtMobility_QContactFetchHintFunc_optimizationHints, METH_NOARGS},
    {"relationshipTypesHint", (PyCFunction)SbkQtMobility_QContactFetchHintFunc_relationshipTypesHint, METH_NOARGS},
    {"setDetailDefinitionsHint", (PyCFunction)SbkQtMobility_QContactFetchHintFunc_setDetailDefinitionsHint, METH_O},
    {"setOptimizationHints", (PyCFunction)SbkQtMobility_QContactFetchHintFunc_setOptimizationHints, METH_O},
    {"setRelationshipTypesHint", (PyCFunction)SbkQtMobility_QContactFetchHintFunc_setRelationshipTypesHint, METH_O},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactFetchHint_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactFetchHint",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactFetchHint_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactFetchHint_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactFetchHint >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactFetchHint",
    /*user_data*/           0
};
} //extern

PyObject* SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint___and__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QContactFetchHint::OptimizationHints >::checkType(self) && Shiboken::Converter<QtMobility::QContactFetchHint::OptimizationHints >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "&", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QContactFetchHint::OptimizationHints >::toPython(
        Shiboken::Converter<QtMobility::QContactFetchHint::OptimizationHints>::toCpp(self)
        & Shiboken::Converter< QtMobility::QContactFetchHint::OptimizationHints >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint___or__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QContactFetchHint::OptimizationHints >::checkType(self) && Shiboken::Converter<QtMobility::QContactFetchHint::OptimizationHints >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "|", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QContactFetchHint::OptimizationHints >::toPython(
        Shiboken::Converter<QtMobility::QContactFetchHint::OptimizationHints>::toCpp(self)
        | Shiboken::Converter< QtMobility::QContactFetchHint::OptimizationHints >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint___xor__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QContactFetchHint::OptimizationHints >::checkType(self) && Shiboken::Converter<QtMobility::QContactFetchHint::OptimizationHints >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "^", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QContactFetchHint::OptimizationHints >::toPython(
        Shiboken::Converter<QtMobility::QContactFetchHint::OptimizationHints>::toCpp(self)
        ^ Shiboken::Converter< QtMobility::QContactFetchHint::OptimizationHints >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QtMobility::QContactFetchHint::OptimizationHints >::toPython(
        ~Shiboken::Converter<QtMobility::QContactFetchHint::OptimizationHints >::toCpp(self)
    );
}


static PyNumberMethods SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint___and__,
    /*nb_xor*/                  (binaryfunc)SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint___xor__,
    /*nb_or*/                   (binaryfunc)SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "OptimizationHint",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyTypeObject SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHints_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "OptimizationHints",
    /*tp_basicsize*/        0,
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_Type.tp_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT | Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              PyInt_Type.tp_new,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};



void init_QtMobility_QContactFetchHint(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTFETCHHINT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactFetchHint_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactFetchHint_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactFetchHint_Type));
    PyModule_AddObject(module, "QContactFetchHint",
        ((PyObject*)&SbkQtMobility_QContactFetchHint_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: OptimizationHint
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTFETCHHINT_OPTIMIZATIONHINT_IDX] = &SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_Type);
    PyDict_SetItemString(SbkQtMobility_QContactFetchHint_Type.super.ht_type.tp_dict,
            "OptimizationHint",((PyObject*)&SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_Type));

    // init flags class: QFlags<QtMobility::QContactFetchHint::OptimizationHint>
    SbkQtMobility_ContactsTypes[SBK_QFLAGS_QTMOBILITY_QCONTACTFETCHHINT_OPTIMIZATIONHINT__IDX] = &SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHints_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHints_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHints_Type);
    PyDict_SetItemString(SbkQtMobility_QContactFetchHint_Type.super.ht_type.tp_dict,
            "OptimizationHints",((PyObject*)&SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHints_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_Type,
        (long) QtMobility::QContactFetchHint::AllRequired, "AllRequired");
    PyDict_SetItemString(SbkQtMobility_QContactFetchHint_Type.super.ht_type.tp_dict,
        "AllRequired", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_Type.tp_dict,
        "AllRequired", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_Type,
        (long) QtMobility::QContactFetchHint::NoRelationships, "NoRelationships");
    PyDict_SetItemString(SbkQtMobility_QContactFetchHint_Type.super.ht_type.tp_dict,
        "NoRelationships", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_Type.tp_dict,
        "NoRelationships", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_Type,
        (long) QtMobility::QContactFetchHint::NoActionPreferences, "NoActionPreferences");
    PyDict_SetItemString(SbkQtMobility_QContactFetchHint_Type.super.ht_type.tp_dict,
        "NoActionPreferences", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_Type.tp_dict,
        "NoActionPreferences", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_Type,
        (long) QtMobility::QContactFetchHint::NoBinaryBlobs, "NoBinaryBlobs");
    PyDict_SetItemString(SbkQtMobility_QContactFetchHint_Type.super.ht_type.tp_dict,
        "NoBinaryBlobs", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactFetchHint_OptimizationHint_Type.tp_dict,
        "NoBinaryBlobs", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QContactFetchHint::OptimizationHint");


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactFetchHint >("QtMobility::QContactFetchHint");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactFetchHint >("QtMobility::QContactFetchHint*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactFetchHint >(typeid(QtMobility::QContactFetchHint).name());
    PySide::initQtMetaType<QtMobility::QContactFetchHint >();
}

